/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.vectortile.mapbox;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.data.IQuadBucketType;
import org.openstreetmap.josm.data.imagery.vectortile.VectorTile;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Layer;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.protobuf.ProtobufParser;
import org.openstreetmap.josm.data.protobuf.ProtobufRecord;
import org.openstreetmap.josm.data.vector.VectorDataStore;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;

public class MVTTile
extends Tile
implements VectorTile,
IQuadBucketType {
    private final ListenerList<TileListener> listenerList = ListenerList.create();
    private Collection<Layer> layers;
    private int extent = 4096;
    static final BufferedImage CLEAR_LOADED = new BufferedImage(1, 1, 6);
    private BBox bbox;
    private VectorDataStore vectorDataStore;

    public MVTTile(TileSource source, int xtile, int ytile, int zoom) {
        super(source, xtile, ytile, zoom);
    }

    @Override
    public void loadImage(InputStream inputStream) throws IOException {
        if (this.image == null || this.image == Tile.LOADING_IMAGE || this.image == Tile.ERROR_IMAGE) {
            this.initLoading();
            ProtobufParser parser = new ProtobufParser(inputStream);
            Collection<ProtobufRecord> protobufRecords = parser.allRecords();
            this.layers = new HashSet<Layer>();
            this.layers = protobufRecords.stream().map(protoBufRecord -> {
                Layer mvtLayer = null;
                if (protoBufRecord.getField() == 3) {
                    try (ProtobufParser tParser = new ProtobufParser(protoBufRecord.getBytes());){
                        mvtLayer = new Layer(tParser.allRecords());
                    }
                    catch (IOException e) {
                        Logging.error(e);
                    }
                    finally {
                        protoBufRecord.close();
                    }
                }
                return mvtLayer;
            }).collect(Collectors.toCollection(HashSet::new));
            this.extent = this.layers.stream().filter(Objects::nonNull).mapToInt(Layer::getExtent).max().orElse(4096);
            if (this.getData() != null) {
                this.finishLoading();
                this.listenerList.fireEvent(event -> event.finishedLoading(this));
                this.image = CLEAR_LOADED;
                this.layers.forEach(Layer::destroy);
            }
        }
    }

    @Override
    public Collection<Layer> getLayers() {
        return this.layers;
    }

    @Override
    public int getExtent() {
        return this.extent;
    }

    public void addTileLoaderFinisher(TileListener listener) {
        this.listenerList.addWeakListener(listener);
    }

    @Override
    public BBox getBBox() {
        if (this.bbox == null) {
            ICoordinate upperLeft = this.getTileSource().tileXYToLatLon(this);
            ICoordinate lowerRight = this.getTileSource().tileXYToLatLon(this.getXtile() + 1, this.getYtile() + 1, this.getZoom());
            BBox newBBox = new BBox(upperLeft.getLon(), upperLeft.getLat(), lowerRight.getLon(), lowerRight.getLat());
            this.bbox = newBBox.toImmutable();
        }
        return this.bbox;
    }

    public VectorDataStore getData() {
        if (this.vectorDataStore == null) {
            VectorDataStore newDataStore = new VectorDataStore();
            newDataStore.addDataTile(this);
            this.vectorDataStore = newDataStore;
        }
        return this.vectorDataStore;
    }

    public static interface TileListener {
        public void finishedLoading(MVTTile var1);
    }

    public static interface LayerShower {
        public List<String> layersToShow();
    }
}

