/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.tools.GeoProperty;

public class GeoPropertyIndex<T> {
    private final int maxLevel;
    private final GeoProperty<T> geoProp;
    private final GPLevel<T> root;
    private GPLevel<T> lastLevelUsed;
    private static final boolean DEBUG = false;

    public GeoPropertyIndex(GeoProperty<T> geoProp, int maxLevel) {
        this.geoProp = geoProp;
        this.maxLevel = maxLevel;
        this.root = new GPLevel(0, new BBox(-180.0, -90.0, 180.0, 90.0), null, this);
        this.lastLevelUsed = this.root;
    }

    public T get(LatLon ll) {
        return this.lastLevelUsed.get(ll);
    }

    public final GeoProperty<T> getGeoProperty() {
        return this.geoProp;
    }

    public String toString() {
        return "GeoPropertyIndex [maxLevel=" + this.maxLevel + ", geoProp=" + this.geoProp + ", root=" + this.root + ", lastLevelUsed=" + this.lastLevelUsed + ']';
    }

    protected static class GPLevel<T> {
        private final T val;
        private final int level;
        private final BBox bbox;
        private final GPLevel<T> parent;
        private final GeoPropertyIndex<T> owner;
        private GPLevel<T>[] children;

        public GPLevel(int level, BBox bbox, GPLevel<T> parent, GeoPropertyIndex<T> owner) {
            this.level = level;
            this.bbox = bbox;
            this.parent = parent;
            this.owner = owner;
            this.val = ((GeoPropertyIndex)owner).geoProp.get(bbox);
        }

        public T get(LatLon ll) {
            if (this.isInside(ll)) {
                return this.getBounded(ll);
            }
            return this.parent != null ? (T)this.parent.get(ll) : null;
        }

        private T getBounded(LatLon ll) {
            if (!this.isInside(ll)) {
                throw new AssertionError((Object)("Point " + ll + " should be inside " + this.bbox));
            }
            if (this.val != null) {
                ((GeoPropertyIndex)this.owner).lastLevelUsed = this;
                return this.val;
            }
            if (this.level >= ((GeoPropertyIndex)this.owner).maxLevel) {
                return ((GeoPropertyIndex)this.owner).geoProp.get(ll);
            }
            if (this.children == null) {
                GPLevel[] tmp = new GPLevel[4];
                this.children = tmp;
            }
            LatLon center = this.bbox.getCenter();
            for (int idx = 0; idx < 4; ++idx) {
                BBox testBBox = null;
                if (this.children[idx] != null) {
                    testBBox = this.children[idx].bbox;
                }
                if (testBBox == null) {
                    double lat1;
                    double lon1;
                    switch (idx) {
                        case 0: {
                            lon1 = this.bbox.getTopLeftLon();
                            lat1 = this.bbox.getBottomRightLat();
                            break;
                        }
                        case 1: {
                            lon1 = this.bbox.getTopLeftLon();
                            lat1 = this.bbox.getTopLeftLat();
                            break;
                        }
                        case 2: {
                            lon1 = this.bbox.getBottomRightLon();
                            lat1 = this.bbox.getBottomRightLat();
                            break;
                        }
                        case 3: {
                            lon1 = this.bbox.getBottomRightLon();
                            lat1 = this.bbox.getTopLeftLat();
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    testBBox = new BBox(lon1, lat1, center.lon(), center.lat());
                }
                if (!this.isInside(testBBox, ll)) continue;
                if (this.children[idx] == null) {
                    this.children[idx] = new GPLevel<T>(this.level + 1, testBBox, this, this.owner);
                }
                return super.getBounded(ll);
            }
            throw new AssertionError((Object)("Point " + ll + " should be inside one of the children of " + this.bbox));
        }

        boolean isInside(LatLon ll) {
            return this.isInside(this.bbox, ll);
        }

        boolean isInside(BBox bbox, LatLon ll) {
            return bbox.getTopLeftLon() <= ll.lon() && (ll.lon() < bbox.getBottomRightLon() || ll.lon() == 180.0 && bbox.getBottomRightLon() == 180.0) && bbox.getBottomRightLat() <= ll.lat() && (ll.lat() < bbox.getTopLeftLat() || ll.lat() == 90.0 && bbox.getTopLeftLat() == 90.0);
        }

        public String toString() {
            return "GPLevel [val=" + this.val + ", level=" + this.level + ", bbox=" + this.bbox + ']';
        }
    }
}

