/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MainPanel;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class MainFrame
extends JFrame {
    private final transient OsmDataLayer.LayerStateChangeListener updateTitleOnLayerStateChange = (layer, newValue) -> this.onLayerChange(layer);
    private final transient PropertyChangeListener updateTitleOnSaveChange = evt -> {
        if (evt.getPropertyName().equals(AbstractModifiableLayer.REQUIRES_SAVE_TO_DISK_PROP) || evt.getPropertyName().equals(OsmDataLayer.REQUIRES_UPLOAD_TO_SERVER_PROP)) {
            AbstractModifiableLayer layer = (AbstractModifiableLayer)evt.getSource();
            this.onLayerChange(layer);
        }
    };
    protected transient WindowGeometry geometry;
    protected int windowState = 0;
    private final MainPanel panel;
    private MainMenu menu;

    public MainFrame() {
        this(new WindowGeometry(new Rectangle(10, 10, 500, 500)));
    }

    public MainFrame(WindowGeometry geometry) {
        this.geometry = geometry;
        this.panel = new MainPanel(MainApplication.getLayerManager());
        this.setContentPane(new JPanel(new BorderLayout()));
        this.setComponentOrientation();
    }

    private void setComponentOrientation() {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(Locale.getDefault());
        if (orientation == ComponentOrientation.RIGHT_TO_LEFT) {
            Logging.info(I18n.tr("Setting component orientation to right-to-left", new Object[0]));
        }
        this.applyComponentOrientation(orientation);
    }

    public void initialize() {
        this.menu = new MainMenu();
        this.addComponentListener(new WindowPositionSizeListener());
        this.addWindowStateListener(new WindowPositionSizeListener());
        this.setJMenuBar(this.menu);
        this.geometry.applySafe(this);
        List l = Stream.of("logo_16x16x32", "logo_16x16x8", "logo_32x32x32", "logo_32x32x8", "logo_48x48x32", "logo_48x48x8", "logo").map(ImageProvider::getIfAvailable).filter(Objects::nonNull).map(ImageIcon::getImage).collect(Collectors.toList());
        this.setIconImages(l);
        this.addWindowListener(new ExitWindowAdapter());
        this.setDefaultCloseOperation(0);
        MainApplication.getLayerManager().addActiveLayerChangeListener(e -> this.refreshTitle());
        MainApplication.getLayerManager().addAndFireLayerChangeListener(new ManageLayerListeners());
        UserIdentityManager.getInstance().addListener(this::refreshTitle);
        Config.getPref().addKeyPreferenceChangeListener("draw.show-user", e -> this.refreshTitle());
        this.refreshTitle();
        this.getContentPane().add((Component)this.panel, "Center");
        this.menu.initialize();
    }

    public void storeState() {
        if (this.geometry != null) {
            this.geometry.remember("gui.geometry");
        }
        Config.getPref().putBoolean("gui.maximized", (this.windowState & 6) != 0);
    }

    public MainMenu getMenu() {
        if (this.menu == null) {
            throw new IllegalStateException("Not initialized.");
        }
        return this.menu;
    }

    public MainPanel getPanel() {
        return this.panel;
    }

    public void setMaximized(boolean maximized) {
        if (maximized) {
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                this.windowState = 6;
                this.setExtendedState(this.windowState);
            } else {
                Logging.debug("Main window: maximizing not supported");
            }
        } else {
            throw new UnsupportedOperationException("Unimplemented.");
        }
    }

    public void refreshTitle() {
        OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
        boolean dirty = editLayer != null && editLayer.isDirty();
        String userInfo = UserIdentityManager.getInstance().getUserName();
        userInfo = userInfo != null && Config.getPref().getBoolean("draw.show-user", false) ? I18n.tr(" ({0})", "@" + userInfo) : "";
        this.setTitle((dirty ? "* " : "") + I18n.tr("Java OpenStreetMap Editor", new Object[0]) + userInfo);
        this.getRootPane().putClientProperty("Window.documentModified", dirty);
    }

    private void onLayerChange(AbstractModifiableLayer layer) {
        if (layer == MainApplication.getLayerManager().getEditLayer()) {
            this.refreshTitle();
        }
    }

    private class WindowPositionSizeListener
    extends WindowAdapter
    implements ComponentListener {
        private WindowPositionSizeListener() {
        }

        @Override
        public void windowStateChanged(WindowEvent e) {
            MainFrame.this.windowState = e.getNewState();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        private void handleComponentEvent(ComponentEvent e) {
            Component c = e.getComponent();
            if (c instanceof JFrame && c.isVisible()) {
                if (MainFrame.this.windowState == 0) {
                    MainFrame.this.geometry = new WindowGeometry((JFrame)c);
                } else {
                    MainFrame.this.geometry.fixScreen((JFrame)c);
                }
            }
        }
    }

    static final class ExitWindowAdapter
    extends WindowAdapter {
        ExitWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            MainApplication.exitJosm(true, 0, null);
        }
    }

    private final class ManageLayerListeners
    implements LayerManager.LayerChangeListener {
        private ManageLayerListeners() {
        }

        @Override
        public void layerAdded(LayerManager.LayerAddEvent e) {
            if (e.getAddedLayer() instanceof OsmDataLayer) {
                OsmDataLayer osmDataLayer = (OsmDataLayer)e.getAddedLayer();
                osmDataLayer.addLayerStateChangeListener(MainFrame.this.updateTitleOnLayerStateChange);
            }
            e.getAddedLayer().addPropertyChangeListener(MainFrame.this.updateTitleOnSaveChange);
        }

        @Override
        public void layerRemoving(LayerManager.LayerRemoveEvent e) {
            if (e.getRemovedLayer() instanceof OsmDataLayer) {
                OsmDataLayer osmDataLayer = (OsmDataLayer)e.getRemovedLayer();
                osmDataLayer.removeLayerStateChangeListener(MainFrame.this.updateTitleOnLayerStateChange);
            }
            e.getRemovedLayer().removePropertyChangeListener(MainFrame.this.updateTitleOnSaveChange);
        }

        @Override
        public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
        }
    }
}

