/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.display;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapMover;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.date.DateUtils;

public class LafPreference
implements SubPreferenceSetting {
    public static final StringProperty LAF = new StringProperty("laf", PlatformManager.getPlatform().getDefaultStyle());
    private JosmComboBox<UIManager.LookAndFeelInfo> lafCombo;
    VerticallyScrollablePanel panel;
    private final JCheckBox showSplashScreen = new JCheckBox(I18n.tr("Show splash screen at startup", new Object[0]));
    private final JCheckBox showUser = new JCheckBox(I18n.tr("Show user name in title", new Object[0]));
    private final JCheckBox showID = new JCheckBox(I18n.tr("Show object ID in selection lists", new Object[0]));
    private final JCheckBox showVersion = new JCheckBox(I18n.tr("Show object version in selection lists", new Object[0]));
    private final JCheckBox showCoor = new JCheckBox(I18n.tr("Show node coordinates in selection lists", new Object[0]));
    private final JCheckBox showLocalizedName = new JCheckBox(I18n.tr("Show localized name in selection lists", new Object[0]));
    private final JCheckBox modeless = new JCheckBox(I18n.tr("Modeless working (Potlatch style)", new Object[0]));
    private final JCheckBox dynamicButtons = new JCheckBox(I18n.tr("Dynamic buttons in side menus", new Object[0]));
    private final JCheckBox isoDates = new JCheckBox(I18n.tr("Display ISO dates", new Object[0]));
    private final JCheckBox dialogGeometry = new JCheckBox(I18n.tr("Remember dialog geometries", new Object[0]));
    private final JCheckBox nativeFileChoosers = new JCheckBox(I18n.tr("Use native file choosers (nicer, but do not support file filters)", new Object[0]));
    private final JCheckBox zoomReverseWheel = new JCheckBox(I18n.tr("Reverse zoom with mouse wheel", new Object[0]));
    private final JCheckBox zoomIntermediateSteps = new JCheckBox(I18n.tr("Intermediate steps between native resolutions", new Object[0]));
    private JSpinner spinZoomRatio;

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        this.lafCombo = new JosmComboBox<UIManager.LookAndFeelInfo>(UIManager.getInstalledLookAndFeels());
        if (PlatformManager.isPlatformOsx()) {
            try {
                Class<?> cquaqua = Class.forName("ch.randelshofer.quaqua.QuaquaLookAndFeel");
                Object oquaqua = cquaqua.getConstructor(null).newInstance(null);
                this.lafCombo.addItem(new UIManager.LookAndFeelInfo(((LookAndFeel)oquaqua).getName(), "ch.randelshofer.quaqua.QuaquaLookAndFeel"));
            }
            catch (ReflectiveOperationException ex) {
                Logging.debug(ex);
            }
        }
        String laf = LAF.get();
        for (int i = 0; i < this.lafCombo.getItemCount(); ++i) {
            if (!((UIManager.LookAndFeelInfo)this.lafCombo.getItemAt(i)).getClassName().equals(laf)) continue;
            this.lafCombo.setSelectedIndex(i);
            break;
        }
        this.lafCombo.setRenderer(new LafListCellRenderer());
        this.panel = new VerticallyScrollablePanel(new GridBagLayout());
        this.panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panel.add((Component)new JLabel(I18n.tr("Look and Feel", new Object[0])), GBC.std().insets(20, 0, 0, 0));
        this.panel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.panel.add(this.lafCombo, GBC.eol().fill(2));
        this.panel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 10, 0, 10));
        this.showSplashScreen.setToolTipText(I18n.tr("Show splash screen at startup", new Object[0]));
        this.showSplashScreen.setSelected(Config.getPref().getBoolean("draw.splashscreen", true));
        this.panel.add((Component)this.showSplashScreen, GBC.eop().insets(20, 0, 0, 0));
        this.showUser.setToolTipText(I18n.tr("Show user name in title", new Object[0]));
        this.showUser.setSelected(Config.getPref().getBoolean("draw.show-user", false));
        this.showID.setToolTipText(I18n.tr("Show object ID in selection lists", new Object[0]));
        this.showID.setSelected(Config.getPref().getBoolean("osm-primitives.showid", false));
        this.showVersion.setToolTipText(I18n.tr("Show object version in selection lists", new Object[0]));
        this.showVersion.setSelected(Config.getPref().getBoolean("osm-primitives.showversion", false));
        this.showCoor.setToolTipText(I18n.tr("Show node coordinates in selection lists", new Object[0]));
        this.showCoor.setSelected(Config.getPref().getBoolean("osm-primitives.showcoor", false));
        this.showLocalizedName.setToolTipText(I18n.tr("Show localized name in selection lists, if available", new Object[0]));
        this.showLocalizedName.setSelected(Config.getPref().getBoolean("osm-primitives.localize-name", true));
        ExpertToggleAction.addVisibilitySwitcher(this.showLocalizedName);
        this.modeless.setToolTipText(I18n.tr("Do not require to switch modes (potlatch style workflow)", new Object[0]));
        this.modeless.setSelected(MapFrame.MODELESS.get());
        ExpertToggleAction.addVisibilitySwitcher(this.modeless);
        this.panel.add((Component)this.showUser, GBC.eop().insets(20, 0, 0, 0));
        this.panel.add((Component)this.showID, GBC.eop().insets(20, 0, 0, 0));
        this.panel.add((Component)this.showVersion, GBC.eop().insets(20, 0, 0, 0));
        this.panel.add((Component)this.showCoor, GBC.eop().insets(20, 0, 0, 0));
        this.panel.add((Component)this.showLocalizedName, GBC.eop().insets(20, 0, 0, 0));
        this.panel.add((Component)this.modeless, GBC.eop().insets(20, 0, 0, 0));
        this.dynamicButtons.setToolTipText(I18n.tr("Display buttons in right side menus only when mouse is inside the element", new Object[0]));
        this.dynamicButtons.setSelected(ToggleDialog.PROP_DYNAMIC_BUTTONS.get());
        this.panel.add((Component)this.dynamicButtons, GBC.eop().insets(20, 0, 0, 0));
        LocalDate today = LocalDate.now(ZoneId.systemDefault());
        this.isoDates.setToolTipText(I18n.tr("Format dates according to {0}. Today''s date will be displayed as {1} instead of {2}", I18n.tr("ISO 8601", new Object[0]), today.toString(), DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).format(today)));
        this.isoDates.setSelected(DateUtils.PROP_ISO_DATES.get());
        this.panel.add((Component)this.isoDates, GBC.eop().insets(20, 0, 0, 0));
        this.dialogGeometry.setSelected(WindowGeometry.GUI_GEOMETRY_ENABLED.get());
        this.panel.add((Component)this.dialogGeometry, GBC.eop().insets(20, 0, 0, 0));
        this.nativeFileChoosers.setToolTipText(I18n.tr("Use file choosers that behave more like native ones. They look nicer but do not support some features like file filters", new Object[0]));
        this.nativeFileChoosers.setSelected(FileChooserManager.PROP_USE_NATIVE_FILE_DIALOG.get());
        this.panel.add((Component)this.nativeFileChoosers, GBC.eop().insets(20, 0, 0, 0));
        this.zoomReverseWheel.setToolTipText(I18n.tr("Check if you feel opposite direction more convenient", new Object[0]));
        this.zoomReverseWheel.setSelected(MapMover.PROP_ZOOM_REVERSE_WHEEL.get());
        this.panel.add((Component)this.zoomReverseWheel, GBC.eop().insets(20, 0, 0, 0));
        this.zoomIntermediateSteps.setToolTipText(I18n.tr("Divide intervals between native resolution levels to smaller steps if they are much larger than zoom ratio", new Object[0]));
        this.zoomIntermediateSteps.setSelected(NavigatableComponent.PROP_ZOOM_INTERMEDIATE_STEPS.get());
        ExpertToggleAction.addVisibilitySwitcher(this.zoomIntermediateSteps);
        this.panel.add((Component)this.zoomIntermediateSteps, GBC.eop().insets(20, 0, 0, 0));
        this.panel.add(Box.createVerticalGlue(), GBC.eol().insets(0, 10, 0, 0));
        double logZoomLevel = Math.log(2.0) / Math.log(NavigatableComponent.PROP_ZOOM_RATIO.get());
        logZoomLevel = Math.max(1.0, logZoomLevel);
        logZoomLevel = Math.min(5.0, logZoomLevel);
        JLabel labelZoomRatio = new JLabel(I18n.tr("Zoom steps to get double scale", new Object[0]));
        this.spinZoomRatio = new JSpinner(new SpinnerNumberModel(logZoomLevel, 1.0, 5.0, 1.0));
        JComponent spinZoomRatioEditor = this.spinZoomRatio.getEditor();
        JFormattedTextField jftf = ((JSpinner.DefaultEditor)spinZoomRatioEditor).getTextField();
        jftf.setColumns(2);
        String zoomRatioToolTipText = I18n.tr("Higher value means more steps needed, therefore zoom steps will be smaller", new Object[0]);
        this.spinZoomRatio.setToolTipText(zoomRatioToolTipText);
        labelZoomRatio.setToolTipText(zoomRatioToolTipText);
        labelZoomRatio.setLabelFor(this.spinZoomRatio);
        this.panel.add((Component)labelZoomRatio, GBC.std().insets(20, 0, 0, 0));
        this.panel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.panel.add((Component)this.spinZoomRatio, GBC.eol());
        JScrollPane scrollpane = this.panel.getVerticalScrollPane();
        scrollpane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gui.getDisplayPreference().addSubTab(this, I18n.tr("Look and Feel", new Object[0]), scrollpane);
    }

    @Override
    public boolean ok() {
        boolean mod = false;
        Config.getPref().putBoolean("draw.splashscreen", this.showSplashScreen.isSelected());
        Config.getPref().putBoolean("draw.show-user", this.showUser.isSelected());
        Config.getPref().putBoolean("osm-primitives.showid", this.showID.isSelected());
        Config.getPref().putBoolean("osm-primitives.showversion", this.showVersion.isSelected());
        Config.getPref().putBoolean("osm-primitives.showcoor", this.showCoor.isSelected());
        Config.getPref().putBoolean("osm-primitives.localize-name", this.showLocalizedName.isSelected());
        MapFrame.MODELESS.put(this.modeless.isSelected());
        Config.getPref().putBoolean(ToggleDialog.PROP_DYNAMIC_BUTTONS.getKey(), this.dynamicButtons.isSelected());
        Config.getPref().putBoolean(DateUtils.PROP_ISO_DATES.getKey(), this.isoDates.isSelected());
        WindowGeometry.GUI_GEOMETRY_ENABLED.put(this.dialogGeometry.isSelected());
        Config.getPref().putBoolean(FileChooserManager.PROP_USE_NATIVE_FILE_DIALOG.getKey(), this.nativeFileChoosers.isSelected());
        MapMover.PROP_ZOOM_REVERSE_WHEEL.put(this.zoomReverseWheel.isSelected());
        NavigatableComponent.PROP_ZOOM_INTERMEDIATE_STEPS.put(this.zoomIntermediateSteps.isSelected());
        NavigatableComponent.PROP_ZOOM_RATIO.put(Math.pow(2.0, 1.0 / (Double)this.spinZoomRatio.getModel().getValue()));
        return mod |= LAF.put(((UIManager.LookAndFeelInfo)this.lafCombo.getSelectedItem()).getClassName());
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getDisplayPreference();
    }

    static final class LafListCellRenderer
    implements ListCellRenderer<UIManager.LookAndFeelInfo> {
        private final DefaultListCellRenderer def = new DefaultListCellRenderer();

        LafListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends UIManager.LookAndFeelInfo> list, UIManager.LookAndFeelInfo value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.def.getListCellRendererComponent(list, value.getName(), index, isSelected, cellHasFocus);
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new LafPreference();
        }
    }
}

