/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BingAerialTileSource
extends TMSTileSource {
    private static final Logger LOG = FeatureAdapter.getLogger(BingAerialTileSource.class);
    public static final String METADATA_API_SETTING = "jmapviewer.bing.metadata-api-url";
    public static final String API_KEY_SETTING = "jmapviewer.bing.api-key";
    public static final String API_KEY_PLACEHOLDER = "{apikey}";
    private static final String METADATA_API_URL = "https://dev.virtualearth.net/REST/v1/Imagery/Metadata/Aerial?include=ImageryProviders&output=xml&key={apikey}";
    private static final String API_KEY = "Arzdiw4nlOJzRwOz__qailc8NiR31Tt51dN2D7cm57NrnceZnCpgOkmJhNpGoppU";
    private static volatile Future<List<Attribution>> attributions;
    private static String imageUrlTemplate;
    private static Integer imageryZoomMax;
    private static String[] subdomains;
    private static final Pattern subdomainPattern;
    private static final Pattern quadkeyPattern;
    private static final Pattern culturePattern;
    private String brandLogoUri;

    public BingAerialTileSource() {
        super(new TileSourceInfo("Bing", null, null));
        this.minZoom = 1;
    }

    public BingAerialTileSource(TileSourceInfo info) {
        super(info);
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) throws IOException {
        if (this.getAttribution() == null) {
            throw new IOException("Attribution is not loaded yet");
        }
        int t = (zoom + tilex + tiley) % subdomains.length;
        String subdomain = subdomains[t];
        String url = imageUrlTemplate;
        url = subdomainPattern.matcher(url).replaceAll(subdomain);
        url = quadkeyPattern.matcher(url).replaceAll(BingAerialTileSource.computeQuadTree(zoom, tilex, tiley));
        return url;
    }

    protected URL getAttributionUrl() throws MalformedURLException {
        return new URL(FeatureAdapter.getSetting(METADATA_API_SETTING, METADATA_API_URL).replace(API_KEY_PLACEHOLDER, FeatureAdapter.getSetting(API_KEY_SETTING, API_KEY)));
    }

    protected List<Attribution> parseAttributionText(InputSource xml) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(xml);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            imageUrlTemplate = xpath.compile("//ImageryMetadata/ImageUrl/text()").evaluate(document).replace("http://ecn.{subdomain}.tiles.virtualearth.net/", "https://ecn.{subdomain}.tiles.virtualearth.net/");
            imageUrlTemplate = culturePattern.matcher(imageUrlTemplate).replaceAll(Locale.getDefault().toString());
            imageryZoomMax = Integer.valueOf(xpath.compile("//ImageryMetadata/ZoomMax/text()").evaluate(document));
            NodeList subdomainTxt = (NodeList)xpath.compile("//ImageryMetadata/ImageUrlSubdomains/string/text()").evaluate(document, XPathConstants.NODESET);
            subdomains = new String[subdomainTxt.getLength()];
            for (int i = 0; i < subdomainTxt.getLength(); ++i) {
                BingAerialTileSource.subdomains[i] = subdomainTxt.item(i).getNodeValue();
            }
            this.brandLogoUri = xpath.compile("/Response/BrandLogoUri/text()").evaluate(document);
            XPathExpression attributionXpath = xpath.compile("Attribution/text()");
            XPathExpression coverageAreaXpath = xpath.compile("CoverageArea");
            XPathExpression zoomMinXpath = xpath.compile("ZoomMin/text()");
            XPathExpression zoomMaxXpath = xpath.compile("ZoomMax/text()");
            XPathExpression southLatXpath = xpath.compile("BoundingBox/SouthLatitude/text()");
            XPathExpression westLonXpath = xpath.compile("BoundingBox/WestLongitude/text()");
            XPathExpression northLatXpath = xpath.compile("BoundingBox/NorthLatitude/text()");
            XPathExpression eastLonXpath = xpath.compile("BoundingBox/EastLongitude/text()");
            NodeList imageryProviderNodes = (NodeList)xpath.compile("//ImageryMetadata/ImageryProvider").evaluate(document, XPathConstants.NODESET);
            ArrayList<Attribution> attributionsList = new ArrayList<Attribution>(imageryProviderNodes.getLength());
            for (int i = 0; i < imageryProviderNodes.getLength(); ++i) {
                Node providerNode = imageryProviderNodes.item(i);
                String attribution = attributionXpath.evaluate(providerNode);
                NodeList coverageAreaNodes = (NodeList)coverageAreaXpath.evaluate(providerNode, XPathConstants.NODESET);
                for (int j = 0; j < coverageAreaNodes.getLength(); ++j) {
                    Node areaNode = coverageAreaNodes.item(j);
                    Attribution attr = new Attribution();
                    attr.attributionText = attribution;
                    attr.maxZoom = Integer.parseInt(zoomMaxXpath.evaluate(areaNode));
                    attr.minZoom = Integer.parseInt(zoomMinXpath.evaluate(areaNode));
                    Double southLat = Double.valueOf(southLatXpath.evaluate(areaNode));
                    Double northLat = Double.valueOf(northLatXpath.evaluate(areaNode));
                    Double westLon = Double.valueOf(westLonXpath.evaluate(areaNode));
                    Double eastLon = Double.valueOf(eastLonXpath.evaluate(areaNode));
                    attr.min = new Coordinate(southLat, westLon);
                    attr.max = new Coordinate(northLat, eastLon);
                    attributionsList.add(attr);
                }
            }
            return attributionsList;
        }
        catch (NumberFormatException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            LOG.log(Level.SEVERE, "Could not parse Bing aerials attribution metadata.", e);
            return null;
        }
    }

    @Override
    public int getMaxZoom() {
        if (imageryZoomMax != null) {
            return imageryZoomMax;
        }
        return 22;
    }

    @Override
    public boolean requiresAttribution() {
        return true;
    }

    @Override
    public String getAttributionLinkURL() {
        return "https://www.microsoft.com/maps/assets/docs/terms.aspx";
    }

    @Override
    public Image getAttributionImage() {
        try {
            URL imageResource = JMapViewer.class.getResource("images/bing_maps.png");
            if (imageResource != null) {
                return FeatureAdapter.readImage(imageResource);
            }
            for (int i = 0; i < 5 && this.getAttribution() == null; ++i) {
                if (!JMapViewer.debug) continue;
                System.out.println("Bing attribution attempt " + (i + 1));
            }
            if (this.brandLogoUri != null && !this.brandLogoUri.isEmpty()) {
                System.out.println("Reading Bing logo from " + this.brandLogoUri);
                return FeatureAdapter.readImage(new URL(this.brandLogoUri));
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error while retrieving Bing logo: " + e.getMessage());
        }
        return null;
    }

    @Override
    public String getAttributionImageURL() {
        return "https://opengeodata.org/microsoft-imagery-details";
    }

    @Override
    public String getTermsOfUseText() {
        return null;
    }

    @Override
    public String getTermsOfUseURL() {
        return "https://opengeodata.org/microsoft-imagery-details";
    }

    protected Callable<List<Attribution>> getAttributionLoaderCallable() {
        return new Callable<List<Attribution>>(){

            @Override
            public List<Attribution> call() throws Exception {
                int waitTimeSec = 1;
                while (true) {
                    try {
                        InputSource xml = new InputSource(BingAerialTileSource.this.getAttributionUrl().openStream());
                        List<Attribution> r = BingAerialTileSource.this.parseAttributionText(xml);
                        System.out.println("Successfully loaded Bing attribution data.");
                        return r;
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, "Could not connect to Bing API. Will retry in " + waitTimeSec + " seconds.");
                        Thread.sleep(TimeUnit.SECONDS.toMillis(waitTimeSec));
                        waitTimeSec *= 2;
                        continue;
                    }
                    break;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected List<Attribution> getAttribution() {
        if (attributions == null) {
            Class<BingAerialTileSource> clazz = BingAerialTileSource.class;
            // MONITORENTER : org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource.class
            if (attributions == null) {
                FutureTask<List<Attribution>> loader = new FutureTask<List<Attribution>>(this.getAttributionLoaderCallable());
                new Thread(loader, "bing-attribution-loader").start();
                attributions = loader;
            }
            // MONITOREXIT : clazz
        }
        try {
            return attributions.get();
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (InterruptedException ign) {
            LOG.log(Level.SEVERE, "InterruptedException: " + ign.getMessage());
            return null;
        }
    }

    @Override
    public String getAttributionText(int zoom, ICoordinate topLeft, ICoordinate botRight) {
        try {
            List<Attribution> data = this.getAttribution();
            if (data == null) {
                return "Error loading Bing attribution data";
            }
            return data.stream().filter(attr -> zoom <= ((Attribution)attr).maxZoom && zoom >= ((Attribution)attr).minZoom).filter(attr -> topLeft.getLon() < ((Attribution)attr).max.getLon() && botRight.getLon() > ((Attribution)attr).min.getLon()).filter(attr -> topLeft.getLat() > ((Attribution)attr).min.getLat() && botRight.getLat() < ((Attribution)attr).max.getLat()).map(attr -> ((Attribution)attr).attributionText).collect(Collectors.joining(" "));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return "Error loading Bing attribution data";
        }
    }

    private static String computeQuadTree(int zoom, int tilex, int tiley) {
        StringBuilder k = new StringBuilder();
        for (int i = zoom; i > 0; --i) {
            char digit = '0';
            int mask = 1 << i - 1;
            if ((tilex & mask) != 0) {
                digit = (char)(digit + 1);
            }
            if ((tiley & mask) != 0) {
                digit = (char)(digit + 2);
            }
            k.append(digit);
        }
        return k.toString();
    }

    static {
        subdomainPattern = Pattern.compile("\\{subdomain\\}");
        quadkeyPattern = Pattern.compile("\\{quadkey\\}");
        culturePattern = Pattern.compile("\\{culture\\}");
    }

    protected static class Attribution {
        private String attributionText;
        private int minZoom;
        private int maxZoom;
        private Coordinate min;
        private Coordinate max;

        protected Attribution() {
        }
    }
}

