/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.SVGException;
import com.kitfox.svg.Tspan;
import com.kitfox.svg.util.FontUtil;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;

public class Text
extends Tspan {
    public static final String TAG_NAME = "text";
    public static final int TXAN_START = 0;
    public static final int TXAN_MIDDLE = 1;
    public static final int TXAN_END = 2;
    public static final int TXST_NORMAL = 0;
    public static final int TXST_ITALIC = 1;
    public static final int TXST_OBLIQUE = 2;
    public static final int TXWE_NORMAL = 0;
    public static final int TXWE_BOLD = 1;
    public static final int TXWE_BOLDER = 2;
    public static final int TXWE_LIGHTER = 3;
    public static final int TXWE_100 = 4;
    public static final int TXWE_200 = 5;
    public static final int TXWE_300 = 6;
    public static final int TXWE_400 = 7;
    public static final int TXWE_500 = 8;
    public static final int TXWE_600 = 9;
    public static final int TXWE_700 = 10;
    public static final int TXWE_800 = 11;
    public static final int TXWE_900 = 12;
    int textAnchor = 0;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    public void rebuild() throws SVGException {
        this.build();
    }

    @Override
    protected void build() throws SVGException {
        super.build();
        this.buildText();
    }

    @Override
    protected void buildAttributes(StyleAttribute sty) throws SVGException {
        String s;
        super.buildAttributes(sty);
        this.textAnchor = this.getStyle(sty.setName("text-anchor")) ? ((s = sty.getStringValue()).equals("middle") ? 1 : (s.equals("end") ? 2 : 0)) : 0;
    }

    private void buildText() throws SVGException {
        this.buildShapeInformation();
        Tspan.Cursor cursor = this.createInitialCursor();
        float xInitial = cursor.x;
        super.buildTextShape(cursor);
        this.alignSegmentsAtAnchor(this.fullPath, xInitial);
    }

    private void alignSegmentsAtAnchor(Path2D textPath, float xInitial) {
        AffineTransform tx;
        switch (this.textAnchor) {
            case 1: {
                Rectangle2D bounds = textPath.getBounds2D();
                tx = AffineTransform.getTranslateInstance(-(bounds.getX() + bounds.getWidth() / 2.0 - (double)xInitial), 0.0);
                break;
            }
            case 2: {
                Rectangle2D bounds = textPath.getBounds2D();
                tx = AffineTransform.getTranslateInstance(-(bounds.getX() + bounds.getWidth() - (double)xInitial), 0.0);
                break;
            }
            default: {
                tx = null;
            }
        }
        if (tx != null) {
            this.fullPath.transform(tx);
            this.textBounds = this.fullPath.getBounds2D();
            this.transformSegments(this.segments, tx);
        }
    }

    private void transformSegments(List<Tspan.TextSegment> segments, AffineTransform transform) {
        for (Tspan.TextSegment segment : segments) {
            if (segment.textPath != null) {
                segment.textPath.transform(transform);
                continue;
            }
            segment.element.fullPath.transform(transform);
            segment.element.textBounds = segment.element.fullPath.getBounds2D();
            this.transformSegments(segment.element.segments, transform);
        }
    }

    @Override
    public boolean updateTime(double curTime) throws SVGException {
        boolean shapeChange;
        boolean changeState = super.updateTime(curTime);
        FontUtil.FontInfo fontInfoOld = this.fontInfo;
        float[] xOld = this.x;
        float[] yOld = this.y;
        float[] dxOld = this.dx;
        float[] dyOld = this.dy;
        this.buildShapeInformation();
        boolean bl = shapeChange = !this.fontInfo.equals(fontInfoOld) || !Arrays.equals(xOld, this.x) || !Arrays.equals(yOld, this.y) || !Arrays.equals(dxOld, this.dx) || !Arrays.equals(dyOld, this.dy);
        if (shapeChange) {
            this.buildText();
        }
        return changeState || shapeChange;
    }
}

