/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.download.AbstractDownloadSourcePanel;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSettings;
import org.openstreetmap.josm.gui.download.DownloadSource;
import org.openstreetmap.josm.gui.download.IDownloadSourceType;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public class OSMDownloadSource
implements DownloadSource<List<IDownloadSourceType>> {
    public static final String SIMPLE_NAME = "osmdownloadpanel";
    static final List<IDownloadSourceType> DOWNLOAD_SOURCES = new ArrayList<IDownloadSourceType>();

    @Override
    public AbstractDownloadSourcePanel<List<IDownloadSourceType>> createPanel(DownloadDialog dialog) {
        return new OSMDownloadSourcePanel(this, dialog);
    }

    @Override
    public void doDownload(List<IDownloadSourceType> data, DownloadSettings settings) {
        Bounds bbox = settings.getDownloadBounds().orElseThrow(() -> new IllegalArgumentException("OSM downloads requires bounds"));
        boolean zoom = settings.zoomToData();
        boolean newLayer = settings.asNewLayer();
        ArrayList tasks = new ArrayList();
        IDownloadSourceType zoomTask = zoom ? (IDownloadSourceType)data.stream().findFirst().orElse(null) : null;
        data.stream().filter(IDownloadSourceType::isEnabled).forEach(type -> {
            try {
                AbstractDownloadTask<?> task = type.getDownloadClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                task.setZoomAfterDownload(type.equals(zoomTask));
                Future<?> future = task.download(new DownloadParams().withNewLayer(newLayer), bbox, null);
                MainApplication.worker.submit(new PostDownloadHandler(task, future));
                if (zoom) {
                    tasks.add(new Pair(task, future));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Logging.error(e);
            }
        });
        if (zoom && tasks.size() > 1) {
            MainApplication.worker.submit(() -> {
                ProjectionBounds bounds = null;
                for (Pair p : tasks) {
                    try {
                        ((Future)p.b).get();
                        ProjectionBounds b = ((AbstractDownloadTask)p.a).getDownloadProjectionBounds();
                        if (bounds == null) {
                            bounds = b;
                            continue;
                        }
                        if (b == null) continue;
                        bounds.extend(b);
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Logging.warn(ex);
                    }
                }
                MapFrame map = MainApplication.getMap();
                if (map != null && bounds != null) {
                    ProjectionBounds pb = bounds;
                    GuiHelper.runInEDTAndWait(() -> map.mapView.zoomTo(new ViewportData(pb)));
                }
            });
        }
    }

    @Override
    public String getLabel() {
        return I18n.tr("Download from OSM", new Object[0]);
    }

    @Override
    public boolean onlyExpert() {
        return false;
    }

    public static List<IDownloadSourceType> getDownloadTypes() {
        return Collections.unmodifiableList(DOWNLOAD_SOURCES);
    }

    public static <T extends IDownloadSourceType> T getDownloadType(Class<T> typeClazz) {
        return (T)((IDownloadSourceType)DOWNLOAD_SOURCES.stream().filter(typeClazz::isInstance).map(typeClazz::cast).findFirst().orElse(null));
    }

    public static boolean removeDownloadType(IDownloadSourceType type) {
        if (type instanceof OsmDataDownloadType || type instanceof GpsDataDownloadType || type instanceof NotesDataDownloadType) {
            throw new IllegalArgumentException(type.getClass().getName());
        }
        return DOWNLOAD_SOURCES.remove(type);
    }

    public static boolean addDownloadType(IDownloadSourceType type) {
        if (type instanceof OsmDataDownloadType || type instanceof GpsDataDownloadType || type instanceof NotesDataDownloadType) {
            throw new IllegalArgumentException(type.getClass().getName());
        }
        if (OSMDownloadSource.getDownloadType(type.getClass()) != null) {
            return false;
        }
        return DOWNLOAD_SOURCES.add(type);
    }

    static {
        DOWNLOAD_SOURCES.add(new OsmDataDownloadType());
        DOWNLOAD_SOURCES.add(new GpsDataDownloadType());
        DOWNLOAD_SOURCES.add(new NotesDataDownloadType());
    }

    public static class OSMDownloadSourcePanel
    extends AbstractDownloadSourcePanel<List<IDownloadSourceType>> {
        private final JLabel sizeCheck = new JLabel();
        private final JPanel downloadSourcesPanel;
        private final ChangeListener checkboxChangeListener;
        public static final String DATA_SOURCES_AND_TYPES = I18n.marktr("Data Sources and Types:");

        public OSMDownloadSourcePanel(OSMDownloadSource ds, DownloadDialog dialog) {
            super(ds);
            this.setLayout(new GridBagLayout());
            this.checkboxChangeListener = e -> {
                this.rememberSettings();
                dialog.getSelectedDownloadArea().ifPresent(this::boundingBoxChanged);
            };
            this.downloadSourcesPanel = new JPanel(new FlowLayout(0));
            this.add((Component)this.downloadSourcesPanel, GBC.eol().fill(2));
            this.updateSources();
            this.sizeCheck.setFont(this.sizeCheck.getFont().deriveFont(0));
            JPanel sizeCheckPanel = new JPanel(new FlowLayout(0));
            sizeCheckPanel.add(this.sizeCheck);
            this.add((Component)sizeCheckPanel, GBC.eol().fill(2));
            this.setMinimumSize(new Dimension(450, 115));
        }

        protected void updateSources() {
            this.downloadSourcesPanel.removeAll();
            this.downloadSourcesPanel.add(new JLabel(I18n.tr(DATA_SOURCES_AND_TYPES, new Object[0])));
            DOWNLOAD_SOURCES.forEach(obj -> {
                Icon icon = obj.getIcon();
                if (icon != null) {
                    this.downloadSourcesPanel.add(Box.createHorizontalStrut(6));
                    this.downloadSourcesPanel.add(new JLabel(icon));
                }
                this.downloadSourcesPanel.add(obj.getCheckBox(this.checkboxChangeListener));
            });
        }

        @Override
        public List<IDownloadSourceType> getData() {
            return DOWNLOAD_SOURCES;
        }

        @Override
        public void rememberSettings() {
            DOWNLOAD_SOURCES.forEach(type -> type.getBooleanProperty().put(type.getCheckBox().isSelected()));
        }

        @Override
        public void restoreSettings() {
            this.updateSources();
            DOWNLOAD_SOURCES.forEach(type -> type.getCheckBox().setSelected(type.isEnabled()));
        }

        @Override
        public void setVisible(boolean aFlag) {
            super.setVisible(aFlag);
            this.updateSources();
        }

        @Override
        public boolean checkDownload(DownloadSettings settings) {
            int confirmation;
            if (!settings.getDownloadBounds().isPresent()) {
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Please select a download area first.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                return false;
            }
            boolean slippyMapShowsDownloadBounds = settings.getSlippyMapBounds().map(b -> b.intersects(settings.getDownloadBounds().get())).orElse(true);
            if (!slippyMapShowsDownloadBounds && (confirmation = JOptionPane.showConfirmDialog(this.getParent(), I18n.tr("The slippy map no longer shows the selected download bounds. Continue?", new Object[0]), I18n.tr("Confirmation", new Object[0]), 2, 3)) != 0) {
                return false;
            }
            if (DOWNLOAD_SOURCES.stream().noneMatch(IDownloadSourceType::isEnabled)) {
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Please select at least one download source.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                return false;
            }
            this.rememberSettings();
            return true;
        }

        @Override
        public Icon getIcon() {
            return ImageProvider.get("download");
        }

        @Override
        public void boundingBoxChanged(Bounds bbox) {
            if (bbox == null) {
                this.sizeCheck.setText(I18n.tr("No area selected yet", new Object[0]));
                this.sizeCheck.setForeground(Color.darkGray);
                return;
            }
            this.displaySizeCheckResult(DOWNLOAD_SOURCES.stream().filter(IDownloadSourceType::isEnabled).anyMatch(type -> type.isDownloadAreaTooLarge(bbox)));
        }

        @Override
        public String getSimpleName() {
            return OSMDownloadSource.SIMPLE_NAME;
        }

        private void displaySizeCheckResult(boolean isAreaTooLarge) {
            if (isAreaTooLarge) {
                this.sizeCheck.setText(I18n.tr("Download area too large; will probably be rejected by server", new Object[0]));
                this.sizeCheck.setForeground(Color.red);
            } else {
                this.sizeCheck.setText(I18n.tr("Download area ok, size probably acceptable to server", new Object[0]));
                this.sizeCheck.setForeground(Color.darkGray);
            }
        }
    }

    private static class OsmDataDownloadType
    implements IDownloadSourceType {
        static final BooleanProperty IS_ENABLED = new BooleanProperty("download.osm.data", true);
        JCheckBox cbDownloadOsmData;

        private OsmDataDownloadType() {
        }

        @Override
        public JCheckBox getCheckBox(ChangeListener checkboxChangeListener) {
            if (this.cbDownloadOsmData == null) {
                this.cbDownloadOsmData = new JCheckBox(I18n.tr("OpenStreetMap data", new Object[0]), true);
                this.cbDownloadOsmData.setToolTipText(I18n.tr("Select to download OSM data in the selected download area.", new Object[0]));
                this.cbDownloadOsmData.getModel().addChangeListener(checkboxChangeListener);
            }
            if (checkboxChangeListener != null) {
                this.cbDownloadOsmData.getModel().addChangeListener(checkboxChangeListener);
            }
            return this.cbDownloadOsmData;
        }

        @Override
        public Icon getIcon() {
            return ImageProvider.get("layer/osmdata_small", ImageProvider.ImageSizes.SMALLICON);
        }

        public Class<? extends AbstractDownloadTask<DataSet>> getDownloadClass() {
            return DownloadOsmTask.class;
        }

        @Override
        public BooleanProperty getBooleanProperty() {
            return IS_ENABLED;
        }

        @Override
        public boolean isDownloadAreaTooLarge(Bounds bound) {
            return bound.getArea() > Config.getPref().getDouble("osm-server.max-request-area", 0.25);
        }
    }

    private static class GpsDataDownloadType
    implements IDownloadSourceType {
        static final BooleanProperty IS_ENABLED = new BooleanProperty("download.osm.gps", false);
        private JCheckBox cbDownloadGpxData;

        private GpsDataDownloadType() {
        }

        @Override
        public JCheckBox getCheckBox(ChangeListener checkboxChangeListener) {
            if (this.cbDownloadGpxData == null) {
                this.cbDownloadGpxData = new JCheckBox(I18n.tr("Raw GPS data", new Object[0]));
                this.cbDownloadGpxData.setToolTipText(I18n.tr("Select to download GPS traces in the selected download area.", new Object[0]));
            }
            if (checkboxChangeListener != null) {
                this.cbDownloadGpxData.getModel().addChangeListener(checkboxChangeListener);
            }
            return this.cbDownloadGpxData;
        }

        @Override
        public Icon getIcon() {
            return ImageProvider.get("layer/gpx_small", ImageProvider.ImageSizes.SMALLICON);
        }

        public Class<? extends AbstractDownloadTask<GpxData>> getDownloadClass() {
            return DownloadGpsTask.class;
        }

        @Override
        public BooleanProperty getBooleanProperty() {
            return IS_ENABLED;
        }

        @Override
        public boolean isDownloadAreaTooLarge(Bounds bound) {
            return false;
        }
    }

    private static class NotesDataDownloadType
    implements IDownloadSourceType {
        static final BooleanProperty IS_ENABLED = new BooleanProperty("download.osm.notes", false);
        private JCheckBox cbDownloadNotes;

        private NotesDataDownloadType() {
        }

        @Override
        public JCheckBox getCheckBox(ChangeListener checkboxChangeListener) {
            if (this.cbDownloadNotes == null) {
                this.cbDownloadNotes = new JCheckBox(I18n.tr("Notes", new Object[0]));
                this.cbDownloadNotes.setToolTipText(I18n.tr("Select to download notes in the selected download area.", new Object[0]));
            }
            if (checkboxChangeListener != null) {
                this.cbDownloadNotes.getModel().addChangeListener(checkboxChangeListener);
            }
            return this.cbDownloadNotes;
        }

        @Override
        public Icon getIcon() {
            return ImageProvider.get("dialogs/notes/note_open", ImageProvider.ImageSizes.SMALLICON);
        }

        public Class<? extends AbstractDownloadTask<NoteData>> getDownloadClass() {
            return DownloadNotesTask.class;
        }

        @Override
        public BooleanProperty getBooleanProperty() {
            return IS_ENABLED;
        }

        @Override
        public boolean isDownloadAreaTooLarge(Bounds bound) {
            return bound.getArea() > Config.getPref().getDouble("osm-server.max-request-area-notes", 25.0);
        }
    }
}

