/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.tools.Pair;

public class NodePair {
    private final Node a;
    private final Node b;

    public NodePair(Node a, Node b) {
        this.a = a;
        this.b = b;
    }

    public NodePair(Pair<Node, Node> pair) {
        this((Node)pair.a, (Node)pair.b);
    }

    public Node getA() {
        return this.a;
    }

    public Node getB() {
        return this.b;
    }

    public boolean isSuccessorOf(NodePair other) {
        return other.getB() == this.a;
    }

    public boolean isPredecessorOf(NodePair other) {
        return this.b == other.getA();
    }

    public NodePair swap() {
        return new NodePair(this.b, this.a);
    }

    public String toString() {
        return "[" + this.a.getId() + ',' + this.b.getId() + ']';
    }

    public boolean contains(Node n) {
        return this.a == n || this.b == n;
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NodePair nodePair = (NodePair)obj;
        return Objects.equals(this.a, nodePair.a) && Objects.equals(this.b, nodePair.b);
    }
}

