/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.openstreetmap.josm.data.oauth.IOAuthParameters;
import org.openstreetmap.josm.data.oauth.IOAuthToken;
import org.openstreetmap.josm.data.oauth.OAuth20Authorization;
import org.openstreetmap.josm.data.oauth.OAuthAccessTokenHolder;
import org.openstreetmap.josm.data.oauth.OAuthException;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthVersion;
import org.openstreetmap.josm.data.oauth.osm.OsmScopes;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.MissingOAuthAccessTokenException;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;

public class OsmConnection {
    private static final String BASIC_AUTH = "Basic ";
    protected boolean cancel;
    protected HttpClient activeConnection;
    protected IOAuthParameters oAuth20Parameters;
    static volatile OAuthAccessTokenFetcher fetcher = u -> {
        throw new JosmRuntimeException("OsmConnection.setOAuthAccessTokenFetcher() has not been called");
    };

    public static void setOAuthAccessTokenFetcher(OAuthAccessTokenFetcher tokenFetcher) {
        fetcher = Objects.requireNonNull(tokenFetcher, "tokenFetcher");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.cancel = true;
        OsmConnection osmConnection = this;
        synchronized (osmConnection) {
            if (this.activeConnection != null) {
                this.activeConnection.disconnect();
            }
        }
    }

    protected String retrieveBasicAuthorizationLogin(HttpClient con) throws OsmTransferException {
        String auth = con.getRequestHeader("Authorization");
        if (auth != null && auth.startsWith(BASIC_AUTH)) {
            try {
                String[] token = new String(Base64.getDecoder().decode(auth.substring(BASIC_AUTH.length())), StandardCharsets.UTF_8).split(":", -1);
                if (token.length == 2) {
                    return token[0];
                }
            }
            catch (IllegalArgumentException e) {
                Logging.error(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBasicAuthorizationHeader(HttpClient con) throws OsmTransferException {
        CredentialsAgentResponse response;
        try {
            CredentialsManager credentialsManager = CredentialsManager.getInstance();
            synchronized (credentialsManager) {
                response = CredentialsManager.getInstance().getCredentials(Authenticator.RequestorType.SERVER, con.getURL().getHost(), false);
            }
        }
        catch (CredentialsAgentException e) {
            throw new OsmTransferException(e);
        }
        if (response != null) {
            if (response.isCanceled()) {
                this.cancel = true;
            } else {
                String username = response.getUsername() == null ? "" : response.getUsername();
                String password = response.getPassword() == null ? "" : String.valueOf(response.getPassword());
                String token = username + ':' + password;
                con.setHeader("Authorization", BASIC_AUTH + Base64.getEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8)));
            }
        }
    }

    private void obtainOAuth20Token() throws MissingOAuthAccessTokenException {
        if (!Boolean.TRUE.equals(GuiHelper.runInEDTAndWaitAndReturn(() -> ConditionalOptionPaneUtil.showConfirmationDialog("oauth.oauth20.obtain.automatically", MainApplication.getMainFrame(), I18n.tr("Obtain OAuth 2.0 token for authentication?", new Object[0]), I18n.tr("Obtain authentication to OSM servers", new Object[0]), 1, 3, 0)))) {
            return;
        }
        boolean remoteControlIsRunning = Boolean.TRUE.equals(RemoteControl.PROP_REMOTECONTROL_ENABLED.get());
        if (!remoteControlIsRunning) {
            RemoteControl.start();
        }
        CountDownLatch done = new CountDownLatch(1);
        Consumer<Optional<IOAuthToken>> consumer = authToken -> {
            if (!remoteControlIsRunning) {
                RemoteControl.stop();
            }
            OAuthAccessTokenHolder.getInstance().setAccessToken(OsmApi.getOsmApi().getServerUrl(), authToken.orElse(null));
            OAuthAccessTokenHolder.getInstance().save(CredentialsManager.getInstance());
            done.countDown();
        };
        new OAuth20Authorization().authorize(this.oAuth20Parameters, consumer, OsmScopes.read_gpx, OsmScopes.write_gpx, OsmScopes.read_prefs, OsmScopes.write_prefs, OsmScopes.write_api, OsmScopes.write_notes);
        for (int counter = 0; done.getCount() >= 0L && counter < 5; ++counter) {
            try {
                if (!done.await(1L, TimeUnit.MINUTES)) continue;
                break;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Logging.trace(e);
                consumer.accept(null);
                throw new MissingOAuthAccessTokenException(e);
            }
        }
    }

    protected void addOAuth20AuthorizationHeader(HttpClient connection) throws OsmTransferException {
        OAuthAccessTokenHolder holder;
        IOAuthToken token;
        if (this.oAuth20Parameters == null) {
            this.oAuth20Parameters = OAuthParameters.createFromApiUrl(connection.getURL().getHost(), OAuthVersion.OAuth20);
        }
        if ((token = (holder = OAuthAccessTokenHolder.getInstance()).getAccessToken(connection.getURL().toExternalForm(), OAuthVersion.OAuth20)) == null) {
            this.obtainOAuth20Token();
            token = holder.getAccessToken(connection.getURL().toExternalForm(), OAuthVersion.OAuth20);
        }
        if (token == null) {
            throw new MissingOAuthAccessTokenException();
        }
        try {
            token.sign(connection);
        }
        catch (OAuthException e) {
            throw new OsmTransferException(I18n.tr("Failed to sign a HTTP connection with an OAuth Authentication header", new Object[0]), e);
        }
    }

    protected void addAuth(HttpClient connection) throws OsmTransferException {
        String authMethod;
        switch (authMethod = OsmApi.getAuthMethod()) {
            case "basic": {
                this.addBasicAuthorizationHeader(connection);
                return;
            }
            case "oauth20": {
                this.addOAuth20AuthorizationHeader(connection);
                return;
            }
        }
        String msg = I18n.tr("Unexpected value for preference ''{0}''. Got ''{1}''.", "osm-server.auth-method", authMethod);
        Logging.warn(msg);
        throw new OsmTransferException(msg);
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    public static interface OAuthAccessTokenFetcher {
        public void obtainAccessToken(URL var1) throws InvocationTargetException, InterruptedException;
    }
}

