/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.Charsets;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.exif.makernotes.NikonPictureControl2Descriptor;
import java.io.IOException;
import java.util.HashMap;

public final class NikonPictureControl2Directory
extends Directory {
    public static final int TAG_PICTURE_CONTROL_VERSION = 0;
    public static final int TAG_PICTURE_CONTROL_NAME = 4;
    public static final int TAG_PICTURE_CONTROL_BASE = 24;
    public static final int TAG_PICTURE_CONTROL_ADJUST = 48;
    public static final int TAG_PICTURE_CONTROL_QUICK_ADJUST = 49;
    public static final int TAG_SHARPNESS = 51;
    public static final int TAG_CLARITY = 53;
    public static final int TAG_CONTRAST = 55;
    public static final int TAG_BRIGHTNESS = 57;
    public static final int TAG_SATURATION = 59;
    public static final int TAG_HUE = 61;
    public static final int TAG_FILTER_EFFECT = 63;
    public static final int TAG_TONING_EFFECT = 64;
    public static final int TAG_TONING_SATURATION = 65;
    private static final HashMap<Integer, String> TAG_NAME_MAP = new HashMap();

    public NikonPictureControl2Directory() {
        this.setDescriptor(new NikonPictureControl2Descriptor(this));
    }

    @Override
    @NotNull
    public String getName() {
        return "Nikon PictureControl 2";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return TAG_NAME_MAP;
    }

    public static NikonPictureControl2Directory read(byte[] bytes) throws IOException {
        int EXPECTED_LENGTH = 68;
        if (bytes.length != EXPECTED_LENGTH) {
            throw new IllegalArgumentException("Must have " + EXPECTED_LENGTH + " bytes.");
        }
        SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
        NikonPictureControl2Directory directory = new NikonPictureControl2Directory();
        directory.setString(0, reader.getStringValue(4, Charsets.UTF_8).toString());
        directory.setString(4, reader.getStringValue(20, Charsets.UTF_8).toString());
        directory.setString(24, reader.getStringValue(20, Charsets.UTF_8).toString());
        reader.skip(4L);
        directory.setObject(48, reader.getByte());
        directory.setObject(49, reader.getByte());
        reader.skip(1L);
        directory.setObject(51, reader.getByte());
        reader.skip(1L);
        directory.setObject(53, reader.getByte());
        reader.skip(1L);
        directory.setObject(55, reader.getByte());
        reader.skip(1L);
        directory.setObject(57, reader.getByte());
        reader.skip(1L);
        directory.setObject(59, reader.getByte());
        reader.skip(1L);
        directory.setObject(61, reader.getByte());
        reader.skip(1L);
        directory.setObject(63, reader.getByte());
        directory.setObject(64, reader.getByte());
        directory.setObject(65, reader.getByte());
        reader.skip(2L);
        assert (reader.getPosition() == (long)EXPECTED_LENGTH);
        return directory;
    }

    static {
        TAG_NAME_MAP.put(0, "Picture Control Version");
        TAG_NAME_MAP.put(4, "Picture Control Name");
        TAG_NAME_MAP.put(24, "Picture Control Base");
        TAG_NAME_MAP.put(48, "Picture Control Adjust");
        TAG_NAME_MAP.put(49, "Picture Control Quick Adjust");
        TAG_NAME_MAP.put(51, "Sharpness");
        TAG_NAME_MAP.put(53, "Clarity");
        TAG_NAME_MAP.put(55, "Contrast");
        TAG_NAME_MAP.put(57, "Brightness");
        TAG_NAME_MAP.put(59, "Saturation");
        TAG_NAME_MAP.put(61, "Hue");
        TAG_NAME_MAP.put(63, "Filter Effect");
        TAG_NAME_MAP.put(64, "Toning Effect");
        TAG_NAME_MAP.put(65, "Toning Saturation");
    }
}

