/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.UniqueIdGenerator;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.tools.I18n;

public enum OsmPrimitiveType {
    NODE(I18n.marktr("node"), Node.class, NodeData.class, Node.idGenerator),
    WAY(I18n.marktr("way"), Way.class, WayData.class, Way.idGenerator),
    RELATION(I18n.marktr("relation"), Relation.class, RelationData.class, Relation.idGenerator),
    CLOSEDWAY(I18n.marktr("closedway"), null, WayData.class, Way.idGenerator),
    MULTIPOLYGON(I18n.marktr("multipolygon"), null, RelationData.class, Relation.idGenerator);

    private static final Collection<OsmPrimitiveType> DATA_VALUES;
    private final String apiTypeName;
    private final Class<? extends OsmPrimitive> osmClass;
    private final Class<? extends PrimitiveData> dataClass;
    private final UniqueIdGenerator idGenerator;

    private OsmPrimitiveType(String apiTypeName, Class<? extends OsmPrimitive> osmClass, Class<? extends PrimitiveData> dataClass, UniqueIdGenerator idGenerator) {
        this.apiTypeName = apiTypeName;
        this.osmClass = osmClass;
        this.dataClass = dataClass;
        this.idGenerator = idGenerator;
    }

    public String getAPIName() {
        return this.apiTypeName;
    }

    public Class<? extends OsmPrimitive> getOsmClass() {
        return this.osmClass;
    }

    public Class<? extends PrimitiveData> getDataClass() {
        return this.dataClass;
    }

    public static OsmPrimitiveType fromApiTypeName(String typeName) {
        for (OsmPrimitiveType type : OsmPrimitiveType.values()) {
            if (!type.getAPIName().equals(typeName)) continue;
            return type;
        }
        throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' is not a valid type name. Got ''{1}''.", "typeName", typeName));
    }

    public static OsmPrimitiveType from(IPrimitive obj) {
        if (obj instanceof INode) {
            return NODE;
        }
        if (obj instanceof IWay) {
            return WAY;
        }
        if (obj instanceof IRelation) {
            return RELATION;
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(obj));
    }

    public static OsmPrimitiveType from(String value) {
        return Arrays.stream(OsmPrimitiveType.values()).filter(type -> type.getAPIName().equalsIgnoreCase(value)).findFirst().orElse(null);
    }

    public static Collection<OsmPrimitiveType> dataValues() {
        return DATA_VALUES;
    }

    public OsmPrimitive newInstance(long uniqueId, boolean allowNegative) {
        switch (this.ordinal()) {
            case 0: {
                return new Node(uniqueId, allowNegative);
            }
            case 1: {
                return new Way(uniqueId, allowNegative);
            }
            case 2: {
                return new Relation(uniqueId, allowNegative);
            }
        }
        throw new AssertionError();
    }

    public OsmPrimitive newVersionedInstance(long id, int version) {
        switch (this.ordinal()) {
            case 0: {
                return new Node(id, version);
            }
            case 1: {
                return new Way(id, version);
            }
            case 2: {
                return new Relation(id, version);
            }
        }
        throw new AssertionError();
    }

    public final UniqueIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public String toString() {
        return I18n.tr(this.getAPIName(), new Object[0]);
    }

    static {
        DATA_VALUES = Arrays.asList(NODE, WAY, RELATION);
    }
}

