/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import java.io.Serializable;
import java.util.Objects;
import org.openstreetmap.josm.data.coor.EastNorth;

public class PolarCoor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final double radius;
    public final double angle;
    public final EastNorth pole;

    public PolarCoor(double radius, double angle) {
        this(radius, angle, new EastNorth(0.0, 0.0));
    }

    public PolarCoor(double radius, double angle, EastNorth pole) {
        this.radius = radius;
        this.angle = angle;
        this.pole = pole;
    }

    public PolarCoor(EastNorth en) {
        this(en, new EastNorth(0.0, 0.0));
    }

    public PolarCoor(EastNorth en, EastNorth pole) {
        this(en.distance(pole), PolarCoor.computeAngle(en, pole), pole);
    }

    public static double computeAngle(EastNorth en, EastNorth pole) {
        return Math.atan2(en.north() - pole.north(), en.east() - pole.east());
    }

    public EastNorth toEastNorth() {
        return new EastNorth(this.radius * Math.cos(this.angle) + this.pole.east(), this.radius * Math.sin(this.angle) + this.pole.north());
    }

    public int hashCode() {
        return Objects.hash(this.radius, this.angle, this.pole);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PolarCoor that = (PolarCoor)obj;
        return Double.compare(that.radius, this.radius) == 0 && Double.compare(that.angle, this.angle) == 0 && Objects.equals(that.pole, this.pole);
    }

    public String toString() {
        return "PolarCoor [radius=" + this.radius + ", angle=" + this.angle + ", pole=" + String.valueOf(this.pole) + "]";
    }
}

