/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.CyclicUploadDependencyException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveComparator;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class APIDataSet {
    private List<OsmPrimitive> toAdd = new LinkedList<OsmPrimitive>();
    private final List<OsmPrimitive> toUpdate = new LinkedList<OsmPrimitive>();
    private List<OsmPrimitive> toDelete = new LinkedList<OsmPrimitive>();

    public APIDataSet() {
    }

    public void init(DataSet ds) {
        if (ds == null) {
            return;
        }
        this.init(ds.allPrimitives());
    }

    public final void init(Collection<OsmPrimitive> primitives) {
        this.toAdd.clear();
        this.toUpdate.clear();
        this.toDelete.clear();
        block5: for (OsmPrimitive osm : primitives) {
            APIOperation op = APIOperation.of(osm);
            if (op == null) continue;
            switch (op.ordinal()) {
                case 0: {
                    this.toAdd.add(osm);
                    continue block5;
                }
                case 1: {
                    this.toUpdate.add(osm);
                    continue block5;
                }
                case 2: {
                    this.toDelete.add(osm);
                    continue block5;
                }
            }
            Logging.trace("Ignored primitive {0} -> {1}", new Object[]{osm, op});
        }
        Comparator<OsmPrimitive> orderingNodesWaysRelations = OsmPrimitiveComparator.orderingNodesWaysRelations();
        Comparator<OsmPrimitive> byUniqueId = OsmPrimitiveComparator.comparingUniqueId();
        this.toAdd.sort(orderingNodesWaysRelations.thenComparing(byUniqueId));
        this.toUpdate.sort(orderingNodesWaysRelations.thenComparing(byUniqueId));
        this.toDelete.sort(orderingNodesWaysRelations.reversed().thenComparing(byUniqueId));
    }

    public APIDataSet(DataSet ds) {
        this();
        this.init(ds);
    }

    public boolean participatesInConflict(ConflictCollection conflicts) {
        if (conflicts == null || conflicts.isEmpty()) {
            return false;
        }
        Set idsParticipatingInConflicts = conflicts.get().stream().flatMap(c -> Stream.of(c.getMy(), c.getTheir())).map(IPrimitive::getPrimitiveId).collect(Collectors.toSet());
        return Stream.of(this.toUpdate, this.toDelete).flatMap(Collection::stream).map(IPrimitive::getPrimitiveId).anyMatch(idsParticipatingInConflicts::contains);
    }

    public APIDataSet(Collection<OsmPrimitive> primitives) {
        this();
        this.init(primitives);
    }

    public boolean isEmpty() {
        return this.toAdd.isEmpty() && this.toUpdate.isEmpty() && this.toDelete.isEmpty();
    }

    public List<OsmPrimitive> getPrimitivesToAdd() {
        return this.toAdd;
    }

    public List<OsmPrimitive> getPrimitivesToUpdate() {
        return this.toUpdate;
    }

    public List<OsmPrimitive> getPrimitivesToDelete() {
        return this.toDelete;
    }

    public List<OsmPrimitive> getPrimitives() {
        LinkedList<OsmPrimitive> ret = new LinkedList<OsmPrimitive>();
        ret.addAll(this.toAdd);
        ret.addAll(this.toUpdate);
        ret.addAll(this.toDelete);
        return ret;
    }

    public int getSize() {
        return this.toAdd.size() + this.toUpdate.size() + this.toDelete.size();
    }

    public void removeProcessed(Collection<IPrimitive> processed) {
        if (processed == null) {
            return;
        }
        this.toAdd.removeAll(processed);
        this.toUpdate.removeAll(processed);
        this.toDelete.removeAll(processed);
    }

    public void adjustRelationUploadOrder() throws CyclicUploadDependencyException {
        LinkedList<OsmPrimitive> newToAdd = new LinkedList<OsmPrimitive>();
        newToAdd.addAll(Utils.filteredCollection(this.toAdd, Node.class));
        newToAdd.addAll(Utils.filteredCollection(this.toAdd, Way.class));
        ArrayList<Relation> relationsToAdd = new ArrayList<Relation>(Utils.filteredCollection(this.toAdd, Relation.class));
        List<Relation> noProblemRelations = this.filterRelationsNotReferringToNewRelations(relationsToAdd);
        newToAdd.addAll(noProblemRelations);
        relationsToAdd.removeAll(noProblemRelations);
        RelationUploadDependencyGraph graph = new RelationUploadDependencyGraph(relationsToAdd, true);
        newToAdd.addAll(graph.computeUploadOrder(false));
        this.toAdd = newToAdd;
        LinkedList<OsmPrimitive> newToDelete = new LinkedList<OsmPrimitive>();
        graph = new RelationUploadDependencyGraph(Utils.filteredCollection(this.toDelete, Relation.class), false);
        newToDelete.addAll(graph.computeUploadOrder(true));
        newToDelete.addAll(Utils.filteredCollection(this.toDelete, Way.class));
        newToDelete.addAll(Utils.filteredCollection(this.toDelete, Node.class));
        this.toDelete = newToDelete;
    }

    protected List<Relation> filterRelationsNotReferringToNewRelations(Collection<Relation> relations) {
        LinkedList<Relation> ret = new LinkedList<Relation>();
        for (Relation relation : relations) {
            boolean refersToNewRelation = relation.getMembers().stream().anyMatch(m -> m.isRelation() && m.getMember().isNewOrUndeleted());
            if (refersToNewRelation) continue;
            ret.add(relation);
        }
        return ret;
    }

    public static enum APIOperation {
        ADD,
        UPDATE,
        DELETE;


        public static APIOperation of(OsmPrimitive osm) {
            if (osm.isNewOrUndeleted() && !osm.isDeleted()) {
                return ADD;
            }
            if (osm.isModified() && !osm.isDeleted()) {
                return UPDATE;
            }
            if (osm.isDeleted() && !osm.isNew() && osm.isModified() && osm.isVisible()) {
                return DELETE;
            }
            return null;
        }
    }

    private static class RelationUploadDependencyGraph {
        private final Map<Relation, Set<Relation>> children = new HashMap<Relation, Set<Relation>>();
        private Collection<Relation> relations;
        private Set<Relation> visited = new HashSet<Relation>();
        private List<Relation> uploadOrder;
        private final boolean newOrUndeleted;

        RelationUploadDependencyGraph(Collection<Relation> relations, boolean newOrUndeleted) {
            this.newOrUndeleted = newOrUndeleted;
            this.build(relations);
        }

        public final void build(Collection<Relation> relations) {
            this.relations = new HashSet<Relation>();
            for (Relation relation : relations) {
                if (this.newOrUndeleted ? !relation.isNewOrUndeleted() : !relation.isDeleted()) continue;
                this.relations.add(relation);
                for (RelationMember m : relation.getMembers()) {
                    if (!m.isRelation() || !(this.newOrUndeleted ? m.getMember().isNewOrUndeleted() : m.getMember().isDeleted())) continue;
                    this.addDependency(relation, (Relation)m.getMember());
                }
            }
        }

        public Set<Relation> getChildren(Relation relation) {
            return this.children.computeIfAbsent(relation, k -> new HashSet());
        }

        public void addDependency(Relation relation, Relation child) {
            this.getChildren(relation).add(child);
        }

        protected void visit(Stack<Relation> path, Relation current) throws CyclicUploadDependencyException {
            if (path.contains(current)) {
                path.push(current);
                throw new CyclicUploadDependencyException(path);
            }
            if (!this.visited.contains(current)) {
                path.push(current);
                this.visited.add(current);
                for (Relation dependent : this.getChildren(current)) {
                    this.visit(path, dependent);
                }
                this.uploadOrder.add(current);
                path.pop();
            }
        }

        public List<Relation> computeUploadOrder(boolean reverse) throws CyclicUploadDependencyException {
            this.visited = new HashSet<Relation>();
            this.uploadOrder = new LinkedList<Relation>();
            Stack<Relation> path = new Stack<Relation>();
            for (Relation relation : this.relations) {
                this.visit(path, relation);
            }
            ArrayList<Relation> ret = new ArrayList<Relation>(this.relations);
            Comparator<Relation> cmpr = Comparator.comparingInt(this.uploadOrder::indexOf);
            if (reverse) {
                cmpr = cmpr.reversed();
            }
            ret.sort(cmpr);
            return ret;
        }
    }
}

