/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.PreferencesAction;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.gui.mappaint.StyleSettingGroupGui;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.loader.MapPaintStyleLoader;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.util.FileFilterAllFiles;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.StayOpenPopupMenu;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.gui.widgets.ScrollableTable;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class MapPaintDialog
extends ToggleDialog {
    protected ScrollableTable tblStyles;
    protected StylesModel model;
    protected final DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
    protected OnOffAction onoffAction;
    protected ReloadAction reloadAction;
    protected MoveUpDownAction upAction;
    protected MoveUpDownAction downAction;
    protected JCheckBox cbWireframe;
    public static final JosmAction PREFERENCE_ACTION = PreferencesAction.forPreferenceSubTab(I18n.tr("Map paint preferences", new Object[0]), null, MapPaintPreference.class, "dialogs/mappaintpreference");

    public MapPaintDialog() {
        super(I18n.tr("Map Paint Styles", new Object[0]), "mapstyle", I18n.tr("configure the map painting style", new Object[0]), Shortcut.registerShortcut("subwindow:mappaint", I18n.tr("Toggle: {0}", I18n.tr("MapPaint", new Object[0])), 77, 5007), 150, false, MapPaintPreference.class);
        this.build();
    }

    protected void build() {
        this.model = new StylesModel();
        this.cbWireframe = new JCheckBox();
        JLabel wfLabel = new JLabel(I18n.tr("Wireframe View", new Object[0]), ImageProvider.get("dialogs/mappaint", "wireframe_small"), 0);
        wfLabel.setFont(wfLabel.getFont().deriveFont(0));
        wfLabel.setLabelFor(this.cbWireframe);
        this.cbWireframe.setModel(new DefaultButtonModel(){

            @Override
            public void setSelected(boolean b) {
                super.setSelected(b);
                MapPaintDialog.this.tblStyles.setEnabled(!b);
                MapPaintDialog.this.onoffAction.updateEnabledState();
                MapPaintDialog.this.upAction.updateEnabledState();
                MapPaintDialog.this.downAction.updateEnabledState();
            }
        });
        this.cbWireframe.addActionListener(e -> MainApplication.getMenu().wireFrameToggleAction.actionPerformed(null));
        this.cbWireframe.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.tblStyles = new ScrollableTable(this.model);
        this.tblStyles.setSelectionModel(this.selectionModel);
        this.tblStyles.addMouseListener(new PopupMenuHandler());
        this.tblStyles.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tblStyles.setBackground(UIManager.getColor("Panel.background"));
        this.tblStyles.setSelectionMode(2);
        this.tblStyles.setTableHeader(null);
        this.tblStyles.getColumnModel().getColumn(0).setMaxWidth(1);
        this.tblStyles.getColumnModel().getColumn(0).setResizable(false);
        this.tblStyles.getColumnModel().getColumn(0).setCellRenderer(new MyCheckBoxRenderer());
        this.tblStyles.getColumnModel().getColumn(1).setCellRenderer(new StyleSourceRenderer());
        this.tblStyles.setShowGrid(false);
        this.tblStyles.setIntercellSpacing(new Dimension(0, 0));
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)this.cbWireframe, GBC.std(0, 0));
        p.add((Component)wfLabel, GBC.std(1, 0).weight(1.0, 0.0));
        p.add((Component)this.tblStyles, GBC.std(0, 1).span(2).fill());
        this.reloadAction = new ReloadAction();
        this.onoffAction = new OnOffAction();
        this.upAction = new MoveUpDownAction(false);
        this.downAction = new MoveUpDownAction(true);
        this.selectionModel.addListSelectionListener(this.onoffAction);
        this.selectionModel.addListSelectionListener(this.reloadAction);
        this.selectionModel.addListSelectionListener(this.upAction);
        this.selectionModel.addListSelectionListener(this.downAction);
        InputMapUtils.addEnterAction(this.tblStyles, this.onoffAction);
        InputMapUtils.addSpacebarAction(this.tblStyles, this.onoffAction);
        this.createLayout(p, true, Arrays.asList(new SideButton((Action)this.onoffAction, false), new SideButton((Action)this.upAction, false), new SideButton((Action)this.downAction, false), new SideButton((Action)PREFERENCE_ACTION, false)));
    }

    @Override
    public void showNotify() {
        MapPaintStyles.addMapPaintSylesUpdateListener(this.model);
        this.model.mapPaintStylesUpdated();
        MainApplication.getMenu().wireFrameToggleAction.addButtonModel(this.cbWireframe.getModel());
    }

    @Override
    public void hideNotify() {
        MainApplication.getMenu().wireFrameToggleAction.removeButtonModel(this.cbWireframe.getModel());
        MapPaintStyles.removeMapPaintSylesUpdateListener(this.model);
    }

    public class MapPaintPopup
    extends StayOpenPopupMenu {
        public MapPaintPopup() {
            StyleSource style;
            this.add(MapPaintDialog.this.reloadAction);
            this.add(new SaveAsAction());
            JMenu setMenu = new JMenu(I18n.tr("Style settings", new Object[0]));
            setMenu.setIcon(new ImageProvider("preference").setMaxSize(ImageProvider.ImageSizes.POPUPMENU).addOverlay(new ImageOverlay(new ImageProvider("dialogs/mappaint", "pencil"), 0.5, 0.5, 1.0, 1.0)).get());
            setMenu.setToolTipText(I18n.tr("Customize the style", new Object[0]));
            this.add(setMenu);
            int sel = MapPaintDialog.this.tblStyles.getSelectionModel().getLeadSelectionIndex();
            StyleSource styleSource = style = sel >= 0 && sel < MapPaintDialog.this.model.getRowCount() ? MapPaintDialog.this.model.getRow(sel) : null;
            if (style == null || style.settings.isEmpty()) {
                setMenu.setEnabled(false);
            } else {
                style.settingGroups.forEach((group, settings) -> new StyleSettingGroupGui((StyleSetting.StyleSettingGroup)group, (List<StyleSetting>)settings).addMenuEntry(setMenu));
                style.settings.stream().filter(s -> style.settingGroups.values().stream().flatMap(Collection::stream).noneMatch(s::equals)).forEach(s -> s.getStyleSettingGui().addMenuEntry(setMenu));
            }
            this.addSeparator();
            this.add(new InfoAction());
        }
    }

    class PopupMenuHandler
    extends PopupMenuLauncher {
        PopupMenuHandler() {
        }

        @Override
        public void launch(MouseEvent evt) {
            if (MapPaintDialog.this.cbWireframe.isSelected()) {
                return;
            }
            super.launch(evt);
        }

        @Override
        protected void showMenu(MouseEvent evt) {
            this.menu = new MapPaintPopup();
            super.showMenu(evt);
        }
    }

    protected class InfoAction
    extends AbstractAction {
        private boolean errorsTabLoaded;
        private boolean warningsTabLoaded;
        private boolean sourceTabLoaded;

        public InfoAction() {
            this.putValue("Name", I18n.tr("Info", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("view meta information, error log and source definition", new Object[0]));
            new ImageProvider("info").getResource().attachImageIcon(this);
            this.setEnabled(MapPaintDialog.this.tblStyles.getSelectedRows().length == 1);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int sel = MapPaintDialog.this.tblStyles.getSelectionModel().getLeadSelectionIndex();
            if (sel < 0 || sel >= MapPaintDialog.this.model.getRowCount()) {
                return;
            }
            StyleSource s = MapPaintDialog.this.model.getRow(sel);
            ExtendedDialog info = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Map Style info", new Object[0]), I18n.tr("Close", new Object[0]));
            info.setPreferredSize(new Dimension(600, 400));
            info.setButtonIcons("ok");
            JTabbedPane tabs = new JTabbedPane();
            JLabel lblInfo = new JLabel(I18n.tr("Info", new Object[0]));
            lblInfo.setLabelFor(tabs.add("Info", this.buildInfoPanel(s)));
            lblInfo.setFont(lblInfo.getFont().deriveFont(0));
            tabs.setTabComponentAt(0, lblInfo);
            JPanel pErrors = this.addErrorOrWarningTab(tabs, lblInfo, s.getErrors(), I18n.marktr("Errors"), 1, ImageProvider.get("misc", "error"));
            JPanel pWarnings = this.addErrorOrWarningTab(tabs, lblInfo, s.getWarnings(), I18n.marktr("Warnings"), 2, ImageProvider.get("warning-small"));
            JPanel pSource = new JPanel(new GridBagLayout());
            JLabel lblSource = new JLabel(I18n.tr("Source", new Object[0]));
            lblSource.setLabelFor(tabs.add("Source", pSource));
            lblSource.setFont(lblSource.getFont().deriveFont(0));
            tabs.setTabComponentAt(3, lblSource);
            tabs.getModel().addChangeListener(e1 -> {
                if (!this.errorsTabLoaded && ((SingleSelectionModel)e1.getSource()).getSelectedIndex() == 1) {
                    this.errorsTabLoaded = true;
                    this.buildErrorsOrWarningPanel(s.getErrors(), pErrors);
                }
                if (!this.warningsTabLoaded && ((SingleSelectionModel)e1.getSource()).getSelectedIndex() == 2) {
                    this.warningsTabLoaded = true;
                    this.buildErrorsOrWarningPanel(s.getWarnings(), pWarnings);
                }
                if (!this.sourceTabLoaded && ((SingleSelectionModel)e1.getSource()).getSelectedIndex() == 3) {
                    this.sourceTabLoaded = true;
                    this.buildSourcePanel(s, pSource);
                }
            });
            info.setContent(tabs, false);
            info.showDialog();
        }

        private JPanel addErrorOrWarningTab(JTabbedPane tabs, JLabel lblInfo, Collection<?> items, String title, int pos, ImageIcon icon) {
            JPanel pErrors = new JPanel(new GridBagLayout());
            tabs.add(title, pErrors);
            if (items.isEmpty()) {
                JLabel lblErrors = new JLabel(I18n.tr(title, new Object[0]));
                lblErrors.setLabelFor(pErrors);
                lblErrors.setFont(lblInfo.getFont().deriveFont(0));
                lblErrors.setEnabled(false);
                tabs.setTabComponentAt(pos, lblErrors);
                tabs.setEnabledAt(pos, false);
            } else {
                JLabel lblErrors = new JLabel(I18n.tr(title, new Object[0]), icon, 0);
                lblErrors.setLabelFor(pErrors);
                tabs.setTabComponentAt(pos, lblErrors);
            }
            return pErrors;
        }

        private JPanel buildInfoPanel(StyleSource s) {
            JPanel p = new JPanel(new GridBagLayout());
            StringBuilder text = new StringBuilder("<table cellpadding=3>");
            text.append(this.tableRow(I18n.tr("Title:", new Object[0]), s.getDisplayString()));
            if (s.url.startsWith("http://") || s.url.startsWith("https://")) {
                text.append(this.tableRow(I18n.tr("URL:", new Object[0]), s.url));
            } else if (s.url.startsWith("resource://")) {
                text.append(this.tableRow(I18n.tr("Built-in Style, internal path:", new Object[0]), s.url));
            } else {
                text.append(this.tableRow(I18n.tr("Path:", new Object[0]), s.url));
            }
            if (s.icon != null) {
                text.append(this.tableRow(I18n.tr("Icon:", new Object[0]), s.icon));
            }
            if (s.getBackgroundColorOverride() != null) {
                text.append(this.tableRow(I18n.tr("Background:", new Object[0]), Utils.toString(s.getBackgroundColorOverride())));
            }
            text.append(this.tableRow(I18n.tr("Style is currently active?", new Object[0]), s.active ? I18n.tr("Yes", new Object[0]) : I18n.tr("No", new Object[0]))).append("</table>");
            p.add((Component)new JScrollPane(new HtmlPanel(text.toString())), GBC.eol().fill(1));
            return p;
        }

        private String tableRow(String firstColumn, String secondColumn) {
            return "<tr><td><b>" + firstColumn + "</b></td><td>" + secondColumn + "</td></tr>";
        }

        private void buildSourcePanel(StyleSource s, JPanel p) {
            JosmTextArea txtSource = new JosmTextArea();
            txtSource.setFont(GuiHelper.getMonospacedFont(txtSource));
            txtSource.setEditable(false);
            p.add((Component)new JScrollPane(txtSource), GBC.std().fill());
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(s.getSourceInputStream(), StandardCharsets.UTF_8));){
                reader.lines().forEach(line -> txtSource.append(line + '\n'));
            }
            catch (IOException ex) {
                Logging.error(ex);
                txtSource.append("<ERROR: failed to read file!>");
            }
            txtSource.setCaretPosition(0);
        }

        private <T> void buildErrorsOrWarningPanel(Collection<T> items, JPanel p) {
            JosmTextArea txtErrors = new JosmTextArea();
            txtErrors.setFont(GuiHelper.getMonospacedFont(txtErrors));
            txtErrors.setEditable(false);
            p.add((Component)new JScrollPane(txtErrors), GBC.std().fill());
            for (T t : items) {
                txtErrors.append(t.toString() + '\n');
            }
            txtErrors.setCaretPosition(0);
        }
    }

    protected class SaveAsAction
    extends AbstractAction {
        public SaveAsAction() {
            this.putValue("Name", I18n.tr("Save as...", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Save a copy of this Style to file and add it to the list", new Object[0]));
            new ImageProvider("copy").getResource().attachImageIcon(this);
            this.setEnabled(MapPaintDialog.this.tblStyles.getSelectedRows().length == 1);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int sel = MapPaintDialog.this.tblStyles.getSelectionModel().getLeadSelectionIndex();
            if (sel < 0 || sel >= MapPaintDialog.this.model.getRowCount()) {
                return;
            }
            StyleSource s = MapPaintDialog.this.model.getRow(sel);
            FileChooserManager fcm = new FileChooserManager(false, "mappaint.clone-style.lastDirectory", Utils.getSystemProperty("user.home"));
            String suggestion = fcm.getInitialDirectory() + File.separator + s.getFileNamePart();
            ExtensionFileFilter ff = s instanceof MapCSSStyleSource ? new ExtensionFileFilter("mapcss,css,zip", "mapcss", I18n.tr("Map paint style file (*.mapcss, *.zip)", new Object[0])) : new ExtensionFileFilter("xml,zip", "xml", I18n.tr("Map paint style file (*.xml, *.zip)", new Object[0]));
            fcm.createFileChooser(false, null, Arrays.asList(ff, FileFilterAllFiles.getInstance()), ff, 0).getFileChooser().setSelectedFile(new File(suggestion));
            AbstractFileChooser fc = fcm.openFileChooser();
            if (fc == null) {
                return;
            }
            MainApplication.worker.submit(new SaveToFileTask(s, fc.getSelectedFile()));
        }

        private class SaveToFileTask
        extends PleaseWaitRunnable {
            private final StyleSource s;
            private final File file;
            private boolean canceled;
            private boolean error;

            SaveToFileTask(StyleSource s, File file) {
                super(I18n.tr("Reloading style sources", new Object[0]));
                this.s = s;
                this.file = file;
            }

            @Override
            protected void cancel() {
                this.canceled = true;
            }

            @Override
            protected void realRun() {
                this.getProgressMonitor().indeterminateSubTask(I18n.tr("Save style ''{0}'' as ''{1}''", this.s.getDisplayString(), this.file.getPath()));
                try (InputStream in = this.s.getSourceInputStream();){
                    Files.copy(in, this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    Logging.warn(e);
                    this.error = true;
                }
            }

            @Override
            protected void finish() {
                SwingUtilities.invokeLater(() -> {
                    if (!this.error && !this.canceled) {
                        SourceEntry se = new SourceEntry(this.s);
                        se.url = this.file.getPath();
                        MapPaintStyles.addStyle(se);
                        MapPaintDialog.this.tblStyles.getSelectionModel().setSelectionInterval(MapPaintDialog.this.model.getRowCount() - 1, MapPaintDialog.this.model.getRowCount() - 1);
                        MapPaintDialog.this.model.ensureSelectedIsVisible();
                    }
                });
            }
        }
    }

    protected class ReloadAction
    extends AbstractAction
    implements ListSelectionListener {
        public ReloadAction() {
            this.putValue("Name", I18n.tr("Reload from file", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("reload selected styles from file", new Object[0]));
            new ImageProvider("dialogs", "refresh").getResource().attachImageIcon(this);
            this.setEnabled(this.getEnabledState());
        }

        protected boolean getEnabledState() {
            if (MapPaintDialog.this.cbWireframe.isSelected()) {
                return false;
            }
            int[] pos = MapPaintDialog.this.tblStyles.getSelectedRows();
            if (pos.length == 0) {
                return false;
            }
            for (int i : pos) {
                if (MapPaintDialog.this.model.getRow(i).isLocal()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(this.getEnabledState());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = MapPaintDialog.this.tblStyles.getSelectedRows();
            MapPaintStyleLoader.reloadStyles(rows);
            MainApplication.worker.submit(() -> SwingUtilities.invokeLater(() -> {
                MapPaintDialog.this.selectionModel.setValueIsAdjusting(true);
                MapPaintDialog.this.selectionModel.clearSelection();
                for (int r : rows) {
                    MapPaintDialog.this.selectionModel.addSelectionInterval(r, r);
                }
                MapPaintDialog.this.selectionModel.setValueIsAdjusting(false);
            }));
        }
    }

    protected class MoveUpDownAction
    extends AbstractAction
    implements ListSelectionListener {
        private final int increment;

        public MoveUpDownAction(boolean isDown) {
            this.increment = isDown ? 1 : -1;
            this.putValue("Name", isDown ? I18n.tr("Down", new Object[0]) : I18n.tr("Up", new Object[0]));
            new ImageProvider("dialogs", isDown ? "down" : "up").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", isDown ? I18n.tr("Move the selected entry one row down.", new Object[0]) : I18n.tr("Move the selected entry one row up.", new Object[0]));
            this.updateEnabledState();
        }

        public void updateEnabledState() {
            int[] sel = MapPaintDialog.this.tblStyles.getSelectedRows();
            this.setEnabled(!MapPaintDialog.this.cbWireframe.isSelected() && MapPaintStyles.canMoveStyles(sel, this.increment));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] sel = MapPaintDialog.this.tblStyles.getSelectedRows();
            MapPaintStyles.moveStyles(sel, this.increment);
            MapPaintDialog.this.selectionModel.setValueIsAdjusting(true);
            MapPaintDialog.this.selectionModel.clearSelection();
            for (int row : sel) {
                MapPaintDialog.this.selectionModel.addSelectionInterval(row + this.increment, row + this.increment);
            }
            MapPaintDialog.this.selectionModel.setValueIsAdjusting(false);
            MapPaintDialog.this.model.ensureSelectedIsVisible();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    protected class OnOffAction
    extends AbstractAction
    implements ListSelectionListener {
        public OnOffAction() {
            this.putValue("Name", I18n.tr("On/Off", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Turn selected styles on or off", new Object[0]));
            new ImageProvider("apply").getResource().attachImageIcon(this, true);
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(!MapPaintDialog.this.cbWireframe.isSelected() && MapPaintDialog.this.tblStyles.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] pos = MapPaintDialog.this.tblStyles.getSelectedRows();
            MapPaintStyles.toggleStyleActive(pos);
            MapPaintDialog.this.selectionModel.setValueIsAdjusting(true);
            MapPaintDialog.this.selectionModel.clearSelection();
            for (int p : pos) {
                MapPaintDialog.this.selectionModel.addSelectionInterval(p, p);
            }
            MapPaintDialog.this.selectionModel.setValueIsAdjusting(false);
        }
    }

    private class StyleSourceRenderer
    extends DefaultTableCellRenderer {
        private StyleSourceRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            StyleSource s = (StyleSource)value;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, s.getDisplayString(), isSelected, hasFocus, row, column);
            label.setIcon(s.getIcon());
            label.setToolTipText(s.getToolTipText());
            label.setEnabled(!MapPaintDialog.this.cbWireframe.isSelected());
            return label;
        }
    }

    private class MyCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        MyCheckBoxRenderer() {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            boolean b = (Boolean)value;
            this.setSelected(b);
            this.setEnabled(!MapPaintDialog.this.cbWireframe.isSelected());
            return this;
        }
    }

    protected class StylesModel
    extends AbstractTableModel
    implements MapPaintStyles.MapPaintSylesUpdateListener {
        private final Class<?>[] columnClasses = new Class[]{Boolean.class, StyleSource.class};
        private transient List<StyleSource> data = new ArrayList<StyleSource>(MapPaintStyles.getStyles().getStyleSources());

        private StyleSource getRow(int i) {
            return this.data.get(i);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.getRow((int)row).active;
            }
            return this.getRow(row);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.columnClasses[column];
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (row < 0 || row >= this.getRowCount() || aValue == null) {
                return;
            }
            if (column == 0) {
                MapPaintStyles.toggleStyleActive(row);
            }
        }

        public void ensureSelectedIsVisible() {
            int index = MapPaintDialog.this.selectionModel.getMinSelectionIndex();
            if (index < 0) {
                return;
            }
            if (index >= this.getRowCount()) {
                return;
            }
            MapPaintDialog.this.tblStyles.scrollToVisible(index, 0);
            MapPaintDialog.this.tblStyles.repaint();
        }

        @Override
        public void mapPaintStylesUpdated() {
            this.data = new ArrayList<StyleSource>(MapPaintStyles.getStyles().getStyleSources());
            this.fireTableDataChanged();
            MapPaintDialog.this.tblStyles.repaint();
        }

        @Override
        public void mapPaintStyleEntryUpdated(int idx) {
            this.data = new ArrayList<StyleSource>(MapPaintStyles.getStyles().getStyleSources());
            this.fireTableRowsUpdated(idx, idx);
            MapPaintDialog.this.tblStyles.repaint();
        }
    }
}

