/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Stopwatch;

public class Test
implements OsmPrimitiveVisitor {
    protected static final Predicate<OsmPrimitive> IN_DOWNLOADED_AREA = new SearchCompiler.NotOutsideDataSourceArea();
    protected static final Predicate<OsmPrimitive> IN_DOWNLOADED_AREA_STRICT = new SearchCompiler.InDataSourceArea(true);
    protected final String name;
    protected final String description;
    public boolean enabled = true;
    protected JCheckBox checkEnabled;
    protected JCheckBox checkBeforeUpload;
    public boolean testBeforeUpload = true;
    protected boolean isBeforeUpload;
    protected List<TestError> errors = new ArrayList<TestError>();
    protected boolean partialSelection;
    protected ProgressMonitor progressMonitor;
    protected Stopwatch stopwatch;
    private boolean showElementCount;

    public Test(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public Test(String name) {
        this(name, null);
    }

    public void initialize() throws Exception {
        this.stopwatch = Stopwatch.createStarted();
    }

    public void startTest(ProgressMonitor progressMonitor) {
        this.progressMonitor = Optional.ofNullable(progressMonitor).orElse(NullProgressMonitor.INSTANCE);
        String startMessage = I18n.tr("Running test {0}", this.name);
        this.progressMonitor.beginTask(startMessage);
        Logging.debug(startMessage);
        this.errors = new ArrayList<TestError>(30);
        this.stopwatch = Stopwatch.createStarted();
    }

    public void setPartialSelection(boolean partialSelection) {
        this.partialSelection = partialSelection;
    }

    public List<TestError> getErrors() {
        return this.errors;
    }

    public void endTest() {
        this.progressMonitor.finishTask();
        this.progressMonitor = null;
        if (this.stopwatch.elapsed() > 0L) {
            Logging.debug(this.stopwatch.toString(this.getName()));
        }
    }

    public void visit(Collection<OsmPrimitive> selection) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setTicksCount(selection.size());
        }
        long cnt = 0L;
        for (OsmPrimitive p : selection) {
            if (this.isCanceled()) break;
            if (this.isPrimitiveUsable(p)) {
                p.accept(this);
            }
            if (this.progressMonitor == null) continue;
            this.progressMonitor.worked(1);
            if (!this.showElementCount || ++cnt % 1000L != 0L) continue;
            this.progressMonitor.setExtraText(I18n.tr("{0} of {1} elements done", cnt, selection.size()));
        }
    }

    public boolean isPrimitiveUsable(OsmPrimitive p) {
        return p.isUsable() && (!(p instanceof Way) || ((Way)p).getNodesCount() > 1);
    }

    @Override
    public void visit(Node n) {
    }

    @Override
    public void visit(Way w) {
    }

    @Override
    public void visit(Relation r) {
    }

    public void addGui(JPanel testPanel) {
        this.checkEnabled = new JCheckBox(this.name, this.enabled);
        this.checkEnabled.setToolTipText(this.description);
        testPanel.add((Component)this.checkEnabled, GBC.std());
        GBC a = GBC.eol();
        a.anchor = 13;
        this.checkBeforeUpload = new JCheckBox();
        this.checkBeforeUpload.setSelected(this.testBeforeUpload);
        testPanel.add((Component)this.checkBeforeUpload, a);
    }

    public boolean ok() {
        this.enabled = this.checkEnabled.isSelected();
        this.testBeforeUpload = this.checkBeforeUpload.isSelected();
        return false;
    }

    public Command fixError(TestError testError) {
        return null;
    }

    public boolean isFixable(TestError testError) {
        return false;
    }

    public boolean testBeforeUpload() {
        return this.testBeforeUpload;
    }

    public void setBeforeUpload(boolean isUpload) {
        this.isBeforeUpload = isUpload;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCanceled() {
        return this.progressMonitor != null && this.progressMonitor.isCanceled();
    }

    protected final Command deletePrimitivesIfNeeded(Collection<? extends OsmPrimitive> primitives) {
        Collection primitivesToDelete = primitives.stream().filter(p -> !p.isDeleted()).collect(Collectors.toList());
        if (!primitivesToDelete.isEmpty()) {
            return DeleteCommand.delete(primitivesToDelete);
        }
        return null;
    }

    protected static final boolean isBuilding(OsmPrimitive p) {
        return p.hasTagDifferent("building", "no", "entrance");
    }

    protected static final boolean isResidentialArea(OsmPrimitive p) {
        return p.hasTag("landuse", "residential");
    }

    public void clear() {
        this.errors.clear();
    }

    protected void setShowElements(boolean b) {
        this.showElementCount = b;
    }

    public Object getSource() {
        return "Java: " + this.getClass().getName();
    }

    public static abstract class TagTest
    extends Test {
        public TagTest(String name, String description) {
            super(name, description);
        }

        public TagTest(String name) {
            super(name);
        }

        public abstract void check(OsmPrimitive var1);

        @Override
        public void visit(Node n) {
            this.check(n);
        }

        @Override
        public void visit(Way w) {
            this.check(w);
        }

        @Override
        public void visit(Relation r) {
            this.check(r);
        }

        protected boolean includeOtherSeverityChecks() {
            return this.isBeforeUpload ? ValidatorPrefHelper.PREF_OTHER_UPLOAD.get() : ValidatorPrefHelper.PREF_OTHER.get();
        }
    }
}

