/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.loader;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class MapPaintStyleLoader
extends PleaseWaitRunnable {
    private boolean canceled;
    private final Collection<StyleSource> sources;

    public MapPaintStyleLoader(Collection<StyleSource> sources) {
        super(I18n.tr("Reloading style sources", new Object[0]));
        this.sources = sources;
    }

    @Override
    protected void cancel() {
        this.canceled = true;
    }

    @Override
    protected void finish() {
        MapPaintStyles.fireMapPaintSylesUpdated();
    }

    @Override
    protected void realRun() {
        ProgressMonitor monitor = this.getProgressMonitor();
        monitor.setTicksCount(this.sources.size());
        for (StyleSource s : this.sources) {
            if (this.canceled) {
                return;
            }
            monitor.subTask(I18n.tr("loading style ''{0}''...", s.getDisplayString()));
            s.loadStyleSource();
            monitor.worked(1);
        }
    }

    public static void reloadStyles(int ... sel) {
        List<StyleSource> data = MapPaintStyles.getStyles().getStyleSources();
        List<StyleSource> toReload = Arrays.stream(sel).mapToObj(data::get).collect(Collectors.toList());
        MainApplication.worker.submit(new MapPaintStyleLoader(toReload));
    }

    public static void reloadStyle(SourceEntry style) {
        if (!(style instanceof StyleSource)) {
            throw new IllegalArgumentException(style + " is not a StyleSource");
        }
        MainApplication.worker.submit(new MapPaintStyleLoader(Collections.singleton((StyleSource)style)));
    }
}

