/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Utils;

public class Version {
    public static final int JOSM_UNKNOWN_VERSION = 0;
    private static Version instance;
    private int version;
    private String releaseDescription;
    private String time;
    private String buildName;
    private boolean isLocalBuild;

    public static synchronized Version getInstance() {
        if (instance == null) {
            instance = new Version();
            instance.init();
        }
        return instance;
    }

    protected void initFromRevisionInfo(InputStream revisionInfo) {
        if (revisionInfo == null) {
            this.releaseDescription = I18n.tr("UNKNOWN", new Object[0]);
            this.version = 0;
            this.time = null;
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(revisionInfo);
        }
        catch (IOException e) {
            Logging.log(Logging.LEVEL_WARN, I18n.tr("Error reading revision info from revision file: {0}", e.getMessage()), e);
        }
        String value = Optional.ofNullable(properties.getProperty("Revision")).orElse("").trim();
        if (!value.isEmpty()) {
            try {
                this.version = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.version = 0;
                Logging.warn(I18n.tr("Unexpected JOSM version number in revision file, value is ''{0}''", value));
            }
        } else {
            this.version = 0;
        }
        this.time = properties.getProperty("Last Changed Date");
        if (this.time == null) {
            this.time = properties.getProperty("Build-Date");
        }
        this.isLocalBuild = "true".equalsIgnoreCase(Optional.ofNullable(properties.getProperty("Is-Local-Build")).orElse("").trim());
        this.buildName = Optional.ofNullable(properties.getProperty("Build-Name")).orElse("").trim();
        this.releaseDescription = properties.entrySet().stream().map(property -> property.getKey() + ":" + property.getValue() + "\n").collect(Collectors.joining());
    }

    public void init() {
        try (InputStream stream = Utils.getResourceAsStream(this.getClass(), "/REVISION");){
            if (stream == null) {
                Logging.warn(I18n.tr("The revision file ''/REVISION'' is missing.", new Object[0]));
                this.version = 0;
                this.releaseDescription = "";
                return;
            }
            this.initFromRevisionInfo(stream);
        }
        catch (IOException e) {
            Logging.warn(e);
        }
    }

    public String getVersionString() {
        return this.version == 0 ? I18n.tr("UNKNOWN", new Object[0]) : Integer.toString(this.version);
    }

    public String getReleaseAttributes() {
        return this.releaseDescription;
    }

    public String getTime() {
        return this.time;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isLocalBuild() {
        return this.isLocalBuild;
    }

    public String getAgentString() {
        return this.getAgentString(true);
    }

    public String getAgentString(boolean includeOsDetails) {
        String s;
        int v = this.getVersion();
        String string = s = v == 0 ? "UNKNOWN" : Integer.toString(v);
        if (this.buildName != null && !this.buildName.isEmpty()) {
            s = s + ' ' + this.buildName;
        }
        if (this.isLocalBuild() && v != 0) {
            s = s + " SVN";
        }
        String result = "JOSM/1.5 (" + s + ' ' + LanguageInfo.getJOSMLocaleCode() + ')';
        if (includeOsDetails) {
            result = result + ' ' + PlatformManager.getPlatform().getOSDescription();
        }
        return result;
    }

    public String getFullAgentString() {
        return this.getAgentString() + " Java/" + Utils.getSystemProperty("java.version");
    }
}

