/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.SymbolShape;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public class ExtrudeAction
extends MapMode
implements MapViewPaintable,
KeyPressReleaseListener,
ModifierExListener {
    private Mode mode = Mode.select;
    private boolean alwaysCreateNodes;
    private boolean nodeDragWithoutCtrl;
    private long mouseDownTime;
    private transient WaySegment selectedSegment;
    private transient Node selectedNode;
    private Color mainColor;
    private transient Stroke mainStroke;
    private boolean ignoreSharedNodes;
    private boolean keepSegmentDirection;
    private Color helperColor;
    private transient Stroke helperStrokeDash;
    private transient Stroke helperStrokeRA;
    private transient Stroke oldLineStroke;
    private double symbolSize;
    private transient List<ReferenceSegment> possibleMoveDirections;
    private transient List<Node> movingNodeList;
    private transient ReferenceSegment activeMoveDirection;
    private Point initialMousePos;
    private int initialMoveDelay = 200;
    private int initialMoveThreshold = 1;
    private EastNorth initialN1en;
    private EastNorth initialN2en;
    private EastNorth newN1en;
    private EastNorth newN2en;
    private transient MoveCommand moveCommand;
    private transient MoveCommand moveCommand2;
    private final Cursor cursorCreateNew;
    private final Cursor cursorTranslate;
    private final Cursor cursorCreateNodes;
    private boolean dualAlignEnabled;
    private boolean dualAlignActive;
    private transient ReferenceSegment dualAlignSegment1;
    private transient ReferenceSegment dualAlignSegment2;
    private boolean dualAlignSegmentCollapsed;
    private final DualAlignChangeAction dualAlignChangeAction;
    private final JCheckBoxMenuItem dualAlignCheckboxMenuItem;
    private final transient Shortcut dualAlignShortcut;
    private boolean useRepeatedShortcut;
    private boolean ignoreNextKeyRelease;

    public ExtrudeAction() {
        super(I18n.tr("Extrude", new Object[0]), "extrude/extrude", I18n.tr("Create areas", new Object[0]), Shortcut.registerShortcut("mapmode:extrude", I18n.tr("Mode: {0}", I18n.tr("Extrude", new Object[0])), 88, 5003), ImageProvider.getCursor("normal", "rectangle"));
        this.setHelpId(HelpUtil.ht("/Action/Extrude"));
        this.cursorCreateNew = ImageProvider.getCursor("normal", "rectangle_plus");
        this.cursorTranslate = ImageProvider.getCursor("normal", "rectangle_move");
        this.cursorCreateNodes = ImageProvider.getCursor("normal", "rectangle_plussmall");
        this.dualAlignEnabled = false;
        this.dualAlignChangeAction = new DualAlignChangeAction();
        this.dualAlignCheckboxMenuItem = this.addDualAlignMenuItem();
        this.dualAlignCheckboxMenuItem.getAction().setEnabled(false);
        this.dualAlignCheckboxMenuItem.setState(this.dualAlignEnabled);
        this.dualAlignShortcut = Shortcut.registerShortcut("mapmode:extrudedualalign", I18n.tr("Edit: {0}", I18n.tr("Extrude Dual alignment", new Object[0])), 65535, 5000);
        this.readPreferences();
    }

    @Override
    public void destroy() {
        super.destroy();
        MainApplication.getMenu().editMenu.remove(this.dualAlignCheckboxMenuItem);
        this.dualAlignChangeAction.destroy();
    }

    private JCheckBoxMenuItem addDualAlignMenuItem() {
        int n = MainApplication.getMenu().editMenu.getItemCount();
        return MainMenu.addWithCheckbox(MainApplication.getMenu().editMenu, this.dualAlignChangeAction, n >= 5 ? n - 5 : -1, false);
    }

    @Override
    public String getModeHelpText() {
        StringBuilder rv;
        if (this.mode == Mode.select) {
            rv = new StringBuilder(I18n.tr("Drag a way segment to make a rectangle. Ctrl-drag to move a segment along its normal, Alt-drag to create a new rectangle, double click to add a new node.", new Object[0]));
            if (this.dualAlignEnabled) {
                rv.append(' ').append(I18n.tr("Dual alignment active.", new Object[0]));
                if (this.dualAlignSegmentCollapsed) {
                    rv.append(' ').append(I18n.tr("Segment collapsed due to its direction reversing.", new Object[0]));
                }
            }
        } else {
            if (this.mode == Mode.translate) {
                rv = new StringBuilder(I18n.tr("Move a segment along its normal, then release the mouse button.", new Object[0]));
            } else if (this.mode == Mode.translate_node) {
                rv = new StringBuilder(I18n.tr("Move the node along one of the segments, then release the mouse button.", new Object[0]));
            } else if (this.mode == Mode.extrude || this.mode == Mode.create_new) {
                rv = new StringBuilder(I18n.tr("Draw a rectangle of the desired size, then release the mouse button.", new Object[0]));
            } else {
                Logging.warn("Extrude: unknown mode " + (Object)((Object)this.mode));
                rv = new StringBuilder();
            }
            if (this.dualAlignActive) {
                rv.append(' ').append(I18n.tr("Dual alignment active.", new Object[0]));
                if (this.dualAlignSegmentCollapsed) {
                    rv.append(' ').append(I18n.tr("Segment collapsed due to its direction reversing.", new Object[0]));
                }
            }
        }
        return rv.toString();
    }

    @Override
    public boolean layerIsSupported(Layer l) {
        return this.isEditableDataLayer(l);
    }

    @Override
    public void enterMode() {
        super.enterMode();
        MapFrame map = MainApplication.getMap();
        map.mapView.addMouseListener(this);
        map.mapView.addMouseMotionListener(this);
        map.statusLine.setAutoLength(false);
        this.ignoreNextKeyRelease = true;
        map.keyDetector.addKeyListener(this);
        map.keyDetector.addModifierExListener(this);
    }

    @Override
    protected void readPreferences() {
        this.initialMoveDelay = Config.getPref().getInt("edit.initial-move-delay", 200);
        this.initialMoveThreshold = Config.getPref().getInt("extrude.initial-move-threshold", 1);
        this.mainColor = new NamedColorProperty(I18n.marktr("Extrude: main line"), Color.RED).get();
        this.helperColor = new NamedColorProperty(I18n.marktr("Extrude: helper line"), Color.ORANGE).get();
        this.helperStrokeDash = GuiHelper.getCustomizedStroke(Config.getPref().get("extrude.stroke.helper-line", "1 4"));
        this.helperStrokeRA = new BasicStroke(1.0f);
        this.symbolSize = Config.getPref().getDouble("extrude.angle-symbol-radius", 8.0);
        this.nodeDragWithoutCtrl = Config.getPref().getBoolean("extrude.drag-nodes-without-ctrl", false);
        this.oldLineStroke = GuiHelper.getCustomizedStroke(Config.getPref().get("extrude.ctrl.stroke.old-line", "1"));
        this.mainStroke = GuiHelper.getCustomizedStroke(Config.getPref().get("extrude.stroke.main", "3"));
        this.ignoreSharedNodes = Config.getPref().getBoolean("extrude.ignore-shared-nodes", true);
        this.dualAlignCheckboxMenuItem.getAction().setEnabled(true);
        this.useRepeatedShortcut = Config.getPref().getBoolean("extrude.dualalign.toggleOnRepeatedX", true);
        this.keepSegmentDirection = Config.getPref().getBoolean("extrude.dualalign.keep-segment-direction", true);
    }

    @Override
    public void exitMode() {
        MapFrame map = MainApplication.getMap();
        map.mapView.removeMouseListener(this);
        map.mapView.removeMouseMotionListener(this);
        map.mapView.removeTemporaryLayer(this);
        this.dualAlignCheckboxMenuItem.getAction().setEnabled(false);
        map.keyDetector.removeKeyListener(this);
        map.keyDetector.removeModifierExListener(this);
        super.exitMode();
    }

    @Override
    public void modifiersExChanged(int modifiers) {
        MapFrame map = MainApplication.getMap();
        if (!MainApplication.isDisplayingMapView() || !map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiersEx(modifiers);
        if (this.mode == Mode.select) {
            map.mapView.setNewCursor(this.ctrl ? this.cursorTranslate : (this.alt ? this.cursorCreateNew : (this.shift ? this.cursorCreateNodes : this.cursor)), (Object)this);
        }
    }

    @Override
    public void doKeyPressed(KeyEvent e) {
    }

    @Override
    public void doKeyReleased(KeyEvent e) {
        if (!(this.dualAlignShortcut.isEvent(e) || this.useRepeatedShortcut && this.getShortcut().isEvent(e))) {
            return;
        }
        if (this.ignoreNextKeyRelease) {
            this.ignoreNextKeyRelease = false;
        } else {
            this.toggleDualAlign();
        }
    }

    private void toggleDualAlign() {
        this.dualAlignEnabled = !this.dualAlignEnabled;
        this.dualAlignCheckboxMenuItem.setState(this.dualAlignEnabled);
        this.updateStatusLine();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        MapFrame map = MainApplication.getMap();
        if (!map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (!((Boolean)this.getValue("active")).booleanValue()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.requestFocusInMapView();
        this.updateKeyModifiers(e);
        this.selectedNode = map.mapView.getNearestNode(e.getPoint(), OsmPrimitive::isSelectable);
        this.selectedSegment = map.mapView.getNearestWaySegment(e.getPoint(), OsmPrimitive::isSelectable);
        if (this.selectedSegment == null && this.selectedNode == null) {
            return;
        }
        if (this.selectedNode != null) {
            if (this.ctrl || this.nodeDragWithoutCtrl) {
                this.movingNodeList = new ArrayList<Node>();
                this.movingNodeList.add(this.selectedNode);
                this.calculatePossibleDirectionsByNode();
                if (this.possibleMoveDirections.isEmpty()) {
                    return;
                }
                this.mode = Mode.translate_node;
                this.dualAlignActive = false;
            }
        } else {
            if (this.dualAlignEnabled && this.checkDualAlignConditions()) {
                this.dualAlignActive = true;
                this.calculatePossibleDirectionsForDualAlign();
                this.dualAlignSegmentCollapsed = false;
            } else {
                this.dualAlignActive = false;
                this.calculatePossibleDirectionsBySegment();
            }
            if (this.ctrl) {
                this.mode = Mode.translate;
                this.movingNodeList = new ArrayList<Node>();
                this.movingNodeList.add(this.selectedSegment.getFirstNode());
                this.movingNodeList.add(this.selectedSegment.getSecondNode());
            } else if (this.alt) {
                this.mode = Mode.create_new;
                this.getLayerManager().getEditDataSet().setSelected(this.selectedSegment.way);
                this.alwaysCreateNodes = true;
            } else {
                this.mode = Mode.extrude;
                this.getLayerManager().getEditDataSet().setSelected(this.selectedSegment.way);
                this.alwaysCreateNodes = this.shift;
            }
        }
        this.newN1en = null;
        this.newN2en = null;
        this.moveCommand = null;
        this.moveCommand2 = null;
        map.mapView.addTemporaryLayer(this);
        this.updateStatusLine();
        map.mapView.repaint();
        this.mouseDownTime = System.currentTimeMillis();
        this.initialMousePos = e.getPoint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        MapView mapView = MainApplication.getMap().mapView;
        if (!mapView.isActiveLayerVisible()) {
            return;
        }
        if (System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.select) {
            EastNorth mouseEn = mapView.getEastNorth(e.getPoint().x, e.getPoint().y);
            EastNorth bestMovement = this.calculateBestMovementAndNewNodes(mouseEn);
            mapView.setNewCursor(13, (Object)this);
            if (this.dualAlignActive) {
                if (this.mode != Mode.extrude && this.mode != Mode.create_new && this.mode == Mode.translate) {
                    EastNorth movement1 = this.newN1en.subtract(this.initialN1en);
                    EastNorth movement2 = this.newN2en.subtract(this.initialN2en);
                    if (this.moveCommand == null || this.moveCommand2 == null) {
                        this.moveCommand = new MoveCommand((OsmPrimitive)this.movingNodeList.get(0), movement1.getX(), movement1.getY());
                        this.moveCommand2 = new MoveCommand((OsmPrimitive)this.movingNodeList.get(1), movement2.getX(), movement2.getY());
                        SequenceCommand c = new SequenceCommand(I18n.tr("Extrude Way", new Object[0]), this.moveCommand, this.moveCommand2);
                        UndoRedoHandler.getInstance().add(c);
                    } else {
                        this.moveCommand.moveAgainTo(movement1.getX(), movement1.getY());
                        this.moveCommand2.moveAgainTo(movement2.getX(), movement2.getY());
                    }
                }
            } else if (bestMovement != null && this.mode != Mode.extrude && this.mode != Mode.create_new && (this.mode == Mode.translate_node || this.mode == Mode.translate)) {
                if (this.moveCommand == null) {
                    this.moveCommand = new MoveCommand(new ArrayList<OsmPrimitive>(this.movingNodeList), bestMovement);
                    UndoRedoHandler.getInstance().add(this.moveCommand);
                } else {
                    this.moveCommand.moveAgainTo(bestMovement.getX(), bestMovement.getY());
                }
            }
            mapView.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        MapView mapView = MainApplication.getMap().mapView;
        if (!mapView.isActiveLayerVisible()) {
            return;
        }
        if (this.mode != Mode.select) {
            if (this.mode == Mode.create_new) {
                if (e.getPoint().distance(this.initialMousePos) > (double)this.initialMoveThreshold && this.newN1en != null) {
                    this.createNewRectangle();
                }
            } else if (this.mode == Mode.extrude) {
                if (e.getClickCount() == 2 && e.getPoint().equals(this.initialMousePos)) {
                    ExtrudeAction.addNewNode(e);
                } else if (e.getPoint().distance(this.initialMousePos) > (double)this.initialMoveThreshold && this.newN1en != null && this.selectedSegment != null) {
                    try {
                        this.performExtrusion();
                    }
                    catch (DataIntegrityProblemException ex) {
                        Logging.error(ex);
                    }
                }
            } else if (this.mode == Mode.translate || this.mode == Mode.translate_node) {
                this.joinNodesIfCollapsed(this.movingNodeList);
            }
            MainApplication.getMap().statusLine.setDist(this.getLayerManager().getEditDataSet().getSelectedWays());
            MainApplication.getMap().statusLine.repaint();
            this.updateKeyModifiers(e);
            mapView.setNewCursor(this.ctrl ? this.cursorTranslate : (this.alt ? this.cursorCreateNew : (this.shift ? this.cursorCreateNodes : this.cursor)), (Object)this);
            mapView.removeTemporaryLayer(this);
            this.selectedSegment = null;
            this.moveCommand = null;
            this.mode = Mode.select;
            this.dualAlignSegmentCollapsed = false;
            this.updateStatusLine();
            mapView.repaint();
        }
    }

    private static void addNewNode(MouseEvent e) {
        MapView mapView = MainApplication.getMap().mapView;
        WaySegment ws = mapView.getNearestWaySegment(e.getPoint(), OsmPrimitive::isSelectable);
        if (ws != null) {
            Node n = new Node(mapView.getLatLon(e.getX(), e.getY()));
            EastNorth a = ws.getFirstNode().getEastNorth();
            EastNorth b = ws.getSecondNode().getEastNorth();
            n.setEastNorth(Geometry.closestPointToSegment(a, b, n.getEastNorth()));
            Way wnew = new Way(ws.way);
            wnew.addNode(ws.lowerIndex + 1, n);
            DataSet ds = ws.way.getDataSet();
            UndoRedoHandler.getInstance().add(new SequenceCommand(I18n.tr("Add a new node to an existing way", new Object[0]), new AddCommand(ds, n), new ChangeNodesCommand(ds, ws.way, wnew.getNodes())));
            wnew.setNodes((List<Node>)null);
        }
    }

    private void createNewRectangle() {
        if (this.selectedSegment == null) {
            return;
        }
        DataSet ds = this.getLayerManager().getEditDataSet();
        LinkedList<Command> cmds = new LinkedList<Command>();
        Node third = new Node(this.newN2en);
        Node fourth = new Node(this.newN1en);
        Way wnew = new Way();
        wnew.addNode(this.selectedSegment.getFirstNode());
        wnew.addNode(this.selectedSegment.getSecondNode());
        wnew.addNode(third);
        if (!this.dualAlignSegmentCollapsed) {
            wnew.addNode(fourth);
        }
        wnew.addNode(this.selectedSegment.getFirstNode());
        cmds.add(new AddCommand(ds, third));
        if (!this.dualAlignSegmentCollapsed) {
            cmds.add(new AddCommand(ds, fourth));
        }
        cmds.add(new AddCommand(ds, wnew));
        SequenceCommand c = new SequenceCommand(I18n.tr("Extrude Way", new Object[0]), cmds);
        UndoRedoHandler.getInstance().add(c);
        ds.setSelected(wnew);
    }

    private void performExtrusion() {
        Node n2Old;
        Node n1Old;
        DataSet ds = this.getLayerManager().getEditDataSet();
        LinkedList<Command> cmds = new LinkedList<Command>();
        Way wnew = new Way(this.selectedSegment.way);
        boolean wayWasModified = false;
        boolean wayWasSingleSegment = wnew.getNodesCount() == 2;
        int insertionPoint = this.selectedSegment.lowerIndex + 1;
        Node prevNode = this.getPreviousNode(this.selectedSegment.lowerIndex);
        boolean nodeOverlapsSegment = prevNode != null && Geometry.segmentsParallel(this.initialN1en, prevNode.getEastNorth(), this.initialN1en, this.newN1en);
        boolean segmentAngleZero = prevNode != null && Math.abs(Geometry.getCornerAngle(prevNode.getEastNorth(), this.initialN1en, this.newN1en)) < 1.0E-5;
        boolean hasOtherWays = ExtrudeAction.hasNodeOtherWays(this.selectedSegment.getFirstNode(), this.selectedSegment.way);
        ArrayList<Node> changedNodes = new ArrayList<Node>();
        if (nodeOverlapsSegment && !this.alwaysCreateNodes && !hasOtherWays) {
            n1Old = this.selectedSegment.getFirstNode();
            cmds.add(new MoveCommand(n1Old, ProjectionRegistry.getProjection().eastNorth2latlon(this.newN1en)));
            changedNodes.add(n1Old);
        } else if (this.ignoreSharedNodes && segmentAngleZero && !this.alwaysCreateNodes && hasOtherWays) {
            n1Old = this.selectedSegment.getFirstNode();
            Node n1New = new Node(ProjectionRegistry.getProjection().eastNorth2latlon(this.newN1en));
            wnew.addNode(insertionPoint, n1New);
            wnew.removeNode(n1Old);
            wayWasModified = true;
            cmds.add(new AddCommand(ds, n1New));
            changedNodes.add(n1New);
        } else {
            Node n1New = new Node(ProjectionRegistry.getProjection().eastNorth2latlon(this.newN1en));
            wnew.addNode(insertionPoint, n1New);
            wayWasModified = true;
            ++insertionPoint;
            cmds.add(new AddCommand(ds, n1New));
            changedNodes.add(n1New);
        }
        Node nextNode = this.getNextNode(this.selectedSegment.lowerIndex + 1);
        nodeOverlapsSegment = nextNode != null && Geometry.segmentsParallel(this.initialN2en, nextNode.getEastNorth(), this.initialN2en, this.newN2en);
        segmentAngleZero = nextNode != null && Math.abs(Geometry.getCornerAngle(nextNode.getEastNorth(), this.initialN2en, this.newN2en)) < 1.0E-5;
        hasOtherWays = ExtrudeAction.hasNodeOtherWays(this.selectedSegment.getSecondNode(), this.selectedSegment.way);
        if (nodeOverlapsSegment && !this.alwaysCreateNodes && !hasOtherWays) {
            n2Old = this.selectedSegment.getSecondNode();
            cmds.add(new MoveCommand(n2Old, ProjectionRegistry.getProjection().eastNorth2latlon(this.newN2en)));
            changedNodes.add(n2Old);
        } else if (this.ignoreSharedNodes && segmentAngleZero && !this.alwaysCreateNodes && hasOtherWays) {
            n2Old = this.selectedSegment.getSecondNode();
            Node n2New = new Node(ProjectionRegistry.getProjection().eastNorth2latlon(this.newN2en));
            wnew.addNode(insertionPoint, n2New);
            wnew.removeNode(n2Old);
            wayWasModified = true;
            cmds.add(new AddCommand(ds, n2New));
            changedNodes.add(n2New);
        } else {
            Node n2New = new Node(ProjectionRegistry.getProjection().eastNorth2latlon(this.newN2en));
            wnew.addNode(insertionPoint, n2New);
            wayWasModified = true;
            cmds.add(new AddCommand(ds, n2New));
            changedNodes.add(n2New);
        }
        if (wayWasSingleSegment) {
            wnew.addNode(this.selectedSegment.getFirstNode());
            wayWasModified = true;
        }
        if (wayWasModified) {
            cmds.add(new ChangeNodesCommand(this.selectedSegment.way, wnew.getNodes()));
            wnew.setNodes((List<Node>)null);
        }
        SequenceCommand c = new SequenceCommand(I18n.tr("Extrude Way", new Object[0]), cmds);
        UndoRedoHandler.getInstance().add(c);
        this.joinNodesIfCollapsed(changedNodes);
    }

    private void joinNodesIfCollapsed(List<Node> changedNodes) {
        Node locNode;
        if (!this.dualAlignActive || this.newN1en == null || this.newN2en == null) {
            return;
        }
        if (this.newN1en.distance(this.newN2en) > 1.0E-6) {
            return;
        }
        Node targetNode = MergeNodesAction.selectTargetNode(changedNodes);
        Command mergeCmd = MergeNodesAction.mergeNodes(changedNodes, targetNode, locNode = MergeNodesAction.selectTargetLocationNode(changedNodes));
        if (mergeCmd != null) {
            UndoRedoHandler.getInstance().add(mergeCmd);
        } else {
            UndoRedoHandler.getInstance().undo();
        }
    }

    private static boolean hasNodeOtherWays(Node node, Way myWay) {
        return node.getReferrers().stream().anyMatch(p -> p instanceof Way && p.isUsable() && p != myWay);
    }

    private EastNorth calculateBestMovement(EastNorth mouseEn) {
        EastNorth initialMouseEn = MainApplication.getMap().mapView.getEastNorth(this.initialMousePos.x, this.initialMousePos.y);
        EastNorth mouseMovement = mouseEn.subtract(initialMouseEn);
        double bestDistance = Double.POSITIVE_INFINITY;
        EastNorth bestMovement = null;
        this.activeMoveDirection = null;
        for (ReferenceSegment direction : this.possibleMoveDirections) {
            double distanceFromMouseMovement;
            EastNorth movement = ExtrudeAction.calculateSegmentOffset(this.initialN1en, this.initialN2en, direction.en, mouseEn);
            if (movement == null || !(bestDistance > (distanceFromMouseMovement = movement.distance(mouseMovement)))) continue;
            bestDistance = distanceFromMouseMovement;
            this.activeMoveDirection = direction;
            bestMovement = movement;
        }
        return bestMovement;
    }

    private static EastNorth calculateSegmentOffset(EastNorth segmentP1, EastNorth segmentP2, EastNorth moveDirection, EastNorth targetPos) {
        EastNorth intersectionPoint = segmentP1.distanceSq(segmentP2) > 1.0E-7 ? Geometry.getLineLineIntersection(segmentP1, segmentP2, targetPos, targetPos.add(moveDirection)) : Geometry.closestPointToLine(targetPos, targetPos.add(moveDirection), segmentP1);
        if (intersectionPoint == null) {
            return null;
        }
        return targetPos.subtract(intersectionPoint);
    }

    private void calculatePossibleDirectionsBySegment() {
        Node nextNode;
        this.initialN1en = this.selectedSegment.getFirstNode().getEastNorth();
        this.initialN2en = this.selectedSegment.getSecondNode().getEastNorth();
        this.possibleMoveDirections = new ArrayList<ReferenceSegment>();
        this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN1en.getY() - this.initialN2en.getY(), this.initialN2en.getX() - this.initialN1en.getX()), this.initialN1en, this.initialN2en, true));
        Node prevNode = this.getPreviousNode(this.selectedSegment.lowerIndex);
        if (prevNode != null) {
            EastNorth en = prevNode.getEastNorth();
            this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN1en.getX() - en.getX(), this.initialN1en.getY() - en.getY()), this.initialN1en, en, false));
        }
        if ((nextNode = this.getNextNode(this.selectedSegment.lowerIndex + 1)) != null) {
            EastNorth en = nextNode.getEastNorth();
            this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN2en.getX() - en.getX(), this.initialN2en.getY() - en.getY()), this.initialN2en, en, false));
        }
    }

    private void calculatePossibleDirectionsByNode() {
        this.initialN2en = this.initialN1en = this.selectedNode.getEastNorth();
        this.possibleMoveDirections = new ArrayList<ReferenceSegment>();
        for (OsmPrimitive p : this.selectedNode.getReferrers()) {
            if (!(p instanceof Way) || !p.isUsable()) continue;
            for (Node neighbor : ((Way)p).getNeighbours(this.selectedNode)) {
                EastNorth en = neighbor.getEastNorth();
                this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN1en.getX() - en.getX(), this.initialN1en.getY() - en.getY()), this.initialN1en, en, false));
            }
        }
    }

    private boolean checkDualAlignConditions() {
        Node prevNode = this.getPreviousNode(this.selectedSegment.lowerIndex);
        Node nextNode = this.getNextNode(this.selectedSegment.lowerIndex + 1);
        if (prevNode == null || nextNode == null) {
            return false;
        }
        EastNorth n1en = this.selectedSegment.getFirstNode().getEastNorth();
        EastNorth n2en = this.selectedSegment.getSecondNode().getEastNorth();
        if (n1en.distance(prevNode.getEastNorth()) < 1.0E-4 || n2en.distance(nextNode.getEastNorth()) < 1.0E-4) {
            return false;
        }
        boolean prevSegmentParallel = Geometry.segmentsParallel(n1en, prevNode.getEastNorth(), n1en, n2en);
        boolean nextSegmentParallel = Geometry.segmentsParallel(n2en, nextNode.getEastNorth(), n1en, n2en);
        return !prevSegmentParallel && !nextSegmentParallel;
    }

    private void calculatePossibleDirectionsForDualAlign() {
        Node nextNode;
        this.initialN1en = this.selectedSegment.getFirstNode().getEastNorth();
        this.initialN2en = this.selectedSegment.getSecondNode().getEastNorth();
        this.possibleMoveDirections = new ArrayList<ReferenceSegment>();
        this.possibleMoveDirections.add(new ReferenceSegment(new EastNorth(this.initialN1en.getY() - this.initialN2en.getY(), this.initialN2en.getX() - this.initialN1en.getX()), this.initialN1en, this.initialN2en, true));
        Node prevNode = this.getPreviousNode(this.selectedSegment.lowerIndex);
        if (prevNode != null) {
            EastNorth prevNodeEn = prevNode.getEastNorth();
            this.dualAlignSegment1 = new ReferenceSegment(new EastNorth(this.initialN1en.getX() - prevNodeEn.getX(), this.initialN1en.getY() - prevNodeEn.getY()), this.initialN1en, prevNodeEn, false);
        }
        if ((nextNode = this.getNextNode(this.selectedSegment.lowerIndex + 1)) != null) {
            EastNorth nextNodeEn = nextNode.getEastNorth();
            this.dualAlignSegment2 = new ReferenceSegment(new EastNorth(this.initialN2en.getX() - nextNodeEn.getX(), this.initialN2en.getY() - nextNodeEn.getY()), this.initialN2en, nextNodeEn, false);
        }
    }

    private EastNorth calculateBestMovementAndNewNodes(EastNorth mouseEn) {
        EastNorth bestMovement = this.calculateBestMovement(mouseEn);
        EastNorth n1movedEn = this.initialN1en.add(bestMovement);
        double distance = ProjectionRegistry.getProjection().eastNorth2latlon(this.initialN1en).greatCircleDistance(ProjectionRegistry.getProjection().eastNorth2latlon(n1movedEn));
        MainApplication.getMap().statusLine.setDist(distance);
        this.updateStatusLine();
        if (this.dualAlignActive) {
            n1movedEn = this.initialN1en.add(bestMovement);
            EastNorth n2movedEn = this.initialN2en.add(bestMovement);
            this.newN1en = Geometry.getLineLineIntersection(n1movedEn, n2movedEn, this.dualAlignSegment1.p1, this.dualAlignSegment1.p2);
            this.newN2en = Geometry.getLineLineIntersection(n1movedEn, n2movedEn, this.dualAlignSegment2.p1, this.dualAlignSegment2.p2);
            if (this.newN1en == null || this.newN2en == null) {
                return bestMovement;
            }
            if (this.keepSegmentDirection && ExtrudeAction.isOppositeDirection(this.newN1en, this.newN2en, this.initialN1en, this.initialN2en)) {
                EastNorth collapsedSegmentPosition;
                this.newN1en = collapsedSegmentPosition = Geometry.getLineLineIntersection(this.dualAlignSegment1.p1, this.dualAlignSegment1.p2, this.dualAlignSegment2.p1, this.dualAlignSegment2.p2);
                this.newN2en = collapsedSegmentPosition;
                this.dualAlignSegmentCollapsed = true;
            } else {
                this.dualAlignSegmentCollapsed = false;
            }
        } else {
            this.newN1en = n1movedEn;
            this.newN2en = this.initialN2en.add(bestMovement);
        }
        return bestMovement;
    }

    private int getPreviousNodeIndex(int index) {
        if (index > 0) {
            return index - 1;
        }
        if (this.selectedSegment.way.isClosed()) {
            return this.selectedSegment.way.getNodesCount() - 2;
        }
        return -1;
    }

    private Node getPreviousNode(int index) {
        int indexPrev = this.getPreviousNodeIndex(index);
        if (indexPrev >= 0) {
            return this.selectedSegment.way.getNode(indexPrev);
        }
        return null;
    }

    private int getNextNodeIndex(int index) {
        int count = this.selectedSegment.way.getNodesCount();
        if (index < count - 1) {
            return index + 1;
        }
        if (this.selectedSegment.way.isClosed()) {
            return 1;
        }
        return -1;
    }

    private Node getNextNode(int index) {
        int indexNext = this.getNextNodeIndex(index);
        if (indexNext >= 0) {
            return this.selectedSegment.way.getNode(indexNext);
        }
        return null;
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        Graphics2D g2 = g;
        if (this.mode != Mode.select) {
            if (this.newN1en != null) {
                Point2D normalUnitVector;
                EastNorth p1 = this.initialN1en;
                EastNorth p2 = this.initialN2en;
                EastNorth p3 = this.newN1en;
                EastNorth p4 = this.newN2en;
                Point2D point2D = normalUnitVector = this.activeMoveDirection != null ? this.getNormalUniVector() : null;
                if (this.mode == Mode.extrude || this.mode == Mode.create_new) {
                    g2.setColor(this.mainColor);
                    g2.setStroke(this.mainStroke);
                    MapViewPath b = new MapViewPath(mv);
                    b.moveTo(p1);
                    b.lineTo(p3);
                    b.lineTo(p4);
                    b.lineTo(p2);
                    b.lineTo(p1);
                    g2.draw(b);
                    if (this.dualAlignActive) {
                        this.drawReferenceSegment(g2, mv, this.dualAlignSegment1);
                        this.drawReferenceSegment(g2, mv, this.dualAlignSegment2);
                    } else if (this.activeMoveDirection != null && normalUnitVector != null) {
                        this.drawReferenceSegment(g2, mv, this.activeMoveDirection);
                        if (this.activeMoveDirection.perpendicular) {
                            double headingMoveDir;
                            double headingRefWS = this.activeMoveDirection.p1.heading(this.activeMoveDirection.p2);
                            double headingDiff = headingRefWS - (headingMoveDir = Math.atan2(normalUnitVector.getY(), normalUnitVector.getX()));
                            if (headingDiff < 0.0) {
                                headingDiff += Math.PI * 2;
                            }
                            boolean mirrorRA = Math.abs(headingDiff - Math.PI) > 1.0E-5;
                            Point pr1 = mv.getPoint(this.activeMoveDirection.p1);
                            this.drawAngleSymbol(g2, pr1, normalUnitVector, mirrorRA);
                        }
                    }
                } else if (this.mode == Mode.translate || this.mode == Mode.translate_node) {
                    g2.setColor(this.mainColor);
                    if (p1.distance(p2) < 3.0) {
                        g2.setStroke(this.mainStroke);
                        g2.draw(new MapViewPath(mv).shapeAround(p1, SymbolShape.CIRCLE, this.symbolSize));
                    } else {
                        g2.setStroke(this.oldLineStroke);
                        g2.draw(new MapViewPath(mv).moveTo(p1).lineTo(p2));
                    }
                    if (this.dualAlignActive) {
                        this.drawReferenceSegment(g2, mv, this.dualAlignSegment1);
                        this.drawReferenceSegment(g2, mv, this.dualAlignSegment2);
                    } else if (this.activeMoveDirection != null) {
                        g2.setColor(this.helperColor);
                        g2.setStroke(this.helperStrokeDash);
                        Point2D centerpoint = mv.getPoint2D(p1.interpolate(p2, 0.5));
                        g2.draw(ExtrudeAction.createSemiInfiniteLine(centerpoint, normalUnitVector, g2));
                        if (this.activeMoveDirection.perpendicular) {
                            g2.setStroke(this.helperStrokeRA);
                            g2.setColor(this.mainColor);
                            this.drawAngleSymbol(g2, centerpoint, normalUnitVector, false);
                        }
                    }
                }
            }
            g2.setStroke(this.helperStrokeRA);
        }
    }

    private Point2D getNormalUniVector() {
        double fac = 1.0 / this.activeMoveDirection.en.length();
        Point2D.Double normalUnitVector = new Point2D.Double(this.activeMoveDirection.en.getX() * fac, this.activeMoveDirection.en.getY() * fac);
        if (this.newN1en != null && this.newN1en.getX() > this.initialN1en.getX() != ((Point2D)normalUnitVector).getX() > -0.0) {
            normalUnitVector = new Point2D.Double(-((Point2D)normalUnitVector).getX(), -((Point2D)normalUnitVector).getY());
        }
        ((Point2D)normalUnitVector).setLocation(((Point2D)normalUnitVector).getX(), -((Point2D)normalUnitVector).getY());
        return normalUnitVector;
    }

    private static boolean isOppositeDirection(EastNorth from1, EastNorth to1, EastNorth from2, EastNorth to2) {
        return (from1.getX() - to1.getX()) * (from2.getX() - to2.getX()) + (from1.getY() - to1.getY()) * (from2.getY() - to2.getY()) < 0.0;
    }

    private void drawAngleSymbol(Graphics2D g2, Point2D center, Point2D normal, boolean mirror) {
        double factor = 1.0 / g2.getTransform().getScaleX();
        double raoffsetx = this.symbolSize * factor * normal.getX();
        double raoffsety = this.symbolSize * factor * normal.getY();
        double cx = center.getX();
        double cy = center.getY();
        double k = mirror ? -1.0 : 1.0;
        Point2D.Double ra1 = new Point2D.Double(cx + raoffsetx, cy + raoffsety);
        Point2D.Double ra3 = new Point2D.Double(cx - raoffsety * k, cy + raoffsetx * k);
        Point2D.Double ra2 = new Point2D.Double(((Point2D)ra1).getX() - raoffsety * k, ((Point2D)ra1).getY() + raoffsetx * k);
        GeneralPath ra = new GeneralPath();
        ra.moveTo((float)((Point2D)ra1).getX(), (float)((Point2D)ra1).getY());
        ra.lineTo((float)((Point2D)ra2).getX(), (float)((Point2D)ra2).getY());
        ra.lineTo((float)((Point2D)ra3).getX(), (float)((Point2D)ra3).getY());
        g2.setStroke(this.helperStrokeRA);
        g2.draw(ra);
    }

    private void drawReferenceSegment(Graphics2D g2, MapView mv, ReferenceSegment seg) {
        g2.setColor(this.helperColor);
        g2.setStroke(this.helperStrokeDash);
        g2.draw(new MapViewPath(mv).moveTo(seg.p1).lineTo(seg.p2));
    }

    private static Line2D createSemiInfiniteLine(Point2D start, Point2D unitvector, Graphics2D g) {
        Rectangle bounds = g.getClipBounds();
        try {
            AffineTransform invtrans = g.getTransform().createInverse();
            Point2D widthpoint = invtrans.deltaTransform(new Point2D.Double(bounds.width, 0.0), null);
            Point2D heightpoint = invtrans.deltaTransform(new Point2D.Double(0.0, bounds.height), null);
            double linelength = Math.abs(widthpoint.getX()) + Math.abs(widthpoint.getY()) + Math.abs(heightpoint.getX()) + Math.abs(heightpoint.getY());
            return new Line2D.Double(start, new Point2D.Double(start.getX() + unitvector.getX() * linelength, start.getY() + unitvector.getY() * linelength));
        }
        catch (NoninvertibleTransformException e) {
            Logging.debug(e);
            return new Line2D.Double(start, new Point2D.Double(start.getX() + unitvector.getX() * 10.0, start.getY() + unitvector.getY() * 10.0));
        }
    }

    private class DualAlignChangeAction
    extends JosmAction {
        DualAlignChangeAction() {
            super(I18n.tr("Dual alignment", new Object[0]), "mapmode/extrude/dualalign", I18n.tr("Switch dual alignment mode while extruding", new Object[0]), null, false);
            this.setHelpId(HelpUtil.ht("/Action/Extrude#DualAlign"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtrudeAction.this.toggleDualAlign();
        }

        @Override
        protected void updateEnabledState() {
            MapFrame map = MainApplication.getMap();
            this.setEnabled(map != null && map.mapMode instanceof ExtrudeAction);
        }
    }

    private static class ReferenceSegment {
        public final EastNorth en;
        public final EastNorth p1;
        public final EastNorth p2;
        public final boolean perpendicular;

        ReferenceSegment(EastNorth en, EastNorth p1, EastNorth p2, boolean perpendicular) {
            this.en = en;
            this.p1 = p1;
            this.p2 = p2;
            this.perpendicular = perpendicular;
        }

        public String toString() {
            return "ReferenceSegment[en=" + this.en + ", p1=" + this.p1 + ", p2=" + this.p2 + ", perp=" + this.perpendicular + ']';
        }
    }

    static enum Mode {
        extrude,
        translate,
        select,
        create_new,
        translate_node;

    }
}

