/*
  Copyright (C) 2006, 2007 Sony Computer Entertainment Inc.
  All rights reserved.

  Redistribution and use in source and binary forms,
  with or without modification, are permitted provided that the
  following conditions are met:
   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the Sony Computer Entertainment Inc nor the names
     of its contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef _VECTORMATH_TEST_H
#define _VECTORMATH_TEST_H

#if defined(__SPU__)
#  define vec_splats_float(v) spu_splats(v)
#  define vec_mul_float(a, b) spu_mul(a, b)
#  define vec_add_float(a, b) spu_add(a, b)
#  define vec_sub_float(a, b) spu_sub(a, b)
#elif defined(__ALTIVEC__)
#  define vec_splats_float(v) ((vec_float4){(float)(v),(float)(v),(float)(v),(float)(v)})
#  define vec_mul_float(a, b) vec_madd(a, b, vec_splats_float(0.0f))
#  define vec_add_float(a, b) vec_add(a, b)
#  define vec_sub_float(a, b) vec_sub(a, b)
#elif defined(__SSE__)
#  error "Not implemented."
#else
#  define _VECTORMATH_SCALAR_TEST
#endif

float randfloats[1024] = {
  -0.658343927787421f,0.499803960969928f,-0.807256688752865f,0.740930454054151f,
  0.154607013590216f,0.571598517679348f,0.38438830691728f,-0.262467460159158f,
  0.747808153723618f,0.49019019690013f,-0.107908181813777f,-0.292543593813249f,
  0.465039264005078f,-0.47955599783424f,-0.211412450152245f,0.553579902451233f,
  0.690070275160572f,0.151576400965553f,0.431077190337326f,-0.833991507852247f,
  -0.0883497426804851f,-0.780106371638709f,0.0904560476331469f,-0.218626858702649f,
  0.137170846428894f,0.918132898976751f,0.735438192918274f,-0.673620979495283f,
  -0.448982146263369f,-0.479277810255866f,0.848189483738331f,-0.12815472579463f,
  0.578921731104181f,-0.744765966376519f,-0.83558862791913f,0.881284032895692f,
  -0.948850147493964f,-0.691578137344351f,-0.235635149443688f,-0.690526600666615f,
  0.0586668362339609f,0.753696982166502f,-0.138777123323202f,-0.472187547315841f,
  -0.372811001953572f,0.540183371709446f,-0.78521823389179f,0.542084510391291f,
  0.410391117788897f,-0.562720682584484f,0.523587985711991f,-0.176573908842087f,
  0.297653645858226f,0.859912509814734f,0.00483713119734119f,0.374881358857735f,
  -0.127818103705344f,0.21660181589948f,0.153117267270737f,0.265243421428139f,
  -0.0731487047425148f,0.264487579220173f,-0.723410134701346f,0.921522835850382f,
  -0.711249997824318f,-0.106633857864438f,-0.350831080309241f,0.905168155184938f,
  -0.283632179037646f,-0.203583555015513f,-0.797436915535236f,0.910171471305759f,
  0.96923389534215f,0.151940162902974f,0.731827470770519f,-0.700248217534451f,
  0.818300860563319f,0.302505017280083f,-0.872278290470156f,0.909998773124912f,
  0.932525528551317f,0.571086770427939f,0.610329635790002f,0.142507359591505f,
  -0.43482856009151f,0.925102103935927f,0.158954117892613f,-0.126282746058862f,
  -0.249127650925452f,0.846815218386041f,-0.942601239873774f,0.537719955431001f,
  0.446213543435171f,0.181938699625931f,-0.148222922840326f,0.284286118166037f,
  0.493525458201255f,-0.861962900371793f,-0.893410102755276f,0.548627291142694f,
  0.407006961478977f,-0.757467096890906f,-0.393126176069536f,-0.850984293029867f,
  0.375719573110992f,-0.270087780463427f,0.45888819784826f,-0.610827766442796f,
  -0.690815628408266f,-0.676415221072347f,0.664465776005038f,0.101873923854313f,
  -0.365713939355025f,0.0554727439164822f,-0.133556089035984f,-0.572643072647438f,
  0.459209235899415f,-0.997261395030506f,0.172408991295974f,-0.0451240115316551f,
  0.879715937508259f,0.524317125330867f,-0.744532077249495f,-0.970443523820151f,
  -1.32784686215359e-05f,0.689543072301063f,0.704297111725616f,-0.817983008667298f,
  0.71550535643383f,0.577868436783262f,0.156952383805468f,-0.80102179210472f,
  0.65633547615213f,0.494393128677046f,0.816743155389922f,0.0242848471199721f,
  0.769131722839866f,0.923894866655701f,0.133021600755988f,-0.0522193159450097f,
  -0.164886284373118f,0.300690282133047f,0.760403145270168f,0.171869369152077f,
  -0.554975788488598f,0.998693253807744f,-0.681641007087912f,0.391194738828759f,
  0.403058705852153f,0.972411306067528f,0.297195187773745f,0.309761312769567f,
  0.688408077837671f,0.363539666742895f,0.94029653976505f,-0.336683042511069f,
  0.600164345782652f,-0.681271587780742f,0.726558239385319f,0.205513360229233f,
  -0.16008221686365f,0.962714155748642f,0.737793770111715f,-0.0719258703692134f,
  -0.506312816314299f,0.689277082946518f,0.686485424709581f,0.473013144786293f,
  -0.735610421404026f,-0.0463900680836105f,0.568673968586005f,-0.00481466271939723f,
  0.137636823654454f,-0.111879120785687f,-0.929542605813147f,-0.336303463382606f,
  -0.146740182632236f,0.165140351947514f,-0.823874099621072f,0.349776463047661f,
  0.174872304411146f,-0.528584334304156f,0.489291834762803f,0.916707538240686f,
  0.728510889338118f,-0.851139787348188f,0.0796199799283031f,-0.234369971523549f,
  -0.996308342568362f,0.433228819394486f,-0.892684128206504f,-0.95791073791078f,
  0.517122298113016f,0.257920984044574f,0.862028434359466f,0.0958813977553206f,
  -0.171932523577503f,-0.214077886807473f,-0.604841274532937f,-0.38383141210609f,
  -0.58149997525441f,0.222182734948547f,-0.2561203625418f,-0.678699493062183f,
  -0.0795530448181339f,0.605960090732907f,-0.633147389976791f,0.435875222532317f,
  -0.0466270522618899f,-0.71649136999298f,0.267317414957141f,-0.514873596167021f,
  -0.751699524124625f,0.742958874040227f,-0.793179510948171f,0.508814009999512f,
  -0.238839286150373f,0.113471002014307f,-0.843523253083085f,-0.245249991279181f,
  0.250368454758338f,0.579243470287253f,-0.157280074848025f,0.648487464157242f,
  0.103833079240538f,0.456401128469849f,-0.0223720820167514f,-0.475631368950744f,
  -0.0041782226245104f,-0.0208652308868125f,-0.0169971127675765f,0.699143621917685f,
  0.83779636548531f,-0.276082033737794f,0.0915817913013015f,0.209063902268738f,
  0.219316780269516f,-0.118359453100055f,0.413442003735092f,-0.567697560481989f,
  0.531358299984625f,-0.387225776610819f,0.572489506868486f,-0.820417090039186f,
  0.797191361229615f,0.867177919412683f,0.934764375062564f,0.237092079542023f,
  -0.866161864691826f,-0.773938728379676f,0.261310530107004f,-0.851569556583101f,
  0.114814425111355f,-0.531592190789155f,0.223924683490957f,0.869104561345111f,
  0.143404566999386f,0.148517529008075f,-0.0711363985626363f,-0.758291614176514f,
  -0.527633502740933f,0.99721511923596f,0.114439963849399f,0.72755837253878f,
  -0.425760405626697f,0.459888066153781f,0.642515762634126f,-0.0225335867899474f,
  0.186094961562027f,-0.775678571017551f,-0.683400976752644f,0.398133764191002f,
  0.189642093838877f,0.765986315134853f,-0.137794739254879f,-0.579843714684088f,
  -0.63564699482432f,0.374970154657689f,-0.563749876868947f,-0.471075422601373f,
  -0.553799500723066f,-0.0146881150006948f,-0.464365244644604f,-0.10788986146774f,
  -0.527503023060852f,-0.406422760262416f,0.301261161950258f,0.499528573888128f,
  0.385179609005043f,-0.150218387266079f,0.519111879977139f,-0.203208683924331f,
  -0.252017508479717f,0.282193567323901f,0.0676372217166588f,0.798376368300907f,
  0.310782163860559f,0.861334103612307f,-0.980345166653173f,-0.655105604450725f,
  0.286765236319503f,0.532078410709602f,0.352670966735097f,0.540977184819425f,
  0.510961465933072f,0.791871139829084f,-0.564378698589145f,0.273199199047909f,
  0.194378063163676f,0.244636363558442f,-0.2696079922111f,-0.858162214209599f,
  -0.495023067522474f,-0.277797538673553f,-0.0327403642191157f,0.00741169596342672f,
  -0.420178428178723f,-0.522576683894926f,0.324971970060567f,0.795389045001329f,
  0.342900104539247f,-0.913636452280628f,0.675221839440177f,0.144052833646484f,
  -0.632328982629893f,-0.947119831218089f,-0.0493673719309484f,0.126332763266575f,
  -0.66420574517786f,0.220879155225703f,0.284218535482147f,-0.387215543918998f,
  0.913567998448777f,0.531906099678991f,0.271995095904906f,-0.862600551020719f,
  -0.738693635668703f,0.514248487507359f,-0.0393632803376036f,0.429389595727585f,
  -0.769468991576751f,0.28133632724311f,-0.203301313955485f,0.412585911285348f,
  0.567925862321268f,0.410131004328946f,-0.462918277454527f,0.560952548692129f,
  -0.731715443500342f,-0.446157565377547f,-0.837491324975311f,-0.573480361464263f,
  -0.607819850918752f,0.23841499693998f,0.213445432027605f,0.0986122683758737f,
  0.135072190814675f,-0.749273552937012f,-0.855977160741141f,0.765675059673342f,
  -0.693447453911567f,0.131554184087008f,-0.366756547983336f,-0.330409262236842f,
  -0.588815619465343f,0.352532978762866f,-0.920522750723883f,-0.915255088789323f,
  0.631923943060777f,-0.870739292438145f,0.415604498050605f,-0.180973894496887f,
  0.775697838994837f,0.879356890591083f,-0.993957564335638f,-0.298451942545356f,
  0.876855036440425f,0.982846031192253f,-0.282564044364371f,0.95346849594155f,
  -0.947311505090191f,-0.317822974923359f,0.692391664998802f,-0.123566763365389f,
  0.407041678839057f,0.141204372181107f,-0.793069847914673f,-0.638275471740698f,
  -0.51955405631346f,0.368499710074474f,0.970213689037045f,0.0272163305900648f,
  0.801791483976395f,-0.0663635812993562f,-0.0512834823579524f,-0.184935295126749f,
  0.516982835871183f,-0.769951152485618f,-0.708267044537941f,0.398266880674086f,
  -0.479614543356881f,0.0604142126476859f,-0.867394563338259f,-0.702364045743693f,
  -0.18260171523908f,-0.83280747136078f,0.278190893454216f,-0.967562302471109f,
  -0.52029595778054f,0.160191201466318f,-0.677989785356466f,-0.470750261667419f,
  -0.846579999787899f,-0.705750757861409f,-0.825367487626302f,-0.712890462610304f,
  -0.0644873847193068f,0.444064587944183f,-0.0452257881147275f,0.116544259603998f,
  -0.00728451932408092f,-0.838230133415692f,-0.410766823165496f,-0.40929905742685f,
  -0.336682948179195f,-0.830699768111344f,-0.801729180453698f,-0.595152571835385f,
  -0.784671779507129f,-0.653655236426147f,0.670791046451306f,0.653571468806589f,
  0.850715654625567f,0.0714334825891569f,-0.0577154211012854f,0.401895373758876f,
  0.0168605144772656f,0.5354384129881f,0.965901293540405f,-0.0726753529456374f,
  0.341689326326282f,0.781662445971847f,0.707322369548329f,0.505889413040066f,
  0.43279006682301f,-0.82579284323046f,0.597718837056043f,-0.250904847502525f,
  -0.085712490334565f,-0.27284668464705f,0.552644217406645f,0.19420250718521f,
  -0.884426763638054f,-0.756791257372726f,0.121106956043313f,0.312482778322803f,
  -0.873316960494485f,0.0450805196969668f,0.687443898195021f,-0.684625629977333f,
  -0.994046624794031f,0.800365484075002f,-0.565640229111075f,-0.625626063021869f,
  0.932584676112249f,0.636927568286012f,0.420250137262336f,0.175862511828669f,
  0.362158342804186f,0.547495978208275f,-0.534422794348934f,-0.563030463450744f,
  -0.254488285756501f,0.647777595706543f,-0.674240168502628f,0.224344628949055f,
  -0.754563097553635f,-0.12881655237274f,-0.997838330250381f,0.0369162049154141f,
  -0.077549312424928f,0.376025736059717f,-0.935044655882827f,-0.189804125597547f,
  0.00764933224392195f,-0.440298102088747f,0.994796322297979f,-0.271484040660724f,
  -0.2590701870053f,0.902148580301628f,-0.836501451887365f,0.229092669621153f,
  0.5863932076197f,-0.287825592948792f,0.942655407357726f,-0.634432455852235f,
  -0.140437555704573f,0.570869095619685f,-0.764965080867434f,0.0675228424859284f,
  -0.514589062662218f,0.233090988246516f,0.554487773397391f,-0.633529215840056f,
  -0.0193735702003366f,0.869258510751365f,-0.369818396412519f,-0.280689998188947f,
  -0.797208739895403f,-0.255233407527697f,0.780605315236578f,0.789803426518219f,
  0.974261893445153f,-0.785980203848396f,-0.701385987245636f,0.871088183435759f,
  0.566742533772562f,0.75227294222347f,-0.476301298243307f,-0.747341931420877f,
  0.0773855838641069f,-0.305599507084935f,-0.229193881336336f,-0.260009071921601f,
  -0.0515187258224827f,0.459831012841761f,0.861793377659517f,-0.00839510548009059f,
  -0.0535644390132504f,0.912885769359548f,-0.402379747450233f,-0.10435292389046f,
  0.644045025641198f,-0.235395897167933f,0.454549452554879f,-0.303775931682779f,
  0.321575614700528f,0.724025709176772f,0.330082831646187f,0.609903689400269f,
  0.851604270169993f,-0.356715440425745f,-0.0455002843413084f,0.13772975575408f,
  -0.148995564903764f,0.892453960056798f,-0.821676934893254f,-0.14847536459807f,
  -0.381886292618752f,0.398820351836747f,-0.292289360617424f,0.0702858731114446f,
  -0.772469821167697f,0.474357996692333f,0.857792314833965f,-0.720558506386439f,
  0.888908862188352f,-0.950919194501893f,-0.196258139903655f,-0.59980821479941f,
  -0.794413298851502f,-0.927635622930836f,-0.18747758800405f,-0.113038430406718f,
  0.366119602275866f,-0.483786056117111f,0.622670249344587f,-0.801805699607442f,
  0.295383348060291f,0.0220054959489744f,-0.000678144987013241f,-0.68933407333013f,
  0.266537772395942f,-0.785099000882013f,-0.572664686201399f,0.772760435300924f,
  0.97189582826514f,-0.961362535549199f,0.723449439795125f,-0.758441529489218f,
  -0.733158222482722f,0.13966678591575f,-0.73814671277507f,0.727223546774141f,
  0.0899213092919311f,-0.113118130362636f,-0.364554501988017f,-0.137644753297124f,
  0.933846571857863f,0.615857754190102f,0.442837902751755f,0.691293553853697f,
  0.862436507424839f,-0.769632706987466f,-0.069558455823973f,-0.216368763497925f,
  -0.240286864167238f,-0.494147338088084f,-0.732343541285623f,0.247500097354347f,
  0.238013165932848f,-0.0222504081638135f,0.0354097573205863f,0.562870060908224f,
  -0.443182852051812f,-0.148476065390099f,-0.785559583638936f,-0.534284390277335f,
  0.804060941136193f,0.161693072162677f,0.626454348053834f,0.564290128221401f,
  0.414242183673117f,-0.314079097076757f,0.871460392700492f,-0.586016607169839f,
  0.446183340840953f,0.670697807509214f,-0.31261251323f,-0.34635111476409f,
  -0.32237160168031f,0.0615992346122596f,0.108866036772035f,-0.96854607364277f,
  -0.0900520153269255f,-0.000638517939648864f,-0.497526906200939f,0.0210549572282304f,
  -0.513626724036349f,0.219974002433304f,-0.406318097379831f,0.829310754424156f,
  0.139888080843043f,-0.409132737685127f,-0.0296375827238435f,-0.713853913104842f,
  0.286946651436075f,-0.734473045715816f,0.649341057254212f,0.0281454231254514f,
  -0.188432361127518f,-0.683807673918693f,0.432885949511977f,-0.0361810926016091f,
  0.438347837417645f,0.710651677026334f,0.673928786874676f,-0.0546809333762468f,
  0.826058562813905f,-0.832265197271681f,-0.668493142354613f,0.35502470967181f,
  0.5354983136667f,0.82137347039f,-0.143300610352533f,0.713426364459551f,
  -0.297806605505109f,0.340760003596245f,-0.564118270640485f,-0.0240265108522948f,
  -0.60137093958766f,-0.178866127631323f,-0.229680331692812f,0.741055717732976f,
  -0.219526898682084f,0.534269946476002f,0.133115059442581f,-0.249583317941799f,
  0.811487242943805f,0.699282902509054f,-0.43331663912921f,0.71961761681392f,
  0.943524928147106f,0.523603303061634f,-0.677065472025312f,-0.636492873531878f,
  0.0384525794274069f,-0.377124785497273f,0.967031372742831f,0.435091298236713f,
  0.161520957813146f,-0.15972397671726f,-0.166845254078147f,-0.587937091804449f,
  0.910419348982238f,0.764819474485904f,-0.987496701506423f,-0.838882086564368f,
  -0.41301635023239f,0.740276015423035f,0.951437768918503f,0.284889876776347f,
  -0.158434377954073f,0.73838340645338f,-0.370863653408783f,0.989946556977472f,
  -0.848079748582045f,-0.449771614068709f,0.663499305019705f,-0.93185425837116f,
  0.523896920061681f,-0.232489928806984f,-0.538281594630583f,-0.899682373052556f,
  -0.338756398325579f,0.951550867830917f,0.494550167204373f,0.194556783574981f,
  0.243717136517866f,0.224354070146973f,0.143792613511486f,-0.333553884855363f,
  0.229952471240104f,-0.204077808365582f,0.469903146410694f,-0.958373658125808f,
  -0.226054823628623f,0.229899490605959f,0.196501423332386f,0.879845549743308f,
  0.577560209175438f,0.641089277668982f,0.642316105885037f,0.232802361926147f,
  -0.381538604113949f,0.640474533642731f,-0.913151229860155f,-0.614188561923768f,
  0.171776090268345f,-0.645757746280538f,-0.122217277374411f,0.00689941379876302f,
  0.019433549917359f,-0.0675691088088968f,-0.373650414044171f,-0.67103881780362f,
  0.504459382741295f,-0.14911057310502f,0.148122926701966f,0.694898716737626f,
  0.585837578674649f,-0.750790936323284f,0.853926520879604f,0.15730556487317f,
  -0.113618219173468f,0.320367463625416f,-0.552134285767956f,-0.920422170186882f,
  -0.338845809007829f,-0.810536065394189f,-0.177695639626343f,0.351905028679525f,
  0.0633494717407146f,-0.865174843305965f,0.634557634797282f,-0.787750206138512f,
  -0.379512173859858f,0.791878043518267f,-0.704956748246282f,-0.670757904173982f,
  0.684751731590218f,-0.953277716787511f,0.985770879077755f,0.122219634876117f,
  0.1721202012071f,-0.388256876288864f,-0.73825752183587f,0.906019401398325f,
  -0.803381430261645f,-0.74941181755554f,0.0727255174881734f,-0.221605735994771f,
  -0.564223723915198f,-0.213656403861052f,-0.608162856680174f,0.921170937654253f,
  0.0847855661657562f,0.417987807384179f,-0.330418934403873f,0.648809934312297f,
  0.0796460930869003f,0.550628835897015f,-0.92719924470385f,0.877452232036589f,
  0.559779671355166f,-0.0896538710039181f,0.849093177103803f,-0.747330460544603f,
  -0.87952842676733f,0.791614152693995f,-0.483542677352212f,0.795053306558017f,
  -0.246444636768096f,-0.967515102978155f,0.159471890174437f,0.210810164441753f,
  -0.874227023772981f,-0.0805964482800334f,0.567497201138046f,-0.137743608785641f,
  -0.710773819308763f,-0.589571113738941f,0.83391847788473f,0.474349423613731f,
  -0.495444643831966f,-0.415319533683743f,-0.688818445640273f,0.923238489082379f,
  0.688452278243922f,-0.639758117768224f,0.353458578584501f,-0.352412753977475f,
  -0.667399029986676f,0.586965778853283f,0.352610916528867f,0.360697015758419f,
  -0.502839728688848f,-0.539644214882799f,0.365329906944815f,-0.379932106654209f,
  -0.269280779163601f,0.694895571222645f,0.727823970732565f,0.51105486079409f,
  -0.761212733299821f,-0.551940664095241f,0.953323471475834f,-0.915964879494524f,
  0.199091342904332f,0.0392241713497299f,-0.19261671908783f,-0.6074206562147f,
  0.345256597791838f,0.031516093623793f,0.563117849295644f,-0.0626584858579093f,
  -0.491887339392029f,-0.758788812866925f,0.265995340863064f,0.23182766277084f,
  0.069408408971249f,-0.758115582411847f,-0.495213306068685f,-0.941798830898321f,
  -0.244099121724069f,-0.496495655783264f,0.217102928532306f,-0.958590442403207f,
  -0.951376141167081f,-0.454184666450089f,0.886300276933433f,0.487002988091731f,
  0.0249044829036293f,-0.482416930998085f,0.949278378895364f,0.332136035903019f,
  0.667897336691517f,-0.903192712329542f,0.0759824890853551f,-0.338269985337703f,
  -0.29518903317139f,-0.768719116695905f,-0.648362986306786f,0.935201134387952f,
  0.661626711929564f,0.224599917215244f,0.348525351988449f,-0.972641665331466f,
  0.996220202383405f,-0.72814219793807f,-0.921619408688976f,-0.134878186992026f,
  0.496907260713279f,0.544992091878385f,0.238303715804555f,-0.924062793629034f,
  -0.630686074442814f,-0.865452949495847f,-0.222028734920293f,0.171739204767604f,
  0.997130539607845f,0.918172604643416f,-0.694626556063078f,0.672880204329672f,
  -0.175982089302543f,-0.876546457819273f,-0.699672836718442f,0.809662568756764f,
  0.393205100623341f,-0.108144983913576f,-0.486322989569125f,-0.613674712751319f,
  -0.317080956716971f,0.471134684264513f,-0.30417867085874f,0.696115419091356f,
  -0.469268432777419f,0.236211281027806f,-0.772378939124543f,0.460249824926805f,
  -0.654534877200454f,-0.934852798470303f,0.032756384083477f,-0.66677857258658f,
  0.314980215822125f,-0.289198088561079f,-0.0476688874127049f,0.0583547444711741f,
  0.941740852748786f,0.774296795413221f,-0.414622097461695f,0.638345821607103f,
  -0.358465167682304f,-0.700596445490135f,0.374529194857949f,0.45456008092971f,
  -0.853620900176985f,0.494280579565469f,-0.217619888424174f,0.956186128386705f,
  0.0389822381652678f,-0.19316201021536f,0.00512085504598048f,-0.0427176575011998f,
  0.547932129275615f,0.721865358296469f,0.456248153651011f,0.618884232413038f,
  0.0410425055490649f,-0.0673903257300594f,-0.218781418704999f,0.528492225462415f,
  -0.0837068514807342f,0.718697939323846f,-0.603328224259776f,0.875509849594366f,
  -0.0909494938322766f,-0.280637910576161f,-0.645530682341054f,-0.705120660981081f,
  -0.529475884017096f,0.140296797228785f,-0.0133440668494202f,0.529843637228154f,
  -0.25828493683013f,0.619866268930593f,0.47419437241583f,0.447278725151833f,
  0.821711397258731f,-0.617272470973745f,-0.212155578716597f,-0.794533711360103f,
  -0.762402399229636f,-0.66554198883216f,0.86799064535122f,-0.61415791629922f,
  0.650236475570502f,0.838917668255732f,-0.658036726366966f,0.79973808497526f,
  -0.583232188921549f,-0.958456594727579f,-0.670917275207309f,-0.607735262211108f,
  0.374114548594356f,0.758519548998692f,-0.831818710697753f,-0.606668498198204f,
  0.461609482669083f,0.676995424711095f,0.338856030176508f,0.5967074997629f,
  -0.925180531336558f,0.4696830362291f,-0.0384243216844951f,0.649557593176482f,
  0.502765260428653f,0.513967467262376f,-0.515358199072217f,-0.444119277197828f,
  -0.230720891612428f,0.348053063903166f,0.335781438011331f,0.567805000835321f,
  -0.345275268793607f,0.452852845315761f,-0.823034642564643f,-0.629914051647049f,
  -0.248509141280827f,0.107760047194603f,0.103293698795021f,0.347988561161273f,
  -0.103424145197316f,0.151822355394586f,-0.272890315097335f,0.940838684544033f,
  0.174472591496773f,0.741124360281646f,-0.950217097467039f,-0.922017392413252f,
  0.496955384825533f,-0.588424819191232f,-0.285012984144181f,-0.292976024259858f,
  0.30303004349728f,0.748249196092075f,-0.565826698130202f,0.973592191086922f,
  0.598249548946463f,-0.926358493656323f,-0.241048287909827f,0.996364548389252f,
  -0.0599127959717052f,0.174629249412504f,-0.96587410625029f,0.980693566420129f,
  -0.696388116912935f,-0.900221651108609f,-0.706671628163384f,0.990309443320101f,
  -0.585908086908283,0.414355789768166f,0.456957525423029f,-0.308246583228438f,
};

#ifdef _VECTORMATH_SOA_TEST
inline float getfloat( vec_float4 val )
{
   union { vec_float4 v; float s[4]; } tmp;
   tmp.v = val;
   return tmp.s[0];
}

vec_float4 randfloat()
{
   static int randfloat_count = 0;
   int idx = randfloat_count;
   vec_float4 tmp = (vec_float4){randfloats[idx],randfloats[idx],randfloats[idx],randfloats[idx]};
   randfloat_count = (randfloat_count+1) % 1024;
   return tmp;
}

#else
inline float getfloat( float val )
{
  return val;
}

float randfloat()
{      
  static int randfloat_count = 0;
  float tmp = randfloats[randfloat_count];   
  randfloat_count = (randfloat_count+1) % 1024;
  return tmp;
}
#endif

#ifdef _VECTORMATH_SCALAR_TEST
#  define scalar_float(v) (v)
#else
#  define scalar_float(v) floatInVec(v)
#endif

#endif
