/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.omegat.util.StringUtil;

public class GlossaryEntry {
    private String mSource;
    private String[] mTargets;
    private String[] mComments;
    private boolean[] mPriorities;
    private String[] mOrigins;

    public GlossaryEntry(String src, String[] loc, String[] com, boolean[] fromPriorityGlossary, String[] origins) {
        this.mSource = StringUtil.normalizeUnicode(src);
        this.mTargets = loc;
        this.normalize(this.mTargets);
        this.mComments = com;
        this.normalize(com);
        this.mPriorities = fromPriorityGlossary;
        this.mOrigins = origins;
    }

    public GlossaryEntry(String src, String loc, String com, boolean fromPriorityGlossary, String origin) {
        this(src, new String[]{loc}, new String[]{com}, new boolean[]{fromPriorityGlossary}, new String[]{origin});
    }

    public String getSrcText() {
        return this.mSource;
    }

    public String getLocText() {
        return this.mTargets.length > 0 ? this.mTargets[0] : "";
    }

    public String[] getLocTerms(boolean uniqueOnly) {
        if (!uniqueOnly || this.mTargets.length == 1) {
            return this.mTargets;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.mTargets.length; ++i) {
            if (i > 0 && this.mTargets[i].equals(this.mTargets[i - 1])) continue;
            list.add(this.mTargets[i]);
        }
        return list.toArray(new String[list.size()]);
    }

    public String getCommentText() {
        return this.mComments.length > 0 ? this.mComments[0] : "";
    }

    public String[] getComments() {
        return this.mComments;
    }

    public boolean getPriority() {
        return this.mPriorities.length > 0 ? this.mPriorities[0] : false;
    }

    public boolean[] getPriorities() {
        return this.mPriorities;
    }

    public String[] getOrigins(boolean uniqueOnly) {
        if (!uniqueOnly || this.mOrigins.length == 1) {
            return this.mOrigins;
        }
        return (String[])Stream.of(this.mOrigins).distinct().toArray(String[]::new);
    }

    public StyledString toStyledString() {
        StyledString result = new StyledString();
        result.text.append(this.mSource);
        result.text.append(" = ");
        StringBuilder comments = new StringBuilder();
        int commentIndex = 0;
        for (int i = 0; i < this.mTargets.length; ++i) {
            if (i > 0 && this.mTargets[i].equals(this.mTargets[i - 1])) {
                if (this.mComments[i].equals("")) continue;
                comments.append("\n");
                comments.append(commentIndex);
                comments.append(". ");
                comments.append(this.mComments[i]);
                continue;
            }
            if (i > 0) {
                result.text.append(", ");
            }
            if (this.mPriorities[i]) {
                result.markBoldStart();
            }
            result.text.append(this.bracketEntry(this.mTargets[i]));
            if (this.mPriorities[i]) {
                result.markBoldEnd();
            }
            ++commentIndex;
            if (this.mComments[i].equals("")) continue;
            comments.append("\n");
            comments.append(commentIndex);
            comments.append(". ");
            comments.append(this.mComments[i]);
        }
        result.text.append((CharSequence)comments);
        return result;
    }

    private String bracketEntry(String entry) {
        if (entry.contains(",") && !entry.contains(";") && !entry.contains("\"")) {
            entry = '\"' + entry + '\"';
        }
        return entry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GlossaryEntry otherGlossaryEntry = (GlossaryEntry)o;
        return Objects.equals(this.mSource, otherGlossaryEntry.mSource) && Arrays.equals(this.mTargets, otherGlossaryEntry.mTargets) && Arrays.equals(this.mComments, otherGlossaryEntry.mComments);
    }

    public int hashCode() {
        int hash = 98;
        hash = hash * 17 + (this.mSource == null ? 0 : this.mSource.hashCode());
        hash = hash * 31 + (this.mTargets == null ? 0 : Arrays.hashCode(this.mTargets));
        hash = hash * 13 + (this.mComments == null ? 0 : Arrays.hashCode(this.mComments));
        return hash;
    }

    private void normalize(String[] strs) {
        for (int i = 0; i < strs.length; ++i) {
            strs[i] = StringUtil.normalizeUnicode(strs[i]);
        }
    }

    static class StyledString {
        public StringBuilder text = new StringBuilder();
        public List<Integer> boldStarts = new ArrayList<Integer>();
        public List<Integer> boldLengths = new ArrayList<Integer>();

        StyledString() {
        }

        void markBoldStart() {
            this.boldStarts.add(this.text.length());
        }

        void markBoldEnd() {
            int start = this.boldStarts.get(this.boldStarts.size() - 1);
            this.boldLengths.add(this.text.length() - start);
        }

        public void append(StyledString str) {
            int off = this.text.length();
            this.text.append((CharSequence)str.text);
            for (int s : str.boldStarts) {
                this.boldStarts.add(off + s);
            }
            this.boldLengths.addAll(str.boldLengths);
        }

        public void append(String str) {
            this.text.append(str);
        }

        public String toHTML() {
            StringBuilder sb = new StringBuilder(this.text);
            for (int i = this.boldStarts.size() - 1; i >= 0; --i) {
                sb.insert(this.boldStarts.get(i) + this.boldLengths.get(i), "</b>");
                sb.insert((int)this.boldStarts.get(i), "<b>");
            }
            sb.insert(0, "<html><p>").append("</p></html>");
            return sb.toString().replaceAll("\n", "<br>");
        }
    }
}

