/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.FloatingDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.NearString;
import org.omegat.gui.filelist.ProjectFilesListController;
import org.omegat.gui.main.IMainMenu;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.main.MainWindowMenu;
import org.omegat.gui.main.MainWindowMenuHandler;
import org.omegat.gui.main.MainWindowUI;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.matches.IMatcher;
import org.omegat.gui.search.SearchWindowController;
import org.omegat.util.FileUtil;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.UIThreadsUtil;

public class MainWindow
extends JFrame
implements IMainWindow {
    public final MainWindowMenu menu;
    protected ProjectFilesListController projWin;
    private Font font;
    private final List<SearchWindowController> searches = new ArrayList<SearchWindowController>();
    protected JLabel lengthLabel;
    protected JLabel progressLabel;
    protected JLabel statusLabel;
    protected DockingDesktop desktop;
    private JLabel lastDialogText;
    private String lastDialogKey;

    public MainWindow() {
        this.menu = new MainWindowMenu(this, new MainWindowMenuHandler(this));
        this.setJMenuBar(this.menu.initComponents());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.menu.mainWindowMenuHandler.projectExitMenuItemActionPerformed();
            }

            @Override
            public void windowDeactivated(WindowEvent we) {
                Core.getEditor().windowDeactivated();
            }
        });
        String fontName = Preferences.getPreferenceDefault("source_font", "Dialog");
        int fontSize = Preferences.getPreferenceDefault("source_font_size", 12);
        this.font = new Font(fontName, 0, fontSize);
        MainWindowUI.createMainComponents(this, this.font);
        this.getContentPane().add((Component)MainWindowUI.initDocking(this), "Center");
        this.pack();
        this.getContentPane().add((Component)MainWindowUI.createStatusBar(this), "South");
        StaticUIUtils.setWindowIcon(this);
        CoreEvents.registerProjectChangeListener(eventType -> {
            this.updateTitle();
            if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE) {
                this.closeSearchWindows();
            }
        });
        CoreEvents.registerApplicationEventListener(new IApplicationEventListener(){

            @Override
            public void onApplicationStartup() {
                MainWindowUI.initializeScreenLayout(MainWindow.this);
                DockingUI.removeUnusedMenuSeparators(MainWindow.this.menu.getOptionsMenu().getPopupMenu());
            }

            @Override
            public void onApplicationShutdown() {
            }
        });
        CoreEvents.registerFontChangedEventListener(newFont -> {
            this.font = newFont;
        });
        MainWindowUI.handlePerProjectLayouts(this);
        this.updateTitle();
        Preferences.addPropertyChangeListener(evt -> {
            if (Core.getProject().isProjectLoaded()) {
                String prop = evt.getPropertyName();
                if (prop.equals("srx") && Core.getProject().getProjectProperties().getProjectSRX() == null) {
                    SwingUtilities.invokeLater(ProjectUICommands::promptReload);
                } else if (prop.equals("filters") && Core.getProject().getProjectProperties().getProjectFilters() == null) {
                    SwingUtilities.invokeLater(ProjectUICommands::promptReload);
                }
            }
        });
    }

    @Override
    public JFrame getApplicationFrame() {
        return this;
    }

    @Override
    public Font getApplicationFont() {
        return this.font;
    }

    @Override
    public IMainMenu getMainMenu() {
        return this.menu;
    }

    @Override
    public void addDockable(Dockable pane) {
        this.desktop.addDockable(pane);
    }

    private void updateTitle() {
        String s = OStrings.getDisplayNameAndVersion();
        if (Core.getProject().isProjectLoaded()) {
            s = s + " :: " + Core.getProject().getProjectProperties().getProjectName();
        }
        this.setTitle(s);
    }

    public void doInsertTrans() {
        NearString near;
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String text = this.getSelectedTextInMatcher();
        boolean fromMT = false;
        if (StringUtil.isEmpty(text) && (near = Core.getMatcher().getActiveMatch()) != null) {
            text = near.translation;
            if (Preferences.isPreference("wf_convertNumbers")) {
                text = Core.getMatcher().substituteNumbers(Core.getEditor().getCurrentEntry().getSrcText(), near.source, near.translation);
            }
            if (near.comesFrom == NearString.MATCH_SOURCE.TM && FileUtil.isInPath(new File(Core.getProject().getProjectProperties().getTMRoot(), "mt"), new File(near.projs[0]))) {
                fromMT = true;
            }
        }
        if (!StringUtil.isEmpty(text)) {
            if (fromMT) {
                Core.getEditor().insertTextAndMark(text);
            } else {
                Core.getEditor().insertText(text);
            }
            Core.getEditor().requestFocus();
        }
    }

    public void doRecycleTrans() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String selection = this.getSelectedTextInMatcher();
        if (!StringUtil.isEmpty(selection)) {
            Core.getEditor().replaceEditText(selection);
            Core.getEditor().requestFocus();
            return;
        }
        NearString near = Core.getMatcher().getActiveMatch();
        if (near != null) {
            String translation = near.translation;
            if (Preferences.isPreference("wf_convertNumbers")) {
                translation = Core.getMatcher().substituteNumbers(Core.getEditor().getCurrentEntry().getSrcText(), near.source, near.translation);
            }
            if (near.comesFrom == NearString.MATCH_SOURCE.TM && FileUtil.isInPath(new File(Core.getProject().getProjectProperties().getTMRoot(), "mt"), new File(near.projs[0]))) {
                Core.getEditor().replaceEditTextAndMark(translation);
            } else {
                Core.getEditor().replaceEditText(translation);
            }
            Core.getEditor().requestFocus();
        }
    }

    private String getSelectedTextInMatcher() {
        IMatcher matcher = Core.getMatcher();
        return matcher instanceof JTextComponent ? ((JTextComponent)((Object)matcher)).getSelectedText() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSearchWindow(final SearchWindowController newSearchWindow) {
        newSearchWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                MainWindow.this.removeSearchWindow(newSearchWindow);
            }
        });
        List<SearchWindowController> list = this.searches;
        synchronized (list) {
            this.searches.add(newSearchWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSearchWindow(SearchWindowController searchWindow) {
        List<SearchWindowController> list = this.searches;
        synchronized (list) {
            this.searches.remove(searchWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSearchWindows() {
        List<SearchWindowController> list = this.searches;
        synchronized (list) {
            for (SearchWindowController sw : this.searches) {
                sw.dispose();
            }
            this.searches.clear();
        }
    }

    protected List<SearchWindowController> getSearchWindows() {
        return Collections.unmodifiableList(this.searches);
    }

    @Override
    public void showStatusMessageRB(String messageKey, Object ... params) {
        final String msg = this.getLocalizedString(messageKey, params);
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.statusLabel.setText(msg);
            }
        });
    }

    private String getLocalizedString(String messageKey, Object ... params) {
        if (messageKey == null) {
            return " ";
        }
        if (params == null) {
            return OStrings.getString(messageKey);
        }
        return StringUtil.format(OStrings.getString(messageKey), params);
    }

    @Override
    public void showTimedStatusMessageRB(String messageKey, Object ... params) {
        this.showStatusMessageRB(messageKey, params);
        if (messageKey == null) {
            return;
        }
        String localizedString = this.getLocalizedString(messageKey, params);
        Timer timer = new Timer(10000, evt -> {
            String text = this.statusLabel.getText();
            if (localizedString.equals(text)) {
                this.statusLabel.setText(null);
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    @Override
    public void showProgressMessage(String messageText) {
        this.progressLabel.setText(messageText);
    }

    public void setProgressToolTipText(String toolTipText) {
        this.progressLabel.setToolTipText(toolTipText);
    }

    @Override
    public void showLengthMessage(String messageText) {
        this.lengthLabel.setText(messageText);
    }

    @Override
    public void displayWarningRB(String warningKey, Object ... params) {
        this.displayWarningRB(warningKey, null, params);
    }

    @Override
    public void displayWarningRB(String warningKey, String supercedesKey, Object ... params) {
        UIThreadsUtil.executeInSwingThread(() -> {
            Window w;
            String msg = params != null ? StringUtil.format(OStrings.getString(warningKey), params) : OStrings.getString(warningKey);
            if (supercedesKey != null && this.lastDialogText != null && supercedesKey.equals(this.lastDialogKey) && (w = SwingUtilities.getWindowAncestor(this.lastDialogText)) != null) {
                w.dispose();
            }
            this.lastDialogText = new JLabel(msg);
            this.lastDialogKey = warningKey;
            this.statusLabel.setText(msg);
            JOptionPane.showMessageDialog(this, this.lastDialogText, OStrings.getString("TF_WARNING"), 2);
        });
    }

    @Override
    public void displayErrorRB(Throwable ex, String errorKey, Object ... params) {
        UIThreadsUtil.executeInSwingThread(() -> {
            String msg = params != null ? StringUtil.format(OStrings.getString(errorKey), params) : OStrings.getString(errorKey);
            this.statusLabel.setText(msg);
            String fulltext = msg;
            if (ex != null) {
                fulltext = fulltext + "\n" + ex.toString();
            }
            JOptionPane.showMessageDialog(this, fulltext, OStrings.getString("TF_ERROR"), 0);
        });
    }

    @Override
    public void lockUI() {
        UIThreadsUtil.mustBeSwingThread();
        this.setEnabled(false);
        for (Frame frame : Frame.getFrames()) {
            frame.setEnabled(false);
        }
        block1: for (Frame frame : this.desktop.getDockables()) {
            if (frame.isDocked()) continue;
            frame.getDockable().getComponent().setEnabled(false);
            for (Container parent = frame.getDockable().getComponent().getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof FloatingDialog)) continue;
                parent.setEnabled(false);
                continue block1;
            }
        }
    }

    @Override
    public void unlockUI() {
        UIThreadsUtil.mustBeSwingThread();
        for (DockableState dockableState : this.desktop.getDockables()) {
            if (dockableState.isDocked()) continue;
            for (Container parent = dockableState.getDockable().getComponent().getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof FloatingDialog)) continue;
                parent.setEnabled(true);
                break;
            }
            dockableState.getDockable().getComponent().setEnabled(true);
        }
        for (Frame frame : Frame.getFrames()) {
            frame.setEnabled(true);
        }
        this.setEnabled(true);
    }

    @Override
    public void showErrorDialogRB(String title, String message, Object ... args) {
        JOptionPane.showMessageDialog(this.getApplicationFrame(), StringUtil.format(OStrings.getString(message), args), OStrings.getString(title), 0);
    }

    @Override
    public int showConfirmDialog(Object message, String title, int optionType, int messageType) throws HeadlessException {
        return JOptionPane.showConfirmDialog(this, message, title, optionType, messageType);
    }

    @Override
    public void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(this, message);
    }
}

