/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import org.omegat.filters3.Attribute;
import org.omegat.filters3.Tag;
import org.omegat.filters3.xml.Translator;
import org.omegat.filters3.xml.XMLUtils;
import org.omegat.util.Language;
import org.xml.sax.Attributes;

public class XMLTag
extends Tag {
    private Language sourceLanguage;
    private Language targetLanguage;

    public XMLTag(String tag, String shortcut, Tag.Type type, Attributes attributes, Translator translator) {
        super(tag, shortcut, type, XMLUtils.convertAttributes(attributes));
        this.sourceLanguage = translator.getSourceLanguage();
        this.targetLanguage = translator.getTargetLanguage();
    }

    @Override
    public String toOriginal() {
        StringBuilder buf = new StringBuilder();
        boolean isRtl = Language.isRTL(this.targetLanguage.getLanguageCode());
        boolean differentDir = this.isDifferentDirection(isRtl);
        boolean isSpecialDocxTagLTR = this.isSpecialDocxBidiTag(false);
        boolean isSpecialDocxTagRTL = this.isSpecialDocxBidiTag(true);
        if (differentDir && (isRtl && isSpecialDocxTagRTL || !isRtl && isSpecialDocxTagLTR)) {
            return "";
        }
        buf.append("<");
        if (Tag.Type.END == this.getType()) {
            buf.append("/");
        }
        if (differentDir && isRtl && isSpecialDocxTagLTR) {
            buf.append(this.getTag() + "Cs");
        } else if (differentDir && !isRtl && isSpecialDocxTagRTL) {
            buf.append(this.getTag().replaceFirst("Cs", ""));
        } else {
            buf.append(this.getTag());
        }
        buf.append(this.getAttributes().toString());
        if (this.getTag().equalsIgnoreCase("w:t") && Tag.Type.BEGIN == this.getType()) {
            Boolean preserve = false;
            for (int i = 0; i < this.getAttributes().size(); ++i) {
                Attribute oneAttribute = this.getAttributes().get(i);
                if (!oneAttribute.getName().equalsIgnoreCase("xml:space")) continue;
                preserve = true;
                break;
            }
            if (!preserve.booleanValue()) {
                buf.append(" xml:space=\"preserve\"");
            }
        }
        boolean alreadyClosed = false;
        if (isRtl) {
            if (this.getTag().equalsIgnoreCase("w:pPr") && Tag.Type.BEGIN == this.getType()) {
                buf.append("><w:bidi/");
            } else if (this.getTag().equalsIgnoreCase("w:sectPr") && Tag.Type.BEGIN == this.getType()) {
                buf.append("><w:bidi/");
            } else if (this.getTag().equalsIgnoreCase("w:rPr") && Tag.Type.BEGIN == this.getType()) {
                buf.append("><w:rtl/");
            } else if (this.getTag().equalsIgnoreCase("w:tblPr") && Tag.Type.BEGIN == this.getType()) {
                buf.append("><w:bidiVisual/");
            } else if (this.getTag().equalsIgnoreCase("w:tblStyle") && Tag.Type.ALONE == this.getType()) {
                buf.append("/><w:bidiVisual/");
                alreadyClosed = true;
            }
        }
        if (Tag.Type.ALONE == this.getType() && !alreadyClosed) {
            buf.append("/");
        }
        buf.append(">");
        return buf.toString();
    }

    private boolean isDifferentDirection(boolean isRtl) {
        if (this.sourceLanguage == null) {
            return false;
        }
        return isRtl != Language.isRTL(this.sourceLanguage.getLanguageCode());
    }

    private boolean isSpecialDocxBidiTag(boolean complex) {
        String suffix = complex ? "Cs" : "";
        return Tag.Type.ALONE == this.getType() && (this.getTag().equalsIgnoreCase("w:i" + suffix) || this.getTag().equalsIgnoreCase("w:b" + suffix) || this.getTag().equalsIgnoreCase("w:sz" + suffix));
    }
}

