/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.statistics.Statistics;

public class StatCount {
    public int segments;
    public int words;
    public int charsWithoutSpaces;
    public int charsWithSpaces;
    public int files;

    public StatCount() {
    }

    public StatCount(SourceTextEntry ste) {
        String src = ste.getSrcText();
        for (ProtectedPart pp : ste.getProtectedParts()) {
            src = src.replace(pp.getTextInSourceSegment(), pp.getReplacementWordsCountCalculation());
        }
        this.segments = 1;
        this.words = Statistics.numberOfWords(src);
        this.charsWithoutSpaces = Statistics.numberOfCharactersWithoutSpaces(src);
        this.charsWithSpaces = Statistics.numberOfCharactersWithSpaces(src);
    }

    public StatCount add(StatCount c) {
        this.segments += c.segments;
        this.words += c.words;
        this.charsWithoutSpaces += c.charsWithoutSpaces;
        this.charsWithSpaces += c.charsWithSpaces;
        return this;
    }

    public void addFiles(int count) {
        this.files += count;
    }
}

