/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNTreeConflictUtil {
    public static Map readTreeConflicts(File dirPath, String conflictData) throws SVNException {
        byte[] data;
        if (conflictData == null) {
            return new SVNHashMap();
        }
        try {
            data = conflictData.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            data = conflictData.getBytes();
        }
        return SVNTreeConflictUtil.readTreeConflicts(dirPath, data);
    }

    public static Map readTreeConflicts(File dirPath, byte[] conflictData) throws SVNException {
        SVNHashMap conflicts = new SVNHashMap();
        if (conflictData == null) {
            return conflicts;
        }
        SVNSkel skel = SVNSkel.parse(conflictData);
        if (skel == null || skel.isAtom()) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Error parsing tree conflict skel");
            SVNErrorManager.error(error, SVNLogType.WC);
        }
        for (SVNSkel conflictSkel : skel.getList()) {
            SVNTreeConflictDescription conflict = SVNTreeConflictUtil.readSingleTreeConflict(conflictSkel, dirPath);
            if (conflict == null) continue;
            conflicts.put(conflict.getPath(), conflict);
        }
        return conflicts;
    }

    public static SVNTreeConflictDescription readSingleTreeConflict(SVNSkel skel, File dirPath) throws SVNException {
        SVNErrorMessage error;
        if (!SVNTreeConflictUtil.isValidConflict(skel)) {
            error = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Invalid conflict info in tree conflict description");
            SVNErrorManager.error(error, SVNLogType.WC);
        }
        if (skel.getChild(1).getData().length == 0) {
            error = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Empty 'victim' field in tree conflict description");
            SVNErrorManager.error(error, SVNLogType.WC);
        }
        String victimBasename = skel.getChild(1).getValue();
        SVNNodeKind kind = SVNTreeConflictUtil.getNodeKind(skel.getChild(2).getValue());
        if (kind != SVNNodeKind.FILE && kind != SVNNodeKind.DIR) {
            SVNErrorMessage error2 = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Invalid 'node_kind' field in tree conflict description");
            SVNErrorManager.error(error2, SVNLogType.WC);
        }
        SVNOperation operation = SVNTreeConflictUtil.getOperation(skel.getChild(3).getValue());
        SVNConflictAction action = SVNTreeConflictUtil.getAction(skel.getChild(4).getValue());
        SVNConflictReason reason = SVNTreeConflictUtil.getConflictReason(skel.getChild(5).getValue());
        SVNConflictVersion srcLeftVersion = SVNTreeConflictUtil.readConflictVersion(skel.getChild(6));
        SVNConflictVersion srcRightVersion = SVNTreeConflictUtil.readConflictVersion(skel.getChild(7));
        return new SVNTreeConflictDescription(new File(dirPath, victimBasename), kind, action, reason, operation, srcLeftVersion, srcRightVersion);
    }

    private static SVNConflictVersion readConflictVersion(SVNSkel skel) throws SVNException {
        String repoURLString;
        SVNURL repoURL;
        if (!SVNTreeConflictUtil.isValidVersionInfo(skel)) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Invalid version info in tree conflict description");
            SVNErrorManager.error(error, SVNLogType.WC);
        }
        SVNURL sVNURL = repoURL = (repoURLString = skel.getChild(1).getValue()).length() == 0 ? null : SVNURL.parseURIEncoded(repoURLString);
        if (repoURL == null) {
            return null;
        }
        long pegRevision = Long.parseLong(skel.getChild(2).getValue());
        String path = skel.getChild(3).getValue();
        path = path.length() == 0 ? null : path;
        SVNNodeKind kind = SVNTreeConflictUtil.getNodeKind(skel.getChild(4).getValue());
        return new SVNConflictVersion(repoURL, path, pegRevision, kind);
    }

    private static boolean isValidVersionInfo(SVNSkel skel) throws SVNException {
        if (skel.getListSize() != 5 || !skel.getChild(0).contentEquals("version")) {
            return false;
        }
        return skel.containsAtomsOnly();
    }

    private static boolean isValidConflict(SVNSkel skel) throws SVNException {
        if (skel.getListSize() != 8 || !skel.getChild(0).contentEquals("conflict")) {
            return false;
        }
        for (int i = 1; i < 6; ++i) {
            SVNSkel element = skel.getChild(i);
            if (element.isAtom()) continue;
            return false;
        }
        return SVNTreeConflictUtil.isValidVersionInfo(skel.getChild(6)) && SVNTreeConflictUtil.isValidVersionInfo(skel.getChild(7));
    }

    public static String getTreeConflictData(Map conflicts) throws SVNException {
        String conflictData;
        if (conflicts == null) {
            return null;
        }
        byte[] rawData = SVNTreeConflictUtil.getTreeConflictRawData(conflicts);
        try {
            conflictData = new String(rawData, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            conflictData = new String(rawData);
        }
        return conflictData;
    }

    public static byte[] getTreeConflictRawData(Map conflicts) throws SVNException {
        if (conflicts == null) {
            return null;
        }
        SVNConflictVersion nullVersion = new SVNConflictVersion(null, null, -1L, SVNNodeKind.UNKNOWN);
        SVNSkel skel = SVNSkel.createEmptyList();
        for (SVNTreeConflictDescription conflict : conflicts.values()) {
            SVNSkel conflictSkel = SVNTreeConflictUtil.getConflictSkel(nullVersion, conflict);
            if (!SVNTreeConflictUtil.isValidConflict(conflictSkel)) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Failed to create valid conflict description skel: ''{0}''", (Object)skel.toString());
                SVNErrorManager.error(error, SVNLogType.WC);
            }
            skel.prepend(conflictSkel);
        }
        return skel.unparse();
    }

    public static String getSingleTreeConflictData(SVNTreeConflictDescription conflict) throws SVNException {
        String conflictData;
        if (conflict == null) {
            return null;
        }
        byte[] rawData = SVNTreeConflictUtil.getSingleTreeConflictRawData(conflict);
        try {
            conflictData = new String(rawData, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            conflictData = new String(rawData);
        }
        return conflictData;
    }

    public static byte[] getSingleTreeConflictRawData(SVNTreeConflictDescription conflict) throws SVNException {
        SVNConflictVersion nullVersion = new SVNConflictVersion(null, null, -1L, SVNNodeKind.UNKNOWN);
        SVNSkel conflictSkel = SVNTreeConflictUtil.getConflictSkel(nullVersion, conflict);
        if (!SVNTreeConflictUtil.isValidConflict(conflictSkel)) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Failed to create valid conflict description skel: ''{0}''", (Object)conflictSkel.toString());
            SVNErrorManager.error(error, SVNLogType.WC);
        }
        return conflictSkel.unparse();
    }

    public static SVNSkel getConflictSkel(SVNConflictVersion nullVersion, SVNTreeConflictDescription conflict) throws SVNException {
        SVNSkel conflictSkel = SVNSkel.createEmptyList();
        SVNConflictVersion sourceRightVersion = conflict.getSourceRightVersion();
        sourceRightVersion = sourceRightVersion == null ? nullVersion : sourceRightVersion;
        SVNTreeConflictUtil.prependVersionInfo(conflictSkel, sourceRightVersion);
        SVNConflictVersion sourceLeftVersion = conflict.getSourceLeftVersion();
        sourceLeftVersion = sourceLeftVersion == null ? nullVersion : sourceLeftVersion;
        SVNTreeConflictUtil.prependVersionInfo(conflictSkel, sourceLeftVersion);
        conflictSkel.prepend(SVNSkel.createAtom(conflict.getConflictReason().toString()));
        conflictSkel.prepend(SVNSkel.createAtom(conflict.getConflictAction().toString()));
        conflictSkel.prepend(SVNSkel.createAtom(conflict.getOperation().toString()));
        if (conflict.getNodeKind() != SVNNodeKind.DIR && conflict.getNodeKind() != SVNNodeKind.FILE) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Invalid 'node_kind' field in tree conflict description");
            SVNErrorManager.error(error, SVNLogType.WC);
        }
        conflictSkel.prepend(SVNSkel.createAtom(SVNTreeConflictUtil.getNodeKindString(conflict.getNodeKind())));
        String path = conflict.getPath().getName();
        if (path.length() == 0) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Empty path basename in tree conflict description");
            SVNErrorManager.error(error, SVNLogType.WC);
        }
        conflictSkel.prepend(SVNSkel.createAtom(path));
        conflictSkel.prepend(SVNSkel.createAtom("conflict"));
        return conflictSkel;
    }

    public static String getHumanReadableConflictDescription(SVNTreeConflictDescription treeConflict) {
        SVNNodeKind incomingKind = SVNNodeKind.UNKNOWN;
        if (treeConflict.getConflictAction() == SVNConflictAction.EDIT || treeConflict.getConflictAction() == SVNConflictAction.DELETE) {
            if (treeConflict.getSourceLeftVersion() != null) {
                incomingKind = treeConflict.getSourceLeftVersion().getKind();
            }
        } else if ((treeConflict.getConflictAction() == SVNConflictAction.ADD || treeConflict.getConflictAction() == SVNConflictAction.REPLACE) && treeConflict.getSourceRightVersion() != null) {
            incomingKind = treeConflict.getSourceRightVersion().getKind();
        }
        String reasonStr = SVNTreeConflictUtil.getReasonString(treeConflict);
        String actionStr = SVNTreeConflictUtil.getActionString(incomingKind, treeConflict);
        String operationStr = treeConflict.getOperation().getName();
        String kindWithSpaceStr = SVNTreeConflictUtil.getNodeKindString(treeConflict.getNodeKind());
        if (kindWithSpaceStr.length() > 0) {
            kindWithSpaceStr = kindWithSpaceStr + " ";
        }
        String description = String.format("local %s%s, incoming %s upon %s", kindWithSpaceStr, reasonStr, actionStr, operationStr);
        return description;
    }

    public static String getHumanReadableConflictVersion(SVNConflictVersion version) {
        String url;
        if (version == null) {
            return "(none)";
        }
        String string = url = version.getRepositoryRoot() != null ? version.getRepositoryRoot().toString() : null;
        url = url != null && version.getPath() != null ? url + "/" + version.getPath() : (url != null ? url + "/..." : (version.getPath() != null ? version.getPath() : "..."));
        return "(" + SVNTreeConflictUtil.getNodeKindString(version.getKind()) + ") " + url + "@" + version.getPegRevision();
    }

    private static String getReasonString(SVNTreeConflictDescription treeConflict) {
        SVNConflictReason reason = treeConflict.getConflictReason();
        if (reason == SVNConflictReason.EDITED) {
            return "edit";
        }
        if (reason == SVNConflictReason.OBSTRUCTED) {
            return "obstruction";
        }
        if (reason == SVNConflictReason.DELETED) {
            return "delete";
        }
        if (reason == SVNConflictReason.MISSING) {
            if (treeConflict.getOperation() == SVNOperation.MERGE) {
                return "missing or deleted or moved away";
            }
            return "missing";
        }
        if (reason == SVNConflictReason.UNVERSIONED) {
            return "unversioned";
        }
        if (reason == SVNConflictReason.ADDED) {
            return "add";
        }
        if (reason == SVNConflictReason.REPLACED) {
            return "replace";
        }
        if (reason == SVNConflictReason.MOVED_AWAY) {
            return "moved away";
        }
        if (reason == SVNConflictReason.MOVED_HERE) {
            return "moved here";
        }
        return null;
    }

    private static String getActionString(SVNNodeKind incomingKind, SVNTreeConflictDescription treeConflict) {
        if (incomingKind == SVNNodeKind.FILE) {
            SVNConflictAction action = treeConflict.getConflictAction();
            if (action == SVNConflictAction.ADD) {
                return "file add";
            }
            if (action == SVNConflictAction.EDIT) {
                return "file edit";
            }
            if (action == SVNConflictAction.DELETE) {
                return "file delete or move";
            }
            if (action == SVNConflictAction.REPLACE) {
                return "replace with file";
            }
        } else if (incomingKind == SVNNodeKind.DIR) {
            SVNConflictAction action = treeConflict.getConflictAction();
            if (action == SVNConflictAction.ADD) {
                return "dir add";
            }
            if (action == SVNConflictAction.EDIT) {
                return "dir edit";
            }
            if (action == SVNConflictAction.DELETE) {
                return "dir delete or move";
            }
            if (action == SVNConflictAction.REPLACE) {
                return "replace with dir";
            }
        } else if (incomingKind == SVNNodeKind.NONE || incomingKind == SVNNodeKind.UNKNOWN) {
            SVNConflictAction action = treeConflict.getConflictAction();
            if (action == SVNConflictAction.ADD) {
                return "add";
            }
            if (action == SVNConflictAction.EDIT) {
                return "edit";
            }
            if (action == SVNConflictAction.DELETE) {
                return "delete or move";
            }
            if (action == SVNConflictAction.REPLACE) {
                return "replace";
            }
        }
        return null;
    }

    private static SVNSkel prependVersionInfo(SVNSkel parent, SVNConflictVersion versionInfo) throws SVNException {
        parent = parent == null ? SVNSkel.createEmptyList() : parent;
        SVNSkel skel = SVNSkel.createEmptyList();
        skel.prepend(SVNSkel.createAtom(SVNTreeConflictUtil.getNodeKindString(versionInfo.getKind())));
        String path = versionInfo.getPath() == null ? "" : versionInfo.getPath();
        skel.prepend(SVNSkel.createAtom(path));
        skel.prepend(SVNSkel.createAtom(String.valueOf(versionInfo.getPegRevision())));
        String repoURLString = versionInfo.getRepositoryRoot() == null ? "" : versionInfo.getRepositoryRoot().toString();
        skel.prepend(SVNSkel.createAtom(repoURLString));
        skel.prepend(SVNSkel.createAtom("version"));
        if (!SVNTreeConflictUtil.isValidVersionInfo(skel)) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Failed to create valid conflict version skel: ''{0}''", (Object)skel.toString());
            SVNErrorManager.error(error, SVNLogType.WC);
        }
        parent.prepend(skel);
        return parent;
    }

    private static SVNNodeKind getNodeKind(String name) throws SVNException {
        if ("".equals(name)) {
            return SVNNodeKind.UNKNOWN;
        }
        SVNNodeKind kind = SVNNodeKind.parseKind(name);
        if (kind == SVNNodeKind.UNKNOWN) {
            SVNTreeConflictUtil.mappingError("node kind");
        }
        return kind;
    }

    private static String getNodeKindString(SVNNodeKind kind) {
        if (kind == SVNNodeKind.UNKNOWN) {
            return "";
        }
        return kind.toString();
    }

    private static SVNOperation getOperation(String name) throws SVNException {
        SVNOperation operation = SVNOperation.fromString(name);
        if (operation == null) {
            SVNTreeConflictUtil.mappingError("operation");
        }
        return operation;
    }

    private static SVNConflictAction getAction(String name) throws SVNException {
        SVNConflictAction action = SVNConflictAction.fromString(name);
        if (action == null) {
            SVNTreeConflictUtil.mappingError("conflict action");
        }
        return action;
    }

    private static SVNConflictReason getConflictReason(String name) throws SVNException {
        SVNConflictReason reason = SVNConflictReason.fromString(name);
        if (reason == null) {
            SVNTreeConflictUtil.mappingError("conflict reason");
        }
        return reason;
    }

    private static void mappingError(String type) throws SVNException {
        SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Unknown {0} value in tree conflict description", (Object)type);
        SVNErrorManager.error(error, SVNLogType.WC);
    }
}

