/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.autotext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import org.omegat.gui.editor.autotext.Autotext;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class AutotextTableModel
extends AbstractTableModel {
    private List<Autotext.AutotextItem> data = Collections.emptyList();
    private String[] columnNames = new String[]{OStrings.getString("AC_AUTOTEXT_ABBREVIATION"), OStrings.getString("AC_AUTOTEXT_TEXT"), OStrings.getString("AC_AUTOTEXT_COMMENT")};

    public AutotextTableModel(Collection<Autotext.AutotextItem> data) {
        this.data = new ArrayList<Autotext.AutotextItem>(data);
    }

    public List<Autotext.AutotextItem> getData() {
        return this.data.stream().filter(item -> !StringUtil.isEmpty(item.target)).collect(Collectors.toList());
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int i, int i1) {
        Autotext.AutotextItem item = this.data.get(i);
        switch (i1) {
            case 0: {
                return item.source;
            }
            case 1: {
                return item.target;
            }
            case 2: {
                return item.comment;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Autotext.AutotextItem current = this.data.get(row);
        String source = col == 0 ? (String)value : current.source;
        String target = col == 1 ? (String)value : current.target;
        String comment = col == 2 ? (String)value : current.comment;
        Autotext.AutotextItem item = new Autotext.AutotextItem(source, target, comment);
        this.data.set(row, item);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public int addRow(Autotext.AutotextItem item, int position) {
        int newPosition = position == -1 ? this.data.size() : position;
        this.data.add(newPosition, item);
        this.fireTableDataChanged();
        return newPosition;
    }

    public void removeRow(int position) {
        this.data.remove(position);
        this.fireTableDataChanged();
    }
}

