/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.omegat.core.data.ProjectProperties;
import org.omegat.util.FileUtil;

public final class ProjectMedProcessing {
    private ProjectMedProcessing() {
    }

    public static void extractFromMed(File medZip, ProjectProperties props) throws Exception {
        String medName = medZip.getName().replaceAll("\\.zip$", "");
        Properties p = new Properties();
        try (ZipFile zip = new ZipFile(medZip);){
            ZipEntry e = zip.getEntry(medName + "/dossier/workflow/translation");
            if (e == null) {
                throw new Exception("Wrong MED zip structure");
            }
            try (InputStream in = zip.getInputStream(e);){
                p.load(in);
            }
        }
        String slang = p.getProperty("slang");
        if (slang == null) {
            throw new Exception("Bad MED format: slang not defined");
        }
        String tlang = p.getProperty("tlang");
        if (tlang == null) {
            throw new Exception("Bad MED format: tlang not defined");
        }
        props.setSourceLanguage(slang);
        props.setTargetLanguage(tlang);
        try (ZipFile zip = new ZipFile(medZip);){
            ProjectMedProcessing.extractFiles(zip, medName + "/doc/main/" + props.getSourceLanguage().getLanguage() + "/", null, props.getSourceDir().getAsFile());
            ProjectMedProcessing.extractFiles(zip, medName + "/doc/support/" + props.getSourceLanguage().getLanguage() + "/", ".tmx", new File(props.getTMAutoRoot()));
            ProjectMedProcessing.extractFiles(zip, medName + "/doc/support/" + props.getSourceLanguage().getLanguage() + "/term/", null, props.getGlossaryDir().getAsFile());
        }
        File outZip = new File(props.getProjectInternalDir(), "med/" + medZip.getName());
        outZip.getParentFile().mkdirs();
        FileUtils.copyFile((File)medZip, (File)outZip);
    }

    private static void extractFiles(ZipFile zip, String zipPrefix, String zipSuffix, File projectDir) throws Exception {
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry e = en.nextElement();
            if (e.isDirectory() || !e.getName().startsWith(zipPrefix) || zipSuffix != null && !e.getName().endsWith(zipSuffix)) continue;
            File outFile = new File(projectDir, e.getName().substring(zipPrefix.length()));
            outFile.getParentFile().mkdirs();
            InputStream in = zip.getInputStream(e);
            try {
                FileUtils.copyInputStreamToFile((InputStream)in, (File)outFile);
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
    }

    public static File getOriginMedFile(ProjectProperties props) throws Exception {
        File[] files = new File(props.getProjectInternalDir(), "med/").listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile() && f.getName().endsWith(".zip");
            }
        });
        if (files != null && files.length > 1) {
            throw new Exception("Too many source med files in the <project>/omegat/med directory");
        }
        File originMedFile = files != null && files.length > 0 ? files[0] : null;
        return originMedFile;
    }

    public static void createMed(File medZip, ProjectProperties props) throws Exception {
        if (medZip.getAbsolutePath().startsWith(props.getProjectRoot())) {
            throw new Exception("Med can't be inside project");
        }
        File sourceMedFile = ProjectMedProcessing.getOriginMedFile(props);
        Properties translationContent = new Properties();
        String slang = props.getSourceLanguage().getLanguage();
        String tlang = props.getTargetLanguage().getLanguage();
        String medName = medZip.getName().replaceAll("\\.zip$", "");
        try (ZipOutputStream outZip = new ZipOutputStream(new FileOutputStream(medZip));){
            if (sourceMedFile != null) {
                String oldMedName = sourceMedFile.getName().replaceAll("\\.zip$", "");
                String[] skipPrefixes = new String[]{oldMedName + "/doc/main/" + slang + "/", oldMedName + "/doc/main/" + tlang + "/"};
                String[] skipFiles = new String[]{oldMedName + "/dossier/workflow/translation", oldMedName + "/doc/support/" + slang + "/tm/" + props.getProjectName() + "-level2" + ".tmx", oldMedName + "/doc/support/" + slang + "/term/glossary.txt"};
                try (ZipFile zip = new ZipFile(sourceMedFile);){
                    ZipEntry tre = zip.getEntry(oldMedName + "/dossier/workflow/translation");
                    if (tre == null) {
                        throw new Exception("Wrong MED zip structure");
                    }
                    try (InputStream in = zip.getInputStream(tre);){
                        translationContent.load(in);
                    }
                    Enumeration<? extends ZipEntry> en = zip.entries();
                    while (en.hasMoreElements()) {
                        ZipEntry e = en.nextElement();
                        if (e.isDirectory()) continue;
                        boolean add = true;
                        for (String skip : skipFiles) {
                            if (!e.getName().equals(skip)) continue;
                            add = false;
                            break;
                        }
                        if (add) {
                            for (String skip : skipPrefixes) {
                                if (!e.getName().startsWith(skip)) continue;
                                add = false;
                                break;
                            }
                        }
                        if (!add) continue;
                        String newName = medName + e.getName().substring(oldMedName.length());
                        outZip.putNextEntry(new ZipEntry(newName));
                        InputStream in = zip.getInputStream(e);
                        try {
                            IOUtils.copy((InputStream)in, (OutputStream)outZip);
                        }
                        finally {
                            if (in == null) continue;
                            in.close();
                        }
                    }
                }
            }
            translationContent.put("slang", slang);
            translationContent.put("tlang", tlang);
            outZip.putNextEntry(new ZipEntry(medName + "/dossier/workflow/translation"));
            translationContent.store(outZip, null);
            ProjectMedProcessing.packDir(props.getSourceDir().getAsFile(), medName + "/doc/main/" + slang + "/", outZip);
            ProjectMedProcessing.packDir(props.getTargetDir().getAsFile(), medName + "/doc/main/" + tlang + "/", outZip);
            outZip.putNextEntry(new ZipEntry(medName + "/doc/support/" + slang + "/tm/" + props.getProjectName() + "-level2" + ".tmx"));
            FileUtils.copyFile((File)new File(props.getProjectRootDir(), props.getProjectName() + "-level2" + ".tmx"), (OutputStream)outZip);
            outZip.putNextEntry(new ZipEntry(medName + "/dossier/post/" + "project_stats.txt"));
            FileUtils.copyFile((File)new File(props.getProjectInternalDir(), "project_stats.txt"), (OutputStream)outZip);
            if (props.getWritableGlossaryFile().getAsFile().exists()) {
                outZip.putNextEntry(new ZipEntry(medName + "/doc/support/" + slang + "/term/glossary.txt"));
                FileUtils.copyFile((File)props.getWritableGlossaryFile().getAsFile(), (OutputStream)outZip);
            }
        }
    }

    private static void packDir(File dir, String namePrefix, ZipOutputStream zip) throws Exception {
        List<String> srcPathList = FileUtil.buildRelativeFilesList(dir, null, null);
        for (String f : srcPathList) {
            if (f.startsWith("/")) {
                f = f.substring(1);
            }
            zip.putNextEntry(new ZipEntry(namePrefix + f));
            FileUtils.copyFile((File)new File(dir, f), (OutputStream)zip);
        }
    }
}

