/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.util.ArrayList;
import java.util.List;
import org.omegat.util.Preferences;

public final class HistoryManager {
    private static final List<String> SEARCH_ITEMS;
    private static final List<String> REPLACE_ITEMS;
    private static final int MAX_ITEMS;

    private HistoryManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSearchItem(String item) {
        List<String> list = SEARCH_ITEMS;
        synchronized (list) {
            SEARCH_ITEMS.remove(item);
            SEARCH_ITEMS.add(0, item);
            while (SEARCH_ITEMS.size() > MAX_ITEMS) {
                SEARCH_ITEMS.remove(MAX_ITEMS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addReplaceItem(String item) {
        List<String> list = REPLACE_ITEMS;
        synchronized (list) {
            REPLACE_ITEMS.remove(item);
            REPLACE_ITEMS.add(0, item);
            while (REPLACE_ITEMS.size() > MAX_ITEMS) {
                REPLACE_ITEMS.remove(MAX_ITEMS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSearchItems() {
        List<String> list = SEARCH_ITEMS;
        synchronized (list) {
            return SEARCH_ITEMS.toArray(new String[SEARCH_ITEMS.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getReplaceItems() {
        List<String> list = REPLACE_ITEMS;
        synchronized (list) {
            return REPLACE_ITEMS.toArray(new String[REPLACE_ITEMS.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        int i;
        List<String> list = SEARCH_ITEMS;
        synchronized (list) {
            for (i = 0; i < SEARCH_ITEMS.size(); ++i) {
                Preferences.setPreference("search_window_search_history_item_" + i, SEARCH_ITEMS.get(i));
            }
        }
        list = REPLACE_ITEMS;
        synchronized (list) {
            for (i = 0; i < REPLACE_ITEMS.size(); ++i) {
                Preferences.setPreference("search_window_replace_history_item_" + i, REPLACE_ITEMS.get(i));
            }
        }
    }

    static {
        MAX_ITEMS = Preferences.getPreferenceDefault("search_window_history_size", 10);
        SEARCH_ITEMS = new ArrayList<String>(MAX_ITEMS);
        REPLACE_ITEMS = new ArrayList<String>(MAX_ITEMS);
        for (int i = 0; i < MAX_ITEMS; ++i) {
            String replaceItem;
            String searchItem = Preferences.getPreferenceDefault("search_window_search_history_item_" + i, null);
            if (searchItem != null) {
                SEARCH_ITEMS.add(searchItem);
            }
            if ((replaceItem = Preferences.getPreferenceDefault("search_window_replace_history_item_" + i, null)) == null) continue;
            REPLACE_ITEMS.add(replaceItem);
        }
    }
}

