/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Color;
import java.util.MissingResourceException;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public final class Styles {
    private static final Logger LOGGER = Logger.getLogger(EditorColor.class.getName());

    private Styles() {
    }

    public static AttributeSet createAttributeSet(Color foregroundColor, Color backgroundColor, Boolean bold, Boolean italic) {
        SimpleAttributeSet r = new SimpleAttributeSet();
        if (foregroundColor != null) {
            StyleConstants.setForeground(r, foregroundColor);
        }
        if (backgroundColor != null) {
            StyleConstants.setBackground(r, backgroundColor);
        }
        if (bold != null) {
            StyleConstants.setBold(r, bold);
        }
        if (italic != null) {
            StyleConstants.setItalic(r, italic);
        }
        return r;
    }

    public static AttributeSet createAttributeSet(Color foregroundColor, Color backgroundColor, Boolean bold, Boolean italic, Boolean strikethrough, Boolean underline) {
        MutableAttributeSet r = (MutableAttributeSet)Styles.createAttributeSet(foregroundColor, backgroundColor, bold, italic);
        if (strikethrough != null) {
            StyleConstants.setStrikeThrough(r, strikethrough);
        }
        if (underline != null) {
            StyleConstants.setUnderline(r, underline);
        }
        return r;
    }

    public static enum EditorColor {
        COLOR_BACKGROUND(UIManager.getColor("TextPane.background")),
        COLOR_FOREGROUND(UIManager.getColor("TextPane.foreground")),
        COLOR_ACTIVE_SOURCE(UIManager.getColor("OmegaT.activeSource")),
        COLOR_ACTIVE_SOURCE_FG((Color)null),
        COLOR_ACTIVE_TARGET((Color)null),
        COLOR_ACTIVE_TARGET_FG((Color)null),
        COLOR_SEGMENT_MARKER_FG((Color)null),
        COLOR_SEGMENT_MARKER_BG((Color)null),
        COLOR_SOURCE(UIManager.getColor("OmegaT.source")),
        COLOR_SOURCE_FG((Color)null),
        COLOR_NOTED(UIManager.getColor("OmegaT.noted")),
        COLOR_NOTED_FG((Color)null),
        COLOR_UNTRANSLATED(UIManager.getColor("OmegaT.untranslated")),
        COLOR_UNTRANSLATED_FG((Color)null),
        COLOR_TRANSLATED(UIManager.getColor("OmegaT.translated")),
        COLOR_TRANSLATED_FG((Color)null),
        COLOR_NON_UNIQUE(UIManager.getColor("OmegaT.nonUnique")),
        COLOR_NON_UNIQUE_BG((Color)null),
        COLOR_MOD_INFO((Color)null),
        COLOR_MOD_INFO_FG((Color)null),
        COLOR_PLACEHOLDER(UIManager.getColor("OmegaT.placeholder")),
        COLOR_REMOVETEXT_TARGET(UIManager.getColor("OmegaT.removeTextTarget")),
        COLOR_NBSP(UIManager.getColor("OmegaT.nbsp")),
        COLOR_WHITESPACE(UIManager.getColor("OmegaT.whiteSpace")),
        COLOR_BIDIMARKERS(UIManager.getColor("OmegaT.bidiMarkers")),
        COLOR_PARAGRAPH_START(UIManager.getColor("OmegaT.paragraphStart")),
        COLOR_MARK_COMES_FROM_TM(UIManager.getColor("OmegaT.markComesFromTm")),
        COLOR_MARK_COMES_FROM_TM_XICE(UIManager.getColor("OmegaT.markComesFromTmXice")),
        COLOR_MARK_COMES_FROM_TM_X100PC(UIManager.getColor("OmegaT.markComesFromTmX100pc")),
        COLOR_MARK_COMES_FROM_TM_XAUTO(UIManager.getColor("OmegaT.markComesFromTmXauto")),
        COLOR_MARK_COMES_FROM_TM_XENFORCED(UIManager.getColor("OmegaT.markComesFromTmXenforced")),
        COLOR_REPLACE(UIManager.getColor("OmegaT.replace")),
        COLOR_LANGUAGE_TOOLS(UIManager.getColor("OmegaT.languageTools")),
        COLOR_TRANSTIPS(UIManager.getColor("OmegaT.transTips")),
        COLOR_SPELLCHECK(UIManager.getColor("OmegaT.spellCheck")),
        COLOR_TERMINOLOGY(UIManager.getColor("OmegaT.terminology")),
        COLOR_MATCHES_CHANGED(UIManager.getColor("OmegaT.matchesChanged")),
        COLOR_MATCHES_UNCHANGED(UIManager.getColor("OmegaT.matchesUnchanged")),
        COLOR_GLOSSARY_SOURCE((Color)null),
        COLOR_GLOSSARY_TARGET((Color)null),
        COLOR_GLOSSARY_NOTE((Color)null),
        COLOR_MATCHES_DEL_ACTIVE((Color)null),
        COLOR_MATCHES_DEL_INACTIVE((Color)null),
        COLOR_MATCHES_INS_ACTIVE(UIManager.getColor("OmegaT.matchesInsActive")),
        COLOR_MATCHES_INS_INACTIVE(UIManager.getColor("OmegaT.matchesInsInactive")),
        COLOR_HYPERLINK(UIManager.getColor("OmegaT.hyperlink")),
        COLOR_SEARCH_FOUND_MARK(UIManager.getColor("OmegaT.searchFoundMark")),
        COLOR_SEARCH_REPLACE_MARK(UIManager.getColor("OmegaT.searchReplaceMark")),
        COLOR_NOTIFICATION_MIN(UIManager.getColor("OmegaT.notificationMin")),
        COLOR_NOTIFICATION_MAX(UIManager.getColor("OmegaT.notificationMax")),
        COLOR_ALIGNER_ACCEPTED(UIManager.getColor("OmegaT.alignerAccepted")),
        COLOR_ALIGNER_NEEDSREVIEW(UIManager.getColor("OmegaT.alignerNeedsReview")),
        COLOR_ALIGNER_HIGHLIGHT(UIManager.getColor("OmegaT.alignerHighlight")),
        COLOR_ALIGNER_TABLE_ROW_HIGHLIGHT(UIManager.getColor("OmegaT.alignerTableRowHighlight"));

        private static final String DEFAULT_COLOR = "__DEFAULT__";
        private Color color;
        private Color defaultColor;

        private EditorColor(Color defaultColor) {
            this.color = defaultColor;
            this.defaultColor = defaultColor;
            String prefColor = Preferences.getPreferenceDefault(this.name(), null);
            if (prefColor != null && !DEFAULT_COLOR.equals(prefColor)) {
                try {
                    this.color = Color.decode(prefColor);
                }
                catch (NumberFormatException e) {
                    Log.logDebug(LOGGER, "Cannot set custom color for {0}, default to {1}.", this.name(), prefColor);
                }
            }
        }

        private EditorColor(String defaultColor) {
            this(Color.decode(defaultColor));
        }

        public String toHex() {
            return String.format("#%02x%02x%02x", this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        }

        public Color getColor() {
            return this.color;
        }

        public Color getDefault() {
            return this.defaultColor;
        }

        public String getDisplayName() {
            try {
                return OStrings.getString(this.name());
            }
            catch (MissingResourceException ex) {
                Log.log(ex);
                return this.name();
            }
        }

        public void setColor(Color newColor) {
            if (newColor == null || newColor.equals(this.defaultColor)) {
                this.color = this.defaultColor;
                Preferences.setPreference(this.name(), DEFAULT_COLOR);
            } else {
                this.color = newColor;
                Preferences.setPreference(this.name(), this.toHex());
            }
        }
    }
}

