/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.languagetool.JLanguageTool;

final class CaseRuleExceptions {
    private static final Set<String> exceptions = CaseRuleExceptions.loadExceptions("/de/case_rule_exceptions.txt");

    private CaseRuleExceptions() {
    }

    public static Set<String> getExceptions() {
        return exceptions;
    }

    private static Set<String> loadExceptions(String path) {
        HashSet<String> result = new HashSet<String>();
        try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(path);
             InputStreamReader reader = new InputStreamReader(stream, "utf-8");
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                if (line.matches("^\\s.*") || line.matches(".*\\s$")) {
                    throw new RuntimeException("Invalid line in " + path + ", starts or ends with whitespace: '" + line + "'");
                }
                result.add(line);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load case rule exceptions from " + path, e);
        }
        return Collections.unmodifiableSet(result);
    }
}

