function Snowball() {
BaseStemmer = function() {
this.setCurrent = function(value) {
this.current = value;
this.cursor = 0;
this.limit = this.current.length;
this.limit_backward = 0;
this.bra = this.cursor;
this.ket = this.limit;
};
this.getCurrent = function() {
return this.current;
};
this.copy_from = function(other) {
this.current = other.current;
this.cursor = other.cursor;
this.limit = other.limit;
this.limit_backward = other.limit_backward;
this.bra = other.bra;
this.ket = other.ket;
};
this.in_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor++;
return true;
};
this.in_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor--;
return true;
};
this.out_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) {
this.cursor++;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0X1 << (ch & 0x7))) == 0) {
this.cursor++;
return true;
}
return false;
};
this.out_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) {
this.cursor--;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) {
this.cursor--;
return true;
}
return false;
};
this.eq_s = function(s)
{
if (this.limit - this.cursor < s.length) return false;
if (this.current.slice(this.cursor, this.cursor + s.length) != s)
{
return false;
}
this.cursor += s.length;
return true;
};
this.eq_s_b = function(s)
{
if (this.cursor - this.limit_backward < s.length) return false;
if (this.current.slice(this.cursor - s.length, this.cursor) != s)
{
return false;
}
this.cursor -= s.length;
return true;
};
 this.find_among = function(v)
{
var i = 0;
var j = v.length;
var c = this.cursor;
var l = this.limit;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >>> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j; 
var w = v[k];
var i2;
for (i2 = common; i2 < w[0].length; i2++)
{
if (c + common == l)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c + common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break; 
if (j == i) break; 
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c + w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c + w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.find_among_b = function(v)
{
var i = 0;
var j = v.length
var c = this.cursor;
var lb = this.limit_backward;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j;
var w = v[k];
var i2;
for (i2 = w[0].length - 1 - common; i2 >= 0; i2--)
{
if (c - common == lb)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c - 1 - common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break;
if (j == i) break;
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c - w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c - w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.replace_s = function(c_bra, c_ket, s)
{
var adjustment = s.length - (c_ket - c_bra);
this.current = this.current.slice(0, c_bra) + s + this.current.slice(c_ket);
this.limit += adjustment;
if (this.cursor >= c_ket) this.cursor += adjustment;
else if (this.cursor > c_bra) this.cursor = c_bra;
return adjustment;
};
this.slice_check = function()
{
if (this.bra < 0 ||
this.bra > this.ket ||
this.ket > this.limit ||
this.limit > this.current.length)
{
return false;
}
return true;
};
this.slice_from = function(s)
{
var result = false;
if (this.slice_check())
{
this.replace_s(this.bra, this.ket, s);
result = true;
}
return result;
};
this.slice_del = function()
{
return this.slice_from("");
};
this.insert = function(c_bra, c_ket, s)
{
var adjustment = this.replace_s(c_bra, c_ket, s);
if (c_bra <= this.bra) this.bra += adjustment;
if (c_bra <= this.ket) this.ket += adjustment;
};
this.slice_to = function()
{
var result = '';
if (this.slice_check())
{
result = this.current.slice(this.bra, this.ket);
}
return result;
};
this.assign_to = function()
{
return this.current.slice(0, this.limit);
};
};
EnglishStemmer = function() {
var base = new BaseStemmer();
 var a_0 = [
["arsen", -1, -1],
["commun", -1, -1],
["gener", -1, -1]
];
 var a_1 = [
["'", -1, 1],
["'s'", 0, 1],
["'s", -1, 1]
];
 var a_2 = [
["ied", -1, 2],
["s", -1, 3],
["ies", 1, 2],
["sses", 1, 1],
["ss", 1, -1],
["us", 1, -1]
];
 var a_3 = [
["", -1, 3],
["bb", 0, 2],
["dd", 0, 2],
["ff", 0, 2],
["gg", 0, 2],
["bl", 0, 1],
["mm", 0, 2],
["nn", 0, 2],
["pp", 0, 2],
["rr", 0, 2],
["at", 0, 1],
["tt", 0, 2],
["iz", 0, 1]
];
 var a_4 = [
["ed", -1, 2],
["eed", 0, 1],
["ing", -1, 2],
["edly", -1, 2],
["eedly", 3, 1],
["ingly", -1, 2]
];
 var a_5 = [
["anci", -1, 3],
["enci", -1, 2],
["ogi", -1, 13],
["li", -1, 15],
["bli", 3, 12],
["abli", 4, 4],
["alli", 3, 8],
["fulli", 3, 9],
["lessli", 3, 14],
["ousli", 3, 10],
["entli", 3, 5],
["aliti", -1, 8],
["biliti", -1, 12],
["iviti", -1, 11],
["tional", -1, 1],
["ational", 14, 7],
["alism", -1, 8],
["ation", -1, 7],
["ization", 17, 6],
["izer", -1, 6],
["ator", -1, 7],
["iveness", -1, 11],
["fulness", -1, 9],
["ousness", -1, 10]
];
 var a_6 = [
["icate", -1, 4],
["ative", -1, 6],
["alize", -1, 3],
["iciti", -1, 4],
["ical", -1, 4],
["tional", -1, 1],
["ational", 5, 2],
["ful", -1, 5],
["ness", -1, 5]
];
 var a_7 = [
["ic", -1, 1],
["ance", -1, 1],
["ence", -1, 1],
["able", -1, 1],
["ible", -1, 1],
["ate", -1, 1],
["ive", -1, 1],
["ize", -1, 1],
["iti", -1, 1],
["al", -1, 1],
["ism", -1, 1],
["ion", -1, 2],
["er", -1, 1],
["ous", -1, 1],
["ant", -1, 1],
["ent", -1, 1],
["ment", 15, 1],
["ement", 16, 1]
];
 var a_8 = [
["e", -1, 1],
["l", -1, 2]
];
 var a_9 = [
["succeed", -1, -1],
["proceed", -1, -1],
["exceed", -1, -1],
["canning", -1, -1],
["inning", -1, -1],
["earring", -1, -1],
["herring", -1, -1],
["outing", -1, -1]
];
 var a_10 = [
["andes", -1, -1],
["atlas", -1, -1],
["bias", -1, -1],
["cosmos", -1, -1],
["dying", -1, 3],
["early", -1, 9],
["gently", -1, 7],
["howe", -1, -1],
["idly", -1, 6],
["lying", -1, 4],
["news", -1, -1],
["only", -1, 10],
["singly", -1, 11],
["skies", -1, 2],
["skis", -1, 1],
["sky", -1, -1],
["tying", -1, 5],
["ugly", -1, 8]
];
 var  g_v = [17, 65, 16, 1];
 var  g_v_WXY = [1, 17, 65, 208, 1];
 var  g_valid_LI = [55, 141, 2];
var  B_Y_found = false;
var  I_p2 = 0;
var  I_p1 = 0;
function r_prelude() {
B_Y_found = false;
var  v_1 = base.cursor;
lab0: {
base.bra = base.cursor;
if (!(base.eq_s("'")))
{
break lab0;
}
base.ket = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.cursor = v_1;
var  v_2 = base.cursor;
lab1: {
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab1;
}
base.ket = base.cursor;
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
}
base.cursor = v_2;
var  v_3 = base.cursor;
lab2: {
while(true)
{
var  v_4 = base.cursor;
lab3: {
golab4: while(true)
{
var  v_5 = base.cursor;
lab5: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab5;
}
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab5;
}
base.ket = base.cursor;
base.cursor = v_5;
break golab4;
}
base.cursor = v_5;
if (base.cursor >= base.limit)
{
break lab3;
}
base.cursor++;
}
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
continue;
}
base.cursor = v_4;
break;
}
}
base.cursor = v_3;
return true;
};
function r_mark_regions() {
I_p1 = base.limit;
I_p2 = base.limit;
var  v_1 = base.cursor;
lab0: {
lab1: {
var  v_2 = base.cursor;
lab2: {
if (base.find_among(a_0) == 0)
{
break lab2;
}
break lab1;
}
base.cursor = v_2;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab5: while(true)
{
lab6: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab6;
}
break golab5;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
}
I_p1 = base.cursor;
golab7: while(true)
{
lab8: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab8;
}
break golab7;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab9: while(true)
{
lab10: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab10;
}
break golab9;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
I_p2 = base.cursor;
}
base.cursor = v_1;
return true;
};
function r_shortv() {
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.out_grouping_b(g_v_WXY, 89, 121)))
{
break lab1;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
if (!(base.out_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
return false;
}
if (base.cursor > base.limit_backward)
{
return false;
}
}
return true;
};
function r_R1() {
if (!(I_p1 <= base.cursor))
{
return false;
}
return true;
};
function r_R2() {
if (!(I_p2 <= base.cursor))
{
return false;
}
return true;
};
function r_Step_1a() {
var  among_var;
var  v_1 = base.limit - base.cursor;
lab0: {
base.ket = base.cursor;
if (base.find_among_b(a_1) == 0)
{
base.cursor = base.limit - v_1;
break lab0;
}
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.ket = base.cursor;
among_var = base.find_among_b(a_2);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!base.slice_from("ss"))
{
return false;
}
break;
case 2:
lab1: {
var  v_2 = base.limit - base.cursor;
lab2: {
{
var  c1 = base.cursor - 2;
if (base.limit_backward > c1 || c1 > base.limit)
{
break lab2;
}
base.cursor = c1;
}
if (!base.slice_from("i"))
{
return false;
}
break lab1;
}
base.cursor = base.limit - v_2;
if (!base.slice_from("ie"))
{
return false;
}
}
break;
case 3:
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_1b() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_4);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!r_R1())
{
return false;
}
if (!base.slice_from("ee"))
{
return false;
}
break;
case 2:
var  v_1 = base.limit - base.cursor;
golab0: while(true)
{
lab1: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break golab0;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
base.cursor = base.limit - v_1;
if (!base.slice_del())
{
return false;
}
var  v_3 = base.limit - base.cursor;
among_var = base.find_among_b(a_3);
if (among_var == 0)
{
return false;
}
base.cursor = base.limit - v_3;
switch (among_var) {
case 1:
{
var  c1 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c1;
}
break;
case 2:
base.ket = base.cursor;
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
break;
case 3:
if (base.cursor != I_p1)
{
return false;
}
var  v_4 = base.limit - base.cursor;
if (!r_shortv())
{
return false;
}
base.cursor = base.limit - v_4;
{
var  c2 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c2;
}
break;
}
break;
}
return true;
};
function r_Step_1c() {
base.ket = base.cursor;
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("y")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("Y")))
{
return false;
}
}
base.bra = base.cursor;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
lab2: {
if (base.cursor > base.limit_backward)
{
break lab2;
}
return false;
}
if (!base.slice_from("i"))
{
return false;
}
return true;
};
function r_Step_2() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_5);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ence"))
{
return false;
}
break;
case 3:
if (!base.slice_from("ance"))
{
return false;
}
break;
case 4:
if (!base.slice_from("able"))
{
return false;
}
break;
case 5:
if (!base.slice_from("ent"))
{
return false;
}
break;
case 6:
if (!base.slice_from("ize"))
{
return false;
}
break;
case 7:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 8:
if (!base.slice_from("al"))
{
return false;
}
break;
case 9:
if (!base.slice_from("ful"))
{
return false;
}
break;
case 10:
if (!base.slice_from("ous"))
{
return false;
}
break;
case 11:
if (!base.slice_from("ive"))
{
return false;
}
break;
case 12:
if (!base.slice_from("ble"))
{
return false;
}
break;
case 13:
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_from("og"))
{
return false;
}
break;
case 14:
if (!base.slice_from("less"))
{
return false;
}
break;
case 15:
if (!(base.in_grouping_b(g_valid_LI, 99, 116)))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_3() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_6);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 3:
if (!base.slice_from("al"))
{
return false;
}
break;
case 4:
if (!base.slice_from("ic"))
{
return false;
}
break;
case 5:
if (!base.slice_del())
{
return false;
}
break;
case 6:
if (!r_R2())
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_4() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_7);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R2())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_del())
{
return false;
}
break;
case 2:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("s")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("t")))
{
return false;
}
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_5() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_8);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!r_R2())
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!r_R1())
{
return false;
}
{
var  v_2 = base.limit - base.cursor;
lab2: {
if (!r_shortv())
{
break lab2;
}
return false;
}
base.cursor = base.limit - v_2;
}
}
if (!base.slice_del())
{
return false;
}
break;
case 2:
if (!r_R2())
{
return false;
}
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_exception2() {
base.ket = base.cursor;
if (base.find_among_b(a_9) == 0)
{
return false;
}
base.bra = base.cursor;
if (base.cursor > base.limit_backward)
{
return false;
}
return true;
};
function r_exception1() {
var  among_var;
base.bra = base.cursor;
among_var = base.find_among(a_10);
if (among_var == 0)
{
return false;
}
base.ket = base.cursor;
if (base.cursor < base.limit)
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("ski"))
{
return false;
}
break;
case 2:
if (!base.slice_from("sky"))
{
return false;
}
break;
case 3:
if (!base.slice_from("die"))
{
return false;
}
break;
case 4:
if (!base.slice_from("lie"))
{
return false;
}
break;
case 5:
if (!base.slice_from("tie"))
{
return false;
}
break;
case 6:
if (!base.slice_from("idl"))
{
return false;
}
break;
case 7:
if (!base.slice_from("gentl"))
{
return false;
}
break;
case 8:
if (!base.slice_from("ugli"))
{
return false;
}
break;
case 9:
if (!base.slice_from("earli"))
{
return false;
}
break;
case 10:
if (!base.slice_from("onli"))
{
return false;
}
break;
case 11:
if (!base.slice_from("singl"))
{
return false;
}
break;
}
return true;
};
function r_postlude() {
if (!B_Y_found)
{
return false;
}
while(true)
{
var  v_1 = base.cursor;
lab0: {
golab1: while(true)
{
var  v_2 = base.cursor;
lab2: {
base.bra = base.cursor;
if (!(base.eq_s("Y")))
{
break lab2;
}
base.ket = base.cursor;
base.cursor = v_2;
break golab1;
}
base.cursor = v_2;
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
if (!base.slice_from("y"))
{
return false;
}
continue;
}
base.cursor = v_1;
break;
}
return true;
};
this.stem =  function() {
lab0: {
var  v_1 = base.cursor;
lab1: {
if (!r_exception1())
{
break lab1;
}
break lab0;
}
base.cursor = v_1;
lab2: {
{
var  v_2 = base.cursor;
lab3: {
{
var  c1 = base.cursor + 3;
if (0 > c1 || c1 > base.limit)
{
break lab3;
}
base.cursor = c1;
}
break lab2;
}
base.cursor = v_2;
}
break lab0;
}
base.cursor = v_1;
r_prelude();
r_mark_regions();
base.limit_backward = base.cursor; base.cursor = base.limit;
var  v_5 = base.limit - base.cursor;
r_Step_1a();
base.cursor = base.limit - v_5;
lab4: {
var  v_6 = base.limit - base.cursor;
lab5: {
if (!r_exception2())
{
break lab5;
}
break lab4;
}
base.cursor = base.limit - v_6;
var  v_7 = base.limit - base.cursor;
r_Step_1b();
base.cursor = base.limit - v_7;
var  v_8 = base.limit - base.cursor;
r_Step_1c();
base.cursor = base.limit - v_8;
var  v_9 = base.limit - base.cursor;
r_Step_2();
base.cursor = base.limit - v_9;
var  v_10 = base.limit - base.cursor;
r_Step_3();
base.cursor = base.limit - v_10;
var  v_11 = base.limit - base.cursor;
r_Step_4();
base.cursor = base.limit - v_11;
var  v_12 = base.limit - base.cursor;
r_Step_5();
base.cursor = base.limit - v_12;
}
base.cursor = base.limit_backward;
var  v_13 = base.cursor;
r_postlude();
base.cursor = v_13;
}
return true;
};
this['stemWord'] = function(word) {
base.setCurrent(word);
this.stem();
return base.getCurrent();
};
};
return new EnglishStemmer();
}
wh.search_stemmer = Snowball();
wh.search_baseNameList = [
 "appendix.LanguageToolPlugin.inOmegaT.html",
 "appendix.ScriptingPlugin.inOmegaT.html",
 "appendix.TeamProjects.html",
 "appendix.TokenizerPlugin.inOmegaT.html",
 "appendix.acknowledgements.html",
 "appendix.keyboard.html",
 "appendix.languages.html",
 "appendix.legal.notices.html",
 "appendix.shortcut.custom.html",
 "appendix.website.html",
 "chapter.about.OmegaT.html",
 "chapter.dictionaries.html",
 "chapter.file.filters.html",
 "chapter.files.and.directories.html",
 "chapter.files.to.translate.html",
 "chapter.glossaries.html",
 "chapter.installing.and.running.html",
 "chapter.instant.start.guide.html",
 "chapter.machine.translate.html",
 "chapter.menu.html",
 "chapter.misc.html",
 "chapter.plain.text.html",
 "chapter.project.properties.html",
 "chapter.regexp.html",
 "chapter.searches.html",
 "chapter.segmentation.html",
 "chapter.spellchecker.html",
 "chapter.translation.editing.html",
 "chapter.translation.memories.html",
 "chapter.user.interface.html",
 "index.html",
 "ix01.html"
];
wh.search_titleList = [
 "Παράρτημα E. Πρόσθετο Εργαλείο γλώσσας",
 "Παράρτημα F. Πρόσθετο για Δημιουργία σεναρίων",
 "Παράρτημα C. Ομαδικά έργα του OmegaT",
 "Παράρτημα D. Πρόσθετο Σύστημα δημιουργίας λεκτικών μονάδων (Tokenizer plugin)",
 "Παράρτημα J. Αναγνώριση συνεισφορών",
 "Παράρτημα B. Συντμεύσεις πληκτρολογίου στο πρόγραμμα επεξεργασίας (editor)",
 "Παράρτημα A. Γλώσσες - Κατάλογος με κωδικούς κατά ISO 639",
 "Παράρτημα I. Νομικές Προειδοποιήσεις",
 "Παράρτημα H. Παραμετροποίηση συντομεύσεων",
 "Παράρτημα G. Το OmegaT στο διαδίτκυο",
 "Σχετικά με το OmegaT - Εισαγωγή",
 "Λεξικά",
 "Φίλτρα αρχείων",
 "OmegaT Αρχεία και Κατάλογοι",
 "Αρχεία προς μετάφραση",
 "Γλωσσάρια",
 "Εγκατάσταση και Λειτουργία του OmegaT",
 "Μάθετε να χρησιμοποιείτε το OmegaT σε 5 λεπτά!",
 "Μηχανική Μετάφραση",
 "Μενού και Συντομεύσεις πληκτρολογίου",
 "Διάφορα θέματα",
 "Εγασίες με απλό κείμενο",
 "Ιδιότητες έργου",
 "Κανονικές εκφράσεις",
 "Αναζητήσεις",
 "Κατάτμηση αρχείων προέλευσης",
 "Ορθογραφικός διορθωτής",
 "Συμπεριφορά επεξεργασίας",
 "Μεταφραστικές μνήμες",
 "Η διεπαφή χρήστη",
 "OmegaT - Εγχειρίδιο χρήστη",
 "Ευρετήριο"
];
wh.search_wordMap= {
"απαιτούν": [29],
"καζακικά": [6],
"οποίος": [10],
"don\'t": [13],
"αναζήτησή": [24],
"συμβουλή": [18,22,[14,29]],
"άλη": [26],
"βασκικά": [6],
"διατήρηση": [[4,10,12]],
"hall": [7],
"μέρος": [29,[17,25],[9,19,24,26,27,28]],
"σημεία": [[1,10]],
"λειτουργήσει": [16,26],
"μετακίνηση": [5,19,[25,30,31]],
"δουλεύετε": [8],
"would": [24],
"φίλτρου": [12,31,30,[25,28]],
"σημείο": [25,[5,9]],
"ανατεθεί": [12],
"επιτύχουν": [18],
"tel": [6],
"οποίοι": [15],
"γαλικιανά": [6],
"info.plist": [16,3],
"anti-alias": [16],
"ελέγχονται": [19],
"διόρθωσης": [26],
"antonio": [7],
"μολδαβικά": [6],
"tex": [14],
"αυτομάτως": [16,[15,21,29],[0,10,12,17,20,22,24]],
"συμπεριλαμβανομένων": [29],
"letzeburgesch": [6],
"έχοντας": [18],
"διαστήματος": [23,25],
"click": [13],
"fuzzi": [27,[8,28],19,31,[14,17,29]],
"επισήμανσης": [19],
"διατηρεί": [2],
"left": [[3,5]],
"kua": [6],
"κρατούν": [14],
"γεωργιανά": [6],
"σάμι": [6],
"φανταστείτε": [10],
"δύο": [16,[2,25,28,29],[10,20,26],27,[1,14,15,22]],
"kur": [6],
"γράφετε": [14],
"suffici": [13],
"αιτίες": [16,15],
"dgoogle.api.key": [16],
"ces": [6],
"result": [[13,24]],
"same": [13],
"άνω": [[25,29]],
"tgl": [6],
"tgk": [6],
"περιμένατε": [[9,19,28]],
"αγλλικά": [28],
"after": [25,13],
"quiet": [[16,20]],
"κλάση": [[1,23]],
"χρήστη": [16,29,19,31,10,[18,27,30],[9,12,20,28],[2,7,8,17,22]],
"ακολουθείστε": [[16,28]],
"πρόβλημα": [[15,21],19],
"περιλαμβάνεται": [28],
"δεσμεύθηκε": [16],
"ενιαίο": [2],
"τέλους": [12],
"es_es.d": [26],
"δούμε": [25],
"προκύψει": [16],
"νοτ": [6],
"tha": [6],
"χώρας": [[12,28]],
"the": [13,3,28,[16,24],14,20],
"λιγώτερες": [[14,20]],
"download.htm": [16],
"διαβαστούν": [16],
"ευρώπης": [31],
"projectimportmenuitem": [8],
"ενιαία": [23],
"χειρός": [22,28],
"imag": [16,13],
"ειναι": [16],
"πρόσβασαη": [20],
"παραδοσιακές": [16],
"ασαφών": [31],
"αμετάφραστων": [19,[8,22]],
"υποσέλιδα": [12],
"διάφορες": [[19,28,29],[1,10,14,17,30]],
"συνεπώς": [[9,15,16,17,19,20,22,24,27]],
"μπαίνει": [28],
"αντιγράψτετα": [28],
"διανέμουν": [28],
"υποστηρίζει": [28,[1,14],[2,10]],
"σχημάτων": [[1,30]],
"συνεργασία": [2],
"currsegment.getsrctext": [1],
"σανσκριτικά": [6],
"tir": [6],
"cha": [6],
"μετακινούμενοι": [27],
"παραμετροποιήσετε": [12,[1,19,31]],
"γλίτωσε": [4],
"che": [6],
"εισαγωγής": [14,[2,19,28]],
"χειρίζεται": [[14,24],[15,16,22,25]],
"αγνοεί": [26],
"check": [[3,12,24,27]],
"transtip": [19,8,29],
"ενιαίου": [2],
"chv": [6],
"chu": [6],
"ταιριάξει": [16],
"καταλόγων": [[22,28],[2,29]],
"άρα": [[16,25,28,29]],
"xxxx9xxxx9xxxxxxxx9xxx99xxxxx9xx9xxxxxxxxxx": [16],
"απαιτεί": [16,[18,19,26,29]],
"λέει": [16,[20,29]],
"ποικιλία": [[10,18]],
"fr-fr": [26],
"ιδιοτήτων": [31,22,[12,20,30]],
"εμπλέκεται": [[25,28]],
"ensur": [13],
"από-αριστερά-προς-τα-δεξιά": [31,14,30],
"madlon-kay": [7],
"φιλτραρίσματος": [10],
"σκληρού": [28],
"φύλλο": [29],
"αποτελεί": [[1,12,30]],
"τελειώνει": [[16,20,23,29]],
"εκατομ": [18],
"συμπτυχθούν": [12],
"xmxzzm": [16],
"root": [28,16,[19,29]],
"webster": [11,31,[29,30]],
"συνδεδεμένα": [16],
"αποδεκτές": [8],
"έγκυρα": [25],
"οποίο": [29,[10,16,28],[12,22,26]],
"προεπιλεγμένους": [25],
"σώμα": [26],
"cjk": [3],
"όμοια": [29,27,10],
"κροατικά": [6],
"έγκυρη": [20],
"blocks": [30],
"ναβάχο": [6],
"ίδιοι": [[15,21,26,27]],
"οποία": [28,[14,18,20],[0,16,19,21,22,24]],
"παραθέτοντας": [23],
"έγκυρο": [[16,25]],
"επίσης": [31,29,28,[12,16,19],[10,14,26],[0,2,3,8,9,15,20,24,27,30]],
"λειτουργικού": [12,[1,16]],
"ίδιος": [[12,19,21,23]],
"βοηθήματα": [16],
"επίπεδο": [25,31,22,2],
"όμοιο": [[2,28]],
"translation": [30],
"μόλις": [[16,17,29],[0,2,8,15,18,20]],
"ίδιου": [2],
"empti": [13,28,16],
"κατάλληλες": [[10,14,21]],
"εδώ": [[2,19],[12,24],[3,10,16,17,22,29]],
"δίκτυο": [2,16],
"ξαναφορτώθηκε": [15],
"τάξεως": [1],
"lepo": [3],
"spolski": [9],
"αναφέρθηκαν": [[16,28]],
"δυτικοευρωπαίκή": [31],
"απαντώνται": [[10,24]],
"επισυνάψετε": [9],
"αργό": [20],
"μπορούν": [28,2,10,[14,16,25,29],[15,23],[1,8,12,19,20,22,27]],
"lepa": [3],
"μεταγενέστερων": [16],
"περιγραφεί": [25],
"block": [23,[20,25]],
"tms": [28,[24,29]],
"ισλανδικά": [6],
"tmx": [28,31,16,29,[13,19,20],[10,24]],
"flow": [13],
"order": [13],
"μέγιστα": [[14,29]],
"χρώματος": [19],
"διπλές": [23],
"σαφείς": [21],
"απαιτούμενους": [15],
"απαρίθμση": [10],
"nl-en": [28],
"δικό": [[2,16,18,20,28]],
"τουρκμενικά": [6],
"integ": [[12,27]],
"intel": [16,[30,31]],
"fr-ca": [25],
"mainmenushortcuts.properti": [8],
"επιτρέποντας": [10],
"αργή": [19],
"αραβικά": [6],
"επιτρέπονται": [[12,27]],
"πρόσβασης": [2],
"cmd": [[5,19],[14,17]],
"επιλέξει": [[1,12,19,27,29]],
"coach": [23],
"συνολικός": [29],
"συγχέεται": [1],
"ίδιιο": [23],
"ινούπιακ": [6],
"καταλόγου": [[2,17],16,[9,19,28,31]],
"πληκτρολογίου": [19,[10,29,30],[5,31],[2,6,8,22]],
"χρήσιμο": [28,[3,7,10,12,16,19,22,27,29]],
"project_name-level1": [[13,28]],
"gotohistorybackmenuitem": [8],
"project_name-level2": [[13,28]],
"save": [13],
"αδεια": [28],
"χρήσιμη": [[7,10,17,19,22,25,28]],
"widgets": [30],
"project-save.tmx": [28],
"μοτίβων": [[12,25]],
"ton": [6],
"top": [13,31],
"γραφήματα": [12],
"have": [13,24],
"powerpc": [16],
"καταστάσεις": [14],
"τρέξετε": [[1,20]],
"συνέπειας": [[10,19]],
"ίσου": [17],
"διαχείρισης": [[14,15,19,30,31]],
"question": [28],
"αυτοματοποίηση": [12],
"platform-independ": [13],
"αρίθμηση": [28],
"ακόλουθους": [2],
"προστέθηκαν": [2],
"στιγμιότυποα": [9],
"littl": [13],
"δικού": [2],
"συνθήκες": [28],
"ταταρικά": [6],
"προϋπάρχουσα": [25],
"οομαδικό": [2],
"χρήσιμα": [28],
"οσσετικά": [6],
"πληκτρολογώντας": [16],
"order2": [28],
"order1": [28],
"διεθνές": [15],
"instal": [13,3],
"δυνατόν": [[4,14,18]],
"ανοικτό": [[1,5,12,19,20,25,29]],
"ίδιες": [[16,28]],
"αντιστοίχως": [28],
"κοινό": [2],
"cos": [6],
"cor": [6],
"μοιράζονται": [28],
"ενότητα": [[16,21],[18,19,22,24]],
"σήματα": [27,29],
"upon": [13],
"κάποιου": [15],
"εις": [[26,29]],
"κάποιος": [[4,12,21]],
"org.omegat.plugins.tokenizer.lucenecjktoken": [3],
"antialias": [[16,31]],
"ονποματα": [28],
"function": [[1,13]],
"west": [6],
"κάποιον": [11],
"lao": [6],
"εξαγόμενα": [19],
"lat": [6],
"αποδεχθείτε": [16],
"lav": [6],
"άρθρο": [9],
"επιδόσεις": [18],
"προχωρήστε": [[11,22]],
"subscript": [13],
"ανοικτά": [24],
"cpu": [29],
"revert": [13],
"τσουάνα": [6],
"γίνονται": [14],
"υποστηρίζονται": [23],
"αποτελεσμάτων": [24,[23,30]],
"translat": [13,18,31,16,[10,12],[1,26,28]],
"τελικές": [22],
"αλλοιωμένα": [14],
"προβλημάτων": [[18,31],[2,14,16,28,30]],
"μορφοποίηση": [14,[17,19,22],[25,28]],
"πληθυντικού": [[3,15]],
"τρέχουμε": [1],
"φίλτρων": [[12,22],[2,21,29,30,31]],
"εντοπίσετε": [[4,27]],
"δική": [16,[4,10,25]],
"ψήφιο": [20],
"ορίγια": [6],
"εναλλακτικά": [[28,31],[2,24]],
"εναλλακτική": [[19,28,29],[2,8,14,16,21,22,27,31]],
"δικά": [[18,28]],
"respons": [18],
"tsn": [6],
"εκτελείτε": [16],
"εμτάφρασης": [18],
"interesar": [18],
"διαδικασίες": [28],
"tso": [6],
"οθόνης": [9],
"ζεύγο": [20],
"δομής": [25,31],
"ακολουθείται": [[23,25]],
"ξέρω": [16],
"cre": [6],
"σημαντικές": [[1,10,17,29]],
"chmod": [13],
"στείλτε": [20],
"ζεύγη": [[12,18],[28,31],[2,20]],
"τροποποίησης": [8,[12,19]],
"gnome": [16],
"εκτελέσιμο": [16],
"κοινή": [[28,31]],
"συνέπειες": [2],
"κατάλληλη": [[10,14,26]],
"κοινά": [10],
"τρίστηλο": [29],
"κατάλληλο": [16,[2,12,26,28]],
"ανακύπτουν": [14],
"κινεζικά": [[6,28]],
"αναθεωρήσει": [28],
"κινεζική": [28],
"αφρικάνς": [6],
"κουμπί": [[16,22],[24,29],[1,12,25,26]],
"ειδικούς": [[14,22]],
"ttx": [28,31],
"κατάλληλα": [[12,26]],
"appdata": [13],
"πλοηγηθείτε": [16,28],
"θέλουμε": [27],
"ξανακάνετε": [29],
"csv": [14,15],
"ενα": [[23,24]],
"επιλύονται": [2,28],
"συμβουλευτείτε": [10],
"tuk": [6],
"υψηλής-ταχύτητας": [18],
"χωρών": [28],
"σλαβονικά": [6],
"tur": [6],
"υποδείξετε": [10],
"κώμμα": [23],
"σλαβονική": [6],
"απρόθυμοι": [[23,30]],
"προσφέρεται": [29,[2,9,10,16,18,25]],
"tuv": [28],
"γρήγορης": [16],
"lep": [3],
"sotho": [6],
"lepš": [3],
"state": [13],
"press": [8],
"dock": [16],
"γνωστή": [25],
"μοτίβου": [12,25],
"ddhttp.proxyhost": [16],
"ενεργοποιείστε": [18],
"αριθμό": [29,19,[18,28],[1,14,24]],
"γνωστοποιηθούν": [18],
"ενώ": [29,[8,10,28],[5,11,12,14,15,18,19,24]],
"υποδεικνύεται": [15],
"επισημάνθηκαν": [28],
"dmicrosoft.api.client_secret": [16],
"δημιουργήστε": [[2,20,26]],
"έλειπαν": [4],
"γράψει": [[16,19]],
"ρωμανικά": [6],
"πατήσετε": [24,5],
"suppli": [13],
"χρώματα": [14],
"χρησιμοποιηθεί": [16,28,[10,15,22],[2,8,17,19,20,26,27]],
"κατάσταση": [[19,29],[4,20,21,22]],
"απότέλεσμα": [28],
"σημασία": [[16,20]],
"filenameon": [29],
"αφήνετε": [22],
"ctrl": [19,8,29,5,31,17,14,28,[13,15,18,24,27],[1,11,22]],
"mykhalchuk": [7],
"αναβαθμισθεί": [28],
"document": [13,12,[4,16,28]],
"twi": [6],
"εκείνο": [[10,12]],
"unix-οειδή": [19],
"two": [13],
"ταυτόσημες": [29],
"netrexx": [1],
"διορθωθούν": [[22,28]],
"πάει": [29],
"χρέωση": [16],
"αδειάζει": [19],
"υποφάκελλο": [28],
"graphic": [13],
"creation": [13],
"ενημερώσεις": [16],
"resourc": [[14,16]],
"κλειστό": [19],
"ανοίξετε": [29,22,[2,8,10]],
"briac": [7],
"φορτώθηκαν": [28],
"ολόκληρων": [[18,25,28]],
"επί": [29,[5,18,20]],
"δουλεύει": [17],
"xx_yy": [[12,28]],
"ακολουθεί": [28,[8,10,16,20]],
"εκτελούνται": [16],
"docx": [14,[12,19,22]],
"εκείνη": [[12,29],[14,15,16,24]],
"txt": [21,[14,15],12],
"ιδιότητες": [12,31,19,[22,28],[10,15,16,25,26,29],[8,11,20,30]],
"επιθυμείτε": [12,28,[22,26,29]],
"μάλλον": [[10,15,24,29]],
"τόγκα": [6],
"εκείνα": [16],
"τεκμηρίωση": [7,31,[8,10,12,23,29,30]],
"thing": [13],
"λατινικά": [6],
"lib": [13],
"μετακινηθείσες": [19],
"αρχική": [14,29,[12,16,22]],
"ρίζα": [3],
"αρχικά": [[16,18,28,29]],
"επιβραδύνει": [28],
"lin": [6],
"lim": [6],
"lit": [6],
"viewdisplaymodificationinfoselectedradiobuttonmenuitem": [8],
"μνημες": [10],
"omegat.tmx": [[13,28]],
"entir": [13],
"index.html": [[16,29]],
"προσφέρουν": [[2,29]],
"ρηχή": [18],
"doubl": [13],
"ευκολώτερο": [14],
"κάποιων": [[19,22]],
"μαλαισιανά": [6],
"υποηρεσίες": [16],
"doubt": [13],
"παράγραφοι": [14],
"develop": [13],
"σαρδηνιακά": [6],
"σελιδοδεικτών": [12],
"breton": [6],
"μαλαγάσυ": [6],
"ξεχωριστά": [12],
"κάθετος": [16],
"τζόνγκα": [6],
"τοπικών": [2],
"προτασης": [23],
"αρσενικό": [3],
"cym": [6],
"inlin": [[19,22]],
"διάφορυς": [22],
"ασαφούς": [8,27],
"page": [13],
"μετακινείσθε": [[27,29]],
"βαλούν": [6],
"χωρίζονται": [15],
"ημερομ": [15],
"μνήνα": [20],
"ειδκών": [22],
"παρεμπιτπότνως": [24],
"cards": [30],
"τρέχουσα": [19,[4,18,25,27,29]],
"χρηστών": [9,[20,28]],
"κουτιά": [12],
"κανόνας": [25,[0,31]],
"εργασσθούν": [2],
"ενημερώνονται": [15],
"ελέγχετε": [19],
"μαλδιβιανά": [6],
"οποίες": [[4,25]],
"προτεινόμενη": [29],
"κέτσουα": [6],
"διαβάζονται": [28],
"κεφάλαιιο": [29],
"προτιμάται": [15],
"project.gettranslationinfo": [1],
"υποδείξει": [28],
"δράσει": [11],
"τρία": [[2,11,28],9],
"κλίναμε": [2],
"βίαια": [2],
"συμβαίνει": [9],
"αντιληφθείτε": [26],
"χρειαστείτε": [16],
"πλατφορμών": [16],
"start": [16,31,30],
"μνήμη": [28,29,19,[20,22],[2,10,14,15,16,17,23,25,30,31]],
"καστιλιάνικα": [26],
"αρχικό": [[14,20,28,29],[1,2,12,16,19,24]],
"smolej": [[7,30]],
"αμετάφραστες": [12],
"κόσο": [14],
"γρηγορώτερο": [15],
"προ-μετάφραση": [28],
"equal": [28,16],
"συμμορφώνεται": [[25,28]],
"εγκαθίστανται": [16],
"πλαίσιο": [23],
"φάσμα": [[24,26]],
"συνεχόμενα": [10],
"διάδοσης": [31],
"αντικαθίστανται": [19],
"αναγνωρίζει": [[10,28,29]],
"ρίξετε": [16],
"γνωστό": [[1,16,28]],
"optionsalwaysconfirmquitcheckboxmenuitem": [8],
"tmxs": [[8,19,28]],
"οπουδήποτε": [[16,26,28]],
"παίρνει": [28,20],
"κρατήστε": [[22,28]],
"ελληνικά": [6],
"three": [13],
"κόπο": [2],
"ανοίξει": [[2,19],[17,26,29],[1,24,27]],
"αμέσως": [19],
"enter": [19,5,8,[14,16,27,29]],
"επιλέξτετον": [28],
"applic": [13,31],
"bidi": [14],
"projectteamnewmenuitem": [8],
"εφαρμόσατε": [18],
"αρμενικά": [6],
"κιργιζία": [6],
"προσαρμοσμένο": [29],
"παρουσιάζει": [17],
"γκουτζαράτι": [6],
"ακριβή": [24,19],
"κορυφαία": [29],
"εγκατεστημένη": [16],
"preced": [13],
"άκυρο": [16],
"βελτιώσεων": [9],
"κρύβουν": [11],
"πλοήγησης": [16],
"ενεργήσει": [28],
"memori": [13,16],
"ελλάττωση": [29],
"άκυρα": [28],
"ρητά": [12],
"γαλλικά": [25,16,[0,6]],
"επανεκκινείστε": [8],
"godfrey": [7],
"avestan": [6],
"log": [3,[9,13]],
"μεμονωμένο": [24],
"kannada": [6],
"παρωχημένη": [14],
"αρχή": [5,16,[15,23,28],2,[0,1,3,4,6,7,8,9,10,11,12,13,14,17,18,19,20,21,22,24,25,26,27,29,31]],
"λέξη": [24,19,[5,9,16],[10,15,23,25,26,28,29]],
"προύπάρχον": [1],
"μέρει": [18],
"εναλλαγή": [[5,14,19]],
"κακομεταφρασμένα": [22],
"παράγραφος": [12],
"καταστεί": [14],
"ζητά": [[2,19]],
"καταχωρήστε": [9],
"χειρίζεσθε": [22],
"αντιστοίχισης": [29,31,19,8,30,28,14],
"μορφής": [[15,24]],
"θιβετιανά": [6],
"μεμονωμένες": [[10,12]],
"ορίστε": [25,14],
"ευρύ": [24],
"ονομάτων": [12],
"περίπου": [[20,29]],
"εξωτερικές": [29,19],
"σύνολο": [29],
"εναι": [11],
"prof": [25],
"camproj": [14],
"dmicrosoft.api.client_id": [16],
"προέρχεται": [8],
"σύνολα": [29],
"διαχωρίστε": [28],
"μορφές": [[14,31],12,[3,28,30],[15,16,17,18,29]],
"διάφοροι": [27],
"μεταφρασμένο": [17,29,[10,12,14,20,22,24,30]],
"config-fil": [[16,20]],
"σχεδιάστηκαν": [14],
"γραμμής": [16,23,5,[12,20],[4,25,28]],
"μη-αντιστοιχίσεις": [19],
"checker": [13],
"ρωτήσετε": [28],
"προχωρημένη": [17],
"κόμι": [6],
"dan": [6],
"τροποποιηθεί": [[8,22]],
"επτιρέπει": [19],
"ενημερώσετε": [16],
"ακόλουθη": [23],
"σίντι": [6],
"μπορέσουν": [12],
"ενέργεια": [19,5],
"προχωρήσει": [8],
"ακόλουθα": [[2,20]],
"day": [28],
"πρόσθετες": [[12,15,20,23]],
"προκαλούσαν": [2],
"βρεθεί": [28,[12,15,19,21,24]],
"obtain": [13],
"εντελώς": [28],
"system-user-nam": [12],
"μεταφράζεται": [[20,29]],
"format": [12],
"wolof": [6],
"δικών": [25],
"οποιαδήποτε": [15,16,[7,9,12,17,20,24,25,28,29]],
"ανορθόγραφης": [26],
"μεταφράσθηκε": [28],
"console.println": [1],
"μιας": [23,[18,22],[12,19,20,24,26,28]],
"αποδεχθεί": [18],
"ανοίγετε": [29],
"ιδιαιτερότητες": [3,30],
"έναρξη": [[12,20]],
"βρείτε": [16,[9,20],[23,29]],
"ίσως": [[9,16]],
"αθώα": [29],
"κλάσης": [1],
"συνεισέφεραν": [4],
"ούτως": [14,[10,24,28]],
"περιβάλλον": [16,20,[2,10],[15,18]],
"αλλαγή": [25,8,[20,22,29],[2,5,14,19,23,24,31]],
"μεταφρασμένα": [29,[14,19,27],[10,12,17,18,20,24]],
"αφήστε": [[2,16,25,27]],
"επιβεβαιώσετε": [2],
"λιγώτερρο": [4],
"παρακαλώ": [[6,16]],
"μετακινήσετε": [25],
"χωρισμένο-με-tab": [29],
"pars": [[19,25,28]],
"part": [13,[20,28]],
"υποδείξεις": [[26,27]],
"χεριού": [28],
"ερμηνεύονται": [21],
"leender": [7],
"επιτυγχάνεται": [27],
"βιβλιογραφίες": [23],
"browser": [29,31,13,[16,19]],
"κρύψει": [19],
"απαιτείται": [[16,19,23]],
"στυλιστικές": [25],
"κορυφαίο": [1],
"αναπαραγωγή": [9],
"αποθηκευμένα": [16],
"λάβετε": [16],
"αποθηκευμένη": [20],
"αναβαθμισμένη": [28],
"κλικ": [16,29,12,2,1,26,[9,17,19,25],[5,14,15,22,24,27]],
"τροποποιηθούν": [20],
"ltr": [14,31],
"συνεχή": [28],
"γραμμές": [12,8,25],
"εγγραφείτε": [9,[2,17]],
"σταθερή": [4],
"μη-ψηφίο": [23],
"optionsexttmxmenuitem": [8],
"ακόλουθο": [[16,18]],
"επιλέξτε": [16,2,[24,26],[12,17,19,20,27,29],[1,21,28]],
"ltz": [6],
"υπηρεσία": [18,[2,19],16],
"build": [20],
"φροντίσει": [4],
"lub": [6],
"αναζήτηση": [24,17,[19,23,31],[8,10,16,29]],
"tonga": [6],
"marketplac": [16],
"lug": [6],
"μεταφραστικού": [14],
"entries.s": [1],
"εξειδικευμένες": [23],
"addit": [13],
"απόδοσης": [2],
"del": [[27,29]],
"επιλεγμένης": [20],
"gotonextuntranslatedmenuitem": [8],
"subdirectori": [13],
"targetlocal": [12],
"ένα": [19,[16,28],29,2,15,20,23,[10,17,25],26,[1,18],[8,12],[22,24,27],[3,9,14],[11,21],[0,5,7,13]],
"path": [[16,20]],
"deu": [6],
"record": [13],
"τμήμα-στόχο": [12],
"ματιά": [16],
"χρησιμοποίησαν": [22],
"έγινε": [24],
"βεβαιωθείτε": [16,18,[2,14,15,17,26,28]],
"χάσατε": [[20,28]],
"allsegments.tmx": [16],
"στοιχείου": [16],
"κύρια": [31,[28,29],[27,30]],
"λειτυργία": [26],
"πέραν": [[11,14]],
"helpcontentsmenuitem": [8],
"έξω": [5],
"παίρνετε": [28],
"κύριο": [31,29,30,19,[12,20,25],[1,8,28]],
"μεταφράσεις": [28,10,29,19,[25,27,30],[2,12,22,23,24,31]],
"μεταφρασθεί": [28,[16,29],[20,25,27]],
"τοποθετώντας": [8],
"περιορισμένος": [12],
"προεπιλογής": [[12,14,19,25,29],[2,21,22,24,28]],
"όπως": [18,29,10,[14,16],[2,7,11,19,20,22,24,28],[15,17,23,25,26]],
"εκκίνηση": [16,20,31,[25,30]],
"προσφορά": [31],
"εργάζεσθε": [[10,28]],
"σενάρια": [1,[16,29]],
"υπογραμμισμένος": [15],
"δεκαεξαδική": [23],
"επιλεγμένες": [12,[1,26]],
"τζόλυ": [12],
"περιηγητής": [[29,31]],
"αποθηκευμένες": [20],
"διαδραστικά": [23],
"uig": [6],
"εγγραφή": [[16,18]],
"ανεμπόδιστη": [2],
"term": [15,24],
"φορτωθεί": [[16,17]],
"backslash": [16,23],
"ψηλώτερα": [25],
"dotx": [14],
"γραφεί": [21],
"έχει": [16,19,[12,28],[15,29],[2,14,26],[21,25],[5,8,20,22,24,27]],
"προσθέσετε": [16,2,[8,29],[1,9,12,14,15,17,18,19,20,27,28]],
"δωθεί": [10],
"υπολογιστή": [16,21,[2,12,30]],
"right": [5],
"ιστότοπος": [9],
"duden": [29],
"σενάριό": [16],
"ιστότοποι": [9,[30,31]],
"λιθουανικά": [6],
"εξυπηρετούν": [28],
"σενάριο": [16,1],
"εαυτοί": [23],
"απποτελεί": [1],
"επισήμασνης": [29],
"σλαβομακεδονικά": [6],
"spotlight": [16],
"προσθέτοντας": [12],
"μεγέθη": [14],
"τροποποιήσετε": [[12,16],[19,22,28]],
"ρουμανικά": [[0,6]],
"tswana": [6],
"imper": [1],
"reserv": [1],
"πόσες": [4],
"catlik": [3],
"murray": [[4,7]],
"εξαγωγή": [28,15,[19,31],27,[8,12,14]],
"άλλο": [19,[2,9,18,20,24,29]],
"μορφοποιημένες": [14],
"dir": [16],
"latex": [14],
"σύντομο": [5],
"div": [[6,12]],
"άλλη": [16,[1,7,18,20,25]],
"habit": [13],
"later": [13],
"υποστηριζόμενο": [28],
"θέμα": [28,9,22],
"υιοθετηθεί": [25],
"σύντομη": [[2,10,21]],
"συμβουλευθείτε": [23],
"viewfilelistmenuitem": [8],
"υποστηριζόμενη": [14],
"άλλα": [31,29,28,[16,19],30,[2,10,27],[9,11,14,20,24]],
"ukr": [6],
"info": [3],
"πάτε": [[16,26]],
"brows": [16],
"κεντιρκής": [31],
"test": [16,20],
"υποκαταλόγους": [[2,22,28]],
"γραφής": [20],
"τοποθετήστετο": [15],
"omegat": [16,31,[13,28],20,10,30,29,[2,17],[9,14],19,12,[8,21],27,[18,22],[1,24,26],[0,7,15],[3,4,25],[5,11,23]],
"αρχείου": [12,31,14,[21,22],29,[15,19],24,[17,28,30],[8,16,18,20,25],[5,10,26]],
"αποθηκεύσεις": [19],
"διεξάγετε": [19],
"συστήματός": [[16,19]],
"kanuri": [6],
"εξοικειωθείτε": [29],
"my-project-dir": [20],
"ταξινομημένα": [28],
"πελάτες": [2],
"σχολιασμένες": [8],
"virtual": [1],
"rather": [16],
"τοποοθεσία": [26],
"ακάν": [6],
"μείνουν": [14],
"console-align": [16,20],
"συμβολοσειράς": [24,[27,29]],
"back": [19],
"ms-dos": [16],
"συλλογή": [29,[11,15,23,31]],
"κρίνετε": [18],
"γραφούν": [12],
"παραγράφους": [10],
"jean-christoph": [[4,7]],
"επικρατήσει": [28],
"λέξης": [5,[3,23,26]],
"δεξιά": [5,[14,29],[16,19,25]],
"πλήκτρων": [8],
"λογαριασμό": [[2,16,29]],
"έσω": [5],
"επεξετάθη": [18],
"εκκινήσετε": [16,[1,20]],
"σημειώσεων": [29],
"κατάλογος": [28,31,[16,30],6,[10,20],[0,1,2,5,11,12,18,19,25]],
"henri": [7],
"υποκαταλόγου": [28,2],
"προστασίας": [22],
"αποτελούνται": [[25,28]],
"ανάγνωση": [[12,14]],
"χαρατκήρας": [23],
"προσέξτε": [[16,20]],
"συμβολοσειρές": [[14,15,28]],
"αποφασίσετε": [22,[27,28]],
"εσπεράντο": [6],
"und": [26],
"project_save.tmx.temporari": [[20,28]],
"από-τα-δεξιά-προς-τα-αριστερά": [31],
"une": [15],
"τοποθετηθεί": [17],
"τοπικού": [2],
"μεταφόρτωσης": [1],
"κατάλογοι": [31,28,13,[2,10,12,14,19,30]],
"πάσα": [[17,20,28,29]],
"πελάτης": [2],
"editoverwritemachinetranslationmenuitem": [8],
"relat": [13],
"αριθμούς": [29,[14,27]],
"ingreek": [23],
"επιλεγμένου": [[19,29]],
"ημερομηνία": [[12,24,29]],
"γραμαμματοσειρά": [8],
"x_windows_without_jr": [16],
"es_es.aff": [26],
"συστήματα": [16,[19,31],2,[18,20,28,30]],
"ignor": [13],
"πέριξ": [19,31],
"construct": [23],
"υποκαταλόγων": [10],
"βελτιωθεί": [18],
"σύνδεσης": [16],
"pojavnem": [15],
"projectexitmenuitem": [8],
"ομοιογένειας": [10],
"συγκρούσεων": [2],
"κεφαλαία": [19,[8,23,25,29]],
"απαιτήσουν": [14],
"text": [[13,21]],
"διαμάχες": [28],
"κεφαλαίο": [23],
"x_source.zip": [16],
"μεταφόρτωση": [16,31,[2,8]],
"αναζ\'ητηση": [24],
"συστήματος": [12,[15,16],[2,8,18]],
"block-level": [25],
"manag": [13],
"προ-μεταφράσει": [28],
"μαζί": [16,[12,22],29],
"ταιριάζουν": [[22,28]],
"εισάγατε": [[18,19,29]],
"μιλώντας": [12],
"maco": [[3,16]],
"εναλλακτκή": [27],
"πολλών": [4],
"doc": [[14,29],13],
"τμήματος-στόχου": [27],
"αποθήκευση": [19,8,[2,10,12,14,16]],
"υπάρχοντα": [[17,18,22]],
"πάρα": [9],
"status": [16],
"server": [2],
"προσέγγιση": [29],
"ενημερώσουν": [2],
"εξασφαλισθεί": [12],
"μισά": [[20,22]],
"paramet": [13],
"dot": [13],
"αντιμετωπισθεί": [21],
"κοιτώντας": [24],
"θελήσετε": [28],
"μισή": [15],
"αριθμών": [27,[29,31]],
"mac": [16,5,[3,8],[13,19,30],[2,10,14,17,31]],
"φάκελλο": [28,26,[2,10,16,29]],
"γενικής": [7],
"επισήμαση": [19],
"αναγνώριση": [4,[7,10,30,31]],
"παραχθούν": [25],
"mah": [6],
"αντένδειξη": [15],
"λογική": [21],
"lepša": [3],
"συνδυάζοντγαι": [16],
"mal": [6],
"πάνω": [16,[1,5,19,25,26,29],[0,9,17,18,22,23,27,28]],
"man": [16],
"συνδυασμού": [5],
"αναφέρονται": [[28,29]],
"lepši": [3],
"παραπομπές": [12],
"mar": [6],
"may": [13],
"urd": [6],
"αμπχαζιανά": [6],
"shona": [6],
"συμβουλές": [[26,31],[14,28,30]],
"τσεκαρισμένο": [25],
"url": [2,[12,16,19,26,29]],
"ξεκινήσετε": [16],
"εικονική": [1],
"αξίζει": [2],
"αντιθέτως": [19,9],
"megabyt": [16],
"προβλέπουν": [21],
"uppercasemenuitem": [8],
"αριθμός": [29,[16,19],[8,12,14,31]],
"viewmarkuntranslatedsegmentscheckboxmenuitem": [8],
"απαιτούνται": [[16,18]],
"faroes": [6],
"relev": [13],
"quantifiers": [30],
"κουανιάμα": [6],
"www.omegat.org": [9],
"τυχόν": [[4,16]],
"mail": [13],
"προφανείς": [15],
"use": [13,24,3,[16,31]],
"subject": [13],
"πάλι": [28,16,[6,24]],
"έως": [20],
"χωρις": [7],
"main": [13],
"πάντωςμ": [20],
"ονόματά": [29],
"βοήθεια": [[4,19,31],[8,10,17,29]],
"επαναφορτώνει": [29],
"όπου": [28,[2,16,29],8,[3,10,14,15,19,22,25,26,27]],
"omegat.jar": [3,13,[0,1,20,28]],
"παράδειγμα": [12,28,16,[21,23,26],29,[2,14,20,25],[3,11,15,18,24,30],[1,8,19,31]],
"omegat.app": [3],
"usr": [16],
"ονόματα": [12,[26,31],27,[3,14,22,29]],
"παράδειγμά": [28],
"logo": [13],
"πατηθούν": [8],
"παρόμοι": [27],
"credit": [19],
"μετατρέψει": [[17,22,27]],
"παραγράφου": [12,25],
"δημιουργήθηκαν": [28,[10,14,19,29]],
"utf": [21,15],
"σύνδεσμο": [29,9],
"προεπιλογές": [12],
"επικυρωτής": [16],
"μπελάς": [14],
"πλήκτρου": [17],
"feed": [23],
"servic": [[2,13]],
"υπολογισμό": [29],
"αναβάθμιση": [31,[16,28],[19,30]],
"διαφόρων": [[10,14,27]],
"οφειλόμενες": [2],
"νεώτερες": [15],
"διάστημα": [[19,23,25],16],
"dsl": [11],
"αποθηκεύσετε": [15],
"επαναφέρετε": [19],
"ανάγκη": [18],
"μερικής": [31,[19,29]],
"χρησιμεύουν": [28,27],
"τοπικοποίηση": [[9,14,31]],
"συμπεριφοράς": [[27,28],[10,30,31]],
"dtd": [14],
"πρόσθετους": [10],
"ασφαλέστερο": [22],
"τελικό": [16,10],
"make": [13,3,20],
"χίντι": [6],
"τροποποιήσεων": [10],
"projectcompilemenuitem": [8],
"δημιουργήθηκε": [1],
"διορθωθεί": [15],
"console-transl": [[16,20]],
"γραμμάτων": [[19,28],[23,24,31]],
"δευτερόλεπτα": [19],
"μεταφράσετε": [12,10,[9,14,17,27]],
"πόσον": [28],
"τονισμένη": [29],
"σφάλματα": [20,[16,29],[0,4,17,19,28]],
"τρόπο": [20,16,14,29,[19,22,28,31],[1,2,5,10,17]],
"wordart": [12],
"συνοψίζουν": [29],
"τελική": [[4,10,17,18]],
"μπιχάρι": [6],
"αρχείων": [31,12,29,[14,19],[26,28],24,[8,21,30],[2,10,13,16,17,22,25,27],[9,15,20]],
"optionsviewoptionsmenuitem": [8],
"inform": [13,3],
"depend": [13],
"ίδια": [[2,27],[14,16,28,29],[12,15,20,21,31]],
"commit": [2],
"εναλλακτικές": [29,19,[2,22,27]],
"targetlocalelcid": [12],
"μεταφράσεων": [29,31,[18,27]],
"project_stats_match.txt": [[2,13,29]],
"μεταφράσεως": [29],
"tab-separ": [[15,29]],
"dvd": [20],
"δυνατότητα": [[16,19],28],
"quarkxpress": [14],
"μονολεκτική": [15],
"δομημένων": [15],
"πρόσβαση": [29,16,2,[1,10,11,19]],
"meniju": [15],
"αρχέιου": [22],
"one_spac": [19],
"limburg": [6],
"αναβαθμίζονται": [16],
"βαθμολογία": [29],
"εναλλακτικής": [[19,22,29]],
"ανεξαρτήτως": [23],
"διαιρούμενος": [29],
"μερικών": [31,29,28,19],
"μερικώς": [29],
"μήκος": [[16,25]],
"κλείνει": [29,19,28],
"κατεγράφη": [19],
"αποσυμπιεσμένο": [16],
"krunner": [16],
"γλώσσες-στόχος": [10],
"libreoffic": [26,17],
"γαλάζιο": [19],
"συμφραζόμενα": [29],
"ψάξτε": [11],
"παραγράφων": [14],
"into": [13],
"χωρίς": [[1,2,4,16,28],[12,15,20,29],[17,18,25,27]],
"εξειδικεύστε": [25],
"καλύτερης": [19],
"απόδοση": [19],
"επιβεβαιώνει": [19],
"διευθύνσεων": [2],
"defin": [13],
"κάπως": [[16,28]],
"uzb": [6],
"συνδέοντας": [14],
"παλιούς": [22],
"πρώϊμες": [28],
"σταματήσει": [16],
"περιορίσετε": [24],
"διεύθυνση": [16,[9,31]],
"ίδιο": [28,[16,27],[1,2,11,12,14,17,19,22,23,29]],
"viewdisplaysegmentsourcecheckboxmenuitem": [8],
"μορφοποιημένου": [[10,14]],
"appear": [[13,16]],
"μπορεί": [28,29,15,[14,16],10,22,[2,17],[8,12,20,25,27],[0,1,21,26],[18,19,23,24]],
"βοσνιακά": [6],
"progress": [13],
"troubleshooting": [30],
"oper": [[13,16]],
"open": [13,12,[3,8,14,28]],
"καταγράφονται": [[16,20]],
"www.oracle.com": [16],
"mkd": [6],
"project": [13,[16,20,31],[3,22,30],8],
"προϋποθέσεις": [20],
"xmx1024m": [16,3],
"ινουκτίτουτ": [6],
"ειδοποιήσεις": [16],
"κατατμηθού": [25],
"όριο": [23],
"ενημερωμένες": [10],
"sever": [[13,24]],
"στείλετε": [20],
"μικρό": [[10,26]],
"dzo": [6],
"ορισμένα": [10],
"greedy": [30],
"αντιγράψατε": [28],
"penalty-xxx": [28,31],
"αντίγραφο": [2,28,[12,20,22]],
"gotonextsegmentmenuitem": [8],
"περιλαμβάνοντας": [[18,29]],
"συνδέονται": [[2,10]],
"εύκολα": [[14,17]],
"προσφέρονται": [[8,19],[3,14,24,25,28,29]],
"παγίδα": [11],
"επικαλύπτεται": [27],
"mlg": [6],
"greedi": [23],
"nnn.nnn.nnn.nnn": [16],
"βοηθά": [28],
"look": [3,[13,28]],
"περιλαμβάνονται": [12],
"εύκολη": [[10,29]],
"mlt": [6],
"abort": [20,16],
"μεταφράσεών": [10],
"ταιριάζει": [[15,22,29]],
"δυσανάγνωστους": [24],
"τοπικές": [28],
"internet": [[2,13],29],
"ήδη": [29,[16,19],[1,22],[15,26,27,28],[0,2,8,10,14,20,25]],
"allow": [13],
"μεταφραστικών": [28,31,30,22],
"συνδυασμός": [[5,16]],
"κλικάρετε": [[15,16,19]],
"εργασίες": [[2,29]],
"ορθές": [3],
"proper": [[3,13]],
"ορίσατε": [24,[12,20,26]],
"σημειώσεις": [[12,29],[19,24],[8,10]],
"questionnair": [13],
"αυτόνομων": [16],
"έντονα": [29,19],
"printf": [19],
"αντίγραφα": [28,20,31,9],
"appli": [3],
"interest": [[13,18]],
"πραγματικότητα": [22],
"δημιουργείτε": [[15,31],[2,14,16,28,30]],
"ορθογραφικά": [26,10],
"ενημερωμένης": [31],
"σταματά": [27,[16,20]],
"πάρετε": [[28,29]],
"προσφέροντας": [29],
"εκκινείστε": [31,16],
"φορτώνετε": [[2,28]],
"διακομιστή": [2,16,[19,31],8],
"middl": [13],
"επλογής": [27],
"επεκτάσεις": [11,[14,15,21]],
"ζουλού": [6],
"αποεπειλέξτε": [22],
"ορθογραφική": [26],
"μετακινηθεί": [5],
"χτίσατε": [29],
"κινεζικών": [19],
"μηχανήματος": [16],
"τυπικό": [28],
"es-mx": [26],
"layout": [29],
"ουζμπεκικά": [6],
"διαθέσιμος": [[2,16]],
"μεμονωμένων": [24],
"μικρά": [[8,19,29]],
"ορθογραφικό": [26,0],
"διάφορους": [10],
"bash": [13],
"μη-λέξης": [23],
"προβολή": [19,20,31,[2,14,29,30]],
"basi": [13],
"mark": [[4,29]],
"stem": [3],
"base": [[15,28]],
"περί": [28],
"συναντήσετε": [28],
"συνεπάγονται": [16],
"σπάνιες": [[22,28]],
"ιδιαίτερο": [16],
"διευκρινισθεί": [20],
"εαυτό": [12],
"παράμετρο": [16],
"romansh": [6],
"σουαχίλι": [6],
"τιμές": [16,20],
"προκαλέσει": [[22,28]],
"ιδιαίτερη": [1],
"mon": [6],
"τυπικά": [16,6],
"αριθμού": [29,14],
"εηρρεάζουν": [22],
"loss": [13],
"εγγραφεί": [28],
"υπάρχουσα": [[16,28]],
"εισαγόμενα": [28],
"lost": [13],
"volapük": [6],
"περιπέχονται": [16],
"αποφεύγεται": [29],
"work": [13],
"lose": [13],
"ερμηνεύει": [21],
"αλφάβητο": [21],
"ενικός": [3],
"gedit": [15],
"αριθμοί": [29,27],
"τιμής": [29],
"δίνει": [[16,28]],
"εξαχθούν": [25],
"ιδιαίτερα": [20,[14,16,22]],
"word": [[14,24],[12,13,17]],
"swati": [6],
"εκκινήσει": [16],
"έντονο": [29],
"ομαδικού": [2,[16,30]],
"φορά": [[2,17,28],[10,14,16,18,19,20,25]],
"εξάγετε": [[10,11,27]],
"εργασίας": [16,[28,29],[19,20,24]],
"χρειασθείτε": [23],
"μπουρμέζικα": [6],
"γραμμτοσειράς": [20],
"κάποιες": [[12,18,22],[10,14,25,29]],
"άλλους": [16,[10,14]],
"μη-λέξη": [23],
"ρωτά": [16],
"οποίων": [10],
"τμημάτων": [29,19,[8,24],10,27,[14,22,28]],
"καταλληλοτητας": [7],
"αυξανόμενο": [18],
"συνολικοί": [31],
"εγκατασταθεί": [16,[0,2]],
"καταγραφεί": [28],
"σχέδια": [12],
"συνώνυμη": [10],
"συμπεριλάβει": [2],
"κασμιριανά": [6],
"κατακερματίσει": [25],
"βοηθητικών": [28],
"τιμή": [23,[16,20,28],[12,18,29]],
"mri": [6],
"vcs": [2],
"chamorro": [6],
"εφαρμοσθούν": [[8,12,25]],
"απλοποιημένο": [10],
"lingvo": [11],
"εγκατεστημένες": [16],
"κορσικανικά": [6],
"βάζετε": [2],
"mrs": [25],
"ολοένα": [18],
"tortoisegit": [2],
"συνδεθείτε": [[2,9,16]],
"sourceforge": [30],
"μήνυμα": [16,[2,9,20,28]],
"msa": [6],
"οντότητα": [24],
"εξής": [23,8,[12,21,25],[2,3,10,14,27,28,29],[1,16,17,18,19,20,22,24]],
"αποτελέσματα": [[12,18,29]],
"ιστοσελίδων": [18],
"σύγχρονα": [6],
"επιμόλυνση": [28],
"float": [27],
"καλύτερες": [25],
"υπηρεσιών": [18],
"pt_pt.aff": [26],
"υποκατάλογοι": [31],
"x_sourc": [16],
"κουτάκι": [12,[22,25,26,27],[16,28]],
"υπαρχουν": [14],
"html": [16,12,14,25,[1,13,17,20,28,29]],
"αναβαθμίσει": [22],
"υποκατάλογος": [31,[26,29]],
"εντοπίζεται": [28],
"ενεργοποιήσετε": [12,[18,19,24]],
"μελλοντική": [[19,28]],
"ven": [6],
"δείκτης": [19,[25,29]],
"καταγραφής": [9],
"spell": [13],
"ενός": [2,[12,15,16,19,31],25,[10,27,30],[1,18,20,21,23,28]],
"μελλοντικά": [[2,17]],
"συμβουλεύουμε": [25],
"δικές": [[5,23]],
"βοηθήσει": [28,[9,10]],
"ακολουθήστε": [[16,26]],
"omegat.bat": [13],
"απλοποίηση": [29],
"πληροφορίες": [16,29,14,[10,28],[8,19],[21,22],[2,6,11,12,15,18,20]],
"ρυθμίζετε": [[12,15,19]],
"artund": [26],
"διαθέσιμες": [[16,29],[8,12,19,20,28]],
"πολυγλωσσικός": [31],
"υπόλοιπα": [29],
"θέση": [[8,15,19,25],[10,26,28,29]],
"ακπομη": [28],
"ξαναφορτώνει": [19],
"υπόλοιπη": [2],
"σελίδες": [[19,29]],
"πατήστε": [17,[2,15,16],[18,24,28,29]],
"eed": [28],
"εφαρμογές": [16,[10,19,20,26]],
"sawuła": [7],
"κωδικοποιήσεις": [12],
"jres": [16],
"www.ibm.com": [16],
"τροποποιήσεις": [7,[24,28]],
"αριστερό": [1],
"κάποιαν": [26],
"πετύχετε": [[16,27],[14,25]],
"μερικοί": [[15,28]],
"εξαιρετική": [4],
"platform": [13],
"πρέπει": [16,25,12,2,8,28,20,26,14,27,[3,9,15,17,19,22],[11,18,23,29],[4,21,30]],
"urdu": [6],
"postfix": [3],
"εισαγωγικό": [4],
"εφαρμογής": [16],
"ντιβέχι": [6],
"αριστερή": [14,29],
"αποθηκεύστε": [[8,14,16]],
"αριστερά": [5,25],
"ληφθεί": [24],
"χρειαστεί": [25,15],
"improv": [16],
"command": [13,[8,19],[2,16]],
"κατατμηθεί": [12],
"project-specif": [13],
"πάντα": [[12,28],[2,8,15,19]],
"κόστους": [29],
"φιλοξενούμενη": [2],
"αναζήτησης": [24,29,31,30,19,[14,20,23]],
"παρουσία": [[16,24]],
"συγκρούσεις": [2],
"ξεκινά": [[16,20]],
"εισαγωγικά": [15],
"τσεκάρει": [26],
"νέας": [[12,15,23]],
"ορισμάτων": [[16,31]],
"viewmarkbidicheckboxmenuitem": [8],
"στατιστικών": [29,8],
"year": [[20,28]],
"επικύρωσης": [29,20,19,[16,30]],
"μπισλάμα": [6],
"μοτίβα": [12,25],
"αρκετό": [20],
"χρησιμοποιούνται": [[12,28],[18,29],[1,10,14,23,26]],
"στοιχείο": [16],
"ανατολικοευρωπαΐκές": [21],
"παρεμβαίνει": [[2,22]],
"κάθε": [12,[2,17],14,[19,25,28,29],[0,16,18,20,27,31]],
"περίπτωση": [28,16,29,[2,10,12],[15,20,21,22],[3,5,14,17,18,27]],
"περιοχές": [29,31,[14,19]],
"μαλτεζικά": [6],
"vie": [6],
"μεθόδους": [24],
"fileshortpath": [29],
"προβάλλεται": [[19,29]],
"double-click": [13,3],
"μοτίβο": [12,[25,31],23,21],
"subdirectories": [30],
"στοιχεία": [[12,14,27]],
"instruct": [3],
"χρονοβόρα": [29],
"πάρει": [[19,20,26]],
"αρκετά": [28,[10,18,23]],
"google": [30],
"αρκετή": [28],
"version": [[2,13,16],[28,30]],
"project-dir": [[16,20]],
"συγγραφή": [25],
"ελέγξει": [[28,29]],
"folder": [13,16,31],
"mya": [6],
"αφήσετε": [27],
"de-fr": [28],
"handl": [10],
"ξεχάσατε": [11],
"detail": [13],
"vista": [13],
"λέξεις": [29,24,[3,19,23],[10,14,15,17,18]],
"προ-επεξεργασθείτε": [28],
"εξαρτώνται": [0],
"όρους": [15,7,29],
"υποδείξουμε": [28],
"projecteditmenuitem": [8],
"least": [13],
"λεπτομέρειες": [[18,29],7,[14,16,23]],
"κειμένων": [18],
"βέλτιστης": [27],
"britannica": [31],
"εμπειρία": [22],
"συνέχεια": [26,[10,17,27,28]],
"προηγούμενες": [10,[4,25,29]],
"machin": [1],
"behavior": [13],
"αρμονικά": [28],
"ακρωνυμίου": [25],
"επαναλαμβάνονται": [29],
"μη-ορατή": [[19,22]],
"ανοίγει": [19,[15,28,29],[2,17,18,20,22,27]],
"μικρών-κεφαλαίων": [[23,31]],
"ιδιωτικότητα": [16],
"υποννοείται": [12],
"περιεχομενό": [28],
"αλλαγών": [2,[16,29]],
"iceni": [14],
"συγχωνεύονται": [2],
"φϊλτρα": [[12,31]],
"οτι": [[4,8]],
"οτε": [16],
"ελεύθερου": [7,30],
"κρατάτε": [29],
"x_mac.zip": [16],
"όρων": [29],
"συμβάσεις": [28],
"προφανώς": [[28,29]],
"ελέγχθηκε": [16],
"περαιτέρω": [12,[15,25]],
"ρυθμίστε": [20],
"specif": [13],
"ανοίγοντας": [29,16],
"αντιστοίχιση": [29,19,28,12,8,[3,15,23,25]],
"διαφορετικό": [28,[12,26]],
"στάδια": [18],
"κανονικές": [24,[23,31],[16,25],[11,22,30]],
"στάδιο": [14],
"συνδυασμένες": [29],
"αντικατάσταση": [19,8,[12,31]],
"αποδέχεται": [29],
"κατατμηθούν": [25],
"φακέλλους": [22],
"μόνον": [12,[16,19,24],[2,11,14,25,26,27,29]],
"ell": [6],
"need": [13,3],
"ομάδα": [[2,22],[9,25],28,[8,12,19,20,23,24,29]],
"μεταφρασμένων": [[14,19],[8,12,31],22],
"βλέπε": [28,19,23,[2,16,18,22],[14,17,29],[0,8,20,24,25,26,27]],
"γλωσσαρίου": [15,31,29,19,[2,8],[3,14,20,30]],
"x0b": [23],
"μετα-ετικέτες": [12],
"αποδειχθούν": [10],
"ταξινομηθούν": [29],
"διαφορετικά": [2,14,[5,25,29]],
"κανονικής": [[20,23,30]],
"διαφορετική": [29,[12,14,28]],
"altern": [13],
"επιλογών": [[19,25,29,30,31]],
"σημείωση": [19,[23,28,29],[8,20],[2,14,15,17,18,24,25]],
"http": [16,1,[3,18]],
"καθίσταται": [14],
"λεπτά": [[2,17,19,20],[7,10,16,28,30]],
"σήμα": [2],
"εικέτες": [29],
"γενική": [[3,22]],
"μορείτε": [16],
"μόνονν": [28],
"καθόλου": [23,[2,16,25,27]],
"τροποποιείται": [[14,16]],
"γενικά": [29,[22,23,25,28]],
"ρωσικά": [16,[6,20,21]],
"χρησιμοπιοείτε": [14],
"ρωσική": [16],
"επεξεργαστή": [1],
"εσωτερικές": [29],
"πελάτη": [[2,28],[10,16,29]],
"εμφανίσει": [[19,28]],
"vol": [6],
"αμετάβλητα": [12,27],
"τελείωσε": [[2,29]],
"αμετάβλητη": [12],
"end": [[5,13,24]],
"de-en": [28],
"docbook": [[4,14]],
"ασφαλείς": [21],
"πηγή-στόχος": [11],
"helton": [4],
"eng": [6],
"σλαβική": [6],
"κληρονομούνται": [14],
"οξιτάνικα": [6],
"συμβολοσειρών": [31,14,[24,29]],
"κάποιο": [[26,28,29]],
"διόρθωση": [26],
"σαμοανικά": [6],
"κάποπιου": [28],
"αντικειμενοστραφούς": [1],
"okapi": [31],
"προγραμματιστές": [[9,19]],
"επικυρώστε": [17,30],
"σχεδόν": [[15,21]],
"κάποια": [28,[12,20,22]],
"ορισάτων": [31],
"αρχικοποίηση": [27],
"γράφονται": [14],
"λίγο": [26],
"προμετάφραση": [31],
"βέντα": [6],
"copyright": [7,19],
"εγκατάστασης": [16,[0,1,26,29,30]],
"moran": [7],
"project_nam": [[13,28]],
"system-os-nam": [12],
"occurr": [24],
"optionstabadvancecheckboxmenuitem": [8],
"ετικέτας": [29,20,[16,31],19,[8,14,30]],
"περιπώσεις": [29],
"specifi": [[3,13],16],
"optionsviewoptionsmenuloginitem": [8],
"μερικά": [[16,17,25,30],[0,11,28,29,31]],
"κειμένου": [14,31,19,21,[10,12,27],[5,25,29],[15,26,28],[1,23],[2,16,17,20,24,30]],
"μερική": [29,19],
"περάτωση": [10],
"invis": [13],
"συστατικά": [19],
"συμπιεσμένες": [31],
"πολλές": [[14,28],[0,16,20,24,25,29]],
"nav": [6],
"προχωρήσετε": [[10,14,19]],
"nau": [6],
"tar.bz2": [11],
"epo": [6],
"καθαρό": [14],
"υπάρχουσες": [28,[1,19,30,31]],
"νόημα": [[24,25,26]],
"συγκεκριμένου": [12],
"επόμενες": [[2,29]],
"απόλυτο": [28],
"λουγκάντα": [6],
"πολυάριθμους": [9],
"omegat-token": [3],
"σειρά": [[24,25],28,[27,29]],
"x64": [16],
"nbl": [6],
"μερικό": [28],
"αποσαφήνιση": [18],
"μη-τυποποιημένες": [20],
"είχατε": [20],
"κοστους": [29],
"βάλετε": [[17,28]],
"keyev": [8],
"γλώσσας": [26,0,28,[6,25,30,31],[10,16,22],[1,3,11,12,18,29]],
"βασισμένο": [1],
"λέγεται": [16,[12,17]],
"παραμετροποιηθούν": [[10,29]],
"πιθανότατα": [15],
"εξάγει": [19,[17,27,28]],
"οποιοδήποτε": [28,29,[2,5,8,12,15,23,25]],
"login": [8],
"isn\'t": [23],
"αριχικό": [5],
"valid": [12],
"interfac": [20],
"κάνετε": [29,[12,16,26],24,[1,27],[2,5,15,17,19,20,23,25,28]],
"ρύθμιση": [31,29,30,19,[17,22,26],[1,16,24]],
"φτιάξατε": [2],
"μείνει": [12],
"share": [28],
"προτιμήσουν": [28],
"μέσων": [20],
"εγκαταταστήσετε": [26],
"ξαναμετατραπούν": [14],
"αποδειχθεί": [[14,25]],
"περικλείονται": [[15,19]],
"optionsteammenuitem": [8],
"gzip": [28],
"σελίδα": [[9,14,16,25,29]],
"πράγματι": [[19,28]],
"ταυτόχρονα": [24],
"nde": [6],
"επόμενης": [5],
"πράγματα": [[12,17],[8,9,19,29,30]],
"μεταφρασμένου": [12,[14,29]],
"τρίστηλους": [15],
"βασισμένα": [18],
"esc": [29,19],
"x86": [16],
"αναγνωσιμότητας": [19],
"ndo": [6],
"exampl": [3,[13,24]],
"ντέμπελε": [6],
"logic": [24],
"περιλαμβάνει": [16,[0,2,7,12,18,23,24,28,29]],
"βασισμένη": [[1,10],25],
"εξηγεί": [10],
"nostemscor": [29],
"πέρα": [5,[16,18]],
"δικαιώματα": [2,16],
"πορτογαλικά": [[6,26]],
"σημεώστε": [28],
"προσετέθησαν": [15],
"αποφασίζει": [19],
"νομολογία": [28],
"est": [6],
"σκάσιμο": [2],
"ανάπτυξης": [9,2],
"εξυπηρετεί": [2],
"μικρώτερος": [14],
"console-createpseudotranslatetmx": [16],
"ίσχυε": [29],
"μέλος": [2],
"συνδεθεί": [[2,16]],
"etc": [[13,28]],
"longman": [[11,31]],
"εμπρός": [19],
"nep": [6],
"αγνοηθούν": [16,28],
"fuzzyflag": [29],
"αναθεωρημμένο": [11],
"δυνατή": [[22,28]],
"ετικέτες": [[19,31],14,[17,29],12,22,28,[16,30]],
"δυνατά": [[1,16]],
"θαυμαστικό": [2],
"merriam": [11,[29,30,31]],
"new": [13],
"escap": [16,23],
"settings": [30],
"παρουσιάζουν": [2],
"συνδεθούν": [14],
"έκαστος": [10],
"καθαρισμό": [27],
"projectname-omegat.tmx": [28],
"καλάλισουτ": [6],
"tool": [13],
"εξειδικευμένο": [10],
"καταντήσει": [29],
"βάση": [[9,12,29]],
"πληκτρολογείστε": [16,2],
"θυμάται": [19],
"εξειδικευμένη": [29],
"νουόζου": [6],
"therefor": [13],
"boundary": [30],
"eus": [6],
"συνηθισμένες": [22],
"project_sav": [29],
"συνειδητοποιήσετε": [22],
"όροι": [15,[2,18,29]],
"περιήγηση": [25],
"επικαλύπτετε": [29],
"οδηγίες": [16,[10,12,14,30]],
"βρέθηκαν": [29],
"δομικές": [25],
"όρος": [15,5],
"βιβλίου": [18],
"όρου": [15],
"υλοποιήθηκαν": [1],
"καλύπτουν": [21],
"magento": [14],
"καταλλήλως": [28],
"vxd": [14],
"αδειάσετε": [29],
"μηνύματος": [9],
"βρετανική": [11],
"καλύπτει": [21],
"υπάρχοντες": [25],
"γλυτώνοντάς": [[27,28]],
"λογότυπo": [19],
"boundari": [23],
"ewe": [6],
"στόχο-ορόσημο": [28],
"offlin": [16],
"ελεύθερων": [26],
"martin": [7],
"συνένωση": [22],
"xslt": [1],
"omegat-plugin": [3],
"ανοίγουν": [14],
"προγραμμάτων": [[1,17]],
"εικονίδιό": [2],
"αλλάξτε": [21,[25,26,28]],
"προορισμό": [[19,24,29]],
"maintain": [13],
"τρέχουσας": [5],
"shift": [19,8,[5,14],[15,17],[27,31]],
"μεταβλητές": [12,[19,29]],
"προσφέρει": [29,[2,16],[10,12,15,18,22,24,27]],
"ικανά": [12],
"παράμτερος": [16],
"ορισμού": [2],
"εγκυκλοπαίδεια": [11],
"wunderlich": [7],
"επιτρέπεται": [27,28],
"java": [16,13,[1,20],[8,31],3,[23,30],[12,14,19,28]],
"exe": [16],
"προβάλλετε": [16],
"τελειώσετε": [28],
"αποσυμπιέστε": [16,[0,1,3]],
"κατηγορίες": [29,[23,30]],
"project_save.tmx": [28,20,[13,14],[2,19]],
"εξετάστε": [21],
"παραδείγματος": [29],
"sourceforge.net": [3],
"dictionari": [13],
"μεταφραστικής": [28,10,[2,3,17,18,20,22,29]],
"δεσμεύσετε": [16],
"remain": [13],
"μέθοδο": [[16,24]],
"απαιτούμενο": [11],
"αλλάζει": [19],
"δείκτη": [25,19,15],
"βάζοντας": [9],
"μνήμες": [28,10,29,[17,24,31],[16,22,30],[14,18,19,21,25]],
"flash": [14],
"λ.ς": [16],
"συχνές": [16],
"ταυτόσημα": [29,24],
"μογγολικά": [6],
"appl": [19,17,16],
"κακής": [22],
"πλεονέκτημα": [16],
"default": [13],
"σαφές": [28],
"ανατολικής": [31],
"τρόπους": [[14,16,20,22,25,26]],
"καταμήσουν": [14],
"ερευνητικών": [18],
"υποβάλλει": [2],
"εμπιστευτικότητας": [2],
"πράξη": [[4,14,16]],
"timestamp": [12],
"διαδικασία": [[10,20,28],[2,25,26,27]],
"αρχής": [5],
"φούλα": [6],
"αποστέλλεται": [18],
"κατατεθέντα": [27,29],
"nld": [6],
"ικανό": [24],
"αρχήν": [9],
"πράγμα": [16,[10,15,28]],
"such": [13],
"πολύ": [10,[25,28],[3,8,9,19,21,23,24,26]],
"τροποποιείστε": [29],
"plugin": [[3,31],[0,2,10,13,19,30]],
"πορέλευσηςη": [28],
"εικονίδιο": [16],
"διαμοιρασμένων": [2],
"οποιονδήποτε": [23,24,[26,28]],
"omegat-l10n-request": [9],
"εικονίδια": [16],
"ζουάνγκ": [6],
"άδεια": [7,[11,16,19]],
"περιγραφή": [[2,4,8,16,28,29]],
"ανακτά": [29],
"διαχειριστή": [26,2],
"x_without_jre.zip": [16],
"άριστη": [4],
"σκοπο": [7],
"editinsertsourcemenuitem": [8],
"κάτω": [29,[2,16,25,28],[1,23,24],[5,11,19,20,26,27]],
"εγγράφου": [[5,14],[1,10,12,19,29]],
"βρέθηκε": [[15,29]],
"microsoft": [[12,14],[16,31],[10,15,17,29]],
"projectnewmenuitem": [8],
"μονάδων": [[3,31],[0,2,30]],
"optionstranstipsenablemenuitem": [8],
"ποια": [12,28,[16,19,22,25]],
"αξιόπιστοι": [25],
"σκοπό": [[15,18]],
"segment": [13,19],
"κάτι": [16,[10,12,20,28]],
"δηλαδή": [18],
"changes.txt": [13],
"δώσουν": [[12,29]],
"glossari": [[13,15],17],
"ignored_words.txt": [[2,13]],
"βρίσκατε": [16],
"αναθέσετε": [2],
"ορισθούν": [[20,25]],
"ποιο": [[17,18]],
"συλλέγονται": [28],
"δημιουργήσατε": [17,26],
"νέοι": [15],
"ξαναρχίσετε": [25],
"nno": [6],
"αλλαχθεί": [[14,15,22]],
"εξυπηρέτηση": [29],
"κόμματα": [12],
"συγχρονισθεί": [16],
"νέου": [31,17,[25,26,28,30],[2,10,19]],
"υπονοούμενη": [7],
"αλλα": [31],
"προβολής": [19],
"γλώσσες": [31,[14,28],[1,25],[18,20,21],[6,30],[0,5,10,15,22,26]],
"nob": [6],
"σύγκρουση": [8],
"προσθέσει": [1],
"σίγουρα": [28],
"string": [3,1],
"ελέγξτε": [18,11,[2,14,24,26,28],[6,20]],
"import": [13],
"μεταφραστικές": [28,10,29,[24,31],[16,17,22,30],[14,18,19,21,25]],
"διάλογος": [31,12,22,[1,15,17,30],[2,19,20,27]],
"μεταφράζει": [20],
"γλωσσάρια": [15,31,30,[10,17],[11,18,19,29]],
"διαφορά": [29],
"κεκλιμμένες": [15],
"εκκινείτε": [16,28],
"διάλογοι": [31,29,30],
"αγγλκή": [4],
"nor": [6],
"not": [13,[3,16]],
"ιστορικό": [19,8],
"τρεις": [14,[13,17,19,21,28,29]],
"μεταφραστικήγ": [20],
"πια": [26],
"now": [0],
"συνδέσμους": [29,9],
"αλλαγμένες": [22],
"ascii": [14],
"έγκυρος": [18],
"χρησιμεύσει": [[15,28]],
"greek": [23],
"ηλεκτρονικό": [29],
"καταμέτρηση": [29],
"πιο": [16,[2,28],[23,29],20,26,[10,17],[3,6,9,12,15,18,19,21,22,24,27]],
"βρίσκνται": [15],
"βάλει": [28],
"μόνη": [29],
"selection.txt": [27,19],
"τελεστές": [[23,30]],
"way": [13],
"xhtml": [12,[14,25,29]],
"ποιότητα": [18,14,[3,28]],
"μόνο": [28,16,24,[2,12,22,29],[5,15],[1,19,20,27]],
"itoken": [3],
"what": [3],
"παρελθόν": [[10,19,28]],
"μαρσαλιανά": [6],
"ελέγχει": [[16,19]],
"εργαλείου": [[23,30]],
"τμήμα": [19,29,27,28,5,[12,15,17,24],[8,18],[14,16],[10,20,22,25]],
"εισάγει": [19,29,[18,27]],
"window": [16,13,[2,31],19,[10,11,14,15,20,23]],
"απίθανους": [24],
"επελέγη": [19,16],
"ελέγχου": [2,26,[8,19,23,28]],
"γερμανικό": [24],
"χαμηλώτερη": [28],
"από-δεξιά-προς-τα-αριστερά": [31],
"αβαρικά": [6],
"omegat.pref": [13],
"when": [13],
"πολλαπλά": [16],
"αφήνει": [[12,27]],
"ύπαρξη": [15],
"προσθέστε": [[12,16],[2,8,21]],
"διάλειμμα": [26],
"fao": [6],
"txml": [14],
"εργαλείων": [[8,30,31],[19,25,29]],
"περιορισμένη": [15],
"carriage-return": [23],
"faq": [9],
"αρχίσει": [[22,29]],
"πολλοί": [[2,28]],
"fas": [6],
"αρχεία-στόχος": [12],
"περίερργη": [21],
"προηγούμενο": [19,[8,28]],
"bartko": [7],
"υπάρχοντος": [19],
"περιγράφει": [10,[5,19,29]],
"εφικτά": [8],
"omegat-script": [1],
"προαπαιτούμενα": [16],
"διαφυγής": [23],
"εφικτή": [[14,28]],
"pt_pt.dic": [26],
"τιγκρίνυα": [6],
"ομοιότητας": [27],
"futur": [13],
"διστάσετε": [20],
"καταφέρω": [4],
"level1": [[17,28],19],
"level2": [[17,28],19],
"δικαιωμάτων": [7,2],
"οκταδική": [23],
"widget": [[29,31]],
"μαλαγιάλαμ": [6],
"αλλά": [28,[16,24],[5,23],[1,2,10,15,20,29],[4,7,14,17,18,19,22,25,26,27]],
"επιτρέπει": [19,[12,27],[1,14,15,16,28],[2,20,23,29]],
"direct": [13],
"flags": [30],
"πρότασης": [31,[10,22,25]],
"τελεί": [7],
"προστεθούν": [15],
"αντικείμενο": [1],
"δίπλα": [[8,26,29]],
"μαζικό": [16],
"συγκεκριμμένες": [29],
"ίντο": [6],
"υπάρει": [15],
"web": [16,9,31,[18,29,30]],
"φορτώσει": [28],
"πληκτρολόγια": [19],
"ευχαριστώ": [4,30],
"γκουαρανί": [6],
"επαρκείς": [[12,25]],
"λιγώτερο": [[10,15,16,23,28]],
"berlin": [7],
"σφάλματος": [[9,16,28]],
"ξαναβάζει": [29],
"φωνήεντα": [23],
"ορολογία": [[28,29],24],
"nth": [19],
"editselectfuzzy4menuitem": [8],
"κωδικό": [26,12,[2,16,19,21]],
"αξιόπιστες": [28],
"γερμανικά": [[0,6]],
"γϊνεται": [24,31],
"πακέτου": [16],
"εγγράψιμο": [15],
"κατεβάστε": [16,[3,11]],
"επαλήθευσης": [15],
"κονσόλας": [20,16,31,30],
"χειρισμός": [31],
"pt_br.dic": [26],
"στρατηγικές": [27],
"βοηθητικές": [[28,29]],
"certain": [[13,28]],
"πρώτα": [2,[15,25],[0,1,9,16,17,23,26]],
"ειδικές": [28,12,[4,10,25,29]],
"μρπςο-πίσω": [14],
"περιορισμοί": [27],
"μορφοροποιημένων": [14],
"ορίσουν": [23],
"σχετικά": [[10,22,29,30],[6,8,14,16,17,18,19,25]],
"σωστά": [[15,16],[14,21,28],[18,29]],
"σωστή": [[14,15],16],
"λεκτικών": [[3,31],[0,2,30]],
"δοκιμαστή": [23],
"afrikaan": [6],
"προηγούμενου": [[5,19]],
"εντολής": [31,[2,16],[8,18]],
"ευελιξίας": [25],
"φορτώνονται": [28,[12,15]],
"κλειδιά": [29],
"περιέχουν": [[24,28],14,27,[10,15,21],[25,29]],
"γλωσσαρίων": [10],
"ορόμο": [6],
"συμπεριφορές-κλειδί": [5],
"φέρουν": [28],
"περιγράψαμε": [16,24],
"σύροντας": [[16,29]],
"που": [16,29,28,19,2,12,10,24,[15,17],[14,18,20],22,[21,26,27],[1,23,25],8,3,0,[5,9],[4,7,30]],
"πληκτρολόγιο": [[19,24,27]],
"σωστό": [[2,11,18,26]],
"μπενγκαλέζικα": [6],
"προσπελάσετε": [16],
"λεπτομερειακά": [29],
"ανάλογα": [28,[16,29],19,14],
"πρώτο": [19,[4,16,22,24,29]],
"nnnn": [29,16],
"project_save.tmx.yearmmddhhnn.bak": [[20,28]],
"keep": [13],
"effect": [16],
"εγκαταστήσατε": [16],
"παραμετροποιημένες": [19],
"πρώτη": [19,[16,29],[2,8,10,15,28]],
"εγγράφων": [14,19,[28,31],[1,8,12]],
"εφαρμογών": [[10,14,16]],
"οποιαδήπ": [16],
"option": [3,13],
"συντομέυσεων": [[19,30]],
"ηλεκτρονικώς": [10],
"εφικτό": [22],
"δεδομέν": [2],
"myproject": [28],
"επεξργασία": [[19,30]],
"προβλήματα": [31,15,[11,30],[20,21,28,29]],
"zh_cn.tmx": [28],
"αλλάξει": [[22,25]],
"chuvash": [6],
"δοθούν": [16],
"wordfast": [14],
"αλλάχωρις": [7],
"εξαίρεση": [25,28],
"προηγούμενη": [[8,19,20,28,29]],
"huriaux": [7],
"απλές": [[10,14]],
"διαχωρισμένα": [12],
"wix": [14],
"σχετικό": [28],
"ελπίδα": [7],
"διακρατάται": [14],
"ολοκλήρωση": [25],
"τεχνικές": [18],
"txt2": [21],
"visio": [14],
"εντολές": [16,5],
"nya": [6],
"txt1": [21],
"επιλέξατε": [19,[12,26,27]],
"archiv": [13,16],
"προκαλέσουν": [29],
"νέες": [8,[12,15,19,22]],
"user": [13,16,[20,31],[17,24,29,30]],
"κλασική": [1],
"proxi": [16,[8,31]],
"προστίθεται": [16],
"extens": [12,[1,13]],
"απώλειας": [20,31,[22,30]],
"fij": [6],
"πινάκων": [30],
"κωδικοπίησής": [25],
"ζεύγος": [28,18,29,[2,22,25]],
"fin": [6],
"προτιμώτερη": [22],
"kinyarwanda": [6],
"hausa": [6],
"ελέγξατε": [14],
"ρυθμίσειε": [17],
"προτιμώτερο": [2],
"απάντηση": [18],
"παρακαμφθεί": [12],
"marāṭhī": [6],
"πρότυπα": [[1,14,18,26,28]],
"rang": [23],
"ψάξετε": [24],
"περιοχών": [29,[30,31]],
"aa": [6],
"ab": [6],
"sure": [[3,13]],
"ad": [13],
"ae": [6],
"af": [6],
"πρότυπη": [[1,10,16]],
"αντικαταστήστε": [28],
"ak": [6],
"δυνατότητές": [10],
"diff": [29],
"automat": [13],
"am": [6],
"an": [13,23,6],
"editmultiplealtern": [8],
"προγραμματισμού": [1,[2,19]],
"πρότυπο": [29,15,26],
"απλούστερο": [26],
"συνεργάζεται": [[2,28]],
"ar": [6],
"as": [13,[3,6]],
"at": [13],
"matchers": [30],
"αποθηκεύθηκε": [28],
"av": [6],
"hierarchi": [13],
"ay": [6],
"wln": [6],
"προτείνει": [10,26],
"az": [6],
"ba": [6],
"συμπεριέλαβε": [29],
"be": [13,3,[6,24]],
"αποεπιλέξτε": [[18,22,25]],
"bg": [6],
"bh": [6],
"top-level": [13],
"bi": [6],
"filters.xml": [13,[2,22]],
"διαμοιρασμός": [2,[28,31],30],
"bm": [6],
"bn": [6],
"μέγεθος": [29,[14,20]],
"bo": [6],
"κενες": [27],
"διανέμεται": [7,3],
"δημιουργός": [[2,19]],
"br": [12,[6,16]],
"bs": [6],
"ρηχής-μεταφοράς": [18],
"search": [24],
"τοποθετούν": [14],
"ανάλυση": [[18,29]],
"εξοικείωση": [[16,20]],
"by": [13],
"περιμένει": [16],
"αντιλαμβάνεται": [10],
"δίνετε": [16],
"θεωρήστε": [4],
"οσσετιανά": [6],
"segmentation.conf": [[13,20],[16,22]],
"panel": [16,1],
"έργων": [13],
"τέλει": [26],
"ca": [[6,16,18]],
"δημιουργήσει": [[16,22],28,[15,20]],
"cd": [16,20],
"ce": [[6,14]],
"öäüqwß": [24],
"fli": [28],
"ch": [6],
"απαγκυρώσετε": [29],
"cn": [16],
"familiar": [24],
"co": [6],
"cr": [6],
"cs": [6],
"cu": [6],
"σύρετε": [29],
"cv": [6],
"τοποικοποίησης": [14],
"cx": [23],
"cy": [6],
"έλεγχος": [26,2,[0,8,16,19,23,30,31]],
"αποδίδει": [25],
"apach": [[2,26]],
"ακόλουθες": [16,[12,29]],
"da": [6],
"adjustedscor": [29],
"font": [16,31],
"dd": [[20,28]],
"de": [[6,29]],
"ειδικά": [22,[0,12,20,25,29]],
"άκυρες": [16],
"κάνουν": [28],
"ειδική": [[14,16,20],[5,12]],
"τέτοιες": [14],
"extern": [13],
"f0": [19],
"f1": [19,29,[8,31]],
"do": [13],
"f2": [16],
"f3": [19,[8,31]],
"μεταφράζετε": [[28,29],[14,17,20],[10,12,25,27]],
"dr": [25],
"χμέρ": [6],
"f5": [[8,19]],
"κύριος": [28,31],
"κύριου": [29,8],
"φράσεων": [17],
"επιλογής": [22,16,[19,25],[12,26,27],[2,8,15]],
"dv": [6],
"εμφάνιση": [8,[29,30],[24,31],[14,15,16,19,28]],
"μεταφρσαθεί": [16],
"wol": [6],
"κίνδυνο": [28],
"dz": [[6,11]],
"επαναχρησιμοποιηθούν": [28],
"editundomenuitem": [8],
"κανονικών": [23,25],
"εμφάνισή": [29],
"κίτρινο": [[19,29]],
"όρους-κλειδί": [23],
"ee": [6],
"which": [13],
"u000a": [23],
"ειδικό": [[12,24]],
"τύπος": [31,12],
"αναθεώρησης": [28],
"τύπου": [17],
"el": [6],
"visualsvn": [2],
"belazar": [18,31,30],
"τύποι": [28],
"en": [[6,16,20,29]],
"eo": [6],
"μπορείτε": [16,29,12,24,2,[19,26,28],20,[14,17],25,[9,27],[0,1,7,10,22],[5,8,11,15,18,21,23]],
"es": [[6,18]],
"u000d": [23],
"et": [6],
"u000c": [23],
"eu": [6],
"διορθώνει": [[10,18]],
"integr": [13],
"επιλογές": [12,31,29,19,30,[24,27],[8,16,18,26],[21,25,28],[0,2,14,20,22,23]],
"παρεμπιπτόντως": [[2,28,29]],
"ορισμός": [[2,29]],
"γραμματοσειρά": [20,19,29,[14,31]],
"first-class": [1],
"παραγόμενο": [20],
"fa": [6],
"κατακερματίζονται": [25],
"inadvert": [13],
"ff": [6],
"stats.txt": [13],
"u001b": [23],
"παραλείψεις": [4],
"fi": [6],
"μέρους": [[4,29]],
"fj": [6],
"for": [13,1,[3,24,28]],
"exclud": [28],
"fo": [6],
"γίντις": [6],
"fr": [16,20,[6,18,25,26]],
"εντοπισμό": [[0,14,19,24]],
"content": [13,16,3],
"διαγράψετε": [28,[15,16,17,27]],
"κουτάκια": [27],
"fy": [6],
"απλούστερος": [16],
"alert": [23],
"applescript": [16],
"πως": [31,[11,14,16],[7,10,15,28,30],[4,17,18,27,29]],
"επαναφέρει": [19],
"ga": [[6,18]],
"επαναφορτωθεί": [28],
"gd": [6],
"class": [12],
"πολυάριθμες": [10],
"τυπογραφικά": [10],
"gl": [6],
"editoverwritetranslationmenuitem": [8],
"outputfilenam": [16],
"gn": [6],
"βιβλιοθήκες": [1],
"fijian": [6],
"aeiou": [23],
"gu": [6],
"gv": [6],
"κυρίου": [[19,29]],
"form": [13],
"υπογραμμίζεται": [0],
"αλφαβήτους": [20],
"σειριοποιηθεί": [1],
"ha": [6],
"restor": [13],
"προχωρημέους": [28],
"he": [6],
"γνώμη": [29],
"hh": [[20,28]],
"διαδικτυακή": [24],
"προσθέτει": [[26,29]],
"hi": [6],
"duser.languag": [16],
"ελεγχθεί": [2],
"ho": [6],
"πληθώρας": [28],
"αξίζουν": [2],
"easili": [14],
"hr": [6],
"εμφανισθούν": [[8,16,19,24,25,26]],
"tab-delimit": [15],
"ht": [6],
"hu": [6],
"σομαλέζικα": [6],
"μοναδικών": [29],
"βοηθήσετε": [9],
"εξάγουν": [28],
"hy": [6],
"κενού": [[8,14,23,25]],
"veri": [13],
"συστήνουμε": [2],
"hz": [6],
"file-target-encod": [12],
"fra": [6],
"oci": [6],
"ia": [6],
"context": [29,19],
"διαφορετικούς": [28],
"briel": [[4,7]],
"id": [[6,29]],
"drag": [16],
"ie": [6],
"fri": [6],
"if": [13,3,[1,24]],
"ούτε": [[7,18,28],16],
"project_stats.txt": [29,2],
"french": [3],
"ig": [6],
"ειδικούτς": [14],
"τέλος": [5,23,[8,16,17,25]],
"ocr": [[19,22]],
"μηνυμάτων": [2],
"ii": [6],
"επιστρέψει": [16],
"ik": [6],
"δυνατότητες": [[19,22,28]],
"καταλόγους": [2,[16,28],[15,22]],
"in": [13,3,[1,14,24],19],
"io": [6],
"ip": [16,31],
"termin": [23],
"έργου": [28,19,31,29,2,17,22,30,8,[10,16,20,26],12,[11,14,15,24],[0,1,25]],
"is": [13,[3,6,23,28]],
"it": [13,3,[6,15,24]],
"iu": [6],
"διαθέσιμα": [26,29,[12,16,19,23]],
"πεδίου": [[10,26,29]],
"odf": [14,[12,25]],
"διαθέσιμη": [[2,16],[10,19]],
"ja": [[6,16,28]],
"fsf": [7],
"multiterm": [15,31,30],
"gave": [3],
"jc": [4],
"απαράλλακτα": [27],
"odp": [14],
"γραφείο": [29],
"διαθέσιμο": [16,[8,20,29]],
"odt": [14,[19,22]],
"επιτρέψει": [[2,20]],
"librari": [13],
"κανόνες": [25,31,10,22,[12,14,16,30],[0,18,23,29]],
"jp": [21],
"επεξεργασία": [19,[12,31],16,[28,30],[8,29],[14,17,20,27]],
"nplural": [12],
"js": [1],
"διορθώνονται": [10],
"μη-κενού": [23],
"χαρακτήρα": [23,5,[16,25],[12,15,24,27]],
"jv": [6],
"εικονιδίων": [16],
"ορθογραφικός": [26,31,10,[0,8,18,19,20,30]],
"learned_words.txt": [[2,13]],
"πηγή": [[19,28,29],31,[16,24],[14,20,27,30]],
"ρήματα": [18],
"προτογαλικά": [16],
"maxym": [7],
"φέρετε": [19],
"ka": [6],
"υπολογισθούν": [29],
"επεξεργασίς": [19],
"συγχωνεύσετε": [28],
"σωστές": [28,[16,17,26,27,29]],
"kg": [6],
"κύριας": [28],
"εσθονικά": [6],
"ki": [6],
"προχωρημένους": [[10,20,23]],
"kj": [6],
"υλικού": [2],
"kk": [6],
"προσθέσουμε": [2],
"kl": [6],
"km": [6],
"uyghur": [6],
"ορίσει": [16,[8,10,12,18]],
"kn": [6],
"ko": [6],
"νέων": [[8,19]],
"ελλεττωματικού": [28],
"kr": [6],
"ks": [6],
"viewdisplaymodificationinfoallradiobuttonmenuitem": [8],
"ku": [6],
"ποτέ": [12],
"ποσό": [16],
"kv": [6],
"kw": [6],
"ky": [6],
"ασαφή": [17],
"διότι": [28,12],
"τύπων": [12],
"la": [6],
"lb": [6],
"καναδά": [16],
"lg": [6],
"έναντι": [19],
"ful": [6],
"li": [6],
"dswing.aatext": [16],
"αντιστοιχίζεται": [[12,25]],
"αποφύγουμε": [27],
"ln": [6],
"lo": [6],
"αβεστανικά": [6],
"αναθεωρήσεων": [2],
"οποιωνδηποτε": [2],
"ls": [13],
"lt": [6],
"lu": [23,6],
"dist": [16],
"lv": [6],
"while": [13,28],
"ακόλουθοι": [2],
"that": [13,3],
"cycleswitchcasemenuitem": [8],
"ήμουν": [25],
"mb": [16],
"κέρδος": [2],
"επισημαίνει": [[2,29]],
"than": [16],
"mg": [6],
"τροποποιεί": [16],
"καθορίσει": [26],
"mh": [6],
"mi": [6],
"mk": [6],
"εφαρμόσει": [12],
"τρέχοντος": [29,19,27,[1,24,31]],
"ml": [6],
"mm": [[20,28]],
"entri": [1],
"mn": [6],
"αντίθεση": [18],
"πιστεύετε": [[20,28]],
"διασπασθεί": [25],
"γραμμένες": [29],
"άνοιγμα": [24,19,16,[5,8,10,31]],
"mr": [25,6],
"ms": [[6,25]],
"mt": [18,[6,10]],
"διαβασθεί": [28],
"thai": [6],
"wxl": [14],
"my": [[6,13]],
"διαφέρουν": [16],
"στυλιστικά": [10],
"προσωρινά": [29],
"chosen": [13],
"ορθογραφικών": [26,[30,31]],
"na": [6],
"nb": [6],
"nd": [6],
"ne": [6],
"περιορισμό": [16],
"ng": [6],
"updat": [13],
"ανεξάρτητα": [[12,19,27,28,29]],
"nl": [[6,28]],
"στόχευε": [18],
"nn": [[6,20,28]],
"no": [12,[0,6]],
"προσαρτηθεί": [19],
"code": [8,[13,18]],
"nr": [6],
"δυνατές": [[3,10]],
"αντίθετο": [[14,18]],
"πατείστε": [29],
"υποβοήθηση": [30],
"nv": [6],
"ελεγξετε": [25],
"αντίθετα": [29],
"gotohistoryforwardmenuitem": [8],
"κενά": [[10,12,15,16]],
"ny": [6],
"κενή": [25,[12,31]],
"διαφυλάσσεται": [28],
"oc": [[6,18]],
"αργότερα": [[16,17,22],[12,19,27,28,29]],
"od": [14],
"of": [13,[16,28],[3,14,20,24]],
"πατήματα": [[8,27]],
"διαστήματα": [[12,19,23],[14,15,20,25,29]],
"possibl": [13],
"oj": [6],
"βλάβη": [15],
"ok": [2,[16,17]],
"om": [6],
"on": [13,3,28],
"σημαντικών": [20],
"τσεκάρατε": [22],
"αλγορίθμων": [8],
"χειρισμού": [19,29],
"or": [13,8,28,[6,19,22,24]],
"ειδικοί": [22],
"os": [16,[3,31],13,30,[2,6,10,14]],
"ot": [14],
"πλειοψηφία": [[2,25]],
"σύγχυση": [[0,28]],
"κενό": [[2,27,28],[12,15,25,29]],
"οδηγήσει": [12,[27,29]],
"σάνγκο": [6],
"αντιπροσωπεύει": [25,12],
"oji": [6],
"περιστάσεις": [24,[22,26,28]],
"pa": [6],
"editinserttranslationmenuitem": [8],
"περιέχεται": [29],
"pc": [16],
"διεξάγονται": [24],
"στιγμή": [18,[2,3,12,14,17,22,24,28,29]],
"επιπτώσεις": [22],
"υποβιβάζεται": [28],
"pi": [6],
"σλοβενικής": [18],
"διατηρηθούν": [[12,16]],
"pl": [6],
"po": [12,29,14,[28,31]],
"ψευδο-ματαφρασμένη": [28,[30,31]],
"δεδομένα": [[2,18,20,27],[3,15,16,19,28,29]],
"μετονομασθεί": [28],
"ps": [6],
"pt": [[6,16,18]],
"δεδομένη": [25,28],
"ουδέτερο": [3],
"ρυθμίσεων": [[16,20],[26,29,31],[19,22,28,30]],
"επανεκκινηθεί": [8],
"δεδομένο": [28,20,16,[14,18,21,22,29]],
"factori": [13],
"κωδικοποιημένα": [21],
"είνα": [28],
"μεταβλητών": [29],
"necessari": [13],
"στιγμιαίος": [29],
"λόγους": [19,[2,15,28]],
"εγκατάσταση": [16,31,[26,30],3,[0,1,10,18,29],[17,19,20]],
"κατεβάσετε": [[0,1,2,16]],
"σκοπιά": [[12,14]],
"λείπουν": [29],
"they": [13,24],
"αντιστοιχίσει": [23,[12,24]],
"διευκολύνει": [21],
"qu": [6],
"χώρου": [[8,14]],
"edit": [3],
"varieti": [14],
"editselectfuzzy5menuitem": [8],
"προσπάθεια": [[9,15,27]],
"ορισμένων": [21],
"ταυτόχορνα": [2],
"x_windows_without_jre.ex": [16],
"them": [13],
"επιβεβαιώστε": [16],
"then": [13],
"θυμάστε": [17,[9,30]],
"χρωμάτων": [14],
"διάδοση": [22],
"εξάγεται": [19],
"άρνηση": [23],
"includ": [13,28],
"παραβλεφθεί": [12],
"τουρκικά": [6],
"πόρους": [[9,10,29]],
"privaci": [16],
"ορατά": [9],
"rm": [6],
"εφαρμόζεται": [28],
"rn": [6],
"ro": [6],
"βρουν": [12],
"κεφαλίδα": [12],
"minut": [4],
"ru": [6],
"χερίζεται": [14],
"ακολυθήστε": [14],
"ορφανές": [28],
"rw": [6],
"optionstranstipsexactmatchmenuitem": [8],
"ευρετήριο": [31,4],
"δουλειάς": [22],
"sa": [6],
"sc": [[6,23]],
"sd": [6],
"se": [6],
"sg": [6],
"πτυχή": [17],
"si": [6],
"τροφοδοτούνται": [16],
"sk": [6],
"sl": [[2,6]],
"samuel": [[4,7]],
"sm": [6],
"αντικαταστήσει": [[18,19,28]],
"sn": [6],
"ορίσθηκαν": [[15,16]],
"so": [3,6],
"sq": [6],
"λεποτομέρειες": [14],
"sr": [6],
"ss": [6],
"st": [6],
"su": [6],
"ακύρωση": [16],
"sv": [6],
"sw": [6],
"onc": [13],
"one": [13,[19,20]],
"reinstal": [13],
"καθορίστε": [[16,21]],
"ώρες": [[20,28]],
"επίσημο": [30],
"δουλειές": [[28,29]],
"ta": [6],
"editoverwritesourcemenuitem": [8],
"λέξεων": [29,15,30,[0,3,10,17,19,24,31]],
"εγγενείς": [28],
"te": [6],
"απευθύνεται": [23],
"αρχίσατε": [28],
"εξέλιξη": [29],
"tg": [6],
"υποβολή": [2],
"th": [6],
"μορφολογική": [18],
"saṁskṛta": [6],
"ti": [6],
"ναούρου": [6],
"tk": [6],
"tl": [6],
"tm": [28,[29,31],[2,24],17],
"παρατίθεται": [[8,16]],
"tn": [6],
"to": [13,3,16,20,[24,28],[1,6,8,14]],
"v2": [18,[16,31]],
"tr": [6],
"ts": [6],
"tt": [6],
"συγγραφής": [20],
"document.xx": [12],
"αναγνωρίζονται": [[10,17]],
"στήσατε": [2],
"tw": [[6,16]],
"ty": [6],
"αναγνωρίζοντας": [3],
"επεξεργάσιμο": [5],
"hmxp": [14],
"θεωρήσει": [21],
"projectwikiimportmenuitem": [8],
"κοινότητα": [2],
"countri": [16],
"gaelic": [6],
"ug": [6],
"αναίρεση": [19,8],
"εικόνα": [31,[0,24,26]],
"uk": [6],
"yahoo": [[9,13]],
"sinhales": [6],
"disambigu": [18],
"αλφαβητική": [28],
"γίνει": [16,2,[20,25,28],[12,19]],
"un": [15],
"έργο": [28,31,[19,22,29],2,20,[12,16],17,15,9,[24,25],[1,10,26,30],[3,8,13,14,18,27]],
"reluctant": [30],
"ur": [6],
"us": [18],
"μετα-ετικετών": [12],
"usual": [13],
"γυρίσει": [16],
"uz": [6],
"μπντέλου": [18],
"μη-διαχωρίσμων": [19],
"έργα": [[2,28],31,[3,5,10,16,17,19,22,30]],
"this": [13,[3,16,23,24]],
"vc": [2],
"εξασφαλίζει": [[2,16]],
"υπάρχουσας": [[15,27]],
"ρυθμίσετε": [19,[10,12,25]],
"πολλαπλών": [[29,31],30,15],
"κειμένμου": [15],
"μεταξύ": [14,12,[1,19,27,29,30]],
"ve": [6],
"εναρμονίζοντας": [25],
"vi": [[6,16]],
"extract": [13],
"περιλαμβάνουν": [[12,29],[27,28]],
"αποκλειστικά": [[4,26]],
"διατηρείτε": [2],
"ουκρανικά": [6],
"vo": [6],
"κρατήσετε": [16],
"έκφραση": [12,[23,24]],
"διαδίτκυο": [[9,31],[1,8,30]],
"vs": [31],
"εφαρμόζονται": [25,0],
"drop": [16],
"διπλού": [16],
"καταχρήσεις": [16],
"προϊόν": [10],
"creationd": [29],
"wa": [6],
"υποχρεωτική": [12],
"we": [3],
"αγάπης": [4],
"αρχαρίους": [[10,17]],
"omegat.sourceforge.net": [16],
"groovy.codehaus.org": [1],
"wo": [6],
"δημιουργικές": [25],
"υλοποιείται": [18],
"backspac": [5],
"αποστέλλει": [18],
"choic": [13],
"εξαρτηθεί": [14],
"ίδρυμα": [7],
"ζευγών": [[12,18]],
"licens": [13],
"emac": [16],
"ori": [6],
"distribut": [13],
"κωδικοσειράς": [1],
"καθώς": [[28,29],[2,3],[10,14,15,16,17,19]],
"orm": [6],
"ουιγουρικά": [6],
"φράσεις": [[10,29]],
"xf": [16],
"xh": [6],
"επινοήσουν": [23],
"venda": [6],
"xp": [13],
"εισαγάγετε": [[15,17]],
"βελτιώνουν": [3],
"ενημερώσει": [[2,20]],
"xx": [16,12],
"xy": [23],
"sourc": [13,28,3,[1,14,16,31],17],
"δεκαδικό": [27],
"type": [[1,8,13]],
"βήμα": [[2,9,29]],
"υπερθετικός": [3],
"στήλες": [15],
"oss": [6],
"volker": [7],
"yi": [6],
"κατάτμησης": [[22,25],[12,31],[3,10,14],[23,29],30],
"συνολικά": [[19,29],[22,31]],
"yo": [6],
"συνολική": [29],
"κλάσεις": [[23,30]],
"περσικά": [6],
"yu": [7],
"burmes": [6],
"τεχνολογία": [16],
"ενεργοποιήστε": [22,[12,31]],
"stylesheet": [1],
"μηχανής": [8,[10,18,29]],
"τόσο": [14,[28,29],[10,16,24]],
"αντικαθιστώντας": [12],
"είδη": [14,[12,25,29]],
"yy": [12],
"τελευταίο": [19,[4,24,28]],
"πάντοτε": [[22,25]],
"κόκκινη": [12],
"εγκαθιστάτε": [31,11,30],
"ενημερωμένο": [[2,14]],
"σύνταξη": [1,[8,25],[3,12]],
"χρησιμοποιηθούν": [[2,12,28]],
"αραγονέζικα": [6],
"za": [6],
"otp": [14],
"κατηγορία": [28],
"κόκκινο": [2],
"δημιουργεί": [19,16,[2,12]],
"zh": [6],
"ott": [14],
"σύνταξή": [25],
"exist": [13,24],
"συχνά": [17,[2,10,12,14,28]],
"δημοσιεύεται": [7],
"περιορίζει": [24],
"penalti": [28],
"εξαίρεσης": [25,31],
"ήταν": [4,[14,28,29]],
"exact": [24],
"zu": [6],
"αντιστοιχούν": [28,29,[2,26]],
"τότε": [16,[24,28],[14,17,18],[10,12,15,19,20,25]],
"εντοπίζει": [[0,3,12,28,29]],
"τελευταία": [[16,24,29]],
"μπορούσα": [4],
"zz": [16],
"yiddish": [[6,18]],
"καλύτερο": [[28,29]],
"τόπο": [28],
"μπορούσε": [[4,20,28]],
"utf8": [15,21,[12,14]],
"καλύτερη": [18],
"copi": [13],
"out": [28],
"ενημερωμένα": [2],
"συγγραφέα": [24],
"παλιότερη": [20],
"καλύτερα": [[20,28]],
"ορθογραφίας": [26],
"κενές": [12,[8,25,27]],
"get": [[3,13]],
"statist": [13,31],
"άποψη": [[2,12,29]],
"packag": [13,3],
"λογιμσικού": [7],
"power": [12],
"αντικαθιστά": [19],
"ενημερωμένη": [2],
"ροή": [29],
"επικάλυψη": [16],
"σύγκριση": [29],
"πρόσθετο": [0,1,3,[30,31],28,[2,9,29]],
"στόχο": [[3,14],[12,17,27]],
"δημόσιας": [7],
"tag-valid": [20,16],
"κόσμου": [21],
"πολωνικά": [[0,6]],
"μονάδες": [[25,28],[10,19]],
"alway": [13],
"απλοποιώντας": [14],
"tokenizer": [30],
"μορφών": [[10,14,18,29]],
"help": [29,31,19],
"μότου": [6],
"ξαναγράψτε": [12],
"πρόσθετα": [[0,1],[3,10,19,24,31]],
"κενής": [27],
"u0009": [23],
"xhh": [23],
"u0007": [23],
"repositori": [2],
"προσπαθεί": [[12,27]],
"πρόσθετη": [16],
"έχετε": [16,[15,26],20,[2,29],[14,19,24,28],[9,10,11,17,18,21,22]],
"xho": [6],
"ετικετών": [19,[12,29],14,[8,17],[10,25,28,31]],
"ειδικών": [22,2],
"data": [13,28],
"καταβάσετε": [26],
"γλωσσάρι": [15,29,2,[17,19,30]],
"μη-ορατό": [12],
"xht": [14],
"lowercasemenuitem": [8],
"firefox": [26,1],
"lists.sourceforge.net": [9],
"συνεισφέρει": [[14,29]],
"translate": [30],
"μετακινείται": [19,25],
"μνημών": [28,31,30,22],
"αντιγραφή": [[19,29],[2,5,26,30,31]],
"εναλλάσσεται": [14],
"απαλό": [19],
"filepath": [29],
"μορφοποίησής": [28],
"εφόσον": [[0,27]],
"oasi": [14],
"σίγουρος": [25],
"αναφορές": [9],
"συνεχίζει": [[16,20]],
"λέγονται": [17],
"ψευδο-μεταφρασμένη": [28],
"χρόνω": [18],
"nl-zh": [28],
"like": [3,13,28],
"μήνας": [[20,28]],
"αγγλικών": [11],
"κανόνων": [25,22,[10,23,29]],
"ρωσικά-λευκορωσικά": [18],
"χρόνο": [[20,26,29]],
"προγράμματα": [14,[3,16]],
"μεταφράζονται": [10],
"αλλοι": [12],
"εξωτερικά": [19,[8,14,29]],
"ενδιαφέροντα": [10],
"προβάλλει": [16],
"εξωτερική": [2],
"επεξήγηση": [20],
"openoffic": [26],
"ψευδο-μεταφρασμένης": [28],
"ενεργοποίηση": [[8,12,18,19,22,26]],
"αλλού": [[26,28]],
"μετονομάσετε": [[12,26]],
"αναφοράς": [[10,28],[9,19,24]],
"send": [13],
"here": [13],
"note": [13],
"στίξεως": [25],
"ξαναφορτώσετε": [[12,25]],
"line": [13,23],
"link": [13],
"τιμοκατάλογος": [18],
"αποθηκευθούν": [[15,22]],
"μοναδικού": [29],
"helari": [[4,7]],
"δείτε": [31,29,25,[0,7,10,12,17,24],[5,9,27,28]],
"git": [2,28],
"σλοβενικού": [29],
"μετακύλιση": [5],
"xx-yy": [12],
"frisian": [6],
"βρίσκεται": [[16,19],29,28,1,[0,3,5,20,22,23,27]],
"κωδικοποιημένο": [[14,21]],
"χρήσης": [7,31,[23,30],[2,4,8,16,18]],
"will": [13,[3,4,24]],
"τροποποιημένο": [19],
"ρυθμίσεις": [16,[20,31],22,19,[12,17],[15,26,28,30]],
"virgul": [15],
"πετυχαίνοντας": [28],
"αντιστοιχίσουν": [23],
"αποτέλεσμά": [25],
"follow": [13,3],
"αποτέλεσμα": [[19,28,29]],
"optionsspellcheckmenuitem": [8],
"περιοχής": [31,29,[12,30],15],
"xlf": [14],
"αποκοπή": [19,[5,29,30]],
"μονάδας": [28],
"optionssetupfilefiltersmenuitem": [8],
"απαντήσεις": [9],
"υφίσταται": [16],
"προχείρου": [19],
"εντολών": [16,20,31,[3,30],[4,10,28]],
"wild": [24,31,[12,30]],
"εισαχθεί": [[15,24,25]],
"αυτό": [16,28,29,19,22,[2,10,18,27],26,[12,14,20,21,23],[3,15,17],[0,1,4,5,9,24,25,30]],
"altgraph": [8],
"ισοδύναμο": [[19,28,29]],
"πληκτρολόγηση": [17],
"δοκιμής": [28],
"ιαπωνικά": [[6,16,20,21,25,28]],
"εκτελέσετε": [16,[17,20,28]],
"your": [13,3],
"τάχιστα": [18],
"άχρηστος": [29],
"μεταφορά": [18],
"without": [13],
"αυτές": [28,[14,16],29,[10,12,19,24,26,27]],
"these": [13],
"μεγέθους": [[14,20]],
"διορθωτής": [26,[10,31],[0,18,20,30]],
"παλαιοεκκλησιαστικά": [6],
"ιαπωνική": [25],
"αυτήν": [26],
"xml": [14,1,12,[13,15,18]],
"επιδείξει": [12],
"τρίτη": [[15,29]],
"δοθεί": [[16,20]],
"τσόγκα": [6],
"ασφαλείας": [28,20,31,16],
"gla": [6],
"αυτα": [25],
"περιηγηθείτε": [29],
"αυτά": [28,29,10,[20,27],[2,3,5,12,13,14,16,25,26]],
"gle": [6],
"καταχωρήσεις": [15,29,[1,8,12,19,30,31]],
"αυτή": [16,19,[12,28],2,29,[10,27],[14,15,20,21,25],[11,17,18]],
"sometim": [13],
"glg": [6],
"χρήσεις": [2],
"πουεισάγει": [5],
"δίσκου": [28],
"μεγιστοποιεί": [29],
"reluct": [23],
"αρχίζετε": [[10,16,28]],
"σουηδικά": [6],
"βιαστικούς": [10],
"αυτής": [[25,28]],
"εγγραφούν": [2],
"glv": [6],
"ελαχιστοποιημένες": [29],
"επάνω": [16,[2,25]],
"befor": [25,13,28],
"επαναλήψεων": [29,19],
"συμπερίληψη": [29],
"τερματικό": [16],
"επαναφορτώνετε": [28],
"tar.bz": [11],
"xltx": [14],
"ορίσματα": [31,16,[18,20]],
"ιδέα": [29],
"όλοι": [[12,21]],
"chapter": [13],
"συντομογραφημένη": [2],
"παίρνοντας": [29],
"χρησιμοποιήσει": [16,[10,18],[15,20,28]],
"μένει": [4],
"εγκρίθηκε": [15],
"υπομενού": [[1,16]],
"δεξί": [2,29,[1,15,16,19,26,27]],
"ορισμένες": [[12,28]],
"χειριστεί": [[10,12]],
"εξαφανισθούν": [26],
"βρίσκονται": [29,[16,19,28],[2,15]],
"προηγουμένως": [[5,19,28]],
"εμπορευσιμοτητας": [7],
"xlsx": [14],
"ετικέτα": [12,[19,29]],
"ενεργοποιείτε": [19],
"απεριόριστη": [16],
"όταν": [[19,28],16,29,27,20,[2,14],[12,15],[10,17,22,25],[0,1,5,24],[18,23]],
"gnu": [7,13],
"νομικές": [31,7,[4,8,10,30]],
"έρων": [25],
"επισημαίνοντας": [14],
"target.txt": [27],
"εμπλακείτε": [[15,25]],
"σκοπός": [31,28,[16,20]],
"discuss": [13],
"όσους": [4],
"standard": [[12,13]],
"σεναρίου": [31,[1,27]],
"ακολουθούμενοι": [25],
"εφαρμογή": [[14,16],7,[10,15,20,21,26,29,30,31]],
"ακολουθούμενοο": [8],
"ακολουθούμενος": [28],
"wish": [[3,13]],
"επιθέτου": [3],
"nameon": [12],
"σλοβενική": [18,24],
"σλοβενικά": [[3,6,15]],
"απλότητας": [2],
"ακκολοουθούμενη": [25],
"προτιμώμενη": [29,[19,25]],
"pan": [6],
"avert": [13],
"προστίθενται": [16],
"αποδεσμεύει": [29],
"gotonextnotemenuitem": [8],
"υπόδειξη": [14],
"tar.gz": [16],
"εξαγωγής": [27,28],
"gpl": [7,11],
"trados": [30],
"list": [13],
"κοινού": [28],
"ανοιχτό": [24,15],
"λεξικού": [26,29,31,[2,15]],
"συναφή": [9],
"ακριβείς": [[15,19,24,29]],
"in-lin": [28],
"lisa": [15],
"ακόμη": [28,[2,4,16,17,19,22],[12,14,20,23,30]],
"azur": [16],
"ακόμα": [[15,29]],
"μορφοποίησης": [14,28,29,[17,19,22]],
"χρησιμοποιείται": [29,14,[1,8,12,19],[2,10,20,22,25]],
"λεπτομερώς": [19],
"rashid": [7],
"παραθύρου": [[19,29],16,[8,25,27]],
"λειτουργικότητα": [2],
"περισσότεροι": [12],
"ανοιχτά": [[24,29]],
"determin": [13],
"απαραίτητη": [14],
"navegar": [18],
"καταλαβαίνει": [28],
"πρακτική": [29],
"απαραίτητο": [[14,16],[2,15,26,29]],
"αλλάζετε": [14],
"κλειδί": [[18,24],16,5,[19,29,30]],
"ποιότητας": [28],
"τοποθεσίες": [28,16],
"μετακινήσει": [19,[22,29]],
"grn": [6],
"δημιουργία": [31,[1,19],2,28,[8,14,22,25,30],[0,9,15,17,18,27,29]],
"πλέον": [[16,22,28],29],
"μετατραπούν": [25],
"xtg": [14],
"bindownload.cgi": [16],
"απαραίτητα": [16,[9,11,14,18,29]],
"σφάλαμ": [28],
"προσθέτων": [1],
"μη-διασπάσιμων": [8],
"with": [13,3],
"pdf": [[1,19,22]],
"αναιρεί": [19],
"μετάφρασης": [18,29,19,10,[14,22,24,27,28],[13,17,20,31],[2,16]],
"δεύτερο": [29,[10,28]],
"there": [0],
"εκείνους": [12],
"αποπακετάρετε": [16],
"δεύτερη": [[8,15,16,28,29]],
"διαχειρίζονται": [2],
"κομμάτια": [[12,25,29]],
"επιλέγοντας": [[12,16,21,29]],
"γκρι": [19,17],
"toolsshowstatisticsmatchesmenuitem": [8],
"χωριστό": [19,29],
"μεγάλου": [20],
"viewdisplaymodificationinfononeradiobuttonmenuitem": [8],
"έρχεται": [16],
"ρόλο": [10],
"κεντροευρωπαϊκές": [21],
"e-mail": [9,13],
"πληκτρο": [5],
"προσαρμόστηκε": [3],
"period": [16,27],
"κωδικοσειρά": [3],
"επισημάνετε": [19],
"σελιδοδείκτες": [12],
"understand": [13],
"αντιστοιχισμένων": [29],
"ίντερνετ": [[10,29]],
"αμφότερες": [18],
"είτε": [28,27,[7,18,25,29],[2,22,23,26]],
"διαθέτουν": [12],
"ισχύει": [29,[2,12,18,19,20,24,28]],
"gui": [20,16,13],
"guj": [6],
"μεταφραστικκής": [20],
"στοίχιση": [14,[16,20]],
"regexp": [16,20,25],
"ομάδες": [10,[25,28]],
"δείχνουμε": [2],
"στήλη": [15,29],
"stemmer": [3,31],
"uhhhh": [23],
"είχε": [[20,25,28]],
"ουγγρικά": [6],
"πίσω": [19,29,1],
"αποφεύγετε": [[10,25]],
"moldovan": [6],
"ενδιαφέρουν": [17],
"optionssentsegmenuitem": [8],
"συγγραφέως": [29],
"ημέρα": [[20,28]],
"αμετάβλητες": [10],
"γιορούμπα": [6],
"χωριστά": [[2,14,25,28]],
"εντός": [28],
"dokuwiki": [14],
"εξοικειωθούν": [2],
"προτύπων": [[0,14]],
"πλήρεις": [19],
"charact": [24],
"αποσυμπιέσετε": [16,11],
"test.html": [16],
"δημιούργησε": [28],
"συμπεριφέρονται": [[5,20,25]],
"εκτεταμένα": [10],
"xxx": [28],
"ενσωματώνει": [28],
"smalltalk": [1],
"αλγόριθμος": [3],
"εκτεταμένη": [10],
"διαχειρίσιμες": [14],
"ant.apache.org": [16],
"νομίσματος": [23],
"σύρτε": [16],
"αρθρώματα": [16],
"παραμείνουν": [12,16],
"ψάχνει": [24],
"άλλου": [[2,16,28]],
"βασισμένες": [18],
"προσπαθήσει": [[12,16]],
"περιέχονται": [10],
"αντιγράψετε": [26,[16,17,28]],
"όλες": [28,24,[12,19,20,29],[1,16,18,22],[2,3,4,8,10,14,21,25,26]],
"διαχειριστής": [2],
"ολόκληρο": [[25,28]],
"pseudotranslatetmx": [[16,28]],
"διεργασία": [29],
"whether": [13],
"ομαδικό": [[2,31]],
"άλλοι": [15],
"start-up": [3],
"arno": [7],
"quantifi": [23],
"velasco": [7],
"παρέχονται": [[8,10]],
"targetlanguagecod": [12],
"ισπανική": [18],
"πληρωμή": [18],
"αρχεια": [28],
"ισπανικά": [26,[6,18]],
"μονάδα": [28],
"παρέχοντας": [29],
"pilpré": [7],
"nuosu": [6],
"υποβιβασθούν": [28],
"έρογυ": [28],
"διαχειριστές": [2],
"κριτήρια": [24],
"συντηρείται": [2],
"ανπεπαρκής": [18],
"γλωσσολογικών": [18],
"εφικτές": [14],
"websit": [13],
"παρέμβαση": [28],
"ομάδας": [2,28,[8,22,25]],
"κοντά": [28],
"συνδυάσετε": [24],
"tο": [26],
"συνεισφορών": [31,[4,9,30],[7,10]],
"υποβιβάζονται": [28],
"χρειάζονται": [[2,16,24,28]],
"χειρονακτικά": [[14,18,19,26,27]],
"θεωρείται": [[14,24,28,29]],
"creationid": [29],
"επεκτείνετε": [25],
"συνοπτική": [11],
"προδιορίζει": [12],
"θεωρείτε": [[9,22,28]],
"λέξεις-κλειδί": [24],
"σαs": [16],
"pli": [6],
"ολόκληρη": [12],
"αντιστοιχιζόμενο": [29],
"φινλανδικά": [6],
"εκκινητή": [16],
"ορθογραφικής": [26],
"όμοιας": [10],
"βλέπει": [15],
"παρόν": [3],
"βάλτετα": [[0,1]],
"διαφορές": [29],
"τσιτσέβα": [6],
"optionstagvalidationmenuitem": [8],
"φύλλων": [12,[15,29]],
"αντικειμώνων": [1],
"περισσότερες": [[16,23],[21,29],[7,18,19,22],[6,12,14,25]],
"ατελούς": [14],
"πρωτότυπα": [1],
"γεμίζει": [28],
"pt_br": [26,16],
"αναγνώρισης": [19],
"βολική": [28],
"σύστημά": [16,26],
"a-z": [23],
"διάθεση": [1],
"zoltan": [7],
"πεδία": [15,12,[14,16]],
"ασυνέπειες": [4,29],
"πεδίο": [29,[16,27],[12,19],[2,24],[20,26]],
"αγγλικά-καταλανικά": [18],
"onlin": [[18,26]],
"συγκεκριμμένα": [27],
"ιταλικά": [6],
"προεπιλεγμένο": [[19,29]],
"ταυτοχρόνως": [29],
"png": [16],
"αντί": [[8,16,17,19,21]],
"προεπιλεγμένη": [8,21,[29,31],[12,14,15,19,28,30]],
"γκικούγιου": [6],
"javascript": [1],
"mediawiki": [[19,29],8],
"αντικειμένων": [[1,25]],
"ποινή": [28],
"τμήματα": [28,29,19,25,24,31,10,22,14,[12,16,27],18,[1,9,17,20]],
"ξεκινάτε": [[20,22]],
"αυτού": [[2,15,17,21,24]],
"walloon": [6],
"αυτπή": [16],
"καμία": [19,15,[14,16,28,29],[5,8,17]],
"γίνεται": [16,31,[19,28],29,[12,20,30],[10,14,15,27]],
"must": [13],
"join.html": [13],
"προδιαγραφές": [12],
"διασπά": [[10,25]],
"κάντε": [16,12,2,[1,9,17,25,29],[15,19,22,26,27]],
"φυλάσσεται": [2],
"org.omegat.plugins.tokenizer.lucenefrenchtoken": [3],
"μεταγενέστερη": [7],
"pod": [14],
"πορσθέστε": [25],
"facto": [29],
"υπέρ": [2],
"υπολογίζονται": [29],
"απενεργοποιήσετε": [[12,19]],
"pol": [6],
"μεταγενέστερο": [14],
"σύνθετους": [23],
"αρχείο": [16,28,17,15,[12,19],29,[8,21],14,[11,20,24],[10,30],[0,1,2,3,18,26,31]],
"por": [6],
"σεναρίων": [1,31,[0,9,10,16,20,30]],
"επιστρέψετε": [[17,29],[12,19,24]],
"found": [[13,16]],
"αντιστοιχηθούν": [8],
"όρισμα": [[16,28]],
"παρουσιάσει": [17],
"χάρη": [19],
"αρχεία": [28,31,[12,14],16,29,[19,21],10,[2,17,20,26],27,[11,13,15,22,24],[3,25],[0,1,8,30],9],
"απαρίθμηση": [10],
"latest": [13],
"πρακτορείο": [[10,29]],
"ποιον": [3,[16,20]],
"πρόοδο": [[2,29]],
"αναφέρει": [[18,27]],
"παράγουν": [28],
"προς": [19,29,25,[5,14,20,27,28],[2,4,8,10,13,15,16,22,30]],
"project_name-omegat.tmx": [28],
"κάνοντας": [29,[1,12,14,16]],
"εκφράσεις": [24,23,31,[16,25],[11,29,30]],
"σύστημα": [16,2,[3,31],[0,5,12,15,21,30]],
"googl": [18,[16,31],[10,24]],
"opendocu": [12],
"αποθηκεύετε": [26],
"σχήμα": [29,[13,15,26],[0,11,12,18,22,23,24,27]],
"ομαδικά": [31,2,[3,5,30]],
"εξηγούν": [10],
"συνεδρίας": [22],
"ομαδική": [16],
"εμπλακούν": [28],
"ενώσετε": [9],
"διάκριση": [28],
"χώρο": [1],
"φροντίζει": [2],
"εντάξει": [28],
"δημοφιλή": [[1,2]],
"αντιγράφει": [19,29],
"εκτός": [23,16,5,[2,15,22,24]],
"κανόνα": [25,31,30],
"ισχυρά": [1],
"πολλαπλές": [10],
"οπποία": [26],
"sourceforg": [9,[8,13,31],2],
"εκτέλεσης": [18],
"εγχειρίδιο": [29,[10,19,30],[4,7,8,9,17,31]],
"structur": [13],
"μελλοντικών": [28],
"περικυκλώνουν": [17],
"ότου": [20],
"hat": [6],
"has": [13],
"keyword": [24],
"hau": [6],
"εγχειρίδια": [14],
"time-stamp": [29],
"given": [[13,24]],
"pre": [3],
"σκωτικά": [6],
"last": [28],
"editmultipledefault": [8],
"batch": [[13,16]],
"προορίζονται": [[16,28]],
"παρόμοιο": [[16,23]],
"editfindinprojectmenuitem": [8],
"εμφάνισης": [14,[19,29],[24,28]],
"έλεγχο": [2,[0,26]],
"μηχανή": [18,[1,24]],
"warn": [20,16],
"αμορφοποίητα": [27],
"αναζητήσεων": [18],
"sindhi": [6],
"technetwork": [16],
"γραμματικής": [0],
"μεταφραστή": [[14,28]],
"έξοδο": [[8,16,19,28]],
"βιετναμέζικα": [6],
"βασιζόμενο": [19,[10,12,16,26]],
"plural": [12],
"ότνα": [28],
"σχετικές": [[10,19]],
"βασιζόμενα": [12],
"γλυτώσει": [21],
"εργαλειο": [0],
"ξόζα": [6],
"μελών": [28],
"ιδια": [28],
"άμεσου": [2],
"συσχετιζόμενα": [29],
"miscellanea": [13],
"μάνξ": [6],
"συντομεύσεως": [8],
"αίτιανά": [6],
"παρόμοια": [[2,10,17]],
"δεξιά-προς-τα-αριστερά": [31,14],
"μηχανική": [18,19,31,30,[15,26,29]],
"jacob": [7],
"μηχανικά": [19],
"συντομεύσεων": [8,[19,30,31],[10,16],[5,7,9,29]],
"λάβατε": [29],
"ονομαστούν": [26],
"σύνδεσμοι": [12],
"αποεπιλέξετε": [28],
"παραγωγής": [10],
"υποκατάλογο": [[17,28],2,[16,20],[22,27,29]],
"επεξεργάζεται": [[12,18]],
"ποσοτικοποιητές": [23,30],
"τρεχόντως": [29,28,[5,10,14,19,22]],
"διορθωτή": [26,30,[19,31]],
"windows": [30],
"δήλωση": [12],
"χώρα": [16,28,[12,31]],
"interlingu": [6],
"διανομή": [16,7],
"ανάκτηση": [19,8],
"λεξικών": [26,[30,31],[10,11,29]],
"chang": [13],
"νυνόρσκ": [6],
"οδηγό": [[9,16,30]],
"quotation": [30],
"ένωσης": [28],
"καμια": [7,29],
"ορίζετε": [[16,19]],
"heb": [6],
"brune": [7],
"kanji": [21],
"καμιά": [11],
"ανοικτές": [29],
"όλων": [[16,29],[5,8,19,24,31]],
"program": [16],
"ανα": [28],
"αλλαγμένα": [28],
"ανά": [25,22,[28,29],[2,8,14,16,17,18,19,20]],
"pus": [6],
"παλιών": [19],
"keith": [7],
"σωστού": [16],
"her": [6],
"υλοποιημένα": [18],
"χωριστεί": [25],
"τίτλο": [24],
"τσέβα": [6],
"ευθείαν": [16],
"χτίζεται": [[16,31],30],
"πρακτικών": [16],
"ενημερωθούν": [[2,12,15]],
"πριν": [19,[5,16],[28,29],[2,8,14,15,17,18,20,25,26]],
"βασίζονται": [[3,10,11,18]],
"διορθώσετε": [[24,29]],
"right-click": [3],
"χρησιμοποιήσουν": [[2,12]],
"camtasia": [14],
"εστιάζετε": [10],
"αφάρ": [6],
"κατάφεραν": [18],
"μεταγλωττίζονται": [18],
"σινχάλα": [6],
"πατήσατε": [15],
"ντόνγκα": [6],
"κονσοόλας": [31],
"άχρηστες": [22],
"μνλήμες": [28],
"εκπαιδεύσετε": [26],
"έκδοση": [16,2,7,[18,28],20,[4,9,14]],
"doc-license.txt": [13],
"yid": [6],
"copyflowgold": [14],
"παραμέτρων": [4],
"γρήγορα": [[24,29]],
"διάλογο": [19,17,[12,20,26],[2,15,22,27,28,31]],
"φροντίδα": [4],
"άλλων": [[4,12,16,17]],
"κλείσιμο": [19,[8,29]],
"editor": [5,30,[0,1,2,6,10,21,27]],
"pseudotranslatetyp": [[16,28]],
"προτιμώμενο": [1],
"φίλτρο": [12,[14,22]],
"hhc": [14],
"κατ": [[9,16]],
"χρονική": [24],
"οθόνη": [16,[8,20]],
"αντιγράφονται": [19],
"καν": [7],
"hhk": [14],
"και": [29,16,28,31,[2,19],10,[14,15],12,18,24,20,[17,26],[1,25],[22,30],[21,27],[3,23],[0,4,9],[7,8],11,13,[5,6]],
"προσχέδιο": [4],
"καθ": [2],
"μετονομάστε": [[20,28]],
"φίλτρα": [12,22,31,21,[19,29],[8,13,14,17,30]],
"cycl": [8],
"από": [16,28,29,19,23,[12,25],14,18,2,[1,8,10],31,[5,21,26],[15,27],20,[3,22,24],[7,30],[0,4,11],[9,17]],
"πέντε": [[1,28]],
"ρυθμισεις": [20],
"απο": [[19,20,28]],
"αντιμέτωπος": [21],
"ορφανά": [28,31,[25,29]],
"javaapplicationstub": [[3,16]],
"projectclosemenuitem": [8],
"καταλήξουν": [28],
"όλους": [4,[18,23,30]],
"hin": [6],
"viewmarknonuniquesegmentscheckboxmenuitem": [8],
"αγγλικής": [18],
"χειρισθείτε": [28],
"hit": [[24,28],[22,23,29]],
"αγγλικές": [28],
"λευκορωσικά": [6],
"εσιάγετε": [19],
"προβληθεί": [16],
"titl": [[8,19]],
"proofread": [0],
"διεξαχθεί": [24],
"group": [13,[17,29]],
"πρσφέρει": [26],
"μορφή": [15,14,31,28,[10,11,12,29],17,[1,2,3,8,16,21,30]],
"tree": [13],
"προσχεδίου": [25],
"readme.txt": [[3,7,12,13]],
"δημοσίως": [9],
"σύγχρονων": [11],
"languagetool": [[0,30]],
"υπολογιστές": [2],
"αναγνωρίσει": [2],
"αναφορά": [9,[28,31],[10,29,30]],
"source.txt": [27],
"παρόλο": [24],
"files.s": [1],
"siband": [7],
"histori": [19],
"tigrinya": [6],
"exchang": [15],
"output-tag-valid": [16],
"βρετονικά": [6],
"projectlock": [2],
"request": [13,18],
"βραζιλία": [16],
"επφάνεια": [16],
"ανάδραση": [29],
"currseg": [1],
"υπολογιστής": [21],
"their": [28,[0,14,16]],
"generat": [13,20],
"χρησιμοποιήθηκε": [[2,24]],
"προεπιλεγμένοι": [25],
"κουτί": [22,[24,25],2],
"point": [12],
"κεφαλίδας": [12],
"καταστήσει": [22],
"δίγλωσσα": [[28,31]],
"general": [13],
"l4j.ini": [16],
"ασθενή": [1],
"δίγλωσση": [28],
"αλλάξετε": [[12,29],[16,22],[8,14,21,25]],
"δίγλωσσο": [10],
"υποστηριζόμενες": [14,12],
"υποστούν": [12],
"process": [[13,20]],
"θυέλετε": [28],
"attribut": [12,[25,29]],
"δίγλωσσω": [18],
"ορθογραφικού": [26,[19,30],31],
"clear": [24],
"κεν": [2],
"andrzej": [7],
"downloaded_file.tar.gz": [16],
"συγκεκριμμένο": [[16,20,22,26,28]],
"αποτελέσουν": [29],
"προϋπάρχοντος": [1],
"εναλλάσσοντας": [14],
"mean": [24],
"προεπιλεγμένου": [19],
"τσετσενικά": [6],
"υπόλοιπες": [29],
"γινεται": [27],
"νορβηγικά": [6],
"been": [13],
"αποθηκεύουν": [28],
"αντιστοίχησης": [[5,27]],
"dhttp.proxyhost": [16],
"εργαλεία": [31,[19,29],[18,28],[14,23],1,[8,10,25,30]],
"τεκμηρίωσης": [4,8],
"συμμετάσχετε": [9],
"διαθεσιμότητα": [18],
"hmo": [6],
"φυσικά": [26],
"στατιστικές": [[29,31],19,8,[18,30]],
"ενοποίηση": [14],
"μεταφραστικά": [[20,28]],
"αλβανικά": [[6,18]],
"αμφίδρομων": [8],
"αλλαγής": [25,[14,19,31]],
"δεσμίδες": [14],
"εργαλείο": [0,10,[1,18,28,30,31],[3,16,20,29]],
"μεταφραστική": [28,29,19,[2,10,20,22,23,25]],
"ignored_word": [31],
"αποεπιλέγοντας": [12],
"yor": [6],
"you": [13,[3,28]],
"λογότυπο": [19],
"αποκαταστήσετε": [20],
"στo": [28],
"απλός": [0],
"contient": [15],
"αμετάφραστα": [[19,22,24,28,29]],
"ενδεχόμενες": [2],
"combo": [12],
"εργοστασιακών": [31],
"τρόπων": [14],
"βρίσκει": [15,[16,19,23,24]],
"ελαχιστοποιεί": [29],
"αποφύγετε": [28,[2,14,20]],
"θεωρούνται": [29],
"unicode": [30],
"αμετάφραστο": [[19,27,29],[8,17]],
"απενεργοποιείτε": [19],
"σουάτι": [6],
"δομική": [18],
"troubl": [13],
"είδατε": [9],
"buloichik": [7],
"προβλέπεται": [16],
"πραγματικό": [29],
"θύρας": [16,31],
"optionsworkflowmenuitem": [8],
"τελεία": [23,25],
"how": [13],
"πραγματική": [[18,19]],
"releas": [[8,16]],
"peter": [7],
"αποφυγή": [2],
"προαιρετικά": [[16,20,28]],
"cordonni": [7],
"sparc": [16],
"λόγο": [[16,26,28]],
"μεταφράστε": [[12,17],[14,30]],
"μετά": [[16,25],2,[5,12,15,20,22,24,28],[8,14,17,19,23,26,29]],
"μεταφραστών": [[2,9,28]],
"εκτυπώνονται": [20,16],
"τοπική": [2,16],
"προτεραιότητα": [19],
"προορισμού": [19,28,[15,26],[22,24,29],18,16,20,[2,17,21]],
"μετα": [23],
"λόγω": [[2,22,28]],
"ορίσθηκε": [16,[12,29]],
"παραμετροποίησης": [12],
"τοπικά": [2],
"διαγράψτε": [[16,22,28,29,31]],
"προέλευσης": [28,29,[12,19],31,17,[15,27],22,[14,18,25],[8,21],24,[3,16],20,[0,1,2,5,10,30]],
"μεταφραστικό": [[10,28]],
"οριετε": [16],
"έκφρασης": [[20,23,30]],
"εγασίες": [21,[27,28,30,31]],
"δωρεάς": [31],
"πατώντας": [29,17,19,[1,14,27]],
"sandra": [7],
"ενόσω": [[12,20]],
"δωρεάν": [[10,11,18,26]],
"προαιρετικό": [28],
"υποστηριζόμενων": [[0,29]],
"προορισμπύ": [26],
"αλλαγές": [[16,25],[2,12],[14,28],[15,19,20,22]],
"τρέχει": [[16,21]],
"ενσωματώσετε": [14],
"διαμοιράζονται": [2],
"αναντιστοιχίες": [4],
"προκαλεί": [14],
"εκφράσεων": [23,25],
"rtl-ltr": [5],
"γράμματα": [[19,29],8,[23,28]],
"κάναντα": [6],
"δέσμη": [20],
"αναρωτηθεί": [4],
"βρει": [20,[0,24],[8,10,16]],
"περιβάλλοντος": [2],
"τονίζονται": [29],
"κλπ": [14,[25,28],[15,16,19,22,24],[0,2,3,11,12,23,29]],
"κάνει": [[2,21,26]],
"επαναφορτώνεται": [[15,20,28]],
"prior": [4],
"σάς": [16],
"ούρντου": [6],
"επικολλά": [19],
"ενφανίζει": [19],
"προβαλλόμενο": [29],
"ψευδο-μετάφραση": [28],
"γράφεται": [3],
"hrv": [6],
"παραβλέψει": [12],
"ορίστηκαν": [8],
"take": [13],
"σαφή": [4],
"συνεργατική": [2],
"κανένας": [15],
"επειδή": [[1,12,24,25]],
"κιργιζιανά": [6],
"file-source-encod": [12],
"συνδέσετε": [16],
"επιστρέφει": [[16,20]],
"προχωρημένοι": [16],
"some": [13,28],
"συντομεύσεις": [19,8,[30,31],10,[16,29],[5,15,22]],
"οδηγός": [10],
"session": [13],
"οδηγήσουν": [28],
"τήρηση": [29],
"vilei": [7],
"διαδίκτυο": [31,[10,18,26]],
"δώσετε": [17],
"tang": [7],
"μεταβάσεις": [28],
"δουλέψει": [26],
"εκδόσεις": [16,28,[4,15,23,26]],
"βασικά": [[14,26]],
"ήμισυ": [25],
"βασική": [16],
"just": [13,[3,24,28]],
"συγκεκριμένα": [12],
"συμβολοσειρά": [24,[15,29]],
"διαμοιράζεσθε": [2],
"πλήρως": [28],
"αντιστοιχίσεως": [20],
"κινυαργουάντα": [6],
"κεφαλαίων": [10,[16,24,30]],
"πρότινος": [25],
"διορθώστε": [29],
"κατεύθυνση": [14],
"αντιστοιχίσεων": [31,29,28,19,[3,30]],
"χρεαστείτε": [17],
"editexportselectionmenuitem": [8],
"λαμβάνετε": [20],
"σασς": [2],
"ουαλικά": [6],
"ανάμεσα": [29,[15,19,28],[20,23,27]],
"επανειλημμένα": [29],
"περίληψης": [29],
"home": [13,[5,16,20]],
"ανάμεσά": [[16,29]],
"michael": [7],
"φρυσικά": [6],
"βασικό": [10,15],
"χρήσιμος": [12],
"build.xml": [16],
"εσείς": [10,[19,21,27,28]],
"καθορίσετε": [16],
"hun": [6],
"τρόπςο": [14],
"αντιστοιχίζονται": [[15,19,23]],
"καλούδια": [16],
"λεξικό": [[11,26],[2,10,30]],
"θέματα": [20,[2,6,10,26,30,31]],
"τακτικά": [[20,28]],
"πληκτρολογήστε": [16],
"εμπλέκουν": [19],
"μπασκίρ": [6],
"συμπιεσθούν": [28],
"έχουν": [28,[14,22],[1,12,15,16,17,19,29],[2,10,21,24,25]],
"x_windows.ex": [16],
"επανάχρηση": [28,31,30],
"μετατροπές": [14],
"διαδοχικές": [19],
"μπροστά": [29],
"προσωπικές": [10],
"aligndir": [[16,20]],
"system-host-nam": [12],
"μπορέσει": [[16,20]],
"επικυρώνετε": [14],
"σαν": [28,[1,16,24,25],[2,14,29],[3,10,12,18,20,21,27]],
"creat": [13],
"python": [1],
"προτάσεις": [10,29,[4,25,28]],
"θηλυκό": [3],
"λεξικά": [26,31,11,30,29,[10,15,23]],
"es_mx.dic": [26],
"πρακτικώτερος": [16],
"χάσετε": [29],
"abil": [13],
"διπλούν": [29],
"δύναμη": [3],
"μη-άπληστοι": [23,30],
"infix": [14],
"προσαρμογή": [[22,29]],
"τυχερός": [29],
"bell": [23],
"αποτελούν": [9],
"πλεονεκτική": [25],
"μοιάζει": [16,[3,17,29]],
"τίποτε": [23,[5,18],0],
"συνηθέστερες": [9],
"ανάπτυξη": [[16,23,31]],
"ανοικτού": [[0,1,10,18,28]],
"πλατφόρμες": [[10,16]],
"χάριν": [25],
"καλείτε": [29],
"δώσει": [16],
"tarbal": [11],
"πλάγιους": [12],
"λογικοί": [[23,30]],
"hindi": [6],
"σας": [16,17,28,29,2,19,10,26,18,21,[20,25,27],12,[4,8,22,24],[9,15,30],[1,3,5,14,23]],
"κωδικών": [[6,28,30]],
"απαρχαιωμένος": [29],
"βάλτε": [16,[19,24,28]],
"συγχρόνως": [[1,10,14,16,25]],
"omegat-development-request": [9],
"περιιοχή": [31],
"οποιουσδήποτε": [15],
"ειτκέτας": [28],
"λογαριασμός": [9],
"προτεραιότητας": [25,31,30],
"πρωτεύοντος": [16],
"αυξήσετε": [25],
"συνήθως": [16,[14,20],[1,10,28]],
"file": [13,31,1,[3,16],[12,28]],
"μελη": [2],
"member": [13],
"προσβάσιμες": [19],
"παρέχει": [18],
"ενοχλούν": [24],
"λατβιανά": [6],
"αφού": [16,[15,22,29],[2,17,20],[10,25,28]],
"φορτώστε": [[1,14,16]],
"meni": [15],
"πηγαίας": [24],
"within": [13],
"case-insensit": [23],
"σχόλια": [12,15,[29,31]],
"προέκταση": [15],
"catti": [3],
"menu": [[8,29],[13,15]],
"εφικτός": [28],
"ασσαμέζικα": [6],
"κωδικός": [8,28,[12,16,26]],
"γλώσσας-χώρας": [25],
"σχόλιο": [15],
"hye": [6],
"ρίναι": [28],
"υποχρεωμένος": [18],
"a-za-z": [23,24],
"κωδικόμ": [28],
"προϊόντων": [14],
"στοίχισης": [[20,31],30],
"return": [[18,19]],
"παρακάμπτεται": [12],
"προχωρημένες": [24,31],
"τροποποιήσατε": [8],
"radio": [[24,29]],
"source-pattern": [[16,20]],
"συνημμένη": [19],
"χαρακτηριστικό": [[11,18,19]],
"παρακάτω": [12,[8,16],[1,19,29],[2,14,23,26,28]],
"find": [13,3],
"χρειάζεστε": [16,18],
"host": [[2,12,13]],
"errat": [13],
"απλού": [14,21,[15,31],[2,19]],
"χρησιμοποιήσετε": [16,[3,18,26,29],28,[2,8,12,15,19,22]],
"κσι": [16],
"chua": [7],
"εγχειριδίου": [[14,29]],
"μη-μοναδικού": [19],
"προηγ": [[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,31]],
"παρατηρήσετε": [2],
"προτιμάτε": [7],
"κείμενο": [29,14,19,28,[12,25,27],21,24,[5,10],[17,18,31],[1,2,3,4,15,22,23,30]],
"βρίσκετε": [[19,20]],
"κείμενα": [[10,19,27],[18,20,21,22,28]],
"προστασία": [7,17],
"πραγματικά": [[2,16,22]],
"ίγκμπο": [6],
"τρέξει": [1],
"χαρακτηριστικά": [10,[1,30]],
"xliff": [14],
"true": [16],
"επικόλληση": [[19,29],[5,30,31]],
"αρχεί": [[12,15]],
"ξαναμεταφρασθεί": [28],
"present": [13],
"δεδομένων": [20,[1,15,18,31],[2,10,14,22,30]],
"κλίσεις": [15],
"groovi": [1],
"μακροπρόθεσμα": [21],
"αποθηκευθεί": [[14,22],[12,20,28]],
"επανάληψη": [19,29],
"στοιχίσει": [16],
"multi-paradigm": [1],
"εντοπίσω": [4],
"αρχίστε": [[12,28]],
"πληροφορία": [14],
"επικυρώνεται": [29],
"transform": [1],
"execut": [13],
"ορίσετε": [25,[12,14,16,20,28],[3,15,29]],
"kmenueditor": [16],
"οτζίμπουε": [6],
"προβάλλονται": [15],
"κοινόχρηστες": [17],
"tortoisesvn": [2],
"συνθέτουν": [13],
"δείχνει": [29,[15,16],[10,11,18,19,21,24]],
"περίληψη": [10,30],
"χτίσετε": [[16,18]],
"τρόποι": [[2,15,16,21]],
"καλός": [3],
"abov": [3,13],
"βασικές": [16],
"διατίθενται": [[10,12]],
"master": [12],
"μετατροπής": [[14,21,22,27,31]],
"δείγμα": [20],
"επιλογή": [19,12,[16,31],[8,20],27,[5,29],[25,28]],
"kmenuedit": [16],
"σερβικά": [6],
"επιλεγμένο": [19,28,[1,17]],
"form-fe": [23],
"συγκεκριμμενο": [7],
"ρύθμισης": [[0,2,16]],
"επιλεγμένα": [28,[19,26,29]],
"τρόπου": [29,[4,16,20]],
"τρόπος": [16,31,20,[14,22,24,30]],
"xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx": [16],
"μνήμης": [28,16,10,20,[2,3,17,18,25,29,31]],
"writer": [17],
"προειδοποίηση": [16,[12,25,29]],
"ελέγχεται": [27],
"επιλεγμένη": [19,29,[8,16,18,28]],
"dalloway": [25],
"rubi": [1],
"παράθυρο": [29,31,19,30,24,2,[16,20,26],[12,22,28],[1,14,18]],
"χρειάζεσθε": [28,20],
"dzongkha": [6],
"ρητές": [4],
"ορολογίας": [15,10,[29,31]],
"προσωπικό": [16],
"διαδρομή": [29,16],
"cover": [13],
"reflect": [13],
"αναφοά": [10],
"πάρτε": [[16,20]],
"πιθανότερη": [29],
"σφάλμα": [[9,16,22,28,29]],
"επαναλήψεις": [29,10],
"ομάδος": [10],
"immedi": [3],
"κορεατικά": [6],
"βοηθητική": [28],
"ωραία": [23],
"βοηθητικά": [14],
"μαορί": [6],
"αναζητάτε": [20],
"therebi": [16],
"καλές": [18],
"βγαίνει": [19],
"μεξικανικά": [26],
"ατιήματα": [9],
"αμηχανία": [4],
"αν": [16,19,28,12,29,20,26,24,[15,18,22],[17,25,27],14,[1,2,5,8,10,11,21],[0,7,9,23],3],
"locmanag": [14],
"αρ": [15],
"ας": [[3,28]],
"regex": [23,30,12,31],
"meta": [8],
"keystrok": [8],
"declar": [1],
"πίνακας": [19,23,8,29,10,[5,6,14,30]],
"αποκλίνοντα": [18],
"τρίτης": [29],
"ευκαιρία": [24],
"παράθυρα": [31,29,30,24,[19,20]],
"σφαλμάτων": [9,31,[0,14,20,30]],
"βασισμένου": [27],
"ευαίσθητος": [29],
"πλαιότερης": [10],
"εκεί": [19,[16,29],[22,27]],
"προκαθορισμένες": [[23,30]],
"υποψήφιες": [28],
"διατηρούν": [14],
"μέση": [23],
"άμεση": [[14,20]],
"πλευράς": [2],
"global": [12],
"διαχωρισμό": [22],
"άμεσα": [16,12,25],
"βλέπετε": [1],
"σαφώς": [[18,20]],
"εισάγετε": [[16,19,27],[2,22,29],[12,15,23]],
"διαγράψει": [26],
"ευχαριστίες": [4],
"unless": [13],
"εκδόσεών": [18],
"γραμμένη": [25],
"χρώμα": [19,[14,29],[0,17]],
"μέσω": [[2,9],[27,29],[8,16,19]],
"οδηγιών": [12],
"κατακερματίζει": [25],
"free": [16],
"χρησιμοποιούν": [[12,19],[3,8,16,18,26]],
"γραμμένο": [21],
"οικονομική": [[9,31]],
"παρέμβει": [16],
"σλοβακικά": [6],
"ενεργοί": [12,25],
"ανγνωρισθούν": [15],
"κουρδικά": [6],
"συμπιεσμένου": [24],
"εντολή": [16,19,29,3],
"δεκτή": [28],
"μετακινούν": [5],
"αναβαθμίσετε": [[16,28]],
"επόμενου": [19],
"ibm": [16],
"fish": [3],
"ibo": [6],
"πρώτης": [1],
"ιστότοπο": [2,[17,18]],
"επαναφόρτωση": [[8,19]],
"παρά": [28,[25,26]],
"λινγκάλα": [6],
"συμβατό": [1],
"λάο": [6],
"δομή": [28,25],
"δημιουργούν": [28],
"αντίστροφο": [22],
"επιρροή": [14],
"μετακινεί": [19],
"μέρη": [29],
"αντίστροφη": [16],
"απαιτητική": [29],
"υποβάλετε": [9],
"ενεργοποιήσατε": [29],
"γαελικά": [6],
"jean": [7],
"διορθώσουν": [9],
"χέρι": [17],
"ικανοποιητικές": [18],
"ευρέως": [2],
"ενημέρωση": [2,[10,15,16]],
"συμβατά": [25],
"συμβατή": [16],
"λόγια": [28],
"εκ": [[2,4,19,22,29]],
"ελ": [18],
"εν": [[2,23],[1,11,18,22,26]],
"εξ": [[2,17]],
"θέλει": [25],
"καταχώρηση": [8,15,19,[16,18,20,21,23,27,28]],
"έστειλε": [18],
"κατάστασης": [29,19,[16,20,28]],
"εφ": [28],
"ido": [6],
"καστίλης": [6],
"τονίζεται": [29],
"idx": [11],
"μέσα": [28,16,15,[2,12,24,27,29],[3,5,10,17,19,26],[8,22,23]],
"πρώτες": [15],
"conflict": [28],
"que": [6],
"βοηθητικό": [11],
"qui": [15],
"λιγωτερες": [16],
"άλλες": [31,14,[10,16,20],[0,12,17,18,28,29,30]],
"εκδόσεων": [2,28],
"rule": [13],
"αποθηκεύσατε": [19],
"παρουσίασης": [12],
"linux": [16,31,[2,13],[10,15,20,23,29,30]],
"οποιασδήποτε": [29],
"checkout": [2],
"κοινών": [[2,29]],
"παραθέτει": [[23,29]],
"ομοιότητα": [28],
"χερέρο": [6],
"αναβαθμίζει": [28],
"επισημαίνεται": [29],
"κορυφή": [29,[23,24,25]],
"αναγνωρίσιμα": [28],
"παραμετροποίηση": [31,8,[9,30],[5,7,10,19,29]],
"αντιστοιχίσεις": [28,29,[19,27,31],[15,24,25]],
"περιγράφεται": [10],
"μεταφράσατε": [[19,29]],
"zha": [6],
"popup": [27],
"ifo": [11],
"διαδρομη": [16],
"λογαριασμού": [16],
"θα": [16,12,28,19,2,17,22,[24,26,29],15,25,20,14,1,[4,9,18,23,27],[0,21],[3,5,8,10],7,11],
"φέρει": [19],
"εκτιμήσεις": [29],
"έτοιμος": [10],
"zho": [6],
"μένα": [4],
"xx.docx": [12],
"κλίνονται": [3],
"herebi": [13],
"consist": [13],
"ταξινόμηση": [8],
"μετάφραση": [29,[18,19,28],[10,14,27],31,22,[8,20,30],16,[12,15],[1,2,13,25,26]],
"σχέση": [29,[17,26]],
"αρχειοθετήσετε": [28],
"δημιουργούνται": [[14,15,18,28]],
"ια": [28],
"βορ": [6],
"λεγόμενα": [[10,28]],
"υπολογίζεται": [29],
"μετάφρασή": [[17,29],[15,28],[12,14,19]],
"ιρλανδικά": [6],
"συναρτήσεις": [1],
"zip": [[3,13,16]],
"παραγωγικότητά": [25],
"compress": [13],
"hesit": [13],
"λακ": [18],
"αναφέρω": [4],
"λέιτουργικό": [16],
"επιθυμητή": [[16,19,29]],
"ibai": [7],
"επιθυμητό": [28],
"yahoogroups.com": [9],
"λογισμικό": [[0,2,7]],
"πρόέλευσης": [28],
"sdlxliff": [14],
"customer-id": [16],
"κα": [29,23],
"πιστοποιητικά": [2],
"δημιουργίας": [1,[3,31],[0,2,8,12,15,30]],
"κι": [[14,21]],
"διαπλατφορμικές": [16],
"επαναχρησιμοποιήσετε": [28],
"όμως": [22,[10,19,21,26,28]],
"στρατηγικών": [28],
"κπ": [2],
"πρώτου": [[19,25,29]],
"στιβαρή": [20],
"iii": [6],
"μάθετε": [17,[10,16,30]],
"τεράστιο": [26],
"requir": [13],
"μέλη": [2,28],
"προτάσεων": [12,[18,22,25,31]],
"επκύρωσης": [29],
"λογισμικά": [1],
"επιθυμίες": [5],
"kyle": [7],
"viewmarknotedsegmentscheckboxmenuitem": [8],
"αντιστοιχεί": [[12,21,23,26]],
"επιφάνεια": [[16,24]],
"tracker": [4],
"εφαρμμογή": [31],
"προέλευσής": [12],
"χρησιμοποιείστε": [29,19,[17,18,20,28]],
"event": [8],
"μη-μοναδικών": [[8,19]],
"τροποποιητής": [8],
"παραμέτρους": [[14,16],[20,21,28]],
"αδυνατεί": [28],
"τερματικού": [16],
"είστε": [18,[10,16,21,29]],
"δώστε": [17],
"subscrib": [9],
"υψηλής": [[12,28]],
"πρότυπες": [29],
"συγχρονίζει": [2],
"ειδάλλως": [[19,28]],
"εγγυάται": [10],
"στο": [16,29,19,28,2,12,9,[15,31],[24,26],[14,17],5,10,[1,27,30],8,[20,23],[18,21,25],3,22,4,11,[0,6]],
"επιβεβαίωση": [19,8],
"optionssaveoptionsmenuitem": [8],
"excel": [12],
"εγκατασταθούν": [26],
"τμημάτων-λόγου": [18],
"runn": [24],
"στη": [16,29,28,20,[14,18],[15,19],[2,9,12,17,25,27],[1,3,10,11,22,23,26],24],
"άπαξ": [23,[28,29]],
"με": [[16,29],28,19,14,10,12,[15,20],31,24,2,[8,22],[25,27],26,[7,21,23,30],[11,17],1,18,[5,6],3,[4,9],[0,13]],
"τοποθεσία": [31,16,[15,28],[20,24],[2,8,22,29]],
"μη": [12,[25,27],[2,15,16,20,31]],
"stardict": [11,31],
"στα": [16,[19,29],14,2,[5,28,31],[12,15,20,22,24],[18,21,25,27],[0,1,3,10,11,30]],
"first": [[13,24]],
"omegat.l4j.ini": [16],
"span": [12],
"προσκήνιο": [19],
"δεδομένης": [28],
"πιθανώς": [23],
"prefer": [13],
"ασυμβατότητες": [19],
"quotat": [23],
"hans-pet": [7],
"ενεργού": [5],
"overridden": [13],
"iku": [6],
"pijffer": [7],
"να": [16,28,29,12,2,25,14,19,17,[15,20],10,[26,27],8,22,18,9,24,31,1,[11,21],23,4,[3,30],[0,7],5],
"zakharov": [7],
"συν": [18],
"simpl": [27],
"προπονητής": [23],
"νε": [16],
"εισαγωγή": [[19,30],31,8,[2,28],[10,14,17,27,29],[0,1,3,5,15,18],24],
"from": [13,3,[24,28]],
"λόγος": [26],
"hardwar": [20],
"thunderbird": [26],
"προτιμήσεις": [16,[8,10]],
"ile": [6],
"editselectfuzzy3menuitem": [8],
"you\'ll": [3],
"βιομηχανικό": [29],
"project.projectfil": [1],
"εκτυπώσει": [1],
"μείζον": [22],
"χρήσιμες": [[10,23],[16,17]],
"έκανα": [0],
"phillip": [7],
"πίνακες": [[6,8,14]],
"βρεθούν": [24],
"ιδιωτικό": [[2,16,18]],
"μείζονες": [25],
"ποντίκι": [0],
"κλικάρατε": [19],
"φτιάχτηκε": [18],
"περιορίζεται": [2],
"αιτιατική": [15],
"έννοια": [[25,26]],
"συντόμευση": [8,[14,16,19,29]],
"πληκτρολογήσετε": [16],
"error": [13],
"αιτήματα": [9],
"μεγάλες": [[18,29]],
"shortcut": [8],
"δανέζικα": [6],
"public": [13],
"χτιστεί": [18],
"array": [3],
"επεξεργάζεσθε": [29],
"εμφανίζουν": [29],
"στόχους": [27],
"οι": [28,29,16,12,[15,19],[14,25],10,[8,24],[2,22,23],[17,27],[1,26],[0,18,20],[3,4,5,9,21,31]],
"εκκίνησης": [16,[9,20,25,31]],
"απλών": [[10,21]],
"ina": [6],
"τώρα": [[2,8,16,27,28,29]],
"ind": [6],
"pt_br.aff": [26],
"τσεχικά": [[6,21]],
"αναζητά": [10],
"ελεύθερα": [17],
"ini": [14,[16,31]],
"ου": [28],
"απλώς": [[15,16,21],[1,9,12,25,26,28,29]],
"εσωτερική": [[19,29],22],
"δίνουν": [21],
"εμπλέκονται": [[2,28]],
"μετάφρασής": [20],
"προορισμός": [28],
"μεταβείτε": [[9,18,19,26,29,30]],
"συνεχόμενες": [28],
"εξοικειωμένος": [20],
"ελεύθερο": [7,[2,10]],
"dhttp.proxyport": [16],
"διαχωρισθούν": [25],
"trado": [15,31],
"αζέρικα": [6],
"ελεύθερη": [[2,11]],
"ορισμό": [8],
"πυ": [12],
"subrip": [14],
"πχ": [14],
"kangaroo": [10],
"χρήστης": [22,18,[8,9,10,19,29]],
"ταυτοποιηθείτε": [18],
"αυτόματα": [[2,16,19,27]],
"αντίστοιχοι": [14],
"υπηρεσίες": [16,18,[2,10,29]],
"κανούρι": [6],
"describ": [3],
"score": [29],
"παρεχόμενα": [18],
"αντίστοιχου": [12],
"ipk": [6],
"επόμενα": [2,[16,22]],
"όλη": [27],
"υποβολής": [2],
"βαθύ": [[15,24]],
"ενημερώνεται": [28],
"όλα": [[16,28],29,[1,19],[9,24],[0,5,14,17,22]],
"παλιότερες": [19],
"αυτόματη": [22,16,[12,27]],
"επόμενο": [19,27,[8,17],[2,11,15,16,24,28,29],[0,1,3,4,5,6,7,9,10,12,13,14,18,20,21,22,23,25,26,30]],
"προέρχονται": [29],
"αυτόματο": [14],
"χαμηλή": [8],
"σελίδας": [[8,14]],
"επόμενη": [[8,16,19,29]],
"όλο": [[19,21,29],[5,16]],
"πιθανόν": [[15,16,25]],
"aaa": [23],
"southern": [6],
"solari": [16,13],
"βάλατε": [19],
"μεταφραστής": [29,28,[12,14,25]],
"πρόγραμμα": [16,20,31,[5,14,30],[0,2,6,10,11,12,15,19,21,27,29]],
"επιτρέψετε": [28],
"manual": [13],
"χρησιμοποιώντας": [12,29,[1,11,18,19,20,22,24,25,26,27,28,31]],
"σε": [28,16,29,14,19,[10,20],2,[21,25],[15,17],[12,18],[1,22],31,27,26,[8,24],4,[3,5,9,11,23,30],7],
"aar": [6],
"διατηρούνται": [15],
"ταϊτιανά": [6],
"αρχείο-στόχο": [[12,14],1],
"κάνατε": [16,29,28,[18,19,22,24,27]],
"εκπαιδεύεται": [20],
"χειρισμό": [[10,21]],
"marshalles": [6],
"ερμηνεύσει": [21],
"επεξεργασίας": [31,29,27,19,14,12,[24,30],[5,10,15,16,17,20,21],[2,6,8,22]],
"εκκινεί": [16],
"τροποποιείτε": [7,14],
"μαράθι": [6],
"iστον": [2],
"εντοπίσει": [[12,15,16]],
"abc": [23],
"rcs": [28],
"μεταφραστές": [28],
"navaho": [6],
"abl": [13],
"abk": [6],
"τάϊ": [6],
"τα": [28,19,[16,29],12,2,20,26,[14,31],10,25,22,[15,23],24,21,[3,18,27],[11,17],1,[5,8],[0,9,30],4],
"πλήρους": [5],
"τη": [16,29,19,28,18,10,22,[12,14],[24,25],15,[2,4,26,27],1,[9,17],[0,3,20,30,31],[8,11,21,23]],
"τι": [9,12],
"δικούς": [2],
"σόνα": [6],
"επαναπροσδιορίσετε": [5],
"το": [16,29,28,19,12,2,20,25,[10,17],[15,18],[14,27],22,23,31,1,8,[21,24],26,30,7,0,[5,11],9,[3,4],13],
"μορφοποιημένο": [[10,14,17]],
"ψάξει": [17],
"ελέγχουν": [28],
"διαγράμματα": [12],
"ξαναχρησιμοποιήσετε": [12],
"μορφοποιημένα": [31,14,19],
"isl": [6],
"iso": [6,31,21,30,[5,10,15,20,25,28]],
"τω": [18],
"εξωτερικούς": [29],
"αποθηκεύει": [19,10,[16,20,21,28,29]],
"contribut": [13],
"υπηρεσίας": [18],
"πάρουν": [16],
"καταλανικά": [6],
"τσουάνγκ": [6],
"zul": [6],
"aggreg": [12],
"μακριά": [28],
"act": [13],
"παρουσιαστεί": [8],
"θεωρηθεί": [22],
"glossary.txt": [15],
"ita": [6],
"απώλεια": [[10,20]],
"υπ": [[19,22],[14,24,27,29]],
"προγούνται": [23],
"εξόδου": [[12,14]],
"μετατρέποντας": [18],
"περιλαμβανομένων": [29],
"εκείνον": [[22,28]],
"παραρτήματα": [[10,19]],
"add": [13],
"initi": [13],
"εγγράφεται": [19],
"αποτελείται": [29],
"equival": [13],
"δημιουργείται": [28,25],
"respect": [14],
"υπάρχει": [16,28,15,[1,14,19,20,27,29],[0,2,11,12,25,26]],
"μεταφράσθηκαν": [[28,29],18],
"αντιληφθεί": [27],
"εγκαταστήσετε": [16,[2,11,26]],
"larouss": [29],
"ελάχιστο": [19],
"untar": [11],
"μεταγλωττιστής": [14],
"ονομάζεται": [16],
"prevent": [13],
"benjamin": [7],
"καθημερινή": [16],
"filters.conf": [20,16],
"γραμμή": [16,29,31,20,[3,8,28,30],[10,18,19,23,25]],
"συμπεριφορά": [31,[27,29],[5,14,19,30],[8,10,12,16,21]],
"απενεργοποιημένη": [12],
"modifi": [[8,13]],
"όρο": [15,24],
"τρέχετε": [16,2],
"μοιάζουν": [24],
"εισάγουν": [28],
"αποδίδοντας": [23],
"παλιά": [6,28],
"διαχείριση": [[10,19],31,[1,2,14,18,27,28]],
"anyth": [13],
"afr": [6],
"μετακινηθείτε": [19,[17,29],5],
"επίλυση": [[18,31],[28,30]],
"αυτούς": [2],
"διάρκεια": [22,[10,25,28,29]],
"σόθο": [6],
"pgdn": [5],
"επαναλαμβάνει": [19],
"saboga": [7],
"αμφίσημο": [12],
"targetlanguag": [12],
"directori": [13],
"έστω": [22],
"αποθετήρια": [2],
"backup": [13],
"sensit": [24],
"αγνοηθεί": [[5,8]],
"χρέωσης": [18],
"διατηρείται": [[19,22]],
"ιαπωνικών": [19],
"properti": [13,[14,20]],
"κάπου": [28],
"έγγραφό": [15],
"εμπορικά": [27,29],
"σταδιακά": [28],
"συνεισφέρετε": [9],
"κεφάλαια": [10,29],
"fisher": [3],
"συμπεριφέρεται": [29],
"αποθετήριο": [2,[18,28]],
"ακριβής": [[24,29],[8,19]],
"μεταφορτωθεί": [15],
"number": [[12,13],3],
"όσα": [28],
"περιεχόμενο": [27,12,[1,15]],
"γαι": [12],
"ενεργοποιηθεί": [19,[0,10,22]],
"υποστήριξη": [9,[1,4,31]],
"simpledateformat": [12],
"ως": [28,29,16,19,[12,22],[2,15,21,25],[8,9,10,26],[3,14,18,23,27],[0,1,11,20,24,31]],
"μορρφοποίηση": [28],
"περιπτώσεις": [28,[14,20,22,25],[18,21,23,29]],
"αυστηρές": [28],
"ενδέχεται": [28,[15,16,20,25]],
"κεφάλαιο": [10,29,28,[18,22],[4,17,23,24,25]],
"troubleshoot": [3],
"έγγραφα": [28,[19,22],[25,27],[1,9,14,17,20,29]],
"κακές-μεταφράσεις": [27],
"αντικαταστείστε": [[28,29]],
"όσο": [[28,29],[14,23],[10,16,24]],
"τοποθετήστε": [26],
"μπορέσετε": [[2,10,18,26]],
"έγγραφά": [16],
"συντήρηση": [2],
"script": [13,31,[1,2,10,16,20,27]],
"ώστε": [14,28,[2,29],[10,24]],
"ισχυρός": [24],
"system": [[3,16]],
"spellcheck": [26],
"πρόληψη": [[20,31],[22,30]],
"επιλέχθηκε": [19,27],
"ενσωματωμένο": [26],
"αγνοώντας": [29],
"καθορισμό": [[10,22]],
"γλωσσολογικά": [18],
"γλωσσικών": [18],
"πούμε": [28],
"έγγραφο": [14,[1,29],[5,7],[2,10,12,17,19,30]],
"συνεχίσετε": [17],
"καταγεγραμμένα": [22],
"other": [13],
"επικίνδυνο": [24],
"διαιρείται": [29],
"μοναδικό": [[18,24]],
"προκαλείται": [18],
"khmer": [6],
"πλευρά": [18],
"ανταλλαγή": [15],
"local": [12,[2,14,16,20]],
"ότι": [16,28,29,18,[2,22],26,20,9,[5,15,17,25],[4,10,11,12,14,19,21,23,24,27]],
"αντίστοιχα": [15,2,[14,18,20,26]],
"ανάμειξη": [31,14],
"αποκατάσταση": [29],
"locat": [13,[3,16]],
"μηδέν": [23,[12,25]],
"τέλεια": [28],
"samoan": [6],
"cree": [6],
"επεξεργάσιμου": [5],
"μοναδικά": [29,22],
"θέσεις": [[1,14]],
"αντίστοιχο": [[12,16,29],[20,25]],
"περιεχόμενα": [2,[19,29],[15,16,20,27],[12,21,28]],
"περιεχόμενά": [28,2,[10,11,24,29]],
"πρόταση": [17,[0,22,25],[19,28]],
"τοποθεσιών": [19],
"αντίστοιχη": [0],
"προγραμαμτιστής": [1],
"προόδους": [20],
"θέματος": [[2,28]],
"τελούγκου": [6],
"aka": [6],
"υπολογιστικών": [12],
"εσάς": [22],
"αντίστοιχό": [11],
"μοναδική": [24],
"αρχίσετε": [[16,17,18,20,29]],
"παραγωγή": [18],
"καιρού": [26],
"σύνδεση": [[8,10,19,26]],
"tsonga": [6],
"μεταφέρει": [16],
"βέβαια": [[22,29]],
"αριθμ": [19],
"μη-διαχωρίσιμα": [19],
"es_mx.aff": [26],
"πρόσφατα": [[3,18,20]],
"επιλεγούν": [0],
"πρόσφατη": [[2,16],[9,20]],
"πληκτρολογείτε": [29,[14,15]],
"correspond": [13,3],
"πατήστερ": [19],
"όχι": [5,[16,23,29],[14,22,24,27,28],[2,4,15,18,19,20,21]],
"βρισκόταν": [5],
"mode": [16,20,14,31],
"συνέχιση": [9],
"εντόπιση": [[4,10]],
"toolsshowstatisticsstandardmenuitem": [8],
"φακέλλων": [22],
"all": [13,24],
"προγενέστερο": [28],
"της": [16,29,2,28,[19,20,31],[12,25],18,[5,22,24],[7,10,15,27],[14,26],[1,3,4,9,17],[0,8,23,30]],
"read": [13,12],
"την": [29,16,19,28,12,14,[2,25],[15,21],[7,18,20,24],10,1,31,3,[5,8],[4,23],[9,22,26,27,30],11,[0,17]],
"umarov": [7],
"διαθέτει": [1,[2,21]],
"alt": [5,[1,8,16]],
"εκείνες": [[23,28]],
"εργασία": [10,[2,19]],
"κομμάτι": [[16,18,19]],
"αλλάξουν": [19],
"ρυθμισθεί": [2],
"βέβαιο": [18],
"επιλεχθείσα": [19],
"διαμοιραζόμενα": [2],
"διαμοιρασθούν": [2],
"org.omegat.core.matching.token": [3],
"alreadi": [13],
"όψη": [22,[14,19,24,27,29]],
"εκτελέστε": [[16,20]],
"υποτίτλων": [14],
"wildrich": [7],
"pinfo.list": [18],
"εκτέλεση": [[18,29],[19,31]],
"amh": [6],
"collect": [[13,15]],
"μικρών": [[16,24]],
"βασίζεται": [2,[3,18,26]],
"unix": [19],
"επιτάχυνση": [28],
"χτίζει": [1],
"αφαίρεση": [23],
"περιλαμβανομένου": [23],
"πλοηγούμενοι": [29],
"παράμετροι": [[14,16,18,31]],
"βασίσθηκε": [18],
"λεξεις-κλειδιά": [1],
"τσαμόρο": [6],
"μηχάνημα": [20],
"roh": [6],
"παράγραφο": [[12,25],22,28],
"χρήστες": [16,31,30,19,[2,10,18],[12,14,17,20,23,28]],
"δρομέας": [5],
"μηχάνημά": [[16,20]],
"γωνία": [29],
"ron": [6],
"λίστα": [12,[19,21,23,24,26,27]],
"εμφανίζοντας": [19],
"καναδικά": [25],
"εϊναι": [1],
"and": [13,[3,24],14,[2,12,16,30,31]],
"είπαμε": [14],
"ταμίλ": [6],
"παραδίδουν": [28],
"μετάφραστικής": [25],
"πατά": [27],
"ani": [13],
"απολύτως": [[14,18]],
"έκδοσης": [2,30],
"αλληλεπιδράτε": [2],
"παράμετρος": [16,20],
"τις": [16,[28,29],19,12,10,14,[17,20],[2,22,24],18,[15,21,26,27],[3,4,25],[5,8],[1,30],[9,23,31]],
"ant": [16],
"ονομάζονται": [[10,26]],
"λέξεις-κλειδιά": [10],
"αποδεκτή": [[18,28]],
"επικυρωθεί": [19],
"πίνακα": [[25,29],12],
"προτυποποιημένη": [12],
"εμφανίζεται": [29,[12,14,19,28],[0,2,8,15,18,22,24]],
"application": [30],
"ορίστηκε": [0],
"παρακολουθούνται": [2],
"jnlp": [16],
"προόδου": [29],
"οποιωνδήποτε": [[10,14,18]],
"omegat.ex": [16],
"πλήρης": [[8,29]],
"reason": [13],
"επισημανθούν": [19,[2,28]],
"διαστάσεων": [19],
"για": [16,29,28,[12,19],25,2,14,18,[17,22],[10,26],23,20,8,[1,21],[3,9],15,[7,24,31],[0,11,27],[4,30],[5,6]],
"γραμματικά": [[3,10]],
"εμφανίζετε": [14],
"sourcetext": [29],
"ακριβης": [15],
"αριχκό": [28],
"κεντρικά": [6],
"γραμματοσειρές": [20],
"δρομέα": [5],
"δημιουργείστε": [17,[0,1,3,28,30]],
"μεταφράσει": [16,[17,20,26]],
"διαφορετικών": [[1,10,28]],
"jar": [16,20,[3,13],28],
"μετρητές": [29,[30,31]],
"παραδείγματα": [31,23,[16,30],25,[12,27]],
"api": [18,16],
"άπληστοι": [23,30],
"jav": [6],
"editselectfuzzy2menuitem": [8],
"ορίζεται": [[12,14,20,28]],
"app": [16],
"using": [30],
"assames": [6],
"ιστοσελίδες": [1],
"μερικές": [28,19,[20,29],[1,12,16]],
"τέτοια": [[27,28]],
"ζητήσετε": [29],
"λιμβουργιανά": [6],
"ακολουθείτε": [29],
"επέκτασή": [[11,14]],
"γραμματοσειράς": [20,[14,29]],
"ενσωματωμένος": [29],
"γραμής": [20],
"alex": [7],
"μη-μεταφράσιμες": [12],
"συνεχίστε": [4],
"θεωρούν": [19],
"επέκταση": [12,15,21,[11,14,28]],
"πολύτιμη": [4],
"μηχανικής": [18,29,19,31],
"στον": [16,[2,28],19,29,[17,20],[1,15,26],[0,27],[8,12,21,24],[3,4,5,11,14,18,22,30]],
"αντικαταστήσετε": [29,18],
"προσθήκη": [[12,16],[2,25],[1,15,29,31]],
"λογιστικό": [29],
"διαμοιραζόμενο": [2],
"πλήρες": [[11,12]],
"αρχείου-στόχου": [12],
"read.m": [12],
"ara": [6],
"επικύρωση": [31,19,[20,29],[8,16],[14,28]],
"βασιμένο": [15],
"τελειώσει": [[2,28]],
"are": [13,3,[14,28]],
"αρχίζει": [[16,29]],
"arg": [6],
"κόμματος": [15],
"αρχίζουν": [[8,16,23]],
"εναλλαγής": [14],
"τέτοιο": [28,[12,16,20]],
"where": [13],
"δυναμική": [1],
"paypal": [9],
"εφαρμοσιμότητά": [25],
"έτος": [[20,28]],
"art": [26],
"holder": [[1,14]],
"εξαρτάται": [[14,18,28]],
"ποσοστά": [28],
"rtl": [14,31],
"βγείτε": [19,28],
"αποθηκεύονται": [2],
"αρκεί": [[15,16]],
"διαγράφονται": [22,19],
"vmoption": [16,3],
"jdk": [16],
"επεξεργαστείτε": [[12,25]],
"υποστηρίζεται": [15],
"ask": [13],
"asm": [6],
"αντιπροσωπεύουν": [[12,28,29]],
"λύση": [31,21,[14,28,30]],
"καταχώρησης": [8,19,[2,15]],
"run": [24,[6,13,14]],
"στις": [12,[24,28],[16,29],[14,25],[8,18,27],[1,2,4,9,10,19,20,21,22,26]],
"μία": [28,[2,5,12,20,25,26],[10,14,18,24]],
"rus": [6],
"view": [13,14],
"either": [13],
"συνταγή": [28],
"διαγράφοντας": [29],
"aymara": [6],
"titlecasemenuitem": [8],
"λειτουργίες": [29,19,[10,17,24,28]],
"ενδεχομένως": [[17,28]],
"editcreateglossaryentrymenuitem": [8],
"ourc": [14],
"του": [16,29,31,28,2,19,12,14,5,17,20,25,[9,15],30,[18,27],[4,10,26],[21,22],[1,8],[3,24],11,0,7,23],
"ital": [12],
"alic": [28],
"dure": [13],
"bold": [29,[14,19]],
"τον": [16,29,23,19,28,[2,26],[10,15],22,[3,12,17,20],5,[0,1,14,18,24],[9,27],[8,11,25,30]],
"αποκτήσετε": [[20,22]],
"ιαβαϊκά": [6],
"χειροκίνητη": [26],
"συναδέλφων": [29],
"μεταφράσιμων": [[25,29]],
"τρέχον": [19,29,15,27,[10,12,20,22,28]],
"αναγνωρίσιμες": [15],
"name": [[3,13],12],
"ψευδομετάφραση": [31],
"παραμένουν": [[16,28]],
"εντοπισμού": [24],
"χειροκίνητα": [15,28],
"κατάταξη": [[10,28,29]],
"web-bas": [18],
"στην": [29,16,15,28,19,18,[2,5,20,24],[9,12,17,21],[10,14,22],[0,1,4,8,11,23,25],[3,26,27]],
"επιλέγετε": [22],
"απαιτούμενων": [2],
"android": [14],
"show": [[3,24]],
"στης": [27],
"ακολουθούμενο": [23,[8,25]],
"ava": [6],
"pushto": [6],
"ισοδυναμεί": [29],
"ave": [6],
"δημιουργούμενα": [19],
"εγγύηση": [7],
"ορισθεί": [16,14,[8,15]],
"τομέα": [10],
"κινεζικής": [16],
"διαχειρίζεσθε": [2],
"μας": [28,[1,27]],
"περισσότερη": [16],
"διεπαφή": [16,29,10,[9,14,19,30,31]],
"κωδικοποίησηη": [15],
"περισσότερα": [15,[8,9,10,14,19,23,24,25,28]],
"pgup": [5],
"λειτουργίας": [[4,27]],
"κωδικοποίησης": [12,10],
"subfold": [13,31,17],
"περισσότερο": [29,[18,20,23]],
"ιδιαίτερες": [25],
"δημοφιλείς": [2],
"συμφέρει": [28],
"ένα-προς-ένα": [10],
"κλασεις": [[23,30]],
"target": [3,[13,14,28],[1,17,31]],
"σύνθετες": [[10,14]],
"χαρακτηρισιτκά": [1],
"μέθοδος": [16],
"κανονική": [12,23,[16,24]],
"επιλέξετε": [12,16,29,[24,26],[15,17,22,25,28]],
"στοιχίζει": [20],
"αποφασίσει": [[2,22]],
"κανείς": [8],
"μέθοδοι": [24,[16,31],[14,30]],
"fabián": [7],
"κανονικά": [[16,20],9],
"config-dir": [[16,20]],
"αποφύγει": [28],
"υποσημειώσεις": [12],
"τελευταίας": [19,8],
"υπάρχουν": [16,[14,22],[15,25,27,28,29],[0,1,2,10,11,17,19,20,21,26]],
"υποφακέλλους": [10],
"tρόπος": [31],
"βοήθειας": [[29,31],[8,19,30],14,20],
"εκτελέσθηκαν": [19],
"αντιστοιχισμένο": [29],
"ελέγξετε": [[2,16,21,24,29]],
"είδους": [[11,12,21]],
"www.netrexx.org": [1],
"προφυλάξεις": [20],
"εισόδου": [18],
"εντοπίσουν": [9],
"κωδικοί": [28,[10,26,31]],
"ισπανικής": [18],
"συναρμολόγησης": [18],
"όνομά": [[12,29],[1,15,19,28]],
"case": [[8,24],19],
"τεχνικά": [12],
"όνομα": [12,[16,28],29,2,17,[3,6,8,11,19,20,24,25]],
"επαναμορφοποίηση": [18],
"πνευματικών": [7],
"item": [8,13],
"κατεγράφησαν": [28],
"μεγάλο": [[26,29]],
"ασφαλές": [28],
"έντυπων": [29],
"matcher": [23],
"χρειάζεται": [[2,15,28,29],[10,16,22,24,27]],
"βρήκαν": [4],
"επαναφορά": [[8,19,29,31]],
"χρησιμοποιείτε": [16,14,[17,28,29],[10,12,20],[2,18,19,22,30]],
"σημαίνει": [[5,11,14,28,29]],
"targettext": [29],
"φορές": [23,29,[1,12,14,28]],
"consid": [13],
"aym": [6],
"οτιδήποτε": [9],
"κλείνετε": [19],
"slide": [12],
"μπορούσαν": [28],
"πειστρέψετε": [29],
"style": [14],
"κεφαλαίου": [[7,15]],
"card": [24,31,12],
"care": [13],
"συμπεριληφθούν": [28,[2,24]],
"μήνα": [[16,28]],
"aaabbb": [23],
"διαχωριστικά": [29],
"aze": [6],
"ερωτήσεις": [9],
"caus": [[13,16]],
"ασύμβατα": [28],
"μέχρι": [23,[5,16,22],[10,25,28,29]],
"edittagpaintermenuitem": [8],
"ενέργειας": [19,8],
"τριών": [28],
"επικυρώσετε": [17],
"bokmål": [6],
"παντζάμπι": [6],
"γεμίσετε": [28],
"more": [13,24],
"display": [[14,24]],
"διαστημάτων": [[8,12,19,29]],
"επέκτσαση": [21],
"viewmarknbspcheckboxmenuitem": [8],
"unicod": [21,[15,23,31]],
"λίστες": [18],
"ενδιάμεσου": [16,31],
"νυάντζα": [6],
"σχολίων": [29,31,[15,16,28,30]],
"απενεργοποιεί": [19],
"πιθανό": [[14,18,21]],
"overwrit": [19],
"en-us": [28],
"κιρούντι": [6],
"εκτελέσει": [[16,17]],
"whitespac": [8],
"προϋπόθεση": [14],
"μετονομάσουμε": [28],
"τοπικό": [2],
"ποσοστό": [29],
"φυλάσσετε": [2],
"δοκιμάσουν": [19],
"κανονες": [14],
"simpli": [13],
"τελευταίες": [19],
"msgstr": [12],
"μήλο": [19],
"λειτουργούν": [25],
"σαρώσει": [1],
"μακροεντολές": [1],
"katarn": [7],
"μεταφράσιμου": [12],
"παρακολούθηση": [9],
"χτίσιμο": [18],
"μεταφράσιμο": [12],
"untransl": [13],
"επισήμανση": [8,19,[12,27,29,31]],
"πιθανά": [[27,28]],
"πιθανή": [28],
"δημιουργήσετε": [[17,28],16,[25,27]],
"ενότητες": [14],
"daili": [13],
"πόρων": [14],
"πρόσφατης": [28],
"μην": [[1,4,8,14,17,20,22,24,25]],
"αναδυόμενα": [22],
"bashkir": [6],
"κορεατικών": [19],
"both": [24],
"αποκαταστήσει": [29],
"most": [13],
"αναθέστετα": [28],
"γράφει": [1],
"πλεονεκτικές": [25],
"περιοχή": [29,31,15,[22,28,30],[17,18,19,20],[1,5,14,24,27]],
"omegat.project": [[2,13,31]],
"μετσαφραστικές": [28],
"targetcountrycod": [12],
"job": [13],
"x_without_jr": [16],
"αναδυόμενο": [29,[15,19,20,26,27]],
"δοκιμή": [23],
"οποιεσδήποτε": [[2,16,27]],
"τουςl": [2],
"διαφανειών": [12],
"webstart": [16],
"αντιγραμμένα": [2],
"χεριίζεται": [12],
"θέλετε": [16,28,[8,9,12,17,18,27,29],[2,3,10,19,21,23,24,26]],
"ενέργειες": [19,16],
"καθορίζονται": [28],
"των": [29,12,28,19,2,[10,14],18,22,[16,25,31],[1,15,21,26,27],[3,4,5,17,24,30],[0,8,11,20]],
"αντιγράψτε": [28,16,20],
"κικούγιου": [6],
"sag": [6],
"μια": [16,28,29,[12,19],14,24,18,[1,20,25],[2,27],[10,17],[8,22,23,26],[9,15,21],[0,4,5,7]],
"messag": [13],
"πολλοίς": [23],
"αγγλική": [29],
"πηγών": [12],
"αγγλικά": [23,[0,3,6,16,28]],
"μεταφρραστική": [19],
"επιταχύνοντας": [28],
"subvers": [2,31],
"αναγνωρισμένου": [25],
"καταγράψετε": [9],
"ψηφίο": [19,23],
"san": [6],
"move": [19],
"καιρόν": [26],
"resp": [3],
"εμφανίζει": [19,29,[10,21],[12,24]],
"νεπαλέζικα": [6],
"επιλεγεί": [16,[19,25]],
"πρόσφατες": [[6,18]],
"jpn": [6],
"also": [13],
"ανθρώπων": [4],
"μεταφράσιμα": [[12,28]],
"resx": [14],
"differ": [[3,13]],
"πολυεθνική": [28],
"consol": [3],
"σύμφωνα": [[10,12,16],[2,5,19,23,27]],
"pāli": [6],
"κωδικού": [2],
"πιθανές": [[15,19,28]],
"itokenizertarget": [3],
"a123456789b123456789c123456789d12345678": [16],
"ρχείου": [24],
"viewmarkwhitespacecheckboxmenuitem": [8],
"πράσινο": [[2,29],19],
"πρόθεση": [25],
"projects": [30],
"bad": [18],
"περισσότερους": [[8,12,25]],
"δίσκο": [[2,16,19]],
"δείχνουν": [[28,29]],
"δεσμεύει": [16],
"lucen": [3,31],
"complet": [[13,28]],
"bak": [[2,6,13]],
"μενού": [8,30,19,31,29,16,22,[1,10,12,17,20,21,25],[14,15,18,26,27]],
"bam": [6],
"λοιπόν": [[16,28]],
"αρχικές": [17],
"bar": [16],
"bat": [16],
"built-in": [29],
"παρέχεται": [[10,29]],
"συσχετιζόμενων": [18],
"μπλέ": [29],
"jre": [16],
"μπλε": [29,[0,24]],
"optionsfontselectionmenuitem": [8],
"posit": [24],
"χρόνος": [[12,19]],
"λεπτομερείς": [29],
"συνηθισμένο": [16,5],
"παραπάνω": [29,28,24,[11,14,15,16],[0,1,2,12,18,21,23]],
"translatedfil": [20],
"συντάσσεται": [18],
"επεξεργασθείτε": [[16,26,28,29]],
"αναθεώρηση": [[0,4]],
"συνηθισμένη": [19],
"είναι": [16,29,28,[12,15],2,[14,18,19,25],20,10,27,8,[17,21,22,26],1,[7,23],11,24,[0,3,9],5],
"aaron": [7],
"συνηθισμένα": [15,[28,30,31]],
"παρούσα": [14],
"προεπιλογή": [12,19,28,[2,27],[14,16,21,23,24]],
"αϊτιανά": [6],
"project2": [2],
"project1": [2],
"λεξικολογική": [18],
"deal": [13],
"freebsd": [[13,23]],
"είδος": [14,[19,25,29]],
"rexx": [1],
"affect": [13],
"icon": [13],
"delet": [5],
"λειτουργικό": [16,[2,12]],
"αυτόν": [[11,16,17,20,26]],
"αυτός": [[1,12],[0,5,15,18,23,25]],
"προσφέρετε": [9],
"see": [13,[3,12]],
"vito": [[7,30]],
"κατα": [12],
"απλό": [21,[10,14,23],[1,16,27,28,30,31]],
"στόχος": [12,31,14],
"seq": [15],
"κατά": [16,[5,20,28],[6,31],[10,25,29],[3,12,18,22,30],[14,15,19,24,26]],
"developerwork": [16],
"προσθήκες": [1],
"contain": [13,[3,28]],
"set": [13,31,[16,21]],
"συγγραφέας": [29,7],
"λειτουργικά": [19,2],
"μννήμες": [10],
"optionsrestoreguimenuitem": [8],
"λειτουργεί": [[18,19],[10,12,13,20,26]],
"απόφαση": [18],
"ιντερλίνγκουα": [6],
"μη-μοναδικά": [19],
"λαμβάνονται": [[2,27,29]],
"αυτών": [26],
"απλά": [31,[14,25,27],[12,15,18,21,30]],
"απλή": [[14,15,23,28]],
"αφορά": [28,[20,22,29]],
"fleurk": [7],
"γράφτηκαν": [19,1],
"διάφορα": [31,[10,12,20,29],[2,6,17,19,26,28,30]],
"γλωσσες": [18],
"bihari": [6],
"offic": [[12,14]],
"ποικιλίες": [28,[12,23]],
"terminolog": [15],
"φόντο": [29,19],
"bel": [6],
"αναζητήσεις": [24,[10,23,31],[12,19,25,29,30]],
"προκαθορισμένς": [12],
"ben": [6],
"φράση": [24,25],
"εξήγηση": [[0,2,16]],
"welsh": [6],
"διαιρέσετε": [29],
"φορτώσετε": [27],
"ακέραια": [4],
"αποκαλούνται": [25],
"projectsavemenuitem": [8],
"πόσα": [29],
"joel": [9],
"ζητήθηκε": [[16,18]],
"digit": [28],
"στόχου": [12,31,14],
"άδειας": [7],
"παρακάμπτει": [12],
"υποστηρίζουν": [[10,15,28]],
"πόσο": [[12,29]],
"τρέχοντα": [16,[2,19,20,28]],
"μου": [4],
"δηλώνω": [4],
"αδειάστε": [29],
"pptx": [14],
"αποθετηρίων": [4],
"ιαπωνικούς": [21],
"βημάτων": [25],
"εξηγήσεις": [14],
"ασήμαντες": [28],
"ρίζες": [3],
"τύπους": [[13,14]],
"καταμηθεί": [25],
"εργάζονται": [[2,10,28]],
"example_project": [13],
"prototype-bas": [1],
"cursor": [19],
"σουδανέζικα": [6],
"ορίζονται": [[26,29]],
"προστεθεί": [15,[1,20]],
"xhosa": [6],
"παρακολουθούν": [29],
"εγγράψιμου": [31],
"σκληρό": [[16,19]],
"υπεύθυνων": [10],
"sin": [6],
"υποκατάλογ": [11],
"ενίοτε": [12],
"τακτά": [[14,20]],
"συνδυασμό": [11],
"ουσιαστικά": [18,21],
"aεπιτρέπει": [18],
"ενθαρρύνεται": [14],
"εισαχθούν": [[19,24,28]],
"γουόλοφ": [6],
"someth": [13],
"τσεκάρετε": [19,16,25,[2,12,26,28]],
"πλήκτρο": [19,8,[5,17]],
"punjabi": [6],
"tiago": [7],
"μάθησης": [18],
"μπει": [28],
"απο-μορφοποίηση": [18],
"βρείτεi": [16],
"πλήκτρα": [[5,19],8],
"πλήρη": [16,[10,17,29]],
"λογισμικού": [16,[2,7,20]],
"χάουζα": [6],
"setup": [13],
"εναλάσσεστε": [14],
"bih": [6],
"select": [13],
"αντιγράψει": [[12,17]],
"bin": [13],
"καποιον": [7],
"ενημερωθεί": [29],
"μηνύματα": [[16,20,29]],
"apertium": [18,31,30],
"bit": [21],
"κυριλλικό": [21],
"πλαίσο": [23],
"bis": [[6,23]],
"εκτελεσθεί": [16],
"clipboard": [19],
"ονομαστική": [[3,15]],
"άρχισε": [23],
"projectopenmenuitem": [8],
"autom": [16],
"yoruba": [6],
"κακή": [19],
"εοιλογές": [31],
"π.χ": [28,[15,29],[2,19],26,[16,20,22],[10,11,21,24,27],[0,1,3,12,14,17,18]],
"βραζιλιανά": [26],
"ολανδικά": [28,[0,6]],
"ordinari": [13],
"join": [13],
"μπαμπάρα": [6],
"δεσμεύοντας": [16],
"κατεβάσατε": [16],
"ενεργό": [19],
"προεπιλεγμένες": [8,[16,20]],
"toolsvalidatetagsmenuitem": [8],
"γλώσσα-στόχο": [[0,12]],
"σημειώστε": [16,28,29,[2,18,26],22,[5,9,11,15,20,24,25]],
"χρησμοποιώντας": [19],
"μίας": [[28,29]],
"τροφοδότηση": [23],
"καιι": [28],
"πραγματοποιείτε": [28],
"αντιστοιχίζει": [23,12,24],
"βολικές": [16],
"ορισμούς": [8],
"ιστορία": [15],
"επιπλέον": [[16,20],[23,27]],
"ακριβώς": [[9,12,20,24,26,27]],
"συνεχώς": [28],
"slk": [6],
"λείπει": [[15,23,29]],
"λούμπα-κατάνγκα": [6],
"έναn": [28],
"όποτε": [28,17],
"john": [7],
"slv": [6],
"βήματα": [2],
"begin": [13],
"σύμβολα": [[29,31]],
"σιωπηλό": [[16,20]],
"απωλεσθείσες": [19],
"ανοίξτε": [[16,17],[2,12,20,21,24,28,29]],
"viewmarktranslatedsegmentscheckboxmenuitem": [8],
"επιθυμητής": [16],
"valu": [[14,29]],
"ενεργοποιήθηκε": [[18,19]],
"sme": [6],
"κλείσετε": [[17,19,29]],
"υποβοηθούμενη": [10],
"shallow-transf": [18],
"μετακινείτε": [[0,17]],
"ανεξάρτητη-γλώσσας": [18],
"αναζητήσετε": [[24,26]],
"δεν": [16,19,15,29,28,22,18,[12,20],[14,25,26],[0,17],[1,4,21,24],[5,8,9,11]],
"smo": [6],
"καλό": [[9,25]],
"σιωπηλή": [20,16],
"χειρισθεί": [[14,17]],
"δεξιού": [29],
"pojavni": [15],
"λειτουργήσετε": [3],
"εκμάθηση": [[4,7]],
"περιηγείσθε": [29],
"ποληροφορίες": [29],
"επιθυμητές": [18],
"δεσμεύονται": [16],
"ενεργοποιούνται": [19],
"κατώφλι": [27],
"editselectfuzzy1menuitem": [8],
"sna": [6],
"snd": [6],
"τάγκαλογκ": [6],
"didier": [4,7],
"case-sensit": [23],
"ξεκινήσει": [16],
"hide": [12],
"αισθάνεσθε": [20],
"γλώσσα": [16,28,[1,26],[3,14,31],[18,29],[12,17,20,21,25],[0,4,15,22,24]],
"στυλ": [[2,28]],
"πολλή": [4],
"προειδοποιήσεις": [31,7,[4,8,16,30]],
"καλή": [29,9],
"πολλά": [[24,27,29],[2,12,20]],
"report": [13],
"γροιλανδικά": [6],
"οποιαδήότε": [24],
"πλεονεκτήματα": [2],
"δείξει": [2],
"περιεχομένων": [[12,16,29,30]],
"auto": [28,[21,31],12],
"notepad": [15],
"document.xx.docx": [12],
"αφορούν": [10,29],
"som": [6],
"γραφικό": [20,16],
"πουλάρ": [6],
"διορθώσεις": [4],
"download": [13,9],
"στόχων": [12],
"επιλέγεται": [19,29],
"φυλά": [2],
"δηλ": [2,[16,28],[15,20,21,22,24]],
"κρεολικά": [6],
"oracl": [16,8,12],
"sot": [6],
"τατζικικά": [6],
"στςι": [19],
"προτάθηκε": [19],
"στήσετε": [2],
"πακέτα": [2],
"βελτιώνοντας": [18],
"δημιουργικά": [10],
"spa": [6],
"level": [28],
"υπογραμμισμένη": [[0,26]],
"λειτουργία": [16,31,[2,10,26,29],[15,17,19,25,27,30]],
"χαρακτήρων": [[5,16,18,23,30],[8,12,15,19,21,29]],
"περιηγητή": [29],
"έγγραφα-στόχο": [12],
"παρουσιάζεται": [2],
"modif": [13],
"πακέτο": [16,[1,3]],
"γίνουν": [2,28],
"bob": [28],
"bod": [6],
"μικρές": [[10,25,29]],
"αυτόματης": [31,20,30],
"ινδονησιακά": [6],
"διαχειριστών": [2],
"άμεσης": [10,16],
"άλλαξε": [2,1],
"ανταλλάσσετε": [10],
"δια": [29],
"αυτόματες": [19],
"bos": [6],
"ανατρέξτε": [[9,14]],
"συνεισφορές": [31],
"διά": [22,[28,29]],
"sqi": [6],
"box": [[12,24,27]],
"μωβ": [19],
"λουξεμβουργιανά": [6],
"φορτώνει": [[17,20,28,29]],
"συνδεδεμένος": [18],
"fouri": [7],
"τετραψήφια": [28],
"κόμμα": [15],
"συνδεδεμένοι": [18],
"ασαφείς": [27],
"δεόντως": [2],
"kal": [6],
"bundl": [[14,16,20]],
"συμβεί": [[16,28]],
"επιπρόσθετα": [28],
"περιέχει": [28,29,20,16,[10,19],[9,15,24],[0,1,2,8,11,12,17,22,26,30]],
"kan": [6],
"φορτώνεται": [28],
"kas": [6],
"thoma": [7],
"δοκιμαστής": [[23,30]],
"kau": [6],
"kat": [6],
"κατόπιν": [28],
"διαβάστε": [9],
"αποθετηρίου": [2,28,31],
"srd": [6],
"kaz": [6],
"εγγυηση": [7],
"gigabyt": [16],
"control": [[2,19],[8,30]],
"αύξηση": [28],
"no-team": [[16,31]],
"srp": [6],
"γραφική": [10],
"φανούν": [23],
"κατατμήσουν": [28],
"ισχυρές": [24],
"srt": [14],
"έτσι": [[2,16,29],[25,28],[7,10,12,21,26]],
"αποεπιλεγμένο": [[22,25]],
"διαγραφή": [5,19,[22,27],[16,26]],
"παράρτημα": [5,[0,1,2,3,7,8,9],[4,6],[20,25,28,29,31]],
"κατακερματισμένο": [28],
"δυνάμεις": [9],
"κομματάκι": [1],
"χαρακτήρες": [12,15,[14,21,23,24],[19,29]],
"πρόιγραμμα": [3],
"συνχείζει": [20],
"λεπτομερειών": [4],
"επεξεργασθεί": [16],
"διευκρινίζουν": [12],
"τουλάχιστον": [[2,18,27,28]],
"πληθυντικός": [3],
"environ": [16,13],
"τονίσετε": [29],
"αυτοματοποιούν": [16],
"ονόματος": [12,31,[15,21]],
"bre": [6],
"προορίζεται": [19],
"αναβαθμισθούν": [28],
"ssw": [6],
"τελείας": [25],
"επεξεργαζόμενοι": [27],
"γραμματοσειρών": [31,[14,20],[19,30]],
"συγκριτικός": [3],
"νέο": [[16,19],[1,28],17,[15,18,21,25,26,27,29,31]],
"ενεργούν": [5],
"δυτικοευρωπαϊκές": [21],
"εμφανίζονται": [[24,29],[12,15,19,28],[16,27],[8,10,14,20,23]],
"διαφορετικές": [29,[14,16,19,20,28]],
"οφείλονται": [4],
"on-lin": [10],
"kde": [16,31],
"ενεργοποιημένη": [12],
"σημαίνουν": [29],
"νέα": [16,[8,22,25],[2,6,12,14,17,23,27,28,29]],
"accept": [13],
"ενεργοποιημένο": [[12,18]],
"προ-επεξεργασία": [14],
"βουλγαρικά": [6],
"οργανωμένο": [2],
"ανάγκες": [[2,19]],
"πιθανότητα": [20],
"συντομία": [[1,2,23]],
"sub": [15],
"δημιουργηθούν": [28],
"access": [[3,13]],
"ανώδυνη": [9],
"δημιοθργήσει": [19],
"languag": [16,[1,3,13]],
"υπάροχυσα": [16],
"διαδικασίας": [[14,22,25,28]],
"sun": [6],
"διεπαφής": [[16,31]],
"current": [13,24],
"έναρξης": [10,29],
"διακομιστής": [2],
"υπολογισμός": [29],
"αρχικού": [14,[10,29]],
"επεξργασθείτε": [12],
"ένας": [[0,10,25],[2,15,16,28],[1,3,8,12,14,24,29]],
"δυσκολίες": [4],
"implic": [13],
"στους": [2,28,[4,23,26,29]],
"key": [3,8,19,[14,18,29]],
"εξάγονται": [[15,27]],
"λογαρισμούς": [18],
"svg": [16],
"έναν": [16,2,28,23,[25,29],[5,19,26],[10,12,15,17,18],[3,8,14,20,22,24]],
"ισχύουν": [16,22,5],
"δημιουργηθεί": [[12,14,15,16,17,19,28,29]],
"όποια": [28],
"στέλνοντας": [9],
"svn": [2,31,[16,28,30]],
"launch": [13,3,31],
"διορθωμένο": [18],
"κλείστε": [[20,24,28]],
"δουλειά": [16,[2,4,17,28]],
"stand-alon": [23],
"tagalog": [6],
"bug": [13],
"κονσόλα": [16,20],
"ανζήτηση": [24],
"συστήνεται": [25],
"bul": [6],
"ολανδικές": [28],
"swa": [6],
"but": [[3,13]],
"πάστο": [6],
"swe": [6],
"χαρακτήρας": [12,[23,30]],
"εκκλησία": [6],
"express": [10,[12,24]],
"υπο": [22],
"διαχωρίζεται": [15],
"τροποποίηση": [29,[19,22],[1,10,12,15]],
"δίπλα-δίπλα": [16],
"zero": [24],
"αποθηκεύεται": [[16,22],[2,20,28,29]],
"χρειάζεθε": [28],
"μειώνει": [[3,14]],
"κώδικα": [1,[0,2,10,12,16,28]],
"χρωματίζονται": [29],
"δημιουργηθέν": [[2,28]],
"υπό": [7,[2,11,14,16,20,28]],
"gotoprevioussegmentmenuitem": [8],
"εκτεταμένος": [10],
"ευρωπαϊκής": [28],
"διαλόγου": [[12,28],[17,21],[25,27,30,31]],
"limburgan": [6],
"ευαίσθητα": [9],
"gotopreviousnotemenuitem": [8],
"υλικό": [2,10],
"ναι": [16],
"editredomenuitem": [8],
"uilayout.xml": [13],
"κατάλογο": [16,28,2,19,29,20,15,[0,1],[3,17],[11,24,26],[12,14,25,27]],
"αναλύει": [[23,25]],
"αρχεία-στόχο": [[12,14]],
"διψήφιο": [16],
"khm": [6],
"κατακτήσει": [28],
"αυτόματος": [26],
"ορίζει": [16,[2,19]],
"πρόχειρο": [19],
"hint": [14],
"περιγράφουν": [29],
"αντιμετωπίζει": [10],
"συνέπεια": [[16,24,26]],
"πλατφόρμα": [18,[11,16]],
"κατάλογό": [8],
"λογιστικών": [29,[12,15]],
"ευρωπαϊκές": [25],
"learned_word": [31],
"παράβλεψη": [12],
"εισήχθη": [[24,29]],
"ανοιχτών": [14],
"επιλέγει": [19,27],
"σύμβολο": [16,[15,19,23,24,29]],
"κυρίαρχος": [22],
"πηγαίνετε": [27],
"kik": [6],
"εγκαταστήσουν": [2],
"kim": [7],
"kin": [6],
"διαγράφει": [[14,19]],
"τσουβάς": [6],
"kir": [6],
"lakunza": [7],
"εντοπισθούν": [28],
"πτυχές": [10],
"επιμέλειά": [4],
"corrupt": [13],
"guido": [7],
"κωδικοποίησή": [[12,21,29]],
"behav": [13],
"γράμμα": [[19,23],14],
"κσαι": [26],
"δανειστούμε": [3],
"ενδιάμεσο": [19,[8,16,28]],
"παλιές": [22],
"κωδικοποίηση": [12,21,31,15,[14,18,30]],
"επίλυσης": [2],
"license.txt": [13],
"φόρμας": [23],
"runtim": [16,13,[1,18]],
"περιπτώσεων": [28,2],
"πρόκειται": [[16,29]],
"συνετώτερο": [26],
"ιστοσελίδα": [[0,1]],
"avar": [6],
"μεταφορτωνετε": [31,11,30],
"ακολούθως": [11],
"παλιάς": [16],
"filenam": [28,12],
"ακολουθούν": [16,[23,24]],
"roam": [13],
"γώσσα": [21],
"αμχαρικά": [6],
"between": [13],
"αφήνονται": [22],
"τμήματος": [5,19,[27,29],25,[18,31],[1,2,8,10,24]],
"αμφίδρομο": [14],
"υψηλή": [8],
"μετάβαση": [[8,19,31],[27,29,30],17],
"ατνιστοιχίσεις": [29],
"χίρι": [6],
"ασφαλώς": [26,[15,16,18,21,22,28]],
"gotosegmentmenuitem": [8],
"σημαντικό": [[4,14,18,28,29]],
"αφήσατε": [19],
"οπότε": [28,[25,29],[14,15,19]],
"intact": [13],
"απλοποιεί": [14],
"opportun": [13],
"cornish": [6],
"xx_yy.tmx": [28],
"key-valu": [12],
"εκτιμηθεί": [9],
"ισπανικών": [26],
"πάντως": [[14,16],[28,29],[4,17,18,25,26]],
"flag": [29,[22,23]],
"είνια": [28],
"κατάτμηση": [25,31,22,10,[19,28,29],12,[8,23,24,30]],
"helpaboutmenuitem": [8],
"επιδιορθώσεις": [28],
"weak": [1],
"εθελοντική": [9],
"περιεχομένου": [12,28],
"αντιγραφεί": [[12,19]],
"πουλάαρ": [6],
"αναδιανέμετε": [7],
"mandelbaum": [7],
"place": [1],
"δέσμευση": [[16,31]],
"δυτ": [6],
"regular": [10,24],
"εκείνος": [[2,28]],
"προγράμματος": [16,[2,15]],
"διπλό": [16,29],
"c\'est": [15],
"άτομο": [2],
"κανένα": [19,[16,29],[2,20]],
"token": [3,31,29,[0,2,10]],
"ετος": [20],
"τομέρος": [2],
"filter": [13],
"x_linux.tar.bz2": [16],
"site": [18],
"omegat.log": [13],
"μεγιστοποίησης": [29],
"αϋμάρα": [6],
"διάταξη": [29,12],
"najlepših": [3],
"τουί": [6],
"argument": [16,[3,31]],
"πειραχθεί": [15],
"έτοιμο": [29],
"μοντέλο": [1,18],
"kom": [6],
"εαυτούς": [2],
"εμπνέονται": [1],
"εβραϊκά": [[6,18]],
"kon": [6],
"omegat-rel": [13],
"επίμονη": [4],
"kor": [6],
"μεταφρασθούν": [12,[16,28],18],
"tab": [15,19,8,25,[23,29]],
"χρήση": [30,31,16,15,28,26,[2,20,29],[0,1,3,11,14,19,25],[8,10,18,21,27]],
"υπολογιστών": [19],
"μείωση": [14],
"έξοδος": [8,[1,19,28]],
"διακόπτεται": [20],
"should": [13,3],
"tah": [6],
"tag": [[12,14],[10,27,31]],
"γλωσσών": [28,18,22,[2,20,25,31],[0,3,10,14,19,29]],
"χρησιμοποιεί": [10,[12,26,28],16,18,[0,1,15,20,21,25,29]],
"τους": [28,25,10,14,29,2,[12,16,23],[6,15,22],[7,8,18,19,24,27],[1,5,9,20,21,26]],
"αναλύονται": [28],
"έτοιμη": [2],
"tam": [6],
"επιλεχθεί": [12],
"tar": [13,16],
"συντμεύσεις": [5,[2,6,30]],
"tat": [6],
"έρθει": [29],
"βόλαπουκ": [6],
"onli": [[12,13,16]],
"εμπλεκόμενα": [26],
"προορσμούς": [28],
"projectreloadmenuitem": [8],
"χρησιμοποιήστε": [16,[11,17,22]],
"βελτιωμένη": [1],
"κλείσει": [19],
"files": [30],
"στατιστικά": [[29,30]],
"φόρτωση": [12,[19,29]],
"μετατροπή": [1,[14,19,31]],
"νοιώσετε": [16],
"νήσοι": [6],
"sail": [18],
"πηγές": [[27,28],31,[14,30]],
"καθοδηγείται": [27],
"σημαντική": [[10,16]],
"winrar": [11],
"tbx": [15,31],
"σημαντικά": [10,20,30],
"ματάβαση": [29],
"συνοψισθούν": [2],
"λάθη": [10,[0,17]],
"υπολογισμούς": [29],
"κωδικούς": [6,[28,31],[25,26],[5,19,20,30]],
"can": [13,[20,24]],
"χάνετε": [15],
"cat": [10,3,[6,28,29]],
"συμπεριφοα": [16],
"εγκαταστάτη": [26],
"duser.countri": [16],
"tcl": [27],
"provid": [13],
"tck": [27],
"τροποποιήστε": [8],
"υπολογισμού": [29],
"υπεύθυνος": [2],
"readm": [12,16],
"πρόθεμα": [27,28],
"πηγής": [19,31,[14,16,18,22]],
"συνηδοτηποιήσετε": [2],
"κουμπιά": [29,24],
"match": [27,[13,19,24,28,31],[14,17]],
"categori": [23],
"κόγκο": [6],
"tajik": [6],
"ισχυρότερους": [23],
"επιτρέπουν": [29,[12,15,16,25]],
"typo3": [14],
"align.tmx": [16,20],
"εμφανισθεί": [16,[2,19],[18,25,29]],
"υπάρχον": [15]
};
