/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.issues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.omegat.gui.issues.IIssueProvider;
import org.omegat.gui.issues.SpellingIssueProvider;
import org.omegat.gui.issues.TerminologyIssueProvider;
import org.omegat.util.Preferences;

public final class IssueProviders {
    static final String ISSUE_IDS_DELIMITER = ",";
    private static final List<IIssueProvider> ISSUE_PROVIDERS = new ArrayList<IIssueProvider>();

    private IssueProviders() {
    }

    public static List<IIssueProvider> getIssueProviders() {
        return Collections.unmodifiableList(ISSUE_PROVIDERS);
    }

    public static void addIssueProvider(IIssueProvider provider) {
        ISSUE_PROVIDERS.add(provider);
    }

    static Set<String> getDisabledProviderIds() {
        String disabled = Preferences.getPreference("issue_providers_disabled");
        return Stream.of(disabled.split(ISSUE_IDS_DELIMITER)).collect(Collectors.toSet());
    }

    static List<IIssueProvider> getEnabledProviders() {
        Set<String> disabled = IssueProviders.getDisabledProviderIds();
        return ISSUE_PROVIDERS.stream().filter(p -> !disabled.contains(p.getId())).collect(Collectors.toList());
    }

    public static void setProviderEnabled(String id, boolean enabled) {
        if (enabled) {
            IssueProviders.setProviders(Collections.singleton(id), Collections.emptySet());
        } else {
            IssueProviders.setProviders(Collections.emptySet(), Collections.singleton(id));
        }
    }

    public static void setProviders(Collection<String> enabled, Collection<String> disabled) {
        HashSet<String> toDisable = new HashSet<String>(IssueProviders.getDisabledProviderIds());
        toDisable.removeAll(enabled);
        toDisable.addAll(disabled);
        Preferences.setPreference("issue_providers_disabled", String.join((CharSequence)ISSUE_IDS_DELIMITER, toDisable));
    }

    static {
        IssueProviders.addIssueProvider(new SpellingIssueProvider());
        IssueProviders.addIssueProvider(new TerminologyIssueProvider());
    }
}

