/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.omegat.core.Core;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.main.MainWindowUI;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.AppearancePreferencesPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DelegatingComboBoxRenderer;

public class AppearanceController
extends BasePreferencesController {
    private AppearancePreferencesPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_APPEARANCE");
    }

    private void initGui() {
        this.panel = new AppearancePreferencesPanel();
        String[] lafs = (String[])Arrays.asList(UIManager.getInstalledLookAndFeels()).stream().map(UIManager.LookAndFeelInfo::getClassName).toArray(String[]::new);
        this.panel.cbThemeSelect.setModel(new DefaultComboBoxModel<String>(lafs));
        this.panel.cbThemeSelect.setRenderer((ListCellRenderer<String>)new DelegatingComboBoxRenderer<String, String>(){

            @Override
            protected String getDisplayText(String value) {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!info.getClassName().equals(value)) continue;
                    return info.getName();
                }
                return value;
            }
        });
        this.panel.cbThemeSelect.addActionListener(e -> {
            String current;
            String selected = this.panel.cbThemeSelect.getSelectedItem().toString();
            this.setRestartRequired(!selected.equals(current = UIManager.getLookAndFeel().getClass().getName()));
        });
        this.panel.restoreWindowButton.addActionListener(e -> MainWindowUI.resetDesktopLayout((MainWindow)Core.getMainWindow()));
    }

    @Override
    protected void initFromPrefs() {
        this.panel.cbThemeSelect.setSelectedItem(UIManager.getLookAndFeel().getClass().getName());
    }

    @Override
    public void restoreDefaults() {
        this.panel.cbThemeSelect.setSelectedItem("org.omegat.gui.theme.DefaultFlatTheme");
    }

    @Override
    public void persist() {
        Preferences.setPreference("theme_class_name", this.panel.cbThemeSelect.getSelectedItem().toString());
    }
}

