/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.spans.NearSpansOrdered;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.Spans;

public class NearSpansPayloadOrdered
extends NearSpansOrdered {
    private List<byte[]> matchPayload = new LinkedList<byte[]>();
    private Set<byte[]> possibleMatchPayloads = new HashSet<byte[]>();

    public NearSpansPayloadOrdered(SpanNearQuery query, List<Spans> subSpans) throws IOException {
        super(query, subSpans);
    }

    @Override
    protected boolean shrinkToAfterShortestMatch() throws IOException {
        boolean match;
        Spans lastSubSpans = this.subSpans[this.subSpans.length - 1];
        this.matchStart = lastSubSpans.startPosition();
        this.matchEnd = lastSubSpans.endPosition();
        this.matchPayload.clear();
        this.possibleMatchPayloads.clear();
        if (lastSubSpans.isPayloadAvailable()) {
            this.possibleMatchPayloads.addAll(lastSubSpans.getPayload());
        }
        ArrayList<byte[]> possiblePayload = null;
        int matchSlop = 0;
        int lastStart = this.matchStart;
        for (int i = this.subSpans.length - 2; i >= 0; --i) {
            Spans prevSpans = this.subSpans[i];
            if (prevSpans.isPayloadAvailable()) {
                Collection<byte[]> payload = prevSpans.getPayload();
                possiblePayload = new ArrayList<byte[]>(payload.size());
                possiblePayload.addAll(payload);
            }
            int prevStart = prevSpans.startPosition();
            int prevEnd = prevSpans.endPosition();
            while (true) {
                if (prevSpans.nextStartPosition() == Integer.MAX_VALUE) {
                    this.oneExhaustedInCurrentDoc = true;
                    break;
                }
                int ppStart = prevSpans.startPosition();
                int ppEnd = prevSpans.endPosition();
                if (ppEnd > lastStart) break;
                prevStart = ppStart;
                prevEnd = ppEnd;
                if (!prevSpans.isPayloadAvailable()) continue;
                Collection<byte[]> payload = prevSpans.getPayload();
                if (possiblePayload == null) {
                    possiblePayload = new ArrayList(payload.size());
                } else {
                    possiblePayload.clear();
                }
                possiblePayload.addAll(payload);
            }
            if (possiblePayload != null) {
                this.possibleMatchPayloads.addAll(possiblePayload);
            }
            assert (prevStart <= this.matchStart);
            if (this.matchStart > prevEnd) {
                matchSlop += this.matchStart - prevEnd;
            }
            this.matchStart = prevStart;
            lastStart = prevStart;
        }
        boolean bl = match = matchSlop <= this.allowedSlop;
        if (match && this.possibleMatchPayloads.size() > 0) {
            this.matchPayload.addAll(this.possibleMatchPayloads);
        }
        return match;
    }

    @Override
    public Collection<byte[]> getPayload() throws IOException {
        return this.matchPayload;
    }

    @Override
    public boolean isPayloadAvailable() {
        return !this.matchPayload.isEmpty();
    }

    @Override
    public String toString() {
        return "NearSpansPayloadOrdered(" + this.query.toString() + ")@" + this.docID() + ": " + this.startPosition() + " - " + this.endPosition();
    }
}

