/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.zip.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class LittleEndianUtils {
    private LittleEndianUtils() {
    }

    public static long readUnsigned4Le(@Nonnull ByteBuffer bytes) throws IOException {
        byte b3;
        byte b2;
        byte b1;
        Preconditions.checkNotNull(bytes, "bytes == null");
        if (bytes.remaining() < 4) {
            throw new EOFException("Not enough data: 4 bytes expected, " + bytes.remaining() + " available.");
        }
        byte b0 = bytes.get();
        long r = (long)(b0 & 0xFF | ((b1 = bytes.get()) & 0xFF) << 8 | ((b2 = bytes.get()) & 0xFF) << 16) | ((long)(b3 = bytes.get()) & 0xFFL) << 24;
        Verify.verify(r >= 0L);
        Verify.verify(r <= 0xFFFFFFFFL);
        return r;
    }

    public static int readUnsigned2Le(@Nonnull ByteBuffer bytes) throws IOException {
        byte b1;
        Preconditions.checkNotNull(bytes, "bytes == null");
        if (bytes.remaining() < 2) {
            throw new EOFException("Not enough data: 2 bytes expected, " + bytes.remaining() + " available.");
        }
        byte b0 = bytes.get();
        int r = b0 & 0xFF | ((b1 = bytes.get()) & 0xFF) << 8;
        Verify.verify(r >= 0);
        Verify.verify(r <= 65535);
        return r;
    }

    public static void writeUnsigned4Le(@Nonnull ByteBuffer output, long value) throws IOException {
        Preconditions.checkNotNull(output, "output == null");
        Preconditions.checkArgument(value >= 0L, "value (%s) < 0", value);
        Preconditions.checkArgument(value <= 0xFFFFFFFFL, "value (%s) > 0x00000000ffffffffL", value);
        output.put((byte)(value & 0xFFL));
        output.put((byte)(value >> 8 & 0xFFL));
        output.put((byte)(value >> 16 & 0xFFL));
        output.put((byte)(value >> 24 & 0xFFL));
    }

    public static void writeUnsigned2Le(@Nonnull ByteBuffer output, int value) throws IOException {
        Preconditions.checkNotNull(output, "output == null");
        Preconditions.checkArgument(value >= 0, "value (%s) < 0", value);
        Preconditions.checkArgument(value <= 65535, "value (%s) > 0x0000ffff", value);
        output.put((byte)(value & 0xFF));
        output.put((byte)(value >> 8 & 0xFF));
    }
}

