/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.zfile;

import com.android.tools.build.apkzlib.sign.ManifestGenerationExtension;
import com.android.tools.build.apkzlib.sign.SigningExtension;
import com.android.tools.build.apkzlib.zip.AlignmentRule;
import com.android.tools.build.apkzlib.zip.AlignmentRules;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.android.tools.build.apkzlib.zip.ZFileOptions;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ZFiles {
    private static final AlignmentRule APK_DEFAULT_RULE = AlignmentRules.constant(4);
    private static final String DEFAULT_BUILD_BY = "Generated-by-ADT";
    private static final String DEFAULT_CREATED_BY = "Generated-by-ADT";

    @Nonnull
    public static ZFile apk(@Nonnull File f, @Nonnull ZFileOptions options) throws IOException {
        options.setAlignmentRule(AlignmentRules.compose(options.getAlignmentRule(), APK_DEFAULT_RULE));
        return new ZFile(f, options);
    }

    @Nonnull
    public static ZFile apk(@Nonnull File f, @Nonnull ZFileOptions options, @Nullable PrivateKey key, @Nullable X509Certificate certificate, boolean v1SigningEnabled, boolean v2SigningEnabled, @Nullable String builtBy, @Nullable String createdBy, int minSdkVersion) throws IOException {
        ZFile zfile = ZFiles.apk(f, options);
        if (builtBy == null) {
            builtBy = "Generated-by-ADT";
        }
        if (createdBy == null) {
            createdBy = "Generated-by-ADT";
        }
        ManifestGenerationExtension manifestExt = new ManifestGenerationExtension(builtBy, createdBy);
        manifestExt.register(zfile);
        if (key != null && certificate != null) {
            try {
                new SigningExtension(minSdkVersion, certificate, key, v1SigningEnabled, v2SigningEnabled).register(zfile);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IOException("Failed to create signature extensions", e);
            }
        }
        return zfile;
    }
}

