/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna;

import de.pleumann.antenna.JadSelector;
import de.pleumann.antenna.misc.Conditional;
import de.pleumann.antenna.misc.JadFile;
import de.pleumann.antenna.misc.Utility;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class WtkRun
extends Task {
    private Utility utility;
    private Conditional condition;
    private Path classpath;
    private File jadFile;
    private String encoding;
    private String device;
    private String heapsize;
    private boolean wait = true;
    private String debugAddress;
    private String trace;
    private File m_jadDirectory;
    private boolean m_eclipseDebugger = false;
    private String m_sourcePath;

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathref(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public void setHeapsize(String heapsize) {
        this.heapsize = heapsize;
    }

    public void setJadFile(File jadFile) {
        this.jadFile = jadFile;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public void setDebugAddress(String address) {
        this.debugAddress = address;
    }

    public void setDebug(String address) {
        this.debugAddress = address;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    public void init() throws BuildException {
        super.init();
        this.utility = Utility.getInstance(this.getProject(), this);
        this.condition = new Conditional(this.getProject());
    }

    public void setIf(String s) {
        this.condition.setIf(s);
    }

    public void setUnless(String s) {
        this.condition.setUnless(s);
    }

    public boolean isActive() {
        return this.condition.isActive();
    }

    public void setJadDirectory(File jadDirectory) {
        this.m_jadDirectory = jadDirectory;
    }

    private void executeSiemensEmulator(String device) throws BuildException {
        String emulator;
        if (device != null) {
            emulator = this.utility.getWtkRelative("emulators/" + device + "/bin/emulator.exe");
            if (!new File(emulator).exists()) {
                emulator = this.utility.getWtkRelative(device + "emulators/bin/mmiu35.exe");
            }
            if (!new File(emulator).exists()) {
                throw new BuildException("Siemens " + device + " emulator not found.");
            }
        } else {
            emulator = this.utility.getWtkRelative("/bin/emulator.exe");
            if (!new File(emulator).exists()) {
                throw new BuildException("Siemens emulator not found.");
            }
        }
        emulator = this.utility.getQuotedName(new File(emulator));
        JadFile jad = new JadFile();
        try {
            jad.load(this.jadFile.getAbsolutePath(), this.encoding);
        }
        catch (IOException ex) {
            throw new BuildException("Unable to load JAD file", (Throwable)ex);
        }
        String arguments = (this.debugAddress != null ? " /dj " : " /sj ") + this.utility.getQuotedName(this.jadFile);
        if (this.classpath != null) {
            arguments = arguments + " -classpath \"" + this.classpath + "\"";
        }
        if (this.trace != null) {
            arguments = arguments + " /tracing";
        }
        this.log("Running : " + emulator + " " + arguments);
        try {
            Process proc = Runtime.getRuntime().exec(emulator + " " + arguments);
            if (this.wait) {
                proc.waitFor();
                if (proc.exitValue() != 0) {
                    throw new BuildException("Emulation failed (result=" + proc.exitValue() + ")");
                }
            }
        }
        catch (IOException ex) {
            throw new BuildException("Emulation failed", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            throw new BuildException("Emulation failed", (Throwable)ex);
        }
    }

    private void executeMPowerEmulator(String device) throws BuildException {
        String arguments = this.utility.getQuotedName(this.jadFile);
        this.log("Arguments : " + arguments, 3);
        Java java = new Java();
        java.setProject(this.getProject());
        java.setTaskName(this.getTaskName());
        java.setFork(true);
        java.setJar(new File(this.utility.getWtkRelative(this.utility.getEmulator())));
        java.setArgs(arguments);
        java.executeJava();
    }

    private void executeDefaultEmulator(String device) throws BuildException {
        String emulator = this.utility.getWtkRelative(this.wait ? "bin/emulator.exe" : "bin/emulatorw.exe");
        if (!new File(emulator).exists()) {
            emulator = this.utility.getWtkRelative("bin/emulator");
        }
        emulator = this.utility.getQuotedName(new File(emulator));
        String arguments = " -Xdescriptor:" + this.utility.getQuotedName(this.jadFile);
        if (this.heapsize != null && this.heapsize.length() > 0) {
            arguments = arguments + " -Xheapsize:" + this.heapsize;
        }
        if (device != null && device.length() > 0) {
            arguments = arguments + " -Xdevice:" + device;
        }
        if (this.classpath != null) {
            arguments = arguments + " -classpath \"" + this.classpath + "\"";
        }
        if (this.debugAddress != null) {
            arguments = arguments + " -Xdebug -Xrunjdwp:transport=dt_socket,address=" + this.debugAddress + ",server=y";
        }
        if (this.trace != null) {
            arguments = arguments + " -Xverbose:" + this.trace;
        }
        if (!this.wait) {
            arguments = arguments + " </dev/nul >/dev/nul";
        }
        this.log("Running : " + emulator + " " + arguments);
        if (this.m_eclipseDebugger) {
            this.startEclipseRemoteDebugger();
        }
        try {
            Process proc = Runtime.getRuntime().exec(emulator + " " + arguments);
            if (this.wait) {
                new Thread(new Redirector(proc.getInputStream())).start();
                new Thread(new Redirector(proc.getErrorStream())).start();
                proc.waitFor();
                if (proc.exitValue() != 0) {
                    throw new BuildException("Emulation failed (result=" + proc.exitValue() + ")");
                }
            }
        }
        catch (IOException ex) {
            throw new BuildException("Emulation failed", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            throw new BuildException("Emulation failed", (Throwable)ex);
        }
    }

    private void startEclipseRemoteDebugger() {
        try {
            InetAddress address = InetAddress.getByName("localhost");
            int port = 60001;
            String srcPath = this.m_sourcePath == null ? "" : this.m_sourcePath;
            this.log("Launching eclispe debugger : (address=" + this.debugAddress + ", source path=" + srcPath + ") -> eclipse(" + address + ":" + port + ")");
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(this.debugAddress);
            dout.writeUTF(srcPath);
            dout.flush();
            byte[] buf = bout.toByteArray();
            DatagramPacket packet = new DatagramPacket(buf, buf.length, address, port);
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
        }
        catch (Exception e) {
            this.log(e.getClass().getName() + " : " + e.getMessage());
        }
    }

    public void execute() throws BuildException {
        if (!this.isActive()) {
            return;
        }
        if (this.m_jadDirectory != null) {
            this.jadFile = new JadSelector(this.m_jadDirectory).selectJad();
            if (this.jadFile == null) {
                throw new BuildException("No jad selected");
            }
            this.log("Selected jad : " + this.jadFile);
        }
        if ("Siemens".equals(this.device) || this.utility.getToolkitType() == 10) {
            if ("Siemens".equals(this.device)) {
                this.device = null;
            }
            this.log("Running " + this.jadFile + " on Siemens " + (this.device == null ? "phone" : this.device));
            this.executeSiemensEmulator(this.device);
        } else if (this.utility.getEmulator().endsWith(".jar")) {
            this.log("Running " + this.jadFile + " on java emulator");
            this.executeMPowerEmulator(this.device);
        } else {
            if (this.device == null) {
                this.device = this.utility.getDevice();
            }
            this.log("Running " + this.jadFile + " on " + this.device);
            this.executeDefaultEmulator(this.device);
        }
    }

    public void setEclipseDebugger(boolean startEclipseRemoteDebugger) {
        this.m_eclipseDebugger = startEclipseRemoteDebugger;
    }

    public void setSourcePath(String sourcePath) {
        this.m_sourcePath = sourcePath;
    }

    private class Redirector
    implements Runnable {
        private InputStream input;

        public Redirector(InputStream input) {
            this.input = input;
        }

        public void run() {
            StringBuffer s = new StringBuffer("");
            try {
                int c;
                while ((c = this.input.read()) != -1) {
                    if (c == 10) {
                        WtkRun.this.log(s.toString());
                        s = new StringBuffer("");
                        continue;
                    }
                    if (c == 13) continue;
                    s.append((char)c);
                }
                this.input.close();
                if (s.length() != 0) {
                    WtkRun.this.log(s.toString());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

