/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna.device;

import de.pleumann.antenna.device.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Capability {
    String m_identifier;
    String m_extention_mode;
    String m_group;
    boolean m_required = false;
    String m_type;
    String m_implicitGroup;

    public Capability(Element dev) {
        NodeList props = dev.getChildNodes();
        for (int i = 0; i < props.getLength(); ++i) {
            Node item = props.item(i);
            if (!(item instanceof Element)) continue;
            Element e = (Element)item;
            String tagName = e.getTagName();
            String text = Util.getText(e);
            if ("identifier".equals(tagName)) {
                this.m_identifier = text;
                continue;
            }
            if ("extension-mode".equals(tagName)) {
                this.m_extention_mode = text;
                continue;
            }
            if ("group".equals(tagName)) {
                this.m_group = text;
                continue;
            }
            if ("required".equals(tagName)) {
                this.m_required = "yes".equalsIgnoreCase(text) || "true".equalsIgnoreCase(text);
                continue;
            }
            if ("type".equals(tagName)) {
                this.m_type = text;
                continue;
            }
            if (!"implicit-group".equals(tagName)) continue;
            this.m_implicitGroup = text;
        }
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public boolean extendByOverwrite() {
        return "overwrite".equalsIgnoreCase(this.m_extention_mode);
    }

    public boolean extendByAppend() {
        return "append".equalsIgnoreCase(this.m_extention_mode);
    }
}

