/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna.device;

import de.pleumann.antenna.device.Capability;
import de.pleumann.antenna.device.DeviceProps;
import de.pleumann.antenna.device.Group;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Devices {
    private static Hashtable s_devices;
    private static Hashtable s_groups;
    private static Hashtable s_capablities;
    private static String s_baseDir;

    public static void main(String[] args) {
        block4: {
            String command;
            block3: {
                if (args.length < 1 || !args[0].equalsIgnoreCase("-list") && args.length < 2) {
                    System.err.println("Usage: java " + Devices.class.getName() + "[-list] | -device DeviceName");
                    return;
                }
                command = args[0];
                if (!"-list".equalsIgnoreCase(command)) break block3;
                DeviceProps[] allDevices = Devices.getAllDevices();
                for (int i = 0; i < allDevices.length; ++i) {
                    System.out.println(allDevices[i].getIdentifier());
                }
                break block4;
            }
            if (!"-device".equalsIgnoreCase(command)) break block4;
            DeviceProps device = Devices.getDevice(args[1]);
            Properties capabilities = device.getCapabilities();
            Enumeration<Object> keys = capabilities.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                System.out.println(key + "=" + capabilities.getProperty(key));
            }
        }
    }

    private Devices() {
    }

    public static DeviceProps getDevice(String deviceName) {
        if (deviceName == null) {
            return null;
        }
        return (DeviceProps)s_devices.get(deviceName);
    }

    public static DeviceProps[] getAllDevices() {
        DeviceProps[] devices = new DeviceProps[s_devices.size()];
        Enumeration enumeration = s_devices.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            devices[i++] = (DeviceProps)enumeration.nextElement();
        }
        return devices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() throws IOException, ParserConfigurationException, SAXException {
        Class clazz = Devices.class;
        synchronized (clazz) {
            if (s_capablities == null) {
                Devices.parseCapabilitiesFile();
            }
            if (s_groups == null) {
                Devices.parseGroupsFile();
            }
            if (s_devices == null) {
                Devices.parseDevicesFile();
            }
        }
    }

    private static InputStream openStream(String cpFile) throws FileNotFoundException, IOException {
        File[] dirs = s_baseDir != null ? new File[]{new File(s_baseDir), new File("lib/"), new File("./")} : new File[]{new File("lib/"), new File("./")};
        BufferedInputStream in = null;
        for (int i = 0; i < dirs.length; ++i) {
            File file = new File(dirs[i], cpFile);
            if (file.exists()) {
                System.out.println("Devices: loading " + file);
                in = new BufferedInputStream(new FileInputStream(file));
                break;
            }
            System.out.println("Devices: " + file.getAbsolutePath() + " not found");
        }
        if (in == null) {
            in = new BufferedInputStream(Devices.class.getResourceAsStream("/" + cpFile));
            if (in != null) {
                System.out.println("Devices: loading " + cpFile + " from classpath");
            } else {
                String msg = "Devices: can't find " + cpFile + " in classpath or in file default file system locations (" + Devices.toString(dirs) + ")";
                System.out.println(msg);
                throw new IOException(msg);
            }
        }
        return in;
    }

    private static String toString(File[] files) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            sb.append(files[i]);
            if (i >= files.length) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseGroupsFile() throws IOException, ParserConfigurationException, SAXException {
        s_groups = new Hashtable();
        InputStream in = Devices.openStream("groups.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            NodeList nodes = document.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element e;
                Node node = nodes.item(i);
                if (!(node instanceof Element) || !"groups".equals((e = (Element)node).getTagName())) continue;
                NodeList groups = e.getChildNodes();
                for (int j = 0; j < groups.getLength(); ++j) {
                    Element e1;
                    Node node2 = groups.item(j);
                    if (!(node2 instanceof Element) || !"group".equals((e1 = (Element)node2).getTagName())) continue;
                    Group group = new Group(e1);
                    s_groups.put(group.getName().toLowerCase(), group);
                }
            }
        }
        finally {
            in.close();
        }
    }

    private static void parseDevicesFile() throws IOException, ParserConfigurationException, SAXException {
        s_devices = new Hashtable();
        Devices.parseDevices(Devices.openStream("devices.xml"));
        try {
            Devices.parseDevices(Devices.openStream("custom-devices.xml"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseDevices(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            NodeList nodes = document.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element e;
                Node node = nodes.item(i);
                if (!(node instanceof Element) || !"devices".equals((e = (Element)node).getTagName())) continue;
                NodeList devices = e.getChildNodes();
                for (int j = 0; j < devices.getLength(); ++j) {
                    boolean clone;
                    Element e1;
                    Node node2 = devices.item(j);
                    if (!(node2 instanceof Element) || !"device".equals((e1 = (Element)node2).getTagName())) continue;
                    DeviceProps dev = new DeviceProps(e1);
                    dev.setGroupsData(s_groups, s_capablities);
                    String ids = dev.getIdentifier();
                    StringTokenizer toks = new StringTokenizer(ids, ",");
                    boolean bl = clone = toks.countTokens() > 1;
                    while (toks.hasMoreTokens()) {
                        String id = toks.nextToken().trim();
                        if (s_devices.containsKey(id)) {
                            DeviceProps d = (DeviceProps)s_devices.get(id);
                            d.parseBase(e1);
                            continue;
                        }
                        DeviceProps dev2 = dev;
                        if (id.length() <= 0) continue;
                        if (clone) {
                            try {
                                dev2 = (DeviceProps)dev.clone();
                                dev2.m_identifier = id;
                            }
                            catch (CloneNotSupportedException e2) {
                                throw new RuntimeException(e2);
                            }
                        }
                        s_devices.put(id, dev2);
                    }
                }
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseCapabilitiesFile() throws IOException, ParserConfigurationException, SAXException {
        s_capablities = new Hashtable();
        String cpFile = "capabilities.xml";
        InputStream in = Devices.openStream(cpFile);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            NodeList nodes = document.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element e;
                Node node = nodes.item(i);
                if (!(node instanceof Element) || !"capabilities".equals((e = (Element)node).getTagName())) continue;
                NodeList groups = e.getChildNodes();
                for (int j = 0; j < groups.getLength(); ++j) {
                    Element e1;
                    Node node2 = groups.item(j);
                    if (!(node2 instanceof Element) || !"capability".equals((e1 = (Element)node2).getTagName())) continue;
                    Capability cap = new Capability(e1);
                    s_capablities.put(cap.getIdentifier().toLowerCase(), cap);
                }
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() throws IOException, ParserConfigurationException, SAXException {
        Class clazz = Devices.class;
        synchronized (clazz) {
            s_groups = null;
            s_capablities = null;
            s_devices = null;
        }
        Devices.initialize();
    }

    public static void setDatabaseDir(String dir) throws IOException, ParserConfigurationException, SAXException {
        s_baseDir = dir;
        Devices.reload();
    }

    static {
        try {
            Devices.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

