/*
 * Decompiled with CFR 0.152.
 */
package antenna.preprocessor.v3;

import java.io.File;

public class PPException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN_LINE = -1;
    private final int m_lineNumber;
    private File m_file;

    public PPException(String message) {
        this(message, null, null);
    }

    public PPException(String message, Throwable cause) {
        this(message, null, cause);
    }

    public PPException(String message, File file) {
        this(message, file, null, -1);
    }

    public PPException(String message, File file, int lineNumber) {
        this(message, file, null, lineNumber);
    }

    public PPException(String message, File file, Throwable cause) {
        this(message, file, cause, -1);
    }

    public PPException(String message, File file, Throwable cause, int lineNumber) {
        super(message, cause);
        this.m_lineNumber = lineNumber;
        this.m_file = file;
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public File getFile() {
        return this.m_file;
    }

    public String getMessage() {
        if (this.m_file != null) {
            String ln = this.m_lineNumber != -1 ? ":" + this.m_lineNumber : "";
            return this.m_file + ln + " : " + super.getMessage();
        }
        if (this.m_lineNumber != -1) {
            return "Line #" + this.m_lineNumber + " : " + super.getMessage();
        }
        return super.getMessage();
    }
}

