/*
 * Decompiled with CFR 0.152.
 */
package antenna.preprocessor.v3;

import antenna.preprocessor.v3.CommandEvaluator;
import antenna.preprocessor.v3.Expander;
import antenna.preprocessor.v3.ILineFilter;
import antenna.preprocessor.v3.ILogger;
import antenna.preprocessor.v3.IPreprocessorListener;
import antenna.preprocessor.v3.PPException;
import antenna.preprocessor.v3.PPLine;
import antenna.preprocessor.v3.parser.APPLexer;
import antenna.preprocessor.v3.parser.APPParser;
import antenna.preprocessor.v3.parser.CommonAST;
import antenna.preprocessor.v3.parser.Defines;
import antenna.preprocessor.v3.parser.PPLineAST;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import java.util.Vector;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenRewriteStream;

public class Preprocessor {
    public static final int STATE_NO_CONDITIONAL = 0;
    public static final int STATE_CAN_BECOME_TRUE = 1;
    public static final int STATE_IS_TRUE = 2;
    public static final int STATE_HAS_BEEN_TRUE = 3;
    private Stack m_statsStack;
    private int m_currentState;
    private boolean m_verbose = false;
    private Defines m_defines;
    private File m_file;
    public ILogger m_logger;
    public ILineFilter m_lineFilter;
    private IPreprocessorListener m_listener;
    private boolean m_disabledByCondition = false;
    private boolean m_debugHideNextLine = false;
    private int m_currentMdebugBlockStart = -1;
    private boolean m_insideHiddenMdebugBlock = false;
    private boolean m_modified;

    public Preprocessor(ILogger logger, ILineFilter lineFilter) {
        this.m_logger = logger;
        this.m_lineFilter = lineFilter;
        this.m_defines = new Defines(lineFilter);
    }

    public void setListener(IPreprocessorListener listener) {
        this.m_listener = listener;
    }

    public void setFile(File fileName) {
        this.m_file = fileName;
    }

    public void addDefines(String defines) throws PPException {
        try {
            this.m_defines.addDefines(defines);
        }
        catch (Exception e) {
            throw new PPException("Error evaluating symbols \"" + defines + "\"", e);
        }
    }

    public void addDefines(InputStream in) throws IOException, PPException {
        try {
            this.m_defines.loadDefines(in);
        }
        catch (Exception e) {
            throw new PPException("Error evaluating symbols from input stream", e);
        }
    }

    public void addDefines(File file) throws IOException, PPException {
        try {
            this.m_defines.loadDefines(file);
        }
        catch (Exception e) {
            throw new PPException("Error evaluating symbols from file " + file, e);
        }
    }

    private void log(String msg) {
        if (this.m_verbose) {
            if (this.m_logger != null) {
                this.m_logger.log(msg);
            } else {
                System.err.println(msg);
            }
        }
    }

    public boolean preprocess(InputStream in, OutputStream out, String encoding) throws IOException, PPException {
        Vector lines = new Vector();
        Preprocessor.loadStrings(lines, in, encoding);
        boolean changed = this.preprocess(lines, encoding);
        Preprocessor.saveStrings(lines, out, encoding);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStrings(Vector lines, OutputStream out, String encoding) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, encoding));
        try {
            int size = lines.size();
            for (int i = 0; i < size; ++i) {
                writer.write((String)lines.get(i));
                writer.newLine();
            }
        }
        finally {
            writer.close();
        }
    }

    public static void loadStrings(Vector lines, InputStream in, String encoding) throws IOException {
        String s;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, encoding));
        while ((s = reader.readLine()) != null) {
            lines.add(s);
        }
        reader.close();
    }

    public boolean preprocess(Vector lines, String encoding) throws IOException, PPException {
        try {
            return this.preprocessImpl(lines, encoding);
        }
        catch (IOException e) {
            if (this.m_listener != null) {
                this.m_listener.error(e, -1, -1, -1);
            }
            throw e;
        }
        catch (PPException e) {
            if (this.m_listener != null) {
                int lineNumber = e.getLineNumber();
                int ln = lineNumber != -1 ? lineNumber + 1 : lineNumber;
                this.m_listener.error(e, ln, -1, -1);
                return false;
            }
            throw e;
        }
    }

    private boolean preprocessImpl(Vector lines, String encoding) throws IOException, PPException {
        this.m_modified = false;
        this.m_statsStack = new Stack();
        this.m_currentState = 0;
        this.m_disabledByCondition = false;
        CommandEvaluator eval = new CommandEvaluator(this.m_defines);
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (this.m_lineFilter != null) {
                line = this.m_lineFilter.filter(line);
            }
            PPLine lp = new PPLine(this.m_file, line, i);
            try {
                if (lp.getType() == "VISIBLE" || lp.getType() == "HIDDEN") {
                    if (this.isBlind()) {
                        String l = this.commentLine(lp);
                        if (!l.equals(line)) {
                            this.m_modified = true;
                        }
                        lines.set(i, l);
                        if (this.isVerbose()) {
                            this.log("(+)" + l);
                        }
                    } else {
                        boolean replace = true;
                        String str = this.uncommentLine(lp);
                        if (!str.equals(line)) {
                            this.m_modified = true;
                        }
                        if (replace) {
                            lines.set(i, str);
                        } else {
                            lines.insertElementAt(str, i);
                        }
                        if (this.isVerbose()) {
                            this.log("(-)" + str);
                        }
                    }
                    this.m_debugHideNextLine = false;
                    continue;
                }
                PPLineAST ast = this.getAST(lp);
                int includeLine = i++;
                if (ast.getType() == 37) {
                    boolean foundEndInclude = false;
                    int currentLine = i;
                    while (i < lines.size()) {
                        PPLineAST ast2;
                        PPLine lp2 = new PPLine(this.m_file, (String)lines.get(i), currentLine);
                        if (lp2.getType() == "COMMAND" && (ast2 = this.getAST(lp2)).getType() == 36) {
                            foundEndInclude = true;
                            break;
                        }
                        lines.remove(i);
                        ++currentLine;
                    }
                    if (!foundEndInclude) {
                        throw new PPException("Missing #endinclude", this.m_file, includeLine);
                    }
                    String file = this.getIncludeName(lp);
                    Vector includeLines = this.loadIncludedFile(includeLine, file, encoding);
                    if (includeLines == null) continue;
                    Preprocessor includePreprocessor = new Preprocessor(this.m_logger, this.m_lineFilter);
                    includePreprocessor.setFile(this.m_file);
                    includePreprocessor.setListener(this.m_listener);
                    includePreprocessor.m_defines = this.m_defines;
                    includePreprocessor.preprocess(includeLines, encoding);
                    for (int k = 0; k < includeLines.size(); ++k) {
                        String s = (String)includeLines.get(k);
                        PPLine lp2 = new PPLine(this.m_file, s, k);
                        if (this.isBlind()) {
                            s = this.commentLine(lp2);
                        }
                        lines.insertElementAt(s, i);
                        ++i;
                        this.m_modified = true;
                    }
                    continue;
                }
                this.handleCommand(lines, lp, ast, eval, encoding, i + 1 == lines.size());
                continue;
            }
            catch (IllegalStateException e) {
                throw new PPException(e.getMessage(), this.m_file, e, i);
            }
            catch (Exception e) {
                throw new PPException("Error parsing line : " + line, this.m_file, e, i);
            }
        }
        if (this.m_currentState != 0) {
            throw new PPException("Missing #endif", this.m_file, -1);
        }
        if (this.m_insideHiddenMdebugBlock) {
            throw new PPException("Missing #enddebug", this.m_file, this.m_currentMdebugBlockStart);
        }
        return this.m_modified;
    }

    public static String regExpQuote(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuilder sb = new StringBuilder(s.length() * 2);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    private String toTemplate(String line) {
        return "\\s*" + Preprocessor.regExpQuote(line.trim()).replaceAll("%.*%", "\\\\E\\.\\*\\\\Q") + "\\s*";
    }

    private String getIncludeName(PPLine line) throws RecognitionException {
        String text = line.getText();
        text = text.substring("include".length()).trim();
        return text;
    }

    private String getExpandLine(PPLine line) {
        String prevLine = line.getText();
        String tok = "expand";
        if ((prevLine = prevLine.substring(tok.length())).charAt(0) == ' ' || prevLine.charAt(0) == '\t') {
            prevLine = prevLine.substring(1);
        }
        return line.getSpace() + prevLine;
    }

    private PPLineAST getAST(PPLine lp) throws PPException, RecognitionException, IOException {
        String s = lp.getText();
        if (s.startsWith("expand")) {
            PPLineAST ast = new PPLineAST(new CommonToken(38, s));
            return ast;
        }
        if (s.startsWith("include")) {
            PPLineAST ast = new PPLineAST(new CommonToken(37, s));
            return ast;
        }
        APPLexer lexer = new APPLexer(new ANTLRReaderStream(new StringReader(lp.getSource())));
        TokenRewriteStream tokens = new TokenRewriteStream(lexer);
        APPParser parser = new APPParser(tokens);
        parser.setTreeAdaptor(PPLineAST.adaptor);
        APPParser.line_return line_return2 = null;
        try {
            line_return2 = parser.line();
        }
        catch (Exception e) {
            throw new PPException("Error parsing " + lp.getSource(), lp.getFileName(), e, lp.getLineNumber());
        }
        PPLineAST ast = (PPLineAST)line_return2.getTree();
        CommonAST.fillParentInfo(ast);
        if (ast.isNil()) {
            ast = (PPLineAST)ast.getChild(1);
        }
        return ast;
    }

    private Vector loadIncludedFile(int lineNum, String file, String encoding) throws PPException {
        File f;
        if (new File(file).isAbsolute()) {
            f = new File(file);
        } else {
            File parent = this.m_file.getParentFile();
            f = new File(parent, file);
        }
        if (!f.exists()) {
            throw new PPException("File not found : " + f, this.m_file, lineNum);
        }
        Vector v = new Vector();
        try {
            Preprocessor.loadStrings(v, new FileInputStream(f), encoding);
            return v;
        }
        catch (IOException e) {
            throw new PPException("Error loading include file " + file, this.m_file, e, lineNum);
        }
    }

    private void pushState() {
        this.m_statsStack.push(new Integer(this.m_currentState));
    }

    private void popState() {
        this.m_currentState = (Integer)this.m_statsStack.pop();
    }

    public boolean isBlind() {
        return this.m_currentState == 1 || this.m_currentState == 3 || this.m_disabledByCondition || this.m_debugHideNextLine || this.m_insideHiddenMdebugBlock;
    }

    public boolean isVerbose() {
        return this.m_verbose;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    String commentLine(PPLine lp) {
        if (lp.getType() == "VISIBLE" || lp.prefixChar() != '@' && lp.getType() != "COMMAND") {
            return "//@" + lp.getSpace() + lp.getText();
        }
        return lp.getSource();
    }

    String uncommentLine(PPLine lp) {
        return lp.getSpace() + lp.getText();
    }

    private void handleIf(boolean condition) {
        this.pushState();
        this.m_currentState = !this.isBlind() ? (condition ? 2 : 1) : 3;
    }

    private void handleElseIf(boolean condition) {
        if (this.m_currentState == 0) {
            throw new IllegalStateException("Unexpected #elif");
        }
        if (this.m_currentState == 1) {
            if (condition) {
                this.m_currentState = 2;
            }
        } else if (this.m_currentState == 2) {
            this.m_currentState = 3;
        }
    }

    private void handleElse() {
        if (this.m_currentState == 0) {
            throw new IllegalStateException("Unexpected #else");
        }
        if (this.m_currentState == 1) {
            this.m_currentState = 2;
        } else if (this.m_currentState == 2) {
            this.m_currentState = 3;
        }
    }

    private void handleEndIf() {
        if (this.m_currentState == 0) {
            throw new IllegalStateException("Unexpected #endif");
        }
        this.popState();
    }

    private void handleCommand(Vector lines, PPLine ppl, PPLineAST ast, CommandEvaluator evaluator, String encoding, boolean lastLine) throws Exception, PPException, UnsupportedEncodingException {
        if (this.isVerbose()) {
            this.log("(?)" + ppl.getSource());
        }
        int type = ast.getType();
        switch (type) {
            case 25: 
            case 26: {
                if (this.isBlind()) break;
                evaluator.evaluate(ppl, ast, this.m_listener);
                break;
            }
            case 27: 
            case 30: 
            case 31: {
                boolean r = evaluator.evaluate(ppl, ast, this.m_listener);
                this.handleIf(r);
                break;
            }
            case 29: {
                if (ppl.getLineNumber() != 0) {
                    throw new PPException("//#condition is only allowed in the first line of the file", this.m_file, ppl.getLineNumber());
                }
                boolean r = evaluator.evaluate(ppl, ast, this.m_listener);
                this.handleCondition(r);
                break;
            }
            case 28: 
            case 32: 
            case 33: {
                boolean r = evaluator.evaluate(ppl, ast, this.m_listener);
                this.handleElseIf(r);
                break;
            }
            case 35: {
                this.handleElse();
                break;
            }
            case 34: {
                this.handleEndIf();
                break;
            }
            case 20: {
                boolean show = evaluator.evaluate(ppl, ast, this.m_listener);
                this.m_debugHideNextLine = !show;
                break;
            }
            case 39: {
                boolean show = evaluator.evaluate(ppl, ast, this.m_listener);
                this.handleMdebug(show, ppl.getLineNumber());
                break;
            }
            case 40: {
                this.handleEnddebug();
                break;
            }
            case 38: {
                this.handleExpand(ppl, lines);
                break;
            }
            default: {
                throw new PPException("Unexpected token " + APPParser.tokenNames[type] + " at \"" + ppl.getSource() + "\"", this.m_file, ppl.getLineNumber());
            }
        }
        if (type != 20) {
            this.m_debugHideNextLine = false;
        }
    }

    private void handleExpand(PPLine ppl, Vector lines) {
        String expLine = this.getExpandLine(ppl);
        String template = this.toTemplate(expLine);
        int nextIndex = ppl.getLineNumber() + 1;
        String str = lines.size() > nextIndex ? (String)lines.get(nextIndex) : "";
        PPLine nextPPline = new PPLine(this.m_file, str, nextIndex);
        String nextLine = this.uncommentLine(nextPPline);
        boolean replace = nextLine.matches(template);
        String expanded = Expander.expandMacros(expLine, this.m_defines);
        if (!nextLine.equals(expanded)) {
            this.m_modified = true;
        }
        if (replace) {
            lines.set(nextIndex, expanded);
        } else {
            lines.insertElementAt(expanded, nextIndex);
        }
    }

    private void handleEnddebug() {
        this.m_currentMdebugBlockStart = -1;
        this.m_insideHiddenMdebugBlock = false;
    }

    private void handleMdebug(boolean show, int lineNumber) {
        this.m_currentMdebugBlockStart = lineNumber;
        this.m_insideHiddenMdebugBlock = !show;
    }

    private void handleCondition(boolean conditionTrue) {
        this.m_disabledByCondition = !conditionTrue;
    }

    public Defines getDefines() {
        return this.m_defines;
    }

    public void clearDefines() {
        this.m_defines.clear();
    }
}

