/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.InjectingObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

public class InjectingObjectCodecAdapter<T, D>
implements ObjectCodec<T> {
    private final InjectingObjectCodec<T, D> codec;
    private final D dependency;

    public InjectingObjectCodecAdapter(InjectingObjectCodec<T, D> codec, D dependency) {
        this.codec = codec;
        this.dependency = dependency;
    }

    @Override
    public Class<T> getEncodedClass() {
        return this.codec.getEncodedClass();
    }

    @Override
    public void serialize(T obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        this.codec.serialize(this.dependency, obj, codedOut);
    }

    @Override
    public T deserialize(CodedInputStream codedIn) throws SerializationException, IOException {
        return this.codec.deserialize(this.dependency, codedIn);
    }
}

