/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.util.AutoValue_Commented;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.parser.Tokens;

@AutoValue
public abstract class Commented<T extends Tree> {
    public abstract T tree();

    public abstract ImmutableList<Tokens.Comment> beforeComments();

    public abstract ImmutableList<Tokens.Comment> afterComments();

    static <T extends Tree> Builder<T> builder() {
        return new AutoValue_Commented.Builder();
    }

    private static final class OffsetComment
    implements Tokens.Comment {
        private final Tokens.Comment wrapped;
        private final int offset;

        private OffsetComment(Tokens.Comment wrapped, int offset) {
            this.wrapped = wrapped;
            this.offset = offset;
        }

        @Override
        public String getText() {
            return this.wrapped.getText();
        }

        @Override
        public int getSourcePos(int i) {
            return this.wrapped.getSourcePos(i) + this.offset;
        }

        @Override
        public Tokens.Comment.CommentStyle getStyle() {
            return this.wrapped.getStyle();
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }
    }

    @AutoValue.Builder
    static abstract class Builder<T extends Tree> {
        Builder() {
        }

        abstract Builder<T> setTree(T var1);

        protected abstract ImmutableList.Builder<Tokens.Comment> beforeCommentsBuilder();

        protected abstract ImmutableList.Builder<Tokens.Comment> afterCommentsBuilder();

        Builder<T> addComment(Tokens.Comment comment, int nodePosition, int tokenizingOffset) {
            OffsetComment offsetComment = new OffsetComment(comment, tokenizingOffset);
            if (comment.getSourcePos(0) < nodePosition) {
                this.beforeCommentsBuilder().add((Object)offsetComment);
            } else {
                this.afterCommentsBuilder().add((Object)offsetComment);
            }
            return this;
        }

        Builder<T> addAllComment(Iterable<? extends Tokens.Comment> comments, int nodePosition, int tokenizingOffset) {
            for (Tokens.Comment comment : comments) {
                this.addComment(comment, nodePosition, tokenizingOffset);
            }
            return this;
        }

        abstract Commented<T> build();
    }
}

