/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.client;

import com.hazelcast.client.impl.client.ClientPortableHook;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.client.impl.client.TargetClientRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.ActionConstants;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.impl.proxyservice.impl.operations.InitializeDistributedObjectOperation;
import java.io.IOException;
import java.security.Permission;
import java.util.Collection;

public class ClientCreateRequest
extends TargetClientRequest
implements Portable,
SecureRequest {
    private String name;
    private String serviceName;
    private Address target;

    public ClientCreateRequest() {
    }

    public ClientCreateRequest(String name, String serviceName, Address target) {
        this.name = name;
        this.serviceName = serviceName;
        this.target = target;
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    protected Operation prepareOperation() {
        return new InitializeDistributedObjectOperation(this.serviceName, this.name);
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation op) {
        return this.operationService.createInvocationBuilder(this.getServiceName(), op, this.target).setTryCount(1);
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("s", this.serviceName);
        this.target.writeData(writer.getRawDataOutput());
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.serviceName = reader.readUTF("s");
        this.target = new Address();
        this.target.readData(reader.getRawDataInput());
    }

    @Override
    public Permission getRequiredPermission() {
        ProxyService proxyService = this.clientEngine.getProxyService();
        Collection<String> distributedObjectNames = proxyService.getDistributedObjectNames(this.serviceName);
        if (distributedObjectNames.contains(this.name)) {
            return null;
        }
        return ActionConstants.getPermission(this.name, this.serviceName, "create");
    }
}

