/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.client.MapKeyBasedClientRequest;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class MapExecuteOnKeyRequest
extends MapKeyBasedClientRequest
implements Portable,
SecureRequest {
    private Data key;
    private EntryProcessor processor;
    private boolean submitToKey;
    private long threadId;

    public MapExecuteOnKeyRequest() {
    }

    public MapExecuteOnKeyRequest(String name, EntryProcessor processor, Data key, long threadId) {
        super(name);
        this.processor = processor;
        this.key = key;
        this.threadId = threadId;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        MapOperation op = this.getOperationProvider().createEntryOperation(this.name, this.key, this.processor);
        op.setThreadId(this.threadId);
        return op;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 38;
    }

    public void setAsSubmitToKey() {
        this.submitToKey = true;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeBoolean("s", this.submitToKey);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
        out.writeObject(this.processor);
        out.writeLong(this.threadId);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.submitToKey = reader.readBoolean("s");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
        this.processor = (EntryProcessor)in.readObject();
        this.threadId = in.readLong();
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "put", "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        if (this.submitToKey) {
            return "submitToKey";
        }
        return "executeOnKey";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.processor};
    }
}

