/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.subclass;

import java.util.Collections;
import java.util.List;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.dynamic.MethodTransformer;
import net.bytebuddy.dynamic.scaffold.MethodRegistry;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.LatentMethodMatcher;

public interface ConstructorStrategy {
    public List<MethodDescription.Token> extractConstructors(TypeDescription var1);

    public MethodRegistry inject(MethodRegistry var1, MethodAttributeAppender.Factory var2);

    public static enum Default implements ConstructorStrategy
    {
        NO_CONSTRUCTORS{

            @Override
            public List<MethodDescription.Token> extractConstructors(TypeDescription superType) {
                return Collections.emptyList();
            }

            @Override
            public MethodRegistry inject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory defaultMethodAttributeAppenderFactory) {
                return methodRegistry;
            }
        }
        ,
        DEFAULT_CONSTRUCTOR{

            @Override
            public List<MethodDescription.Token> extractConstructors(TypeDescription instrumentedType) {
                MethodList.Empty defaultConstructors;
                TypeDescription superType = instrumentedType.getSuperType().asErasure();
                MethodList<MethodDescription.InDefinedShape> methodList = defaultConstructors = superType == null ? new MethodList.Empty() : (MethodList)superType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isVisibleTo(instrumentedType)));
                if (defaultConstructors.size() == 1) {
                    return defaultConstructors.asTokenList();
                }
                throw new IllegalArgumentException(instrumentedType.getSuperType() + " declares no constructor that is visible to " + instrumentedType);
            }

            @Override
            public MethodRegistry inject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory defaultMethodAttributeAppenderFactory) {
                return methodRegistry.append(new LatentMethodMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), defaultMethodAttributeAppenderFactory, MethodTransformer.NoOp.INSTANCE);
            }
        }
        ,
        IMITATE_SUPER_TYPE{

            @Override
            public List<MethodDescription.Token> extractConstructors(TypeDescription instrumentedType) {
                GenericTypeDescription superType = instrumentedType.getSuperType();
                return (superType == null ? new MethodList.Empty() : (MethodList)superType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.isVisibleTo(instrumentedType)))).asTokenList();
            }

            @Override
            public MethodRegistry inject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory defaultMethodAttributeAppenderFactory) {
                return methodRegistry.append(new LatentMethodMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), defaultMethodAttributeAppenderFactory, MethodTransformer.NoOp.INSTANCE);
            }
        }
        ,
        IMITATE_SUPER_TYPE_PUBLIC{

            @Override
            public List<MethodDescription.Token> extractConstructors(TypeDescription instrumentedType) {
                GenericTypeDescription superType = instrumentedType.getSuperType();
                return (superType == null ? new MethodList.Empty() : (MethodList)superType.asErasure().getDeclaredMethods().filter(ElementMatchers.isPublic().and(ElementMatchers.isConstructor()))).asTokenList();
            }

            @Override
            public MethodRegistry inject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory defaultMethodAttributeAppenderFactory) {
                return methodRegistry.append(new LatentMethodMatcher.Resolved(ElementMatchers.isConstructor()), new MethodRegistry.Handler.ForImplementation(SuperMethodCall.INSTANCE), defaultMethodAttributeAppenderFactory, MethodTransformer.NoOp.INSTANCE);
            }
        };


        public String toString() {
            return "ConstructorStrategy.Default." + this.name();
        }
    }
}

