/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.MapSubject;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import javax.annotation.Nullable;

public final class SortedMapSubject
extends MapSubject {
    private final NavigableMap<?, ?> actualAsNavigableMap;

    SortedMapSubject(FailureMetadata metadata, SortedMap<?, ?> map) {
        super(metadata, (Map<?, ?>)map);
        this.actualAsNavigableMap = map == null ? null : SortedMapAsNavigableMap.wrapIfNecessary(map);
    }

    @Override
    public SortedMapSubject named(String format, Object ... args) {
        super.named(format, args);
        return this;
    }

    public void hasFirstKey(@Nullable Object key) {
        if (this.actualAsNavigableMap().isEmpty()) {
            this.fail("has first key", key);
            return;
        }
        if (!Objects.equal(this.actualAsNavigableMap().firstKey(), (Object)key)) {
            if (this.actualAsNavigableMap().containsKey(key)) {
                this.failWithRawMessage("Not true that %s has first key <%s>. It does contain this key, but the first key is <%s>", this.actualAsString(), key, this.actualAsNavigableMap().firstKey());
                return;
            }
            this.failWithRawMessage("Not true that %s has first key <%s>. It does not contain this key, and the first key is <%s>", this.actualAsString(), key, this.actualAsNavigableMap().firstKey());
        }
    }

    public void hasFirstEntry(@Nullable Object key, @Nullable Object value) {
        Map.Entry expectedEntry = Maps.immutableEntry((Object)key, (Object)value);
        if (this.actualAsNavigableMap().isEmpty()) {
            this.fail("has first entry", (Object)expectedEntry);
            return;
        }
        Map.Entry<?, ?> actualFirstEntry = this.actualAsNavigableMap().firstEntry();
        if (!Objects.equal(actualFirstEntry, (Object)expectedEntry)) {
            Object actualFirstKey = actualFirstEntry.getKey();
            if (this.actualAsNavigableMap().entrySet().contains(expectedEntry)) {
                this.failWithRawMessage("Not true that %s has first entry <%s>. It does contain this entry, but the first entry is <%s>", this.actualAsString(), expectedEntry, actualFirstEntry);
            } else if (Objects.equal(actualFirstKey, (Object)key)) {
                this.failWithRawMessage("Not true that %s has first entry <%s>, the first value is <%s>", this.actualAsString(), expectedEntry, actualFirstEntry.getValue());
            } else if (Objects.equal(actualFirstEntry.getValue(), (Object)value)) {
                this.failWithRawMessage("Not true that %s has first entry <%s>, the first key is <%s>", this.actualAsString(), expectedEntry, actualFirstKey);
            } else if (this.actualAsNavigableMap().containsKey(key)) {
                this.failWithRawMessage("Not true that %s has first entry <%s>. It does contain this key, but the key is mapped to <%s>, and the first entry is <%s>", this.actualAsString(), expectedEntry, this.actualAsNavigableMap().get(key), actualFirstEntry);
            } else if (this.actualAsNavigableMap().containsValue(value)) {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry actualEntry : this.actualAsNavigableMap().entrySet()) {
                    if (!Objects.equal(actualEntry.getValue(), (Object)value)) continue;
                    keys.add(actualEntry.getKey());
                }
                this.failWithRawMessage("Not true that %s has first entry <%s>. It does contain this value, but the value is mapped from the keys <%s>, and the first entry is <%s>", this.actualAsString(), expectedEntry, keys, actualFirstEntry);
            } else {
                this.failWithRawMessage("Not true that %s has first entry <%s>. It does not contain this entry, and the first entry is <%s>", this.actualAsString(), expectedEntry, actualFirstEntry);
            }
        }
    }

    public void hasLastKey(@Nullable Object key) {
        if (this.actualAsNavigableMap().isEmpty()) {
            this.fail("has last key", key);
            return;
        }
        if (!Objects.equal(this.actualAsNavigableMap().lastKey(), (Object)key)) {
            if (this.actualAsNavigableMap().containsKey(key)) {
                this.failWithRawMessage("Not true that %s has last key <%s>. It does contain this key, but the last key is <%s>", this.actualAsString(), key, this.actualAsNavigableMap().lastKey());
                return;
            }
            this.failWithRawMessage("Not true that %s has last key <%s>. It does not contain this key, and the last key is <%s>", this.actualAsString(), key, this.actualAsNavigableMap().lastKey());
        }
    }

    public void hasLastEntry(@Nullable Object key, @Nullable Object value) {
        Map.Entry expectedEntry = Maps.immutableEntry((Object)key, (Object)value);
        if (this.actualAsNavigableMap().isEmpty()) {
            this.fail("has last entry", (Object)expectedEntry);
            return;
        }
        Map.Entry<?, ?> actualLastEntry = this.actualAsNavigableMap().lastEntry();
        if (!Objects.equal(actualLastEntry, (Object)expectedEntry)) {
            Object actualLastKey = actualLastEntry.getKey();
            if (this.actualAsNavigableMap().entrySet().contains(expectedEntry)) {
                this.failWithRawMessage("Not true that %s has last entry <%s>. It does contain this entry, but the last entry is <%s>", this.actualAsString(), expectedEntry, actualLastEntry);
            } else if (Objects.equal(actualLastKey, (Object)key)) {
                this.failWithRawMessage("Not true that %s has last entry <%s>, the last value is <%s>", this.actualAsString(), expectedEntry, actualLastEntry.getValue());
            } else if (Objects.equal(actualLastEntry.getValue(), (Object)value)) {
                this.failWithRawMessage("Not true that %s has last entry <%s>, the last key is <%s>", this.actualAsString(), expectedEntry, actualLastKey);
            } else if (this.actualAsNavigableMap().containsKey(key)) {
                this.failWithRawMessage("Not true that %s has last entry <%s>. It does contain this key, but the key is mapped to <%s>, and the last entry is <%s>", this.actualAsString(), expectedEntry, this.actualAsNavigableMap().get(key), actualLastEntry);
            } else if (this.actualAsNavigableMap().containsValue(value)) {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry actualEntry : this.actualAsNavigableMap().entrySet()) {
                    if (!Objects.equal(actualEntry.getValue(), (Object)value)) continue;
                    keys.add(actualEntry.getKey());
                }
                this.failWithRawMessage("Not true that %s has last entry <%s>. It does contain this value, but the value is mapped from the keys <%s>, and the last entry is <%s>", this.actualAsString(), expectedEntry, keys, actualLastEntry);
            } else {
                this.failWithRawMessage("Not true that %s has last entry <%s>. It does not contain this entry, and the last entry is <%s>", this.actualAsString(), expectedEntry, actualLastEntry);
            }
        }
    }

    private NavigableMap<?, ?> actualAsNavigableMap() {
        return this.actualAsNavigableMap;
    }

    private static class SortedMapAsNavigableMap<K, V>
    extends ForwardingSortedMap<K, V>
    implements NavigableMap<K, V> {
        private final SortedMap<K, V> delegate;

        static <K, V> NavigableMap<K, V> wrapIfNecessary(SortedMap<K, V> map) {
            if (map instanceof NavigableMap) {
                return (NavigableMap)map;
            }
            return new SortedMapAsNavigableMap<K, V>(map);
        }

        SortedMapAsNavigableMap(SortedMap<K, V> delegate) {
            this.delegate = (SortedMap)Preconditions.checkNotNull(delegate);
        }

        protected SortedMap<K, V> delegate() {
            return this.delegate;
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K ceilingKey(K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Iterator entryIterator = this.delegate().entrySet().iterator();
            return entryIterator.hasNext() ? entryIterator.next() : null;
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K floorKey(K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K higherKey(K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            try {
                Object lastKey = this.delegate().lastKey();
                return (Map.Entry)Iterables.getOnlyElement(this.delegate().tailMap(lastKey).entrySet());
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K lowerKey(K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            throw new UnsupportedOperationException();
        }
    }
}

