/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.bugpatterns.argumentselectiondefects.AutoValue_ArgumentChangeFinder;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Changes;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Costs;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Heuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.InvocationInfo;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Parameter;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ParameterPair;
import com.sun.source.tree.ExpressionTree;
import java.util.List;
import java.util.function.Function;

@AutoValue
abstract class ArgumentChangeFinder {
    ArgumentChangeFinder() {
    }

    abstract Function<ParameterPair, Double> distanceFunction();

    abstract ImmutableList<Heuristic> heuristics();

    static Builder builder() {
        return new AutoValue_ArgumentChangeFinder.Builder();
    }

    Changes findChanges(InvocationInfo invocationInfo) {
        if (invocationInfo.formalParameters().size() <= 1) {
            return Changes.empty();
        }
        if (invocationInfo.actualParameters().size() < invocationInfo.formalParameters().size()) {
            return Changes.empty();
        }
        ImmutableList<Parameter> formals = Parameter.createListFromVarSymbols(invocationInfo.formalParameters());
        ImmutableList<Parameter> actuals = Parameter.createListFromExpressionTrees((List<? extends ExpressionTree>)invocationInfo.actualParameters().subList(0, invocationInfo.formalParameters().size()));
        Costs costs = new Costs(formals, actuals);
        costs.viablePairs().filter(ParameterPair::isAlternativePairing).filter(p -> !p.actual().isAssignableTo(p.formal(), invocationInfo.state())).forEach(p -> costs.invalidatePair((ParameterPair)p));
        if (costs.viablePairs().noneMatch(ParameterPair::isAlternativePairing)) {
            return Changes.empty();
        }
        costs.viablePairs().forEach(p -> costs.updatePair((ParameterPair)p, this.distanceFunction().apply((ParameterPair)p)));
        Changes changes = costs.computeAssignments();
        if (changes.isEmpty()) {
            return changes;
        }
        for (Heuristic heuristic : this.heuristics()) {
            if (heuristic.isAcceptableChange(changes, invocationInfo.tree(), invocationInfo.symbol(), invocationInfo.state())) continue;
            return Changes.empty();
        }
        return changes;
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setDistanceFunction(Function<ParameterPair, Double> var1);

        abstract ImmutableList.Builder<Heuristic> heuristicsBuilder();

        Builder addHeuristic(Heuristic heuristic) {
            this.heuristicsBuilder().add((Object)heuristic);
            return this;
        }

        abstract ArgumentChangeFinder build();
    }
}

