/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@BugPattern(name="AssignmentToMock", summary="Fields annotated with @Mock should not be manually assigned to.", severity=BugPattern.SeverityLevel.WARNING)
public final class AssignmentToMock
extends BugChecker
implements BugChecker.AssignmentTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Matcher<Tree> HAS_MOCK_ANNOTATION = Matchers.hasAnnotation((String)"org.mockito.Mock");
    private static final Matcher<ExpressionTree> MOCK_FACTORY = MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("mock");
    private static final Matcher<ExpressionTree> INITIALIZES_MOCKS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("org.mockito.MockitoAnnotations").named("initMocks")});
    private static final MultiMatcher<ClassTree, AnnotationTree> MOCKITO_RUNNER = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.hasArgumentWithValue((String)"value", (Matcher)JUnitMatchers.isJUnit4TestRunnerOfType((Iterable)ImmutableList.of((Object)"org.mockito.runners.MockitoJUnitRunner"))));

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        if (!HAS_MOCK_ANNOTATION.matches((Tree)tree.getVariable(), state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = SuggestedFix.delete((Tree)tree);
        return this.describeMatch(tree, (Fix)fix);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (tree.getInitializer() == null || !HAS_MOCK_ANNOTATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)AssignmentToMock.createFix(tree, state));
    }

    private static SuggestedFix createFix(VariableTree tree, VisitorState state) {
        if (MOCK_FACTORY.matches((Tree)tree.getInitializer(), state) && !AssignmentToMock.classContainsInitializer((ClassTree)state.findEnclosing(new Class[]{ClassTree.class}), state)) {
            AnnotationTree anno = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"Mock");
            return SuggestedFix.delete((Tree)anno);
        }
        int startPos = ((JCTree)((Object)tree)).getStartPosition();
        List tokens = state.getOffsetTokens(startPos, ((JCTree)((Object)tree.getInitializer())).getStartPosition());
        for (ErrorProneToken token : Lists.reverse((List)tokens)) {
            if (token.kind() != Tokens.TokenKind.EQ) continue;
            return SuggestedFix.replace((int)token.pos(), (int)state.getEndPosition((Tree)tree.getInitializer()), (String)"");
        }
        return SuggestedFix.builder().build();
    }

    private static boolean classContainsInitializer(ClassTree classTree, final VisitorState state) {
        final AtomicBoolean initialized = new AtomicBoolean(false);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitClass(ClassTree classTree, Void unused) {
                if (MOCKITO_RUNNER.matches((Tree)classTree, state)) {
                    initialized.set(true);
                    return null;
                }
                return (Void)super.visitClass(classTree, null);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void unused) {
                if (INITIALIZES_MOCKS.matches((Tree)methodInvocationTree, state)) {
                    initialized.set(true);
                    return null;
                }
                return (Void)super.visitMethodInvocation(methodInvocationTree, null);
            }

            @Override
            public Void visitNewClass(NewClassTree newClassTree, Void unused) {
                if (INITIALIZES_MOCKS.matches((Tree)newClassTree, state)) {
                    initialized.set(true);
                    return null;
                }
                return (Void)super.visitNewClass(newClassTree, null);
            }
        }.scan(classTree, null);
        return initialized.get();
    }
}

