/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import javax.lang.model.element.Modifier;

@BugPattern(name="NonAtomicVolatileUpdate", summary="This update of a volatile variable is non-atomic", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class NonAtomicVolatileUpdate
extends BugChecker
implements BugChecker.UnaryTreeMatcher,
BugChecker.CompoundAssignmentTreeMatcher,
BugChecker.AssignmentTreeMatcher {
    private static final Matcher<UnaryTree> unaryIncrementDecrementMatcher = Matchers.allOf((Matcher[])new Matcher[]{NonAtomicVolatileUpdate.expressionFromUnaryTree((Matcher<ExpressionTree>)Matchers.hasModifier((Modifier)Modifier.VOLATILE)), Matchers.not((Matcher)Matchers.inSynchronized()), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.POSTFIX_INCREMENT), Matchers.kindIs((Tree.Kind)Tree.Kind.PREFIX_INCREMENT), Matchers.kindIs((Tree.Kind)Tree.Kind.POSTFIX_DECREMENT), Matchers.kindIs((Tree.Kind)Tree.Kind.PREFIX_DECREMENT)})});
    private static final Matcher<CompoundAssignmentTree> compoundAssignmentIncrementDecrementMatcher = Matchers.allOf((Matcher[])new Matcher[]{NonAtomicVolatileUpdate.variableFromCompoundAssignmentTree((Matcher<ExpressionTree>)Matchers.hasModifier((Modifier)Modifier.VOLATILE)), Matchers.not((Matcher)Matchers.inSynchronized()), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.PLUS_ASSIGNMENT), Matchers.kindIs((Tree.Kind)Tree.Kind.MINUS_ASSIGNMENT)})});

    private static Matcher<UnaryTree> expressionFromUnaryTree(final Matcher<ExpressionTree> exprMatcher) {
        return new Matcher<UnaryTree>(){

            public boolean matches(UnaryTree tree, VisitorState state) {
                return exprMatcher.matches((Tree)tree.getExpression(), state);
            }
        };
    }

    private static Matcher<CompoundAssignmentTree> variableFromCompoundAssignmentTree(final Matcher<ExpressionTree> exprMatcher) {
        return new Matcher<CompoundAssignmentTree>(){

            public boolean matches(CompoundAssignmentTree tree, VisitorState state) {
                return exprMatcher.matches((Tree)tree.getVariable(), state);
            }
        };
    }

    private static Matcher<AssignmentTree> variableFromAssignmentTree(final Matcher<ExpressionTree> exprMatcher) {
        return new Matcher<AssignmentTree>(){

            public boolean matches(AssignmentTree tree, VisitorState state) {
                return exprMatcher.matches((Tree)tree.getVariable(), state);
            }
        };
    }

    public Description matchUnary(UnaryTree tree, VisitorState state) {
        if (unaryIncrementDecrementMatcher.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    public Description matchCompoundAssignment(CompoundAssignmentTree tree, VisitorState state) {
        if (compoundAssignmentIncrementDecrementMatcher.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static Matcher<AssignmentTree> assignmentIncrementDecrementMatcher(ExpressionTree variable) {
        return Matchers.allOf((Matcher[])new Matcher[]{NonAtomicVolatileUpdate.variableFromAssignmentTree((Matcher<ExpressionTree>)Matchers.hasModifier((Modifier)Modifier.VOLATILE)), Matchers.not((Matcher)Matchers.inSynchronized()), Matchers.assignment((Matcher)Matchers.anything(), (Matcher)Matchers.toType(BinaryTree.class, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.PLUS), Matchers.kindIs((Tree.Kind)Tree.Kind.MINUS)}), Matchers.binaryTree((Matcher)Matchers.sameVariable((ExpressionTree)variable), (Matcher)Matchers.anything())})))});
    }

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        if (NonAtomicVolatileUpdate.assignmentIncrementDecrementMatcher(tree.getVariable()).matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

