/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_ProtoRedundantSet_FieldWithValue;
import com.google.errorprone.bugpatterns.AutoValue_ProtoRedundantSet_MapField;
import com.google.errorprone.bugpatterns.AutoValue_ProtoRedundantSet_RepeatedField;
import com.google.errorprone.bugpatterns.AutoValue_ProtoRedundantSet_SingleField;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;

@BugPattern(name="ProtoRedundantSet", summary="A field on a protocol buffer was set twice in the same chained expression.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public final class ProtoRedundantSet
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> PROTO_FLUENT_METHOD = MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{"com.google.protobuf.GeneratedMessage.Builder", "com.google.protobuf.GeneratedMessageLite.Builder"}).withNameMatching(Pattern.compile("^(set|add|clear|put).+"));
    private static final Matcher<ExpressionTree> TERMINAL_PROTO_FLUENT_METHOD = Matchers.allOf((Matcher[])new Matcher[]{PROTO_FLUENT_METHOD, (Matcher & Serializable)(tree, state) -> !(state.getPath().getParentPath().getLeaf() instanceof MemberSelectTree) || !PROTO_FLUENT_METHOD.matches((Tree)((ExpressionTree)state.getPath().getParentPath().getParentPath().getLeaf()), state)});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!TERMINAL_PROTO_FLUENT_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ArrayListMultimap setters = ArrayListMultimap.create();
        Type type = ASTHelpers.getReturnType((ExpressionTree)tree);
        ExpressionTree current = tree;
        while (PROTO_FLUENT_METHOD.matches((Tree)current, state)) {
            String methodName;
            Symbol symbol;
            MethodInvocationTree method = current;
            if (!ASTHelpers.isSameType((Type)type, (Type)ASTHelpers.getReturnType((ExpressionTree)current), (VisitorState)state) || !((symbol = ASTHelpers.getSymbol((Tree)current)) instanceof Symbol.MethodSymbol) || (methodName = symbol.getSimpleName().toString()).endsWith("Builder")) break;
            ProtoRedundantSet.match(method, methodName, (ListMultimap<ProtoField, FieldWithValue>)setters);
            current = ASTHelpers.getReceiver((ExpressionTree)current);
        }
        setters.asMap().entrySet().removeIf(entry -> ((Collection)entry.getValue()).size() <= 1);
        if (setters.isEmpty()) {
            return Description.NO_MATCH;
        }
        for (Map.Entry entry2 : setters.asMap().entrySet()) {
            ProtoField protoField = (ProtoField)entry2.getKey();
            Collection values = (Collection)entry2.getValue();
            state.reportMatch(this.describe(protoField, values, state));
        }
        return Description.NO_MATCH;
    }

    private Description describe(ProtoField protoField, Collection<FieldWithValue> locations, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        long values = locations.stream().map(l -> state.getSourceForNode((Tree)l.getArgument())).distinct().count();
        if (values == 1L) {
            for (FieldWithValue field : Iterables.skip(locations, (int)1)) {
                MethodInvocationTree method = field.getMethodInvocation();
                int startPos = state.getEndPosition((Tree)ASTHelpers.getReceiver((ExpressionTree)method));
                int endPos = state.getEndPosition((Tree)method);
                fix.replace(startPos, endPos, "");
            }
        }
        return this.buildDescription(locations.iterator().next().getArgument()).setMessage(String.format("%s was called %s with %s. Setting the same field multiple times is redundant, and could mask a bug.", protoField, ProtoRedundantSet.nTimes(locations.size()), values == 1L ? "the same argument" : "different arguments")).addFix((Fix)fix.build()).build();
    }

    private static void match(MethodInvocationTree method, String methodName, ListMultimap<ProtoField, FieldWithValue> setters) {
        for (FieldType fieldType : FieldType.values()) {
            FieldWithValue match = fieldType.match(methodName, method);
            if (match == null) continue;
            setters.put((Object)match.getField(), (Object)match);
        }
    }

    private static String nTimes(int n) {
        return n == 2 ? "twice" : String.format("%d times", n);
    }

    @AutoValue
    static abstract class FieldWithValue {
        FieldWithValue() {
        }

        abstract ProtoField getField();

        abstract MethodInvocationTree getMethodInvocation();

        abstract ExpressionTree getArgument();

        static FieldWithValue of(ProtoField field, MethodInvocationTree methodInvocationTree, ExpressionTree argumentTree) {
            return new AutoValue_ProtoRedundantSet_FieldWithValue(field, methodInvocationTree, argumentTree);
        }
    }

    @AutoValue
    static abstract class MapField
    implements ProtoField {
        MapField() {
        }

        abstract String getName();

        abstract Object getKey();

        static MapField of(String name, Object key) {
            return new AutoValue_ProtoRedundantSet_MapField(name, key);
        }

        public final String toString() {
            return String.format("%s(%s, ..)", this.getName(), this.getKey());
        }
    }

    @AutoValue
    static abstract class RepeatedField
    implements ProtoField {
        RepeatedField() {
        }

        abstract String getName();

        abstract int getIndex();

        static RepeatedField of(String name, int index) {
            return new AutoValue_ProtoRedundantSet_RepeatedField(name, index);
        }

        public final String toString() {
            return String.format("%s(%s, ..)", this.getName(), this.getIndex());
        }
    }

    @AutoValue
    static abstract class SingleField
    implements ProtoField {
        SingleField() {
        }

        abstract String getName();

        static SingleField of(String name) {
            return new AutoValue_ProtoRedundantSet_SingleField(name);
        }

        public final String toString() {
            return String.format("%s(..)", this.getName());
        }
    }

    static enum FieldType {
        SINGLE{

            @Override
            FieldWithValue match(String name, MethodInvocationTree tree) {
                if (name.startsWith("set") && tree.getArguments().size() == 1) {
                    return FieldWithValue.of(SingleField.of(name), tree, tree.getArguments().get(0));
                }
                return null;
            }
        }
        ,
        REPEATED{

            @Override
            FieldWithValue match(String name, MethodInvocationTree tree) {
                Integer index;
                if (name.startsWith("set") && tree.getArguments().size() == 2 && (index = (Integer)ASTHelpers.constValue((Tree)tree.getArguments().get(0), Integer.class)) != null) {
                    return FieldWithValue.of(RepeatedField.of(name, index), tree, tree.getArguments().get(1));
                }
                return null;
            }
        }
        ,
        MAP{

            @Override
            FieldWithValue match(String name, MethodInvocationTree tree) {
                Object key;
                if (name.startsWith("put") && tree.getArguments().size() == 2 && (key = ASTHelpers.constValue((Tree)tree.getArguments().get(0), Object.class)) != null) {
                    return FieldWithValue.of(MapField.of(name, key), tree, tree.getArguments().get(1));
                }
                return null;
            }
        };


        abstract FieldWithValue match(String var1, MethodInvocationTree var2);
    }

    static interface ProtoField {
    }
}

